/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.business.log;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.bos.util.StringUtils;
import kd.scmc.ccm.business.core.CreditContext;
import kd.scmc.ccm.common.helper.SysParamHelper;

public class CcmLogInfo
implements Serializable {
    private static final Log logger = LogFactory.getLog(CcmLogInfo.class);
    private Long id;
    private String source;
    private String level;
    private Date datetime;
    private Long user;
    private String traceid;
    private String detail;
    private String detail_tag;
    private Map<String, Object> logCollection;
    private Long billid;
    private List<Long> billentryid;
    private List<Long> billseq;
    private String billtype;
    private String billnos;
    private String opkey;
    private String result;
    private static final String DELETESQL = "DELETE FROM T_CCM_LOG WHERE  FBILLID=?";
    private static final String UPDATESQL = "UPDATE T_CCM_LOG  SET FDETAIL=?, FDETAIL_TAG=?  WHERE  FID=?";
    private static final String INSERTSQL = "INSERT INTO T_CCM_LOG (FID,FLEVEL,FSOURCE,FBILLTYPE,FOPKEY,FTRACEID,FUSERID,FDATETIME,FDETAIL,FDETAIL_TAG,FBILLNOS_TAG,FBILLNOS,FCOSTTIME) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private static final String WRITESQL = "UPDATE T_CCM_LOG SET FDETAIL_TAG=?,FRESULT=?  WHERE  FID=?";
    public static final String CREDITSCHEME = "creditscheme";
    public static final String CREDITJOURNAL = "creditjournal";
    public static final String ARCHIVE_BEFORE = "archive_before";
    public static final String ARCHIVE_AFTER = "archive_after";
    public static final String NOGETCREDITLOCK = "nogetcreditlock";

    private CcmLogInfo(String billtype, String opkey, Set<String> billNoList, String source) {
        this.billtype = billtype;
        this.opkey = opkey;
        long[] pkId = DBServiceHelper.genLongIds((String)"T_CCM_LOG", (int)1);
        this.id = pkId[0];
        this.logCollection = new LinkedHashMap<String, Object>(16);
        this.createCreditLogInfo(billtype, opkey, billNoList, source);
    }

    private CcmLogInfo() {
        long[] pkId = DBServiceHelper.genLongIds((String)"T_CCM_LOG", (int)1);
        this.id = pkId[0];
        this.createCreditLogInfo("", "", new HashSet<String>(16), "");
    }

    public static CcmLogInfo doCreate(String creditbill, String creditop, Set<String> billNoList, String source) {
        return new CcmLogInfo(creditbill, creditop, billNoList, source);
    }

    private void createCreditLogInfo(String billtype, String opkey, Set<String> billNoList, String source) {
        this.detail_tag = ResManager.loadKDString((String)"**\u4fe1\u7528\u63a7\u5236\u8be6\u60c5**", (String)"CcmLogInfo_0", (String)"scmc-ccm-business", (Object[])new Object[0]);
        this.detail = ResManager.loadKDString((String)"**\u4fe1\u7528\u63a7\u5236\u8be6\u60c5**", (String)"CcmLogInfo_0", (String)"scmc-ccm-business", (Object[])new Object[0]);
        ThreadPools.executeOnce((String)"create ccmLogInfo", () -> {
            try (TXHandle h = TX.requiresNew((String)"ccmLogInfoList");){
                Boolean iswritelog = (Boolean)SysParamHelper.getCCMSysParam((String)"iswritelog");
                if (Boolean.FALSE.equals(iswritelog)) {
                    return;
                }
                String loglevel = (String)SysParamHelper.getCCMSysParam((String)"loglevel");
                this.level = StringUtils.isNotEmpty((String)loglevel) ? loglevel : "INFO";
                try {
                    Object[] obj = new Object[13];
                    obj[0] = this.id;
                    obj[1] = this.level;
                    obj[2] = source;
                    obj[3] = billtype;
                    obj[4] = opkey;
                    obj[5] = RequestContext.get().getTraceId();
                    obj[6] = UserServiceHelper.getCurrentUserId();
                    obj[7] = TimeServiceHelper.now();
                    obj[8] = this.detail;
                    obj[9] = this.detail_tag;
                    if (billNoList != null && billNoList.size() > 0) {
                        obj[10] = SerializationUtils.toJsonString((Object)billNoList);
                        obj[11] = ResManager.loadKDString((String)"\u5b58\u5728", (String)"CcmLogInfo_1", (String)"scmc-ccm-business", (Object[])new Object[0]);
                    } else {
                        obj[10] = "";
                        obj[11] = ResManager.loadKDString((String)"\u4e0d\u5b58\u5728", (String)"CcmLogInfo_2", (String)"scmc-ccm-business", (Object[])new Object[0]);
                    }
                    obj[12] = 0;
                    DB.execute((DBRoute)DBRoute.of((String)"SCM"), (String)INSERTSQL, (Object[])obj);
                    logger.info("\u4fe1\u63a7\u65e5\u5fd7\u4fdd\u5b58\u7ed3\u675f\u2026\u2026");
                }
                catch (Exception kde) {
                    logger.error("\u4fe1\u63a7\u65e5\u5fd7\u4fdd\u5b58\u5f02\u5e38\uff1a{}", (Object)kde.getMessage().concat(Arrays.toString(kde.getStackTrace())));
                    h.markRollback();
                }
                finally {
                    h.commit();
                }
            }
        });
    }

    public void updateCcmLogInfo(String detailparameter, String detail_tagparameter) {
        ThreadPools.executeOnce((String)"update ccmLogInfo", () -> {
            try (TXHandle h = TX.requiresNew((String)"ccmLogInfoList");){
                try {
                    Boolean iswritelog = (Boolean)SysParamHelper.getCCMSysParam((String)"iswritelog");
                    if (Boolean.FALSE.equals(iswritelog)) {
                        return;
                    }
                    Object[] obj = new Object[]{detailparameter, detail_tagparameter, this.id};
                    DB.execute((DBRoute)DBRoute.of((String)"SCM"), (String)UPDATESQL, (Object[])obj);
                    logger.info("\u4fe1\u63a7\u65e5\u5fd7\u4fdd\u5b58\u7ed3\u675f\u2026\u2026");
                }
                catch (Exception kde) {
                    logger.error("\u4fe1\u63a7\u65e5\u5fd7\u4fdd\u5b58\u5f02\u5e38\uff1a{}", (Object)kde.getMessage().concat(Arrays.toString(kde.getStackTrace())));
                    h.markRollback();
                }
                finally {
                    h.commit();
                }
            }
        });
    }

    public static void writeCreditLog() {
        CreditContext cxt = CreditContext.get();
        if (cxt == null) {
            return;
        }
        CcmLogInfo logInfo = cxt.getLogInfo();
        if (logInfo == null) {
            return;
        }
        logInfo.writeCreditLogInfo();
    }

    public static void writeExpCreditLog(String detailparameter, String detail_tagparameter) {
        CreditContext txt = CreditContext.get();
        if (txt == null) {
            return;
        }
        CcmLogInfo logInfo = txt.getLogInfo();
        if (logInfo == null) {
            logInfo = new CcmLogInfo();
        } else {
            Map<String, Object> logCollection = logInfo.getLogCollection();
            if (logCollection != null) {
                logCollection.clear();
                logCollection = null;
            }
        }
        logInfo.updateCcmLogInfo(detailparameter, detail_tagparameter);
    }

    public static void collectCcmLogInfo(String theme, Object parameter) {
        CreditContext txt = CreditContext.get();
        if (txt == null) {
            return;
        }
        CcmLogInfo logInfo = txt.getLogInfo();
        if (logInfo == null) {
            return;
        }
        if (logInfo.getLogCollection() != null) {
            logInfo.getLogCollection().put(theme, parameter);
        }
    }

    public static void collectCcmLogInfo(String result) {
        CreditContext txt = CreditContext.get();
        if (txt == null) {
            return;
        }
        CcmLogInfo logInfo = txt.getLogInfo();
        if (logInfo == null) {
            return;
        }
        logInfo.setResult(result);
    }

    public void writeCreditLogInfo() {
        ThreadPools.executeOnce((String)"update ccmLogInfo", () -> {
            try (TXHandle h = TX.requiresNew((String)"ccmLogInfoList");){
                Boolean iswritelog = (Boolean)SysParamHelper.getCCMSysParam((String)"iswritelog");
                if (Boolean.FALSE.equals(iswritelog)) {
                    return;
                }
                String loglevel = (String)SysParamHelper.getCCMSysParam((String)"loglevel");
                try {
                    if (this.logCollection != null && this.logCollection.size() > 0) {
                        this.detail_tag = this.logCollection.toString();
                    }
                    Object[] obj = new Object[]{!"DEBUG".equals(loglevel) && !"ERROR".equals(loglevel) ? "" : this.detail_tag, this.result != null && !"".equals(this.result) ? this.result : ResManager.loadKDString((String)"\u6267\u884c\u5b8c\u6210", (String)"CcmLogInfo_3", (String)"scmc-ccm-business", (Object[])new Object[0]), this.id};
                    DB.execute((DBRoute)DBRoute.of((String)"SCM"), (String)WRITESQL, (Object[])obj);
                    logger.info("\u4fe1\u63a7\u65e5\u5fd7\u4fdd\u5b58\u7ed3\u675f\u2026\u2026");
                }
                catch (Exception kde) {
                    logger.error("\u4fe1\u63a7\u65e5\u5fd7\u4fdd\u5b58\u5f02\u5e38\uff1a{}", (Object)kde.getMessage().concat(Arrays.toString(kde.getStackTrace())));
                    h.markRollback();
                }
            }
            catch (Exception exp) {
                logger.error("\u4fe1\u63a7\u65e5\u5fd7\u4fdd\u5b58\u5f02\u5e38\uff1a{}", (Object)exp.getMessage().concat(Arrays.toString(exp.getStackTrace())));
            }
        });
    }

    public Long getId() {
        return this.id;
    }

    public Date getDatetime() {
        return this.datetime;
    }

    public Long getUser() {
        return this.user;
    }

    public String getTraceid() {
        return this.traceid;
    }

    public String getDetail() {
        return this.detail;
    }

    public String getDetail_tag() {
        return this.detail_tag;
    }

    public Long getBillid() {
        return this.billid;
    }

    public String getBilltype() {
        return this.billtype;
    }

    public String getBillnos() {
        return this.billnos;
    }

    public String getOpkey() {
        return this.opkey;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setDatetime(Date datetime) {
        this.datetime = datetime;
    }

    public void setUser(Long user) {
        this.user = user;
    }

    public void setTraceid(String traceid) {
        this.traceid = traceid;
    }

    public void setDetail(String detail) {
        this.detail = detail;
    }

    public void setDetail_tag(String detail_tag) {
        this.detail_tag = detail_tag;
    }

    public void setBillid(Long billid) {
        this.billid = billid;
    }

    public List<Long> getBillentryid() {
        return this.billentryid;
    }

    public void setBillentryid(List<Long> billentryid) {
        this.billentryid = billentryid;
    }

    public List<Long> getBillseq() {
        return this.billseq;
    }

    public void setBillseq(List<Long> billseq) {
        this.billseq = billseq;
    }

    public void setBilltype(String billtype) {
        this.billtype = billtype;
    }

    public void setBillnos(String billnos) {
        this.billnos = billnos;
    }

    public void setOpkey(String opkey) {
        this.opkey = opkey;
    }

    public Map<String, Object> getLogCollection() {
        return this.logCollection;
    }

    public void setLogCollection(Map<String, Object> logCollection) {
        this.logCollection = logCollection;
    }

    public String getResult() {
        return this.result;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public String toString() {
        return "{id=" + this.id + ", source=" + this.source + ", datetime=" + this.datetime + ", user=" + this.user + ", traceid='" + this.traceid + '\'' + ", logdetail='" + this.detail + '\'' + ", billid=" + this.billid + ", billentryid=" + this.billentryid + ", billseq=" + this.billseq + ", billtype='" + this.billtype + '\'' + ", billnos='" + this.billnos + '\'' + ", opkey='" + this.opkey + '\'' + ", result='" + this.result + '\'' + '}';
    }
}

