/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.business.monitor;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import kd.scmc.ccm.business.monitor.DebugDetail;
import kd.scmc.ccm.business.monitor.DebugDetailFake;
import kd.scmc.ccm.business.monitor.DebugInfo;
import kd.scmc.ccm.business.monitor.DebugInfoFake;
import kd.scmc.ccm.business.monitor.IDebugDetail;
import kd.scmc.ccm.business.monitor.IDebugInfo;
import kd.scmc.ccm.business.scheme.CreditScheme;

public class Monitor {
    private static ThreadLocal<Boolean> debugTag = new ThreadLocal();
    private static ThreadLocal<IDebugInfo> debugInfoHolder = new ThreadLocal();

    public static IDebugInfo getDebugInfo() {
        IDebugInfo debugInfo = debugInfoHolder.get();
        if (debugInfo == null) {
            debugInfo = Monitor.isDebugMode() ? new DebugInfo() : new DebugInfoFake();
            debugInfoHolder.set(debugInfo);
        }
        return debugInfo;
    }

    public static IDebugDetail getDebugDetail(CreditScheme scheme) {
        Map<CreditScheme, IDebugDetail> debugDetailsMap;
        IDebugDetail debugDetail;
        IDebugInfo debugInfo = debugInfoHolder.get();
        if (debugInfo == null) {
            debugInfo = Monitor.isDebugMode() ? new DebugInfo() : new DebugInfoFake();
            debugInfoHolder.set(debugInfo);
        }
        if ((debugDetail = (debugDetailsMap = debugInfo.getDebugDetailsMap()).get(scheme)) == null) {
            debugDetail = Monitor.isDebugMode() ? new DebugDetail() : new DebugDetailFake();
            debugDetail.setScheme(scheme);
            debugDetailsMap.put(scheme, debugDetail);
        }
        return debugDetail;
    }

    public static Collection<IDebugDetail> getAll() {
        IDebugInfo debugInfo = debugInfoHolder.get();
        if (debugInfo == null) {
            return new LinkedList<IDebugDetail>();
        }
        return debugInfo.getDebugDetailsMap().values();
    }

    public static boolean isDebugMode() {
        Boolean isDebugMode = debugTag.get();
        if (isDebugMode == null) {
            return false;
        }
        return isDebugMode;
    }

    public static void setDebugMode(Boolean isDebugMode) {
        debugTag.set(isDebugMode);
    }

    public static void clear() {
        debugInfoHolder.set(null);
    }
}

