/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.business.overdue;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.ccm.business.core.DimensionValue;
import kd.scmc.ccm.business.core.Field;
import kd.scmc.ccm.business.core.Role;
import kd.scmc.ccm.business.overdue.OverdueCalculator;
import kd.scmc.ccm.business.scheme.CreditScheme;
import kd.scmc.ccm.business.service.CreditServiceFacade;
import kd.scmc.ccm.business.setting.EntityConfig;
import kd.scmc.ccm.common.util.DateUtils;

public class ArFinOverDueDayCalculator
implements OverdueCalculator {
    @Override
    public Map<DimensionValue, BigDecimal> calculate(CreditScheme scheme, Set<DimensionValue> dimensionValues) {
        EntityConfig finBillConfig = new CreditServiceFacade().getConfig("ar_finarbill");
        LinkedList<QFilter> finBillFilters = new LinkedList<QFilter>();
        if (!scheme.isGlobalScheme()) {
            List<Long> orgScopes = scheme.getOrgScopes();
            finBillFilters.add(new QFilter("org", "in", orgScopes));
        }
        finBillFilters.add(new QFilter("settlestatus", "<>", (Object)"settled"));
        Date date = new Date();
        finBillFilters.add(new QFilter("duedate", "<", (Object)date));
        LinkedList<String> billRoleFields = new LinkedList<String>();
        List<Role> roles = scheme.getDimension().getRoles();
        for (Role role : roles) {
            Field roleField = finBillConfig.getRoleField(role.getRoleType());
            billRoleFields.add(roleField.getKey());
            HashSet<Long> roleIds = new HashSet<Long>(dimensionValues.size());
            for (DimensionValue dimensionValue : dimensionValues) {
                Object value = dimensionValue.getValue(role);
                roleIds.add(Long.valueOf(value.toString()));
            }
            if (roleIds.isEmpty()) continue;
            if (roleField.getEntryKey() == null) {
                finBillFilters.add(new QFilter(roleField.getKey(), "in", roleIds));
                continue;
            }
            finBillFilters.add(new QFilter(roleField.getEntryKey() + "." + roleField.getKey(), "in", roleIds));
        }
        LinkedList<String> finBillSelectors = new LinkedList<String>(billRoleFields);
        finBillSelectors.add("duedate");
        DataSet finBills = QueryServiceHelper.queryDataSet((String)"ccm.queryoverdueday", (String)finBillConfig.getEntityKey(), (String)String.join((CharSequence)",", finBillSelectors), (QFilter[])finBillFilters.toArray(new QFilter[0]), null);
        DataSet minDuedateFinBills = finBills.groupBy(billRoleFields.toArray(new String[0])).min("duedate").finish();
        HashMap<DimensionValue, BigDecimal> results = new HashMap<DimensionValue, BigDecimal>(dimensionValues.size());
        for (Row row : minDuedateFinBills) {
            DimensionValue dimensionValue = new DimensionValue(scheme.getDimension());
            for (Role role : roles) {
                Field roleField = finBillConfig.getRoleField(role.getRoleType());
                dimensionValue.putValue(role, row.get(roleField.getKey()));
            }
            BigDecimal diffDays = BigDecimal.valueOf(DateUtils.getDiffDays((Date)row.getDate("duedate"), (Date)date));
            results.put(dimensionValue, diffDays);
        }
        return results;
    }
}

