/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.business.overdue;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BigIntProp;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.ccm.business.core.CreditContext;
import kd.scmc.ccm.business.core.CreditElement;
import kd.scmc.ccm.business.core.DimensionValue;
import kd.scmc.ccm.business.core.Expression;
import kd.scmc.ccm.business.core.Field;
import kd.scmc.ccm.business.core.Role;
import kd.scmc.ccm.business.scheme.BillStrategy;
import kd.scmc.ccm.business.scheme.CreditScheme;
import kd.scmc.ccm.business.service.CreditServiceFacade;
import kd.scmc.ccm.business.setting.EntityConfig;

public class OverdueBillQueryConditionGenerator {
    private QFilter filter = new QFilter("1", "=", (Object)1);
    private List<String> selectors = new LinkedList<String>();
    private List<String> billRoleFields = new LinkedList<String>();
    private Long cusunicodeId = 0L;

    public OverdueBillQueryConditionGenerator(CreditScheme scheme, Set<DimensionValue> dimensionValues) {
        CreditContext creditContext = CreditContext.get();
        BillStrategy billStrategy = scheme.getBillStrategy(creditContext.getEntityKey());
        String assingEntityKey = billStrategy.getAssingEntityKey();
        EntityConfig entityConfig = new CreditServiceFacade().getConfig(assingEntityKey);
        List<Long> orgScopes = scheme.getOrgScopes();
        if (orgScopes != null && orgScopes.size() > 0) {
            Field orgField = entityConfig.getOrgField();
            String orgFieldKey = orgField.getKey();
            if (orgField.getEntryKey() != null) {
                orgFieldKey = orgField.getEntryKey() + "." + orgField.getKey();
            }
            this.filter.and(new QFilter(orgFieldKey, "in", orgScopes));
        }
        if ("overdueamt".equals(scheme.getQuotaType().getQuotaType()) && scheme.isSingleCurrencyControl()) {
            Field currencyField = entityConfig.getField(CreditElement.ELEMENT_CURRENCY);
            String currencyFilterKey = currencyField.getKey();
            if (currencyField.getEntryKey() != null) {
                currencyFilterKey = currencyField.getEntryKey() + "." + currencyField.getKey();
            }
            this.filter.and(new QFilter(currencyFilterKey, "=", (Object)scheme.getCurrency()));
        }
        Expression expression = billStrategy.getExpression();
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)assingEntityKey);
        if (!ObjectUtils.isEmpty((Object)expression.getCondition().getCondition())) {
            FilterCondition filterCondition = expression.getCondition().getCondition().getFilterCondition();
            FilterBuilder filterBuilder = new FilterBuilder(dataEntityType, filterCondition);
            filterBuilder.buildFilter();
            this.filter.and(filterBuilder.getQFilter());
        }
        List<Role> roles = scheme.getDimension().getRoles();
        for (Role role : roles) {
            String roleType = role.getRoleType();
            Field roleField = entityConfig.getRoleField(roleType);
            if (roleField == null) {
                String errMessage = ResManager.loadKDString((String)"\u903e\u671f\u5355\u636e\u6ce8\u518c: %s \u914d\u7f6e\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"OverdueBillQueryConditionGenerator_0", (String)"scmc-ccm-business", (Object[])new Object[0]);
                throw new KDBizException(String.format(errMessage, role.getRoleName()));
            }
            HashSet<Long> roleIds = new HashSet<Long>(dimensionValues.size());
            for (DimensionValue dimensionValue : dimensionValues) {
                Object value = dimensionValue.getValue(role);
                if ("CUSUNICODE".equals(roleType)) {
                    this.cusunicodeId = Long.valueOf(String.valueOf(value));
                    continue;
                }
                roleIds.add(Long.valueOf(value.toString()));
            }
            if (this.cusunicodeId != 0L) {
                DynamicObjectCollection cusunicodes = QueryServiceHelper.query((String)"ccm_cusunicode", (String)"entry.e_customer", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)this.cusunicodeId)});
                for (DynamicObject cusunicode : cusunicodes) {
                    roleIds.add(cusunicode.getLong("entry.e_customer"));
                }
            }
            String roleFieldKey = roleField.getKey();
            String string = role.getBasedataEntityKey();
            MainEntityType roleBDEntityType = MetadataServiceHelper.getDataEntityType((String)string);
            if (roleBDEntityType != null && roleBDEntityType.findProperty("masterid") != null) {
                MainEntityType assEntityType = MetadataServiceHelper.getDataEntityType((String)assingEntityKey);
                if (assEntityType.getProperty(roleField.getKey()) instanceof BigIntProp) {
                    QFilter q = new QFilter("masterid", "in", roleIds);
                    DynamicObjectCollection roleIdCollection = QueryServiceHelper.query((String)string, (String)"id", (QFilter[])new QFilter[]{q});
                    if (roleIdCollection != null && !roleIdCollection.isEmpty()) {
                        HashSet roleIdsNew = new HashSet(16);
                        roleIdCollection.stream().forEach(roleValue -> roleIdsNew.add(roleValue.getLong("id")));
                        roleIds.clear();
                        roleIds.addAll(roleIdsNew);
                    }
                } else if (assEntityType.getProperty(roleField.getKey()) instanceof BasedataProp) {
                    roleFieldKey = roleFieldKey + ".masterid";
                }
            }
            if (roleField.getEntryKey() == null) {
                this.filter.and(new QFilter(roleFieldKey, "in", roleIds));
                this.selectors.add(roleFieldKey);
                this.billRoleFields.add(roleFieldKey);
                continue;
            }
            this.filter.and(new QFilter(roleField.getEntryKey() + "." + roleFieldKey, "in", roleIds));
            this.selectors.add(roleField.getEntryKey() + "." + roleFieldKey);
            this.billRoleFields.add(roleField.getEntryKey() + "." + roleFieldKey);
        }
    }

    public QFilter getFilter() {
        return this.filter;
    }

    public List<String> getSelectors() {
        return this.selectors;
    }

    public List<String> getBillRoleFields() {
        return this.billRoleFields;
    }

    public Long getCusunicodeId() {
        return this.cusunicodeId;
    }
}

