/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.business.overdue;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.ccm.business.core.CreditContext;
import kd.scmc.ccm.business.core.CreditElement;
import kd.scmc.ccm.business.core.DimensionValue;
import kd.scmc.ccm.business.core.Field;
import kd.scmc.ccm.business.core.Role;
import kd.scmc.ccm.business.monitor.Monitor;
import kd.scmc.ccm.business.overdue.OverDueDayHelper;
import kd.scmc.ccm.business.overdue.OverdueBillQueryConditionGenerator;
import kd.scmc.ccm.business.overdue.OverdueCalculator;
import kd.scmc.ccm.business.scheme.BillStrategy;
import kd.scmc.ccm.business.scheme.CreditScheme;
import kd.scmc.ccm.business.service.CreditServiceFacade;
import kd.scmc.ccm.business.setting.EntityConfig;
import kd.scmc.ccm.common.helper.CurrencyHelper;
import kd.scmc.ccm.common.util.DateUtils;

public class RuleBasedOverdueCalculator
implements OverdueCalculator {
    private static final Log logger = LogFactory.getLog(RuleBasedOverdueCalculator.class);

    @Override
    public Map<DimensionValue, BigDecimal> calculate(CreditScheme scheme, Set<DimensionValue> dimensionValues) {
        long queryOverdueBeginTime = System.currentTimeMillis();
        logger.info("\u8ba1\u7b97\u903e\u671f\u6570\u636e 1.\u5f00\u59cb\uff1a" + new Date(queryOverdueBeginTime));
        CreditContext creditContext = CreditContext.get();
        BillStrategy billStrategy = scheme.getBillStrategy(creditContext.getEntityKey());
        boolean isSingleCurrencyControl = scheme.isSingleCurrencyControl();
        int currencyPrecision = scheme.getCurrencyPrecision();
        String calculateDateField = "";
        String calculateAmtField = "";
        String quotaType = scheme.getQuotaType().getQuotaType();
        if ("overdueamt".equals(quotaType)) {
            calculateAmtField = billStrategy.getCalculateAmt();
            calculateDateField = billStrategy.getCalculateDate();
        } else if ("days".equals(quotaType)) {
            calculateDateField = billStrategy.getCalculateDate();
        }
        if (ObjectUtils.isEmpty((Object)calculateDateField)) {
            return new HashMap<DimensionValue, BigDecimal>(0);
        }
        String assingEntityKey = billStrategy.getAssingEntityKey();
        EntityConfig entityConfig = new CreditServiceFacade().getConfig(assingEntityKey);
        List<Role> roles = scheme.getDimension().getRoles();
        OverdueBillQueryConditionGenerator billCondition = new OverdueBillQueryConditionGenerator(scheme, dimensionValues);
        List<String> billRoleFields = billCondition.getBillRoleFields();
        QFilter filter = billCondition.getFilter();
        List<String> selectors = billCondition.getSelectors();
        Long cusunicodeId = billCondition.getCusunicodeId();
        HashMap<DimensionValue, BigDecimal> results = new HashMap<DimensionValue, BigDecimal>(dimensionValues.size());
        HashMap<DimensionValue, String> billnos = new HashMap<DimensionValue, String>(dimensionValues.size());
        selectors.add(calculateDateField);
        selectors.add("billno");
        Field currencyField = entityConfig.getField(CreditElement.ELEMENT_CURRENCY);
        String currencyFieldKey = currencyField.getKey();
        if (currencyField.getEntryKey() != null) {
            currencyFieldKey = currencyField.getEntryKey() + "." + currencyField.getKey();
        }
        filter.and(new QFilter(calculateDateField, "is not null", null));
        if ("overdueamt".equals(quotaType)) {
            selectors.add(calculateAmtField);
            if (isSingleCurrencyControl) {
                filter.and(new QFilter(currencyFieldKey, "=", (Object)scheme.getCurrency()));
            } else {
                selectors.add(currencyFieldKey);
            }
            filter.and(new QFilter(calculateDateField, "<", (Object)DateUtils.getStartOfDay((Date)new Date())));
        }
        Monitor.getDebugDetail(scheme).info(this.getClass(), "filter=", filter.toString());
        long getConfigAndFilterTime = System.currentTimeMillis();
        logger.info("\u8ba1\u7b97\u903e\u671f\u6570\u636e 2.\u89e3\u6790\u65b9\u6848\u6784\u9020\u67e5\u8be2\u6761\u4ef6\uff1a" + new Date(getConfigAndFilterTime) + " \u8017\u65f6\uff1a" + (getConfigAndFilterTime - queryOverdueBeginTime) + " ms");
        DataSet bills = QueryServiceHelper.queryDataSet((String)"ccm.RuleBasedOverdueCalculator.queryoverdue", (String)assingEntityKey, (String)String.join((CharSequence)",", selectors), (QFilter[])new QFilter[]{filter}, null);
        DataSet processedBills = null;
        long queryBillTime = System.currentTimeMillis();
        logger.info("\u8ba1\u7b97\u903e\u671f\u6570\u636e 3.\u67e5\u8be2\u5355\u636edataset\uff1a" + new Date(queryBillTime) + " \u8017\u65f6\uff1a" + (queryBillTime - getConfigAndFilterTime) + " ms");
        DataSet billscopy = bills.copy();
        if ("overdueamt".equals(quotaType)) {
            if (!isSingleCurrencyControl) {
                RowMeta rowMeta = billscopy.getRowMeta();
                DataSetBuilder newBillsBuilder = Algo.create((String)this.getClass().getName()).createDataSetBuilder(rowMeta);
                Long schemeCurrencyId = scheme.getCurrency();
                Long schemeExchangeRateTableId = scheme.getExchangeRateTable();
                for (Object bill : billscopy) {
                    Object[] newRow = new Object[rowMeta.getFieldCount()];
                    BigDecimal actual_overdueamt = BigDecimal.ZERO;
                    BigDecimal bigDecimal = bill.getBigDecimal(calculateAmtField);
                    Long billCurrencyId = bill.getLong(currencyFieldKey);
                    if (schemeCurrencyId.longValue() != billCurrencyId.longValue()) {
                        String[] rate = CurrencyHelper.getExChangeRate((Long)billCurrencyId, (Long)schemeCurrencyId, (Long)schemeExchangeRateTableId, (Date)new Date());
                        if (rate != null) {
                            actual_overdueamt = bigDecimal.multiply((BigDecimal)rate).setScale(currencyPrecision, 4);
                        }
                    } else {
                        actual_overdueamt = bigDecimal.setScale(currencyPrecision, 4);
                    }
                    for (String fieldName : rowMeta.getFieldNames()) {
                        int fieldIndex = rowMeta.getFieldIndex(fieldName);
                        newRow[fieldIndex] = calculateAmtField.endsWith(fieldName) ? actual_overdueamt : bill.get(fieldName);
                    }
                    newBillsBuilder.append(newRow);
                }
                processedBills = newBillsBuilder.build().groupBy(billRoleFields.toArray(new String[0])).sum(calculateAmtField).finish();
                long calExchangeAmoutTime = System.currentTimeMillis();
                logger.info("\u8ba1\u7b97\u903e\u671f\u6570\u636e 4.\u975e\u5e01\u522b\u9694\u79bb\u8fdb\u884c\u91d1\u989d\u6362\u7b97\u5e76\u6c47\u603b\uff1a" + new Date(calExchangeAmoutTime) + " \u8017\u65f6\uff1a" + (calExchangeAmoutTime - queryBillTime) + " ms");
            } else {
                long calSumAmtBeginTime = System.currentTimeMillis();
                processedBills = bills.groupBy(billRoleFields.toArray(new String[0])).sum(calculateAmtField).finish();
                long calSumAmtEndTime = System.currentTimeMillis();
                logger.info("\u8ba1\u7b97\u903e\u671f\u6570\u636e 4.\u5e01\u522b\u9694\u79bb\u4e0d\u7528\u6362\u7b97\u76f4\u63a5\u6c47\u603b\uff1a" + new Date(calSumAmtEndTime) + " \u8017\u65f6\uff1a" + (calSumAmtEndTime - calSumAmtBeginTime) + " ms");
            }
        } else {
            processedBills = bills.groupBy(billRoleFields.toArray(new String[0])).min(calculateDateField).finish();
            long calMinDayEndTime = System.currentTimeMillis();
            logger.info("\u8ba1\u7b97\u903e\u671f\u6570\u636e 4.\u8ba1\u7b97\u6700\u5c0f\u903e\u671f\u5929\u6570\uff1a" + new Date(calMinDayEndTime) + " \u8017\u65f6\uff1a" + (calMinDayEndTime - queryBillTime) + " ms");
        }
        long buildOverdueResultBeginTime = System.currentTimeMillis();
        logger.info("\u5ba2\u6237\u7edf\u4e00\u7801\uff1a{}", (Object)cusunicodeId);
        for (Row row : processedBills) {
            DimensionValue dimensionValue = new DimensionValue(scheme.getDimension());
            for (Role role : roles) {
                MainEntityType assEntityType;
                Field roleField = entityConfig.getRoleField(role.getRoleType());
                String string = role.getRoleType();
                if (cusunicodeId != 0L && "CUSUNICODE".equals(string)) {
                    dimensionValue.putValue(role, cusunicodeId);
                    continue;
                }
                String roleFieldKey = roleField.getKey();
                String roleBDEntityKey = role.getBasedataEntityKey();
                MainEntityType roleBDEntityType = MetadataServiceHelper.getDataEntityType((String)roleBDEntityKey);
                if (roleBDEntityType != null && roleBDEntityType.findProperty("masterid") != null && (assEntityType = MetadataServiceHelper.getDataEntityType((String)assingEntityKey)).getProperty(roleField.getKey()) instanceof BasedataProp) {
                    roleFieldKey = roleFieldKey + ".masterid";
                }
                if (roleField.getEntryKey() == null) {
                    dimensionValue.putValue(role, row.get(roleFieldKey));
                    continue;
                }
                dimensionValue.putValue(role, row.get(roleField.getEntryKey() + "." + roleFieldKey));
            }
            if ("overdueamt".equals(quotaType)) {
                BigDecimal currentCustomAmnt = row.getBigDecimal(calculateAmtField).setScale(currencyPrecision, 4);
                if (cusunicodeId != null && cusunicodeId != 0L) {
                    BigDecimal customerUnifiedCodeSum = BigDecimal.ZERO;
                    if (results.size() > 0) {
                        for (Map.Entry entry : results.entrySet()) {
                            DimensionValue tempDimensionValue = (DimensionValue)entry.getKey();
                            if (!tempDimensionValue.equals(dimensionValue)) continue;
                            customerUnifiedCodeSum = customerUnifiedCodeSum.add((BigDecimal)entry.getValue());
                        }
                    }
                    BigDecimal currentAllCustomAmnt = currentCustomAmnt.add(customerUnifiedCodeSum).setScale(currencyPrecision, 4);
                    results.put(dimensionValue, currentAllCustomAmnt);
                    this.writeProcessOverdueLog(dimensionValue, currentCustomAmnt, cusunicodeId);
                    continue;
                }
                results.put(dimensionValue, currentCustomAmnt);
                continue;
            }
            if (!"days".equals(quotaType)) continue;
            QFilter dateFilter = new QFilter(calculateDateField, "=", (Object)row.getDate(calculateDateField));
            DynamicObject bill = QueryServiceHelper.queryOne((String)assingEntityKey, (String)"billno", (QFilter[])new QFilter[]{filter, dateFilter});
            if (!ObjectUtils.isEmpty((Object)bill)) {
                billnos.put(dimensionValue, bill.getString("billno"));
            }
            BigDecimal diffDays = BigDecimal.valueOf(DateUtils.getDiffDays((Date)row.getDate(calculateDateField), (Date)new Date()));
            results.put(dimensionValue, diffDays);
        }
        long buildOverdueResultEndTime = System.currentTimeMillis();
        logger.info("\u8ba1\u7b97\u903e\u671f\u6570\u636e 5.\u6c47\u603b\uff1a" + new Date(buildOverdueResultEndTime) + " \u8017\u65f6\uff1a" + (buildOverdueResultEndTime - buildOverdueResultBeginTime) + " ms");
        this.cacheOverdueDayBillNo(scheme, billnos);
        this.writeCusUnifyIdOverdueLog(results, cusunicodeId);
        return results;
    }

    private void writeProcessOverdueLog(DimensionValue dimensionValue, BigDecimal currentCustomAmnt, Long cusunicodeId) {
        try {
            if (cusunicodeId != null && cusunicodeId != 0L) {
                logger.info("\u6536\u96c6\u8fc7\u7a0b\u96c6\u4e2d\uff0c\u4fe1\u63a7\u7ef4\u5ea6ID\uff1a{},\u4fe1\u63a7\u7ef4\u5ea6\u503c\uff1a{}\uff0c\u5bf9\u5e94\u7684\u903e\u671f\u91d1\u989d\uff1a{}", new Object[]{dimensionValue.getDimension().getId(), dimensionValue.getValue(), currentCustomAmnt});
            }
        }
        catch (Exception exp) {
            logger.error("\u6536\u96c6\u8fc7\u7a0b\u65e5\u5fd7\u51fa\u73b0\u5f02\u5e38", (Throwable)exp);
        }
    }

    private void writeCusUnifyIdOverdueLog(Map<DimensionValue, BigDecimal> results, Long cusunicodeId) {
        try {
            if (cusunicodeId != null && cusunicodeId != 0L) {
                for (Map.Entry<DimensionValue, BigDecimal> obj : results.entrySet()) {
                    DimensionValue key = obj.getKey();
                    BigDecimal value = obj.getValue();
                    logger.info("\u6536\u96c6\u7ed3\u679c\u96c6\u4e2d\uff0c\u4fe1\u63a7\u7ef4\u5ea6ID\uff1a{},\u4fe1\u63a7\u7ef4\u5ea6\u503c\uff1a{}\uff0c\u5bf9\u5e94\u7684\u903e\u671f\u91d1\u989d\uff1a{}", new Object[]{key.getDimension().getId(), key.getValue(), value});
                }
            }
        }
        catch (Exception exp) {
            logger.error("\u6536\u96c6\u7ed3\u679c\u65e5\u5fd7\u51fa\u73b0\u5f02\u5e38", (Throwable)exp);
        }
    }

    private void cacheOverdueDayBillNo(CreditScheme scheme, Map<DimensionValue, String> billnos) {
        for (Map.Entry<DimensionValue, String> entry : billnos.entrySet()) {
            OverDueDayHelper.cacheOverdueDayDetailBillno(scheme, entry.getKey(), entry.getValue());
        }
    }
}

