/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.business.plugin;

import java.util.LinkedList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.scmc.ccm.business.core.CreditContext;
import kd.scmc.ccm.business.plugin.ICreditPlugin;
import kd.scmc.ccm.business.scheme.CreditScheme;
import kd.scmc.ccm.business.scheme.SchemeFilter;
import kd.scmc.ccm.business.service.CreditServiceFacade;

@KSObject
public abstract class AbstractCreditPlugin
implements ICreditPlugin {
    protected CreditServiceFacade creditServiceFacade = new CreditServiceFacade();
    protected CreditScheme scheme;
    protected CreditContext context;
    private SchemeFilter schemeFilter;

    @Override
    @KSMethod
    public void init(CreditScheme scheme, CreditContext context) {
        this.scheme = scheme;
        this.context = context;
        this.schemeFilter = new SchemeFilter(scheme, context);
    }

    @Override
    @KSMethod
    public boolean isBillMatch(DynamicObject bill) {
        return this.schemeFilter.isBillMatch(bill);
    }

    @Override
    @KSMethod
    public boolean isRowMatch(DynamicObject row) {
        return this.schemeFilter.isRowMatch(row);
    }

    @Override
    public List<String> getRequiredFields(String entityKey) {
        return new LinkedList<String>();
    }
}

