/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.business.plugin;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.scmc.ccm.business.plugin.BillConfig;
import kd.scmc.ccm.business.plugin.SrcMergedCreditPlugin;

public class ArBusBillCreditPlugin
extends SrcMergedCreditPlugin {
    @Override
    protected String getSrcEntityKey(DynamicObject bill) {
        return bill.getString("sourcebilltype");
    }

    @Override
    protected String getEntryKey() {
        return "entry";
    }

    @Override
    protected String getQtyKey() {
        return "e_quantity";
    }

    @Override
    protected long getSrcRowId(DynamicObject targetRow) {
        return targetRow.getLong("e_srcentryid");
    }

    @Override
    protected long getSrcId(DynamicObject targetRow) {
        return targetRow.getLong("e_srcbillid");
    }

    @Override
    protected String getSrcEntryKey(String srcEntityKey) {
        return BillConfig.getEntryKey(srcEntityKey);
    }

    @Override
    protected String getSrcPriceKey(String srcEntityKey) {
        return BillConfig.getPriceKey(srcEntityKey);
    }

    @Override
    protected Map<Long, String> getSrcBillInfoMap(DynamicObject bill) {
        DynamicObjectCollection entry = bill.getDynamicObjectCollection(this.getEntryKey());
        HashMap<Long, String> map = new HashMap<Long, String>(entry.size());
        for (DynamicObject row : entry) {
            long srcRowId = this.getSrcRowId(row);
            String srcBillNo = bill.getString("sourcebillno");
            map.put(srcRowId, srcBillNo);
        }
        return map;
    }

    @Override
    public List<String> getRequiredFields(String entityKey) {
        LinkedList<String> selectors = new LinkedList<String>();
        selectors.add("sourcebilltype");
        selectors.add("e_quantity");
        selectors.add("e_srcbillid");
        selectors.add("e_srcentryid");
        selectors.add("sourcebillno");
        return selectors;
    }
}

