/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.business.plugin;

import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scmc.ccm.business.archives.ArchiveCollection;
import kd.scmc.ccm.business.archives.ArchiveLoader;
import kd.scmc.ccm.business.check.CheckResult;
import kd.scmc.ccm.business.check.CreditChecker;
import kd.scmc.ccm.business.core.CreditContext;
import kd.scmc.ccm.business.core.DimensionValue;
import kd.scmc.ccm.business.journal.Journal;
import kd.scmc.ccm.business.journal.JournalBuilder;
import kd.scmc.ccm.business.journal.JournalGroup;
import kd.scmc.ccm.business.plugin.ICreditPlugin;
import kd.scmc.ccm.business.plugin.PluginFactory;
import kd.scmc.ccm.business.plugin.event.AfterBuildJournalArgs;
import kd.scmc.ccm.business.plugin.event.AfterLoadArchiveArgs;
import kd.scmc.ccm.business.plugin.event.BeforeBuildJournalArgs;
import kd.scmc.ccm.business.plugin.event.RegisterServiceArgs;
import kd.scmc.ccm.business.recalculate.IRecalculatePlugin;
import kd.scmc.ccm.business.recalculate.RecalculateStrategy;
import kd.scmc.ccm.business.scheme.BillStrategy;
import kd.scmc.ccm.business.scheme.CreditScheme;
import kd.scmc.ccm.business.service.CreditServiceFacade;

public class CreditPluginProxy {
    private static final Log logger = LogFactory.getLog(CreditPluginProxy.class);
    private CreditScheme scheme;
    private CreditContext context;
    private CreditServiceFacade facade;
    private ICreditPlugin plugin;
    private RegisterServiceArgs registerServiceArgs;

    public CreditPluginProxy(CreditScheme scheme, CreditContext context, CreditServiceFacade facade) {
        this.scheme = scheme;
        this.context = context;
        this.facade = facade;
        this.plugin = this.createPluginInstance(scheme, context);
        this.registerService();
    }

    private ICreditPlugin createPluginInstance(CreditScheme scheme, CreditContext context) {
        ICreditPlugin plugin;
        long beginCreatePluginInsTime = System.currentTimeMillis();
        logger.info("\u4fe1\u7528\u63d2\u4ef6\u8c03\u7528 createPluginInstance begin: " + new Date(beginCreatePluginInsTime));
        boolean isInit = "INIT".equals(context.getCreditAction());
        logger.info("\u4fe1\u7528\u63d2\u4ef6\u8c03\u7528 createPluginInstance isInit \uff1a" + isInit);
        if (isInit) {
            RecalculateStrategy recalculateStrategy = scheme.getRecalculateStrategy(context.getEntityKey());
            String pluginType = recalculateStrategy.getPluginType();
            String pluginName = recalculateStrategy.getPluginName();
            IRecalculatePlugin recalculatePlugin = PluginFactory.getRecalculatePlugin(pluginType, pluginName);
            recalculatePlugin.init(scheme, context);
            logger.info("\u4fe1\u7528\u63d2\u4ef6\u8c03\u7528 createPluginInstance recalculatePlugin \uff1a" + pluginName + "-----schemeid: " + scheme.getId());
            logger.info("\u4fe1\u7528\u63d2\u4ef6\u8c03\u7528 createPluginInstance recalculatePlugin end \uff1a" + new Date(System.currentTimeMillis()));
            return recalculatePlugin;
        }
        BillStrategy billSetting = scheme.getBillStrategy(context.getEntityKey());
        String pluginType = billSetting.getPluginType();
        String pluginName = billSetting.getPluginName();
        try {
            plugin = PluginFactory.getCreditPlugin(pluginType, pluginName);
            plugin.init(scheme, context);
        }
        catch (RuntimeException e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u201c\u4fe1\u7528\u63a7\u5236\u7ba1\u7406\u201d\u7684\u5355\u636e\u7b56\u7565\uff1a%1$s (%2$s) \u4e2d\u7684\u63d2\u4ef6\u201c%3$s\u201d\u65e0\u6cd5\u8bc6\u522b\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"CreditPluginProxy_0", (String)"scmc-ccm-business", (Object[])new Object[]{billSetting.getName() != null ? billSetting.getName().toString() : "", billSetting.getNumber(), pluginName}));
        }
        logger.info("\u4fe1\u7528\u63d2\u4ef6\u8c03\u7528 createPluginInstance creditPlugin \uff1a" + pluginName + "-----schemeid: " + scheme.getId());
        logger.info("\u4fe1\u7528\u63d2\u4ef6\u8c03\u7528 createPluginInstance creditPlugin end \uff1a" + new Date(System.currentTimeMillis()));
        return plugin;
    }

    private void registerService() {
        this.registerServiceArgs = new RegisterServiceArgs(this.scheme, this.context);
        this.plugin.registerService(this.registerServiceArgs);
    }

    public List<JournalGroup> buildJournals(List<DynamicObject> bills) {
        List<JournalGroup> journalGroups;
        BeforeBuildJournalArgs beforeBuildJournalArgs = new BeforeBuildJournalArgs(this.scheme, this.context);
        this.plugin.beforeBuildJournal(beforeBuildJournalArgs);
        JournalBuilder journalBuilder = this.registerServiceArgs.getJournalBuilder();
        if (journalBuilder == null) {
            journalGroups = this.facade.buildJournals(this.scheme, this.context, bills);
            if (journalGroups == null) {
                logger.info("\u4fe1\u7528 buildJournals \u672a\u8c03\u7528\u63d2\u4ef6\u524d\u6784\u9020\u7684journalGroups size \uff1a{}", (Object)0);
            } else {
                logger.info("\u4fe1\u7528 buildJournals \u672a\u8c03\u7528\u63d2\u4ef6\u524d\u6784\u9020\u7684journalGroups size \uff1a{}", (Object)journalGroups.size());
                for (JournalGroup journalGroup : journalGroups) {
                    if (journalGroup == null) continue;
                    for (Journal journal : journalGroup.getJournals()) {
                        if (journal == null) {
                            logger.info("\u4fe1\u7528 buildJournals \u672a\u8c03\u7528\u63d2\u4ef6\u524d\u6784\u9020\u7684journalGroups \u4e2d\u7684journal is null!");
                            continue;
                        }
                        logger.info("\u4fe1\u7528 buildJournals \u672a\u8c03\u7528\u63d2\u4ef6\u524d\u6784\u9020\u7684journalGroups \u4e2d\u7684journal.getJournalId\uff1a{}", (Object)journal.getJournalId());
                        logger.info("\u4fe1\u7528 buildJournals \u672a\u8c03\u7528\u63d2\u4ef6\u524d\u6784\u9020\u7684journalGroups \u4e2d\u7684journal.getArchiveId\uff1a{}", (Object)journal.getArchiveId());
                        logger.info("\u4fe1\u7528 buildJournals \u672a\u8c03\u7528\u63d2\u4ef6\u524d\u6784\u9020\u7684journalGroups \u4e2d\u7684journal.getMainEntityKey()\uff1a{}", (Object)journal.getMainEntityKey());
                        logger.info("\u4fe1\u7528 buildJournals \u672a\u8c03\u7528\u63d2\u4ef6\u524d\u6784\u9020\u7684journalGroups \u4e2d\u7684journal.getBillNo\uff1a{}", (Object)journal.getBillNo());
                        logger.info("\u4fe1\u7528 buildJournals \u672a\u8c03\u7528\u63d2\u4ef6\u524d\u6784\u9020\u7684journalGroups \u4e2d\u7684journal.getAction\uff1a{}", (Object)journal.getAction());
                        logger.info("\u4fe1\u7528 buildJournals \u672a\u8c03\u7528\u63d2\u4ef6\u524d\u6784\u9020\u7684journalGroups \u4e2d\u7684journal.getOp\uff1a{}", (Object)journal.getOp());
                        logger.info("\u4fe1\u7528 buildJournals \u672a\u8c03\u7528\u63d2\u4ef6\u524d\u6784\u9020\u7684journalGroups \u4e2d\u7684journal.getAmount\uff1a{}", (Object)journal.getAmount());
                    }
                }
            }
        } else {
            journalGroups = journalBuilder.buildJournals(bills);
            logger.info("\u4fe1\u7528 buildJournals \u8c03\u7528\u63d2\u4ef6buildJournals\u6784\u9020\u7684journalGroups size \uff1a{}", (Object)(journalGroups != null ? journalGroups.size() : 0));
        }
        AfterBuildJournalArgs afterBuildJournalArgs = new AfterBuildJournalArgs(this.scheme, this.context);
        afterBuildJournalArgs.setJournalGroups(journalGroups);
        afterBuildJournalArgs.setBills(bills);
        this.plugin.afterBuildJournal(afterBuildJournalArgs);
        logger.info("\u4fe1\u7528 buildJournals \u8c03\u7528\u7684\u63d2\u4ef6 \uff1a" + this.plugin.getClass());
        if (journalGroups != null) {
            logger.info("\u4fe1\u7528 buildJournals \u8c03\u7528\u63d2\u4ef6\u540e\u7684journalGroups size \uff1a{}", (Object)journalGroups.size());
            for (JournalGroup afterPluginJournalGroup : journalGroups) {
                if (afterPluginJournalGroup == null) continue;
                for (Journal journal : afterPluginJournalGroup.getJournals()) {
                    if (journal == null) {
                        logger.info("\u4fe1\u7528 buildJournals \u8c03\u7528\u63d2\u4ef6\u540e\u7684journalGroups \u4e2d\u7684journal is null");
                        continue;
                    }
                    logger.info("\u4fe1\u7528 buildJournals \u8c03\u7528\u63d2\u4ef6\u540e\u7684journalGroups \u4e2d\u7684journal.getJournalId\uff1a{}", (Object)journal.getJournalId());
                    logger.info("\u4fe1\u7528 buildJournals \u8c03\u7528\u63d2\u4ef6\u540e\u7684journalGroups \u4e2d\u7684journal.getArchiveId\uff1a{}", (Object)journal.getArchiveId());
                    logger.info("\u4fe1\u7528 buildJournals \u8c03\u7528\u63d2\u4ef6\u540e\u7684journalGroups \u4e2d\u7684journal.getMainEntityKey()\uff1a{}", (Object)journal.getMainEntityKey());
                    logger.info("\u4fe1\u7528 buildJournals \u8c03\u7528\u63d2\u4ef6\u540e\u7684journalGroups \u4e2d\u7684journal.getBillNo\uff1a{}", (Object)journal.getBillNo());
                    logger.info("\u4fe1\u7528 buildJournals \u8c03\u7528\u63d2\u4ef6\u540e\u7684journalGroups \u4e2d\u7684journal.getAction\uff1a{}", (Object)journal.getAction());
                    logger.info("\u4fe1\u7528 buildJournals \u8c03\u7528\u63d2\u4ef6\u540e\u7684journalGroups \u4e2d\u7684journal.getOp\uff1a{}", (Object)journal.getOp());
                    logger.info("\u4fe1\u7528 buildJournals \u8c03\u7528\u63d2\u4ef6\u540e\u7684journalGroups \u4e2d\u7684journal.getAmount\uff1a{}", (Object)journal.getAmount());
                }
            }
        } else {
            logger.info("\u4fe1\u7528 buildJournals \u8c03\u7528\u63d2\u4ef6\u540e\u7684journalGroups size \uff1a{}", (Object)0);
        }
        logger.info("\u4fe1\u7528 buildJournals end \uff1a" + new Date(System.currentTimeMillis()));
        return journalGroups;
    }

    public ArchiveCollection loadArchives(List<DimensionValue> dimensionValues) {
        ArchiveLoader archiveLoader = this.registerServiceArgs.getArchiveLoader();
        ArchiveCollection archives = new ArchiveCollection(this.scheme);
        archives = archiveLoader == null ? this.facade.loadArchives(this.scheme, dimensionValues) : archiveLoader.loadArchives(this.scheme, dimensionValues);
        AfterLoadArchiveArgs afterLoadArchiveArgs = new AfterLoadArchiveArgs(this.scheme, this.context);
        this.plugin.afterLoadArchive(afterLoadArchiveArgs);
        return archives;
    }

    public List<CheckResult> check(List<JournalGroup> journalGroups, ArchiveCollection archives) {
        CreditChecker checker = this.registerServiceArgs.getChecker();
        if (checker == null) {
            return this.facade.check(this.scheme, journalGroups, archives);
        }
        LinkedList<CheckResult> results = new LinkedList<CheckResult>();
        for (JournalGroup journalGroup : journalGroups) {
            CheckResult checkResult = checker.check(journalGroup, archives);
            results.add(checkResult);
        }
        return results;
    }

    public List<CheckResult> update(List<JournalGroup> journalGroups, ArchiveCollection archives, boolean isReverse) {
        LinkedList<CheckResult> results = new LinkedList<CheckResult>();
        for (JournalGroup journalGroup : journalGroups) {
            CheckResult checkResult = this.facade.updateBalance(journalGroup, archives, isReverse);
            results.add(checkResult);
        }
        return results;
    }

    public List<DynamicObject> loadBills() {
        return ((IRecalculatePlugin)this.plugin).loadBills();
    }

    public List<String> getRequireFields(String entityKey) {
        return this.plugin.getRequiredFields(entityKey);
    }
}

