/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.business.plugin;

import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.scmc.ccm.business.plugin.DefaultCreditServicePlugin;
import kd.scmc.ccm.business.plugin.ICreditPlugin;
import kd.scmc.ccm.business.recalculate.IRecalculatePlugin;
import kd.scmc.ccm.business.recalculate.RecalculatePlugin;
import kd.scmc.ccm.common.ks.KsLoader;

public class PluginFactory {
    public static ICreditPlugin getCreditPlugin(String pluginType, String pluginName) {
        if (StringUtils.isEmpty((CharSequence)pluginName)) {
            return new DefaultCreditServicePlugin();
        }
        return PluginFactory.createPlugin(pluginType, pluginName, ICreditPlugin.class);
    }

    public static IRecalculatePlugin getRecalculatePlugin(String pluginType, String pluginName) {
        if (StringUtils.isEmpty((CharSequence)pluginName)) {
            return new RecalculatePlugin();
        }
        return PluginFactory.createPlugin(pluginType, pluginName, IRecalculatePlugin.class);
    }

    private static <T> T createPlugin(String pluginType, String pluginName, Class<T> pluginInterface) {
        if ("ks".equals(pluginType)) {
            KsLoader ksLoader = new KsLoader();
            Map script = ksLoader.getScript(pluginName);
            return (T)ksLoader.wapScript(pluginName, (String)script.get("scriptcontext"), pluginInterface, new Object[0]);
        }
        try {
            Class<?> pluginClass = Class.forName(pluginName);
            return (T)pluginClass.newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }
}

