/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.business.plugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.ccm.business.core.Direction;
import kd.scmc.ccm.business.journal.Journal;
import kd.scmc.ccm.business.journal.JournalGroup;
import kd.scmc.ccm.business.plugin.AbstractCreditPlugin;
import kd.scmc.ccm.business.plugin.event.AfterBuildJournalArgs;
import kd.scmc.ccm.business.scheme.BillStrategy;

public abstract class SrcMergedCreditPlugin
extends AbstractCreditPlugin {
    @Override
    public void afterBuildJournal(AfterBuildJournalArgs args) {
        super.afterBuildJournal(args);
        List<DynamicObject> bills = args.getBills();
        Map<String, Set<Long>> srcIdsMap = this.getSrcBillInfo(bills);
        this.filterSrcBills(srcIdsMap);
        Map<String, Map<Long, BigDecimal>> srcEntryRowsMap = this.loadSrcPriceInfo(srcIdsMap);
        List<JournalGroup> billJournalGroups = args.getJournalGroups();
        for (JournalGroup journalGroup : billJournalGroups) {
            DynamicObject bill = this.matchBill(journalGroup, bills);
            if (bill == null) continue;
            this.modifyJournal(bill, journalGroup, srcEntryRowsMap);
        }
    }

    private Map<String, Set<Long>> getSrcBillInfo(List<DynamicObject> bills) {
        String entryKey = this.getEntryKey();
        HashMap<String, Set<Long>> srcIdsMap = new HashMap<String, Set<Long>>();
        for (DynamicObject bill : bills) {
            String srcEntityKey = this.getSrcEntityKey(bill);
            if (!this.isSrcEntityInBusinessRoute(srcEntityKey)) continue;
            DynamicObjectCollection entry = bill.getDynamicObjectCollection(entryKey);
            for (DynamicObject row : entry) {
                long srcId = this.getSrcId(row);
                this.addToMap(srcEntityKey, srcId, srcIdsMap);
            }
        }
        return srcIdsMap;
    }

    private void addToMap(String key, long srcRowId, Map<String, Set<Long>> entryIdsMap) {
        Set<Long> list = entryIdsMap.get(key);
        if (list != null) {
            list.add(srcRowId);
        } else {
            HashSet<Long> linkedList = new HashSet<Long>();
            linkedList.add(srcRowId);
            entryIdsMap.put(key, linkedList);
        }
    }

    private Map<String, Map<Long, BigDecimal>> loadSrcPriceInfo(Map<String, Set<Long>> srcIdsMap) {
        HashMap<String, Map<Long, BigDecimal>> srcEntryRowsMap = new HashMap<String, Map<Long, BigDecimal>>(srcIdsMap.size());
        for (Map.Entry<String, Set<Long>> entry : srcIdsMap.entrySet()) {
            String srcEntityKey = entry.getKey();
            Set<Long> billIds = entry.getValue();
            String srcEntryKey = this.getSrcEntryKey(srcEntityKey);
            String srcPriceKey = this.getSrcPriceKey(srcEntityKey);
            QFilter entryFilter = new QFilter("id", "in", billIds);
            DynamicObjectCollection srcEntryRows = QueryServiceHelper.query((String)srcEntityKey, (String)(srcEntryKey + ".id," + srcEntryKey + "." + srcPriceKey), (QFilter[])new QFilter[]{entryFilter});
            Map<Long, BigDecimal> srcPriceMap = srcEntryRows.stream().collect(Collectors.toMap(row -> row.getLong(srcEntryKey + ".id"), row -> row.getBigDecimal(srcEntryKey + "." + srcPriceKey)));
            srcEntryRowsMap.put(srcEntityKey, srcPriceMap);
        }
        return srcEntryRowsMap;
    }

    private void filterSrcBills(Map<String, Set<Long>> srcIdsMap) {
        for (Map.Entry<String, Set<Long>> entry : srcIdsMap.entrySet()) {
            String srcEntityKey = entry.getKey();
            Set<Long> billIds = entry.getValue();
            List<JournalGroup> srcJournals = this.creditServiceFacade.loadJournals(this.scheme, srcEntityKey, billIds);
            for (JournalGroup journalGroup : srcJournals) {
                long billId = journalGroup.getMainBillId();
                if (billIds.contains(billId)) continue;
                billIds.remove(billId);
            }
        }
    }

    private DynamicObject matchBill(JournalGroup journalGroup, List<DynamicObject> bills) {
        for (DynamicObject bill : bills) {
            if (journalGroup.getMainBillId() != bill.getLong("id")) continue;
            return bill;
        }
        return null;
    }

    private JournalGroup modifyJournal(DynamicObject bill, JournalGroup journalGroup, Map<String, Map<Long, BigDecimal>> srcEntryRowsMap) {
        String srcEntityKey = this.getSrcEntityKey(bill);
        String qtyKey = this.getQtyKey();
        HashSet<String> billNoSet = new HashSet<String>();
        HashMap<String, BigDecimal> amountMap = new HashMap<String, BigDecimal>();
        HashMap<String, Long> srcInfoMap = new HashMap<String, Long>();
        String entryKey = this.getEntryKey();
        Map<Long, BigDecimal> srcPriceMap = srcEntryRowsMap.get(srcEntityKey);
        if (srcPriceMap != null) {
            DynamicObjectCollection entry = bill.getDynamicObjectCollection(entryKey);
            for (DynamicObject row : entry) {
                long srcEntryId = this.getSrcRowId(row);
                BigDecimal price = srcPriceMap.get(srcEntryId);
                if (price == null) continue;
                BigDecimal rowReverseAmount = row.getBigDecimal(qtyKey).multiply(price);
                Map<Long, String> srcBillInfoMap = this.getSrcBillInfoMap(bill);
                for (Map.Entry<Long, String> srcBillInfo : srcBillInfoMap.entrySet()) {
                    Long key = srcBillInfo.getKey();
                    if (srcEntryId != key) continue;
                    String value = srcBillInfo.getValue();
                    srcInfoMap.put(value, this.getSrcId(row));
                    if (billNoSet.add(value)) {
                        amountMap.put(value, rowReverseAmount);
                        continue;
                    }
                    BigDecimal reverseAmount = ((BigDecimal)amountMap.get(value)).add(rowReverseAmount);
                    amountMap.put(value, reverseAmount);
                }
            }
            ArrayList<Journal> srcJournals = new ArrayList<Journal>();
            for (Journal journal : journalGroup.getJournals()) {
                if (!"amount".equals(journal.getQuotaType())) continue;
                for (Map.Entry map : amountMap.entrySet()) {
                    Journal copyJournal = journal.copy();
                    copyJournal.setDirection(Direction.INCREASE.name());
                    copyJournal.setBillNo((String)map.getKey());
                    copyJournal.setEntityKey(srcEntityKey);
                    copyJournal.setBillId((Long)srcInfoMap.get(map.getKey()));
                    copyJournal.setOriginalAmount((BigDecimal)map.getValue());
                    copyJournal.setAmount(((BigDecimal)map.getValue()).multiply(copyJournal.getConversionRate()));
                    srcJournals.add(copyJournal);
                }
            }
            for (Journal srcJournal : srcJournals) {
                journalGroup.getJournals().add(0, srcJournal);
            }
        }
        return journalGroup;
    }

    protected boolean isSrcEntityInBusinessRoute(String srcEntityKey) {
        List<BillStrategy> billSettings = this.scheme.getBillStrategies();
        for (BillStrategy billSetting : billSettings) {
            if (!Objects.equals(srcEntityKey, billSetting.getEntityKey())) continue;
            return true;
        }
        return false;
    }

    protected abstract String getSrcEntityKey(DynamicObject var1);

    protected abstract String getEntryKey();

    protected abstract String getQtyKey();

    protected abstract long getSrcRowId(DynamicObject var1);

    protected abstract long getSrcId(DynamicObject var1);

    protected abstract String getSrcEntryKey(String var1);

    protected abstract String getSrcPriceKey(String var1);

    protected abstract Map<Long, String> getSrcBillInfoMap(DynamicObject var1);
}

