/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.business.recalculate;

import java.util.List;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.scmc.ccm.business.core.CreditElement;
import kd.scmc.ccm.business.core.Expression;
import kd.scmc.ccm.business.core.Field;
import kd.scmc.ccm.business.recalculate.RecalculateStrategy;
import kd.scmc.ccm.business.scheme.CreditScheme;
import kd.scmc.ccm.business.setting.EntityConfig;

public class RecalculateFilterBuilder {
    public QFilter buildFilter(CreditScheme scheme, RecalculateStrategy recalculateStrategy, Expression expression) {
        EntityConfig config = recalculateStrategy.getConfig();
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)recalculateStrategy.getEntityKey());
        FilterCondition filterCondition = expression.getCondition().getCondition().getFilterCondition();
        FilterBuilder filterBuilder = new FilterBuilder(dataEntityType, filterCondition);
        filterBuilder.buildFilter();
        QFilter qFilter = filterBuilder.getQFilter();
        List<Long> orgScopes = scheme.getOrgScopes();
        if (orgScopes != null) {
            Field orgField = config.getField(CreditElement.ELEMENT_ORG);
            String orgFilterKey = orgField.getKey();
            if (orgField.getEntryKey() != null) {
                orgFilterKey = orgField.getEntryKey() + "." + orgField.getKey();
            }
            QFilter orgFilter = new QFilter(orgFilterKey, "in", orgScopes);
            qFilter.and(orgFilter);
        }
        if (scheme.isSingleCurrencyControl()) {
            Field currencyField = config.getField(CreditElement.ELEMENT_CURRENCY);
            String currencyFilterKey = currencyField.getKey();
            if (currencyField.getEntryKey() != null) {
                currencyFilterKey = currencyField.getEntryKey() + "." + currencyField.getKey();
            }
            QFilter currencyFilter = new QFilter(currencyFilterKey, "=", (Object)scheme.getCurrency());
            qFilter.and(currencyFilter);
        }
        return qFilter;
    }
}

