/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.business.recalculate;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.scmc.ccm.business.core.Expression;
import kd.scmc.ccm.business.plugin.AbstractCreditPlugin;
import kd.scmc.ccm.business.recalculate.IRecalculatePlugin;
import kd.scmc.ccm.business.recalculate.RecalculateFilterBuilder;
import kd.scmc.ccm.business.recalculate.RecalculateStrategy;
import kd.scmc.ccm.business.setting.EntityConfig;
import kd.scmc.ccm.common.util.OrmFacade;

public class RecalculatePlugin
extends AbstractCreditPlugin
implements IRecalculatePlugin {
    private OrmFacade ormFacade = new OrmFacade();
    private static final Log logger = LogFactory.getLog(RecalculatePlugin.class);

    @Override
    public List<DynamicObject> loadBills() {
        RecalculateStrategy recalculateStrategy = this.scheme.getRecalculateStrategy(this.context.getEntityKey());
        EntityConfig entityConfig = recalculateStrategy.getConfig();
        RecalculateFilterBuilder recalculateFilterBuilder = new RecalculateFilterBuilder();
        List<Expression> expressions = recalculateStrategy.getExpressions();
        LinkedList<DynamicObject> recalculateBills = new LinkedList<DynamicObject>();
        HashSet<Object> billIdSet = new HashSet<Object>(100);
        Set<String> selectors = entityConfig.getSelectors();
        for (Expression expression : expressions) {
            DynamicObject[] bills;
            QFilter filter = recalculateFilterBuilder.buildFilter(this.scheme, recalculateStrategy, expression);
            logger.info("RecalculatePlugin.loadBills:" + filter);
            for (DynamicObject bill : bills = this.ormFacade.load(recalculateStrategy.getEntityKey(), String.join((CharSequence)",", selectors), new QFilter[]{filter})) {
                Object billId = bill.getPkValue();
                if (!billIdSet.add(billId)) continue;
                recalculateBills.add(bill);
            }
        }
        if (recalculateBills.isEmpty()) {
            logger.info("RecalculatePlugin.loadBills : bills is empty");
        }
        return recalculateBills;
    }
}

