/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.business.recalculate;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.ccm.business.archives.ArchiveCollection;
import kd.scmc.ccm.business.archives.ArchiveService;
import kd.scmc.ccm.business.archives.CreditArchive;
import kd.scmc.ccm.business.check.CheckResult;
import kd.scmc.ccm.business.core.CreditContext;
import kd.scmc.ccm.business.core.DimensionValue;
import kd.scmc.ccm.business.journal.Journal;
import kd.scmc.ccm.business.journal.JournalGroup;
import kd.scmc.ccm.business.plugin.CreditPluginProxy;
import kd.scmc.ccm.business.recalculate.RecalculateStrategy;
import kd.scmc.ccm.business.scheme.CreditScheme;
import kd.scmc.ccm.business.scheme.SchemeValidator;
import kd.scmc.ccm.business.service.CreditServiceFacade;

public class RecalculateService {
    private CreditServiceFacade facade;

    public RecalculateService() {
        this.facade = new CreditServiceFacade();
    }

    public RecalculateService(CreditServiceFacade facade) {
        this.facade = facade;
    }

    public List<CreditArchive> recalculatePreview(CreditScheme scheme, String dimensionRangeMode, List<DimensionValue> dimensionValues) {
        return this.recalculate(scheme, dimensionRangeMode, dimensionValues, false);
    }

    public List<Journal> recalculateDetailPreview(CreditScheme scheme, DimensionValue dimensionValue) {
        this.removeRedundantStrategies(scheme);
        LinkedList<Journal> journals = new LinkedList<Journal>();
        for (RecalculateStrategy recalculateStrategy : scheme.getRecalculateStrategies()) {
            CreditContext context = new CreditContext();
            context.setEntityKey(recalculateStrategy.getEntityKey());
            context.setCreditAction("INIT");
            CreditPluginProxy pluginProxy = new CreditPluginProxy(scheme, context, this.facade);
            List<DynamicObject> bills = pluginProxy.loadBills();
            List<JournalGroup> journalGroups = pluginProxy.buildJournals(bills);
            for (JournalGroup journalGroup : journalGroups) {
                for (Journal journal : journalGroup.getJournals()) {
                    if (!Objects.equals(dimensionValue, journal.getDimensionValue())) continue;
                    journals.add(journal);
                }
            }
        }
        ArrayList<DimensionValue> dimensionValues = new ArrayList<DimensionValue>(1);
        dimensionValues.add(dimensionValue);
        ArchiveCollection archives = this.facade.loadArchives(scheme, dimensionValues);
        List<JournalGroup> adjustmentJournalGroups = this.getAdjustmentJournalGroups(archives, scheme);
        for (JournalGroup adjustmentJournalGroup : adjustmentJournalGroups) {
            for (Journal adjustmentJournal : adjustmentJournalGroup.getJournals()) {
                journals.add(adjustmentJournal);
            }
        }
        return journals;
    }

    public List<CreditArchive> recalculate(CreditScheme scheme, String dimensionRangeMode, List<DimensionValue> dimensionValues) {
        Throwable throwable = null;
        try (TXHandle tx = TX.required();){
            List<CreditArchive> list = this.recalculate(scheme, dimensionRangeMode, dimensionValues, true);
            return list;
        }
        catch (Exception e) {
            try {
                tx.markRollback();
                throw e;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private List<CreditArchive> recalculate(CreditScheme scheme, String mode, List<DimensionValue> dimensionValues, boolean persistent) {
        CheckResult checkResult = new SchemeValidator().checkSetting(scheme);
        if (!checkResult.isSuccess()) {
            throw new KDBizException(checkResult.getMessage());
        }
        LinkedList<JournalGroup> journals = new LinkedList<JournalGroup>();
        ArchiveCollection archives = null;
        archives = "ALL".equals(mode) ? this.facade.loadArchives(scheme) : this.facade.loadArchives(scheme, dimensionValues);
        for (CreditArchive archive : archives.values()) {
            List<DynamicObject> rawArchives = archive.getRawArchives();
            Iterator<Object> iterator = rawArchives.iterator();
            while (iterator.hasNext()) {
                DynamicObject rawArchive = iterator.next();
                rawArchive.set("balance", rawArchive.get("quota"));
                rawArchive.set("reducesum", (Object)BigDecimal.ZERO);
                rawArchive.set("increasesum", (Object)BigDecimal.ZERO);
            }
            archive.setBalance(archive.getQuota());
        }
        List<JournalGroup> adjustmentJournalGroups = this.getAdjustmentJournalGroups(archives, scheme);
        ArchiveService service = new ArchiveService();
        for (JournalGroup journalGroup : adjustmentJournalGroups) {
            service.updateBalance(journalGroup, archives, false);
        }
        this.removeRedundantStrategies(scheme);
        List<RecalculateStrategy> recalculateStrategies = scheme.getRecalculateStrategies();
        for (RecalculateStrategy recalculateStrategy : recalculateStrategies) {
            CreditContext context = new CreditContext();
            context.setEntityKey(recalculateStrategy.getEntityKey());
            context.setCreditAction("INIT");
            CreditPluginProxy pluginProxy = new CreditPluginProxy(scheme, context, this.facade);
            List<DynamicObject> bills = pluginProxy.loadBills();
            List<JournalGroup> journalGroups = pluginProxy.buildJournals(bills);
            journals.addAll(journalGroups);
            pluginProxy.update(journalGroups, archives, false);
        }
        if (persistent) {
            if ("ALL".equals(mode)) {
                this.facade.deleteJournal(scheme);
            } else {
                this.facade.deleteJournal(scheme, dimensionValues);
            }
            this.facade.saveJournals(journals);
            this.facade.saveArchives(archives.values());
        }
        return new LinkedList<CreditArchive>(archives.values());
    }

    private List<JournalGroup> getAdjustmentJournalGroups(ArchiveCollection archives, CreditScheme scheme) {
        HashSet<Long> relatedIds = new HashSet<Long>(archives.size());
        for (CreditArchive archive : archives.values()) {
            List<DynamicObject> rawArchives = archive.getRawArchives();
            for (DynamicObject rawArchive : rawArchives) {
                relatedIds.add(rawArchive.getLong("relatedid"));
            }
        }
        QFilter relatedIdFilter = new QFilter("relatedid", "in", relatedIds);
        DynamicObjectCollection archiveObjs = QueryServiceHelper.query((String)"ccm_archive", (String)"id", (QFilter[])new QFilter[]{relatedIdFilter});
        HashSet<Long> archiveIds = new HashSet<Long>(archiveObjs.size());
        for (DynamicObject archiveObj : archiveObjs) {
            archiveIds.add(archiveObj.getLong("id"));
        }
        return this.facade.loadJournals(scheme, archiveIds, "ADJUST");
    }

    private void removeRedundantStrategies(CreditScheme scheme) {
        List<RecalculateStrategy> recalculateStrategies = scheme.getRecalculateStrategies();
        Iterator<RecalculateStrategy> iterator = recalculateStrategies.iterator();
        while (iterator.hasNext()) {
            RecalculateStrategy recalculateStrategy = iterator.next();
            if (!recalculateStrategy.getExpressions().isEmpty() || !StringUtils.isBlank((CharSequence)recalculateStrategy.getPluginName())) continue;
            iterator.remove();
        }
        Map<String, List<RecalculateStrategy>> groupbyStrategies = recalculateStrategies.stream().collect(Collectors.groupingBy(RecalculateStrategy::getEntityKey));
        HashSet<RecalculateStrategy> removeableStrategies = new HashSet<RecalculateStrategy>(10);
        for (List<RecalculateStrategy> value : groupbyStrategies.values()) {
            if (value.size() <= 1) continue;
            ListIterator<RecalculateStrategy> listIterator = value.listIterator(value.size());
            while (listIterator.hasPrevious() && value.size() > 1) {
                RecalculateStrategy strategy = listIterator.previous();
                if (!StringUtils.isBlank((CharSequence)strategy.getPluginName())) continue;
                removeableStrategies.add(strategy);
                listIterator.remove();
            }
        }
        ListIterator<RecalculateStrategy> listIterator = recalculateStrategies.listIterator(recalculateStrategies.size());
        while (listIterator.hasPrevious()) {
            RecalculateStrategy strategy = listIterator.previous();
            if (!removeableStrategies.contains(strategy)) continue;
            listIterator.remove();
        }
    }
}

