/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.business.recalculate;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.scmc.ccm.business.core.CreditContext;
import kd.scmc.ccm.business.core.CreditElement;
import kd.scmc.ccm.business.core.Expression;
import kd.scmc.ccm.business.recalculate.IRecalculatePlugin;
import kd.scmc.ccm.business.recalculate.RecalculatePlugin;
import kd.scmc.ccm.business.scheme.CreditScheme;
import kd.scmc.ccm.business.setting.EntityConfig;
import kd.scmc.ccm.business.valuegetter.ValueGetter;
import kd.scmc.ccm.business.valuegetter.ValueGetterManager;
import kd.scmc.ccm.common.ks.KsLoader;

public class RecalculateStrategy {
    private String entityKey;
    private EntityConfig config;
    private List<Expression> expressions = new ArrayList<Expression>();
    private String pluginType;
    private String pluginName;
    private IRecalculatePlugin plugin;
    private ValueGetterManager valueGetterManager;

    public String getEntityKey() {
        return this.entityKey;
    }

    public void setEntityKey(String entityKey) {
        this.entityKey = entityKey;
    }

    public IRecalculatePlugin getPlugin(CreditScheme scheme, CreditContext context) {
        if (this.plugin == null) {
            this.plugin = this.createPlugin(this.pluginName, this.pluginType);
            this.plugin.init(scheme, context);
        }
        return this.plugin;
    }

    public void setPlugin(IRecalculatePlugin plugin) {
        this.plugin = plugin;
    }

    public EntityConfig getConfig() {
        return this.config;
    }

    public void setConfig(EntityConfig config) {
        this.config = config;
    }

    private IRecalculatePlugin createPlugin(String pluginName, String pluginType) {
        if (StringUtils.isEmpty((CharSequence)pluginName)) {
            return new RecalculatePlugin();
        }
        if ("ks".equals(pluginType)) {
            KsLoader ksLoader = new KsLoader();
            Map script = ksLoader.getScript(pluginName);
            return (IRecalculatePlugin)ksLoader.wapScript(pluginName, (String)script.get("scriptcontext"), IRecalculatePlugin.class, new Object[0]);
        }
        try {
            Class<?> pluginClass = Class.forName(pluginName);
            return (IRecalculatePlugin)pluginClass.newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    public ValueGetter getValueGetter(CreditElement element) {
        if (this.valueGetterManager == null) {
            this.valueGetterManager = new ValueGetterManager(this.config);
        }
        return this.valueGetterManager.getValueGetter(element);
    }

    public void setValueGetter(CreditElement element, ValueGetter valueGetter) {
        if (this.valueGetterManager == null) {
            this.valueGetterManager = new ValueGetterManager(this.config);
        }
        this.valueGetterManager.registerValueGetter(element, valueGetter);
    }

    public String getPluginType() {
        return this.pluginType;
    }

    public void setPluginType(String pluginType) {
        this.pluginType = pluginType;
    }

    public String getPluginName() {
        return this.pluginName;
    }

    public void setPluginName(String pluginName) {
        this.pluginName = pluginName;
    }

    public List<Expression> getExpressions() {
        return this.expressions;
    }

    public void setExpressions(List<Expression> expressions) {
        this.expressions = expressions;
    }
}

