/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.business.recalculatenew;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.scmc.ccm.business.core.CreditElement;
import kd.scmc.ccm.business.core.Direction;
import kd.scmc.ccm.business.core.Expression;
import kd.scmc.ccm.business.core.Field;
import kd.scmc.ccm.business.scheme.BillStrategy;
import kd.scmc.ccm.business.scheme.CreditScheme;
import kd.scmc.ccm.business.setting.EntityConfig;

public class RecalculateNewFilterBuilder {
    public QFilter buildFilter(CreditScheme scheme, BillStrategy billStrategy, Expression expression, Date beginDate) {
        EntityConfig config = billStrategy.getConfig();
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)billStrategy.getEntityKey());
        FilterCondition filterCondition = null;
        QFilter qFilter = QFilter.of((String)"1==1", (Object[])new Object[0]);
        if (expression.getCondition() != null && expression.getCondition().getCondition() != null && (filterCondition = expression.getCondition().getCondition().getFilterCondition()) != null) {
            FilterBuilder filterBuilder = new FilterBuilder(dataEntityType, filterCondition);
            filterBuilder.buildFilter();
            qFilter = filterBuilder.getQFilter();
        }
        List<Long> orgScopes = scheme.getOrgScopes();
        if (!scheme.isGlobalScheme() && orgScopes != null) {
            Field orgField = config.getField(CreditElement.ELEMENT_ORG);
            String orgFilterKey = orgField.getKey();
            if (orgField.getEntryKey() != null) {
                orgFilterKey = orgField.getEntryKey() + "." + orgField.getKey();
            }
            QFilter orgFilter = new QFilter(orgFilterKey, "in", orgScopes);
            qFilter.and(orgFilter);
        }
        if (scheme.isSingleCurrencyControl()) {
            Field currencyField = config.getField(CreditElement.ELEMENT_CURRENCY);
            String currencyFilterKey = currencyField.getKey();
            if (currencyField.getEntryKey() != null) {
                currencyFilterKey = currencyField.getEntryKey() + "." + currencyField.getKey();
            }
            QFilter currencyFilter = new QFilter(currencyFilterKey, "=", (Object)scheme.getCurrency());
            qFilter.and(currencyFilter);
        }
        if (dataEntityType == null) {
            return QFilter.of((String)"1!=1", (Object[])new Object[0]);
        }
        String entityKey = dataEntityType.getName();
        if (dataEntityType.findProperty("createtime") != null) {
            QFilter DateFilter = new QFilter("createtime", ">=", (Object)beginDate);
            DateFilter.and(new QFilter("createtime", "<=", (Object)new Date()));
            qFilter.and(DateFilter);
        }
        QFilter statusFilter = QFilter.of((String)"1!=1", (Object[])new Object[0]);
        if (dataEntityType.findProperty("billstatus") != null) {
            List<String> reduceOps = billStrategy.getReduceOps();
            List<String> increaseOps = billStrategy.getIncreaseOps();
            List<Object> checkOps = new ArrayList(3);
            checkOps = Direction.REDUCE == billStrategy.getDirection() ? reduceOps : increaseOps;
            if ("cas_recbill".equals(entityKey) && checkOps.contains("receivingrec") || "cas_paybill".equals(entityKey) && checkOps.contains("pay")) {
                statusFilter = new QFilter("billstatus", "=", (Object)"D");
            } else if (!"cas_paybill".equals(entityKey) && !"cas_recbill".equals(entityKey)) {
                statusFilter = checkOps.contains("audit") && !checkOps.contains("submit") ? new QFilter("billstatus", "=", (Object)"C") : (checkOps.contains("submit") ? new QFilter("billstatus", "in", (Object)new String[]{"B", "C"}) : QFilter.of((String)"1!=1", (Object[])new Object[0]));
            }
        }
        qFilter.and(statusFilter);
        return qFilter;
    }
}

