/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.business.recalculatenew;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scmc.ccm.business.archives.ArchiveCollection;
import kd.scmc.ccm.business.archives.ArchiveService;
import kd.scmc.ccm.business.archives.CreditArchive;
import kd.scmc.ccm.business.check.CheckResult;
import kd.scmc.ccm.business.core.CreditContext;
import kd.scmc.ccm.business.core.DimensionValue;
import kd.scmc.ccm.business.core.Expression;
import kd.scmc.ccm.business.core.Role;
import kd.scmc.ccm.business.journal.JournalGroup;
import kd.scmc.ccm.business.plugin.CreditPluginProxy;
import kd.scmc.ccm.business.recalculatenew.RecalculateNewFilterBuilder;
import kd.scmc.ccm.business.recalculatenew.record.RecalculateRecordHelper;
import kd.scmc.ccm.business.scheme.BillStrategy;
import kd.scmc.ccm.business.scheme.CreditScheme;
import kd.scmc.ccm.business.scheme.SchemeValidator;
import kd.scmc.ccm.business.service.CreditServiceFacade;
import kd.scmc.ccm.business.setting.DimensionEntryFieldMapper;
import kd.scmc.ccm.business.setting.EntityConfig;
import kd.scmc.ccm.common.util.OrmFacade;

public class RecalculateNewService {
    private static final Log LOGGER = LogFactory.getLog(RecalculateNewService.class);
    private CreditServiceFacade facade;

    public RecalculateNewService() {
        this.facade = new CreditServiceFacade();
    }

    public RecalculateNewService(CreditServiceFacade facade) {
        this.facade = facade;
    }

    public Map<Long, List<CreditArchive>> recalculatePreview(CreditScheme scheme, String dimensionRangeMode, List<DimensionValue> dimensionValues, Date beginDate) {
        Throwable throwable = null;
        try (TXHandle tx = TX.required();){
            Map<Long, List<CreditArchive>> map = this.recalculate(scheme, dimensionRangeMode, dimensionValues, beginDate);
            return map;
        }
        catch (Exception e) {
            try {
                tx.markRollback();
                throw e;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private Map<Long, List<CreditArchive>> recalculate(CreditScheme scheme, String mode, List<DimensionValue> dimensionValues, Date beginDate) {
        CheckResult checkResult = new SchemeValidator().checkSetting(scheme);
        if (!checkResult.isSuccess()) {
            throw new KDBizException(checkResult.getMessage());
        }
        LinkedList<JournalGroup> journals = new LinkedList<JournalGroup>();
        ArchiveCollection archives = null;
        archives = "ALL".equals(mode) ? this.facade.loadArchives(scheme, true) : this.facade.loadArchives(scheme, dimensionValues, true);
        if (archives != null && archives.size() > 0) {
            for (CreditArchive archive : archives.values()) {
                List<DynamicObject> rawArchives = archive.getRawArchives();
                Iterator<DynamicObject> iterator = rawArchives.iterator();
                while (iterator.hasNext()) {
                    DynamicObject rawArchive = iterator.next();
                    rawArchive.set("balance", rawArchive.get("quota"));
                    rawArchive.set("reducesum", (Object)BigDecimal.ZERO);
                    rawArchive.set("increasesum", (Object)BigDecimal.ZERO);
                }
                archive.setBalance(archive.getQuota());
            }
            List<JournalGroup> adjustmentJournalGroups = this.getAdjustmentJournalGroups(archives, scheme);
            ArchiveService service = new ArchiveService();
            for (JournalGroup journalGroup : adjustmentJournalGroups) {
                service.updateBalance(journalGroup, archives, false);
            }
            if (adjustmentJournalGroups != null && adjustmentJournalGroups.size() > 0) {
                journals.addAll(adjustmentJournalGroups);
            }
            List<BillStrategy> billStrategies = scheme.getBillStrategies();
            for (BillStrategy billStrategy : billStrategies) {
                CreditContext context = new CreditContext();
                context.setEntityKey(billStrategy.getEntityKey());
                context.setCreditAction("RECALCULATE");
                CreditPluginProxy pluginProxy = new CreditPluginProxy(scheme, context, this.facade);
                List<DynamicObject> bills = this.loadBills(scheme, context, this.facade, beginDate);
                List<JournalGroup> journalGroups = pluginProxy.buildJournals(bills);
                journals.addAll(journalGroups);
                pluginProxy.update(journalGroups, archives, false);
            }
            DynamicObject dynamicObject = this.buildAndSaveCurrentRecalRecord(scheme, journals, archives, beginDate);
            if (dynamicObject != null && dynamicObject.getLong("id") > 0L) {
                List<DynamicObject> dynDetails = RecalculateRecordHelper.transferJournalGroupToRecalDetails(journals, dynamicObject.getLong("id"));
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
                if (!dynDetails.isEmpty()) {
                    SaveServiceHelper.save((DynamicObject[])dynDetails.toArray(new DynamicObject[0]));
                }
                HashMap<Long, List<CreditArchive>> recalResult = new HashMap<Long, List<CreditArchive>>(1);
                recalResult.put(dynamicObject.getLong("id"), new LinkedList(archives.values()));
                return recalResult;
            }
            return null;
        }
        return null;
    }

    private DynamicObject buildAndSaveCurrentRecalRecord(CreditScheme scheme, List<JournalGroup> journals, ArchiveCollection archives, Date beginDate) {
        DynamicObject rrDO = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"ccm_recalculaterecord"));
        long recRecordID = DB.genLongId((String)"ccm_recalculaterecord");
        rrDO.set("id", (Object)recRecordID);
        rrDO.set("billno", (Object)("RR-" + recRecordID));
        rrDO.set("begindate", (Object)beginDate);
        rrDO.set("recalculator", (Object)UserServiceHelper.getCurrentUserId());
        rrDO.set("recalculatedate", (Object)new Date());
        rrDO.set("recstatus", (Object)"A");
        rrDO.set("scheme", (Object)scheme.getId());
        long dimensionid = scheme.getDimension().getId();
        rrDO.set("dimension", (Object)dimensionid);
        DimensionEntryFieldMapper mapper = new DimensionEntryFieldMapper(dimensionid);
        List<Role> roles = scheme.getDimension().getRoles();
        List<String> roleFieldKeys = mapper.getRoleFieldKeys();
        List<String> fieldTypeKeys = mapper.getFieldTypeKeys();
        for (String fieldTypeKey : fieldTypeKeys) {
            rrDO.set(fieldTypeKey, (Object)mapper.getBaseDataKey(fieldTypeKey));
        }
        LinkedList allArchives = new LinkedList(archives.values());
        DynamicObjectCollection rrentryDOCol = rrDO.getDynamicObjectCollection("billentry");
        for (int i = 0; i < allArchives.size(); ++i) {
            CreditArchive archive = (CreditArchive)allArchives.get(i);
            DynamicObject mainarchiveDo = archive.getMainArchive();
            DynamicObject rrEntryDO = rrentryDOCol.addNew();
            DimensionValue dimensionValue = archive.getDimensionValue();
            rrEntryDO.set("dimensionvalue", (Object)dimensionValue.getValue());
            rrEntryDO.set("dealtype", (Object)"A");
            for (int j = 0; j < roleFieldKeys.size(); ++j) {
                if (!mainarchiveDo.containsProperty(roleFieldKeys.get(j))) continue;
                rrEntryDO.set(roleFieldKeys.get(j), dimensionValue.getValue(roles.get(j)));
            }
            if (mainarchiveDo.containsProperty("relatedid")) {
                rrEntryDO.set("relatedid", mainarchiveDo.get("relatedid"));
            }
            this.setNewArchiveProValue(rrEntryDO, mainarchiveDo, "relatedid");
            rrEntryDO.set("quota", (Object)archive.getQuota());
            rrEntryDO.set("archivetype", (Object)mainarchiveDo.getString("archivetype"));
            rrEntryDO.set("archiveid", mainarchiveDo.get("id"));
            rrEntryDO.set("newincreasesum", (Object)mainarchiveDo.getBigDecimal("increasesum"));
            rrEntryDO.set("newreducesum", (Object)mainarchiveDo.getBigDecimal("reducesum"));
            rrEntryDO.set("oldbalance", (Object)archive.getOldBalance());
            rrEntryDO.set("newbalance", (Object)archive.getBalance());
        }
        return rrDO;
    }

    private void setNewArchiveProValue(DynamicObject rrEntryDO, DynamicObject mainarchiveDo, String propertyKey) {
        if (mainarchiveDo.containsProperty(propertyKey)) {
            rrEntryDO.set(propertyKey, mainarchiveDo.get(propertyKey));
        }
    }

    public List<DynamicObject> loadBills(CreditScheme scheme, CreditContext context, CreditServiceFacade facade, Date begindate) {
        OrmFacade ormFacade = new OrmFacade();
        BillStrategy billStrategy = scheme.getBillStrategy(context.getEntityKey());
        EntityConfig entityConfig = billStrategy.getConfig();
        RecalculateNewFilterBuilder recalculateFilterBuilder = new RecalculateNewFilterBuilder();
        List<Expression> expressions = billStrategy.getExpressions();
        LinkedList<DynamicObject> recalculateBills = new LinkedList<DynamicObject>();
        HashSet<Object> billIdSet = new HashSet<Object>(100);
        Set<String> selectors = entityConfig.getSelectors();
        for (Expression expression : expressions) {
            DynamicObject[] bills;
            QFilter filter = recalculateFilterBuilder.buildFilter(scheme, billStrategy, expression, begindate);
            LOGGER.info("RecalculatePlugin.loadBills:" + filter);
            for (DynamicObject bill : bills = ormFacade.load(billStrategy.getEntityKey(), String.join((CharSequence)",", selectors), new QFilter[]{filter})) {
                Object billId = bill.getPkValue();
                if (!billIdSet.add(billId)) continue;
                recalculateBills.add(bill);
            }
        }
        if (recalculateBills.isEmpty()) {
            LOGGER.info("RecalculatePlugin.loadBills : bills is empty");
        }
        return recalculateBills;
    }

    private List<JournalGroup> getAdjustmentJournalGroups(ArchiveCollection archives, CreditScheme scheme) {
        HashSet<Long> relatedIds = new HashSet<Long>(archives.size());
        for (CreditArchive archive : archives.values()) {
            List<DynamicObject> rawArchives = archive.getRawArchives();
            for (DynamicObject rawArchive : rawArchives) {
                relatedIds.add(rawArchive.getLong("relatedid"));
            }
        }
        QFilter relatedIdFilter = new QFilter("relatedid", "in", relatedIds);
        DynamicObjectCollection archiveObjs = QueryServiceHelper.query((String)"ccm_archive", (String)"id", (QFilter[])new QFilter[]{relatedIdFilter});
        HashSet<Long> archiveIds = new HashSet<Long>(archiveObjs.size());
        for (DynamicObject archiveObj : archiveObjs) {
            archiveIds.add(archiveObj.getLong("id"));
        }
        return this.facade.loadJournals(scheme, archiveIds, "ADJUST");
    }

    public boolean recalculateConfirm(Long currentRecalRecordID, CreditScheme scheme, String dimensionRangeMode, List<DimensionValue> dimensionValues) {
        try (TXHandle tx = TX.required();){
            boolean isSuccess = false;
            try {
                QFilter recordIDQfilter = new QFilter("recrecordid", "=", (Object)currentRecalRecordID);
                QFilter actionFilter = new QFilter("action", "<>", (Object)"ADJUST");
                OrmFacade ormFacade = new OrmFacade();
                DynamicObject recRecordDO = ormFacade.loadSingle((Object)currentRecalRecordID, "ccm_recalculaterecord");
                DynamicObjectCollection entryCol = recRecordDO.getDynamicObjectCollection("billentry");
                if (entryCol != null && entryCol.size() > 0) {
                    DynamicObject[] updateArchives;
                    ArrayList archivekeys = new ArrayList(entryCol.size());
                    HashMap updateDataMap = new HashMap(entryCol.size());
                    for (DynamicObject entry : entryCol) {
                        Long archiveid = entry.getLong("archiveid");
                        HashMap<String, BigDecimal> amountMap = new HashMap<String, BigDecimal>(3);
                        amountMap.put("newincreasesum", entry.getBigDecimal("newincreasesum"));
                        amountMap.put("newreducesum", entry.getBigDecimal("newreducesum"));
                        amountMap.put("newbalance", entry.getBigDecimal("newbalance"));
                        updateDataMap.put(archiveid, amountMap);
                    }
                    entryCol.forEach(o -> archivekeys.add(o.getLong("archiveid")));
                    MainEntityType archiveEntityType = MetadataServiceHelper.getDataEntityType((String)"ccm_archive");
                    for (DynamicObject upArchive : updateArchives = ormFacade.load(archivekeys.toArray(), archiveEntityType)) {
                        Map aMap = (Map)updateDataMap.get(upArchive.getLong("id"));
                        if (aMap == null) continue;
                        upArchive.set("increasesum", aMap.get("newincreasesum"));
                        upArchive.set("reducesum", aMap.get("newreducesum"));
                        upArchive.set("balance", aMap.get("newbalance"));
                    }
                    SaveServiceHelper.save((DynamicObject[])updateArchives);
                    LOGGER.info("\u6863\u6848\u5df2\u66f4\u65b0: " + entryCol.size() + " \u6761");
                }
                String selectors = RecalculateRecordHelper.getDetailsSelector(scheme);
                DynamicObject[] recDetailInfoDOs = ormFacade.load("ccm_recalculatedetail", selectors, new QFilter[]{recordIDQfilter, actionFilter});
                DynamicObject[] journals = RecalculateRecordHelper.detailDOsToJournalDOs(scheme, recDetailInfoDOs);
                if ("ALL".equals(dimensionRangeMode)) {
                    this.facade.deleteJournal(scheme);
                } else {
                    this.facade.deleteJournal(scheme, dimensionValues);
                }
                if (journals != null && journals.length > 0) {
                    SaveServiceHelper.save((DynamicObject[])journals);
                    LOGGER.info("\u6d41\u6c34\u5df2\u4fdd\u5b58: " + journals.length + " \u6761");
                }
                recRecordDO.set("recstatus", (Object)"B");
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{recRecordDO});
                isSuccess = true;
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
            boolean bl = isSuccess;
            return bl;
        }
    }
}

