/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.business.recalculatenew.record;

import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scmc.ccm.business.archives.ArchiveCollection;
import kd.scmc.ccm.business.core.DimensionValue;
import kd.scmc.ccm.business.core.Role;
import kd.scmc.ccm.business.journal.Journal;
import kd.scmc.ccm.business.journal.JournalGroup;
import kd.scmc.ccm.business.recalculatenew.record.RecalculateRecordInfo;
import kd.scmc.ccm.business.scheme.CreditScheme;
import kd.scmc.ccm.business.setting.DimensionEntryFieldMapper;

public class RecalculateRecordHelper {
    private static final Log LOGGER = LogFactory.getLog(RecalculateRecordHelper.class);

    public void buildRecRecordByArchives(List<JournalGroup> journalGroups, ArchiveCollection archives, Date beginDate) {
        RecalculateRecordInfo rrinfo = new RecalculateRecordInfo();
        long recRecordID = DB.genLongId((String)"ccm_recalculaterecord");
        rrinfo.setId(recRecordID);
        rrinfo.setBeginDate(beginDate);
        rrinfo.setRecalculator(UserServiceHelper.getCurrentUserId());
        rrinfo.setRecalculateDate(new Date());
        rrinfo.setBillNo("RR-" + recRecordID);
        rrinfo.setRecStatus("A");
    }

    public static List<DynamicObject> transferJournalGroupToRecalDetails(List<JournalGroup> journalGroups, long recRecordID) {
        LinkedList<DynamicObject> dynDetails = new LinkedList<DynamicObject>();
        for (JournalGroup journalGroup : journalGroups) {
            for (Journal journal : journalGroup.getJournals()) {
                if (journal.getArchiveId() == 0L) continue;
                dynDetails.add(RecalculateRecordHelper.journalToDetailDynamicObject(journal, recRecordID));
            }
        }
        return dynDetails;
    }

    public static DynamicObject journalToDetailDynamicObject(Journal journal, long recRecordID) {
        if (journal != null) {
            DynamicObject recalculateDetailInfoDO = BusinessDataServiceHelper.newDynamicObject((String)"ccm_recalculatedetail");
            DimensionValue dimensionValue = journal.getDimensionValue();
            long dimensionId = journal.getDimensionValue().getDimension().getId();
            DimensionEntryFieldMapper mapper = new DimensionEntryFieldMapper(dimensionId);
            List<String> fieldTypeKeys = mapper.getFieldTypeKeys();
            List<String> fieldKeys = mapper.getRoleFieldKeys();
            List<Role> roles = dimensionValue.getDimension().getRoles();
            Map<Role, Object> valueMap = dimensionValue.getValueMap();
            for (int i = 0; i < roles.size(); ++i) {
                recalculateDetailInfoDO.set(fieldTypeKeys.get(i), (Object)mapper.getBaseDataKey(fieldTypeKeys.get(i)));
                recalculateDetailInfoDO.set(fieldKeys.get(i), valueMap.get(roles.get(i)));
            }
            recalculateDetailInfoDO.set("recrecordid", (Object)recRecordID);
            recalculateDetailInfoDO.set("scheme", (Object)journal.getScheme().getId());
            recalculateDetailInfoDO.set("org", (Object)journal.getOrg());
            recalculateDetailInfoDO.set("dimension", (Object)dimensionId);
            recalculateDetailInfoDO.set("dimensionvalue", (Object)dimensionValue.getValue());
            recalculateDetailInfoDO.set("archiveid", (Object)journal.getArchiveId());
            recalculateDetailInfoDO.set("quotatype", (Object)journal.getQuotaType());
            recalculateDetailInfoDO.set("originalunit", (Object)journal.getOriginalUnit());
            recalculateDetailInfoDO.set("originalamount", (Object)journal.getOriginalAmount());
            recalculateDetailInfoDO.set("conversionRate", (Object)journal.getConversionRate());
            recalculateDetailInfoDO.set("unit", (Object)journal.getUnit());
            recalculateDetailInfoDO.set("amount", (Object)journal.getAmount());
            recalculateDetailInfoDO.set("entitykey", (Object)journal.getEntityKey());
            recalculateDetailInfoDO.set("entrykey", (Object)journal.getEntryKey());
            recalculateDetailInfoDO.set("billid", (Object)journal.getBillId());
            recalculateDetailInfoDO.set("entryid", (Object)journal.getEntryId());
            recalculateDetailInfoDO.set("billno", (Object)journal.getBillNo());
            recalculateDetailInfoDO.set("mainentitykey", (Object)journal.getMainEntityKey());
            recalculateDetailInfoDO.set("mainbillid", (Object)journal.getMainBillId());
            recalculateDetailInfoDO.set("action", (Object)journal.getAction());
            recalculateDetailInfoDO.set("op", (Object)journal.getOp());
            recalculateDetailInfoDO.set("direction", (Object)journal.getDirection());
            recalculateDetailInfoDO.set("createtime", (Object)new Date());
            recalculateDetailInfoDO.set("creator", (Object)RequestContext.get().getUserId());
            return recalculateDetailInfoDO;
        }
        return null;
    }

    public static DynamicObject[] detailDOsToJournalDOs(CreditScheme scheme, DynamicObject[] recDetailInfoDOs) {
        if (recDetailInfoDOs != null && recDetailInfoDOs.length > 0) {
            ArrayList<DynamicObject> journalArrays = new ArrayList<DynamicObject>();
            for (DynamicObject recDetailInfoDO : recDetailInfoDOs) {
                if (recDetailInfoDO == null) continue;
                DynamicObject journal = BusinessDataServiceHelper.newDynamicObject((String)"ccm_journal");
                long dimensionId = recDetailInfoDO.getDynamicObject("dimension").getLong("id");
                DimensionEntryFieldMapper mapper = new DimensionEntryFieldMapper(dimensionId);
                List<String> fieldTypeKeys = mapper.getFieldTypeKeys();
                List<String> fieldKeys = mapper.getRoleFieldKeys();
                List<Role> roles = scheme.getDimension().getRoles();
                for (int i = 0; i < roles.size(); ++i) {
                    journal.set(fieldTypeKeys.get(i), recDetailInfoDO.get(fieldTypeKeys.get(i)));
                    journal.set(fieldKeys.get(i), recDetailInfoDO.get(fieldKeys.get(i)));
                }
                journal.set("scheme", recDetailInfoDO.get("scheme"));
                journal.set("org", recDetailInfoDO.get("org"));
                journal.set("dimension", recDetailInfoDO.get("dimension"));
                journal.set("dimensionvalue", recDetailInfoDO.get("dimensionvalue"));
                journal.set("archiveid", recDetailInfoDO.get("archiveid"));
                journal.set("quotatype", recDetailInfoDO.get("quotatype"));
                journal.set("originalunit", recDetailInfoDO.get("originalunit"));
                journal.set("originalamount", recDetailInfoDO.get("originalamount"));
                journal.set("conversionRate", recDetailInfoDO.get("conversionRate"));
                journal.set("unit", recDetailInfoDO.get("unit"));
                journal.set("amount", recDetailInfoDO.get("amount"));
                journal.set("entitykey", recDetailInfoDO.get("entitykey"));
                journal.set("entrykey", recDetailInfoDO.get("entrykey"));
                journal.set("billid", recDetailInfoDO.get("billid"));
                journal.set("entryid", recDetailInfoDO.get("entryid"));
                journal.set("billno", recDetailInfoDO.get("billno"));
                journal.set("mainentitykey", recDetailInfoDO.get("mainentitykey"));
                journal.set("mainbillid", recDetailInfoDO.get("mainbillid"));
                journal.set("action", recDetailInfoDO.get("action"));
                journal.set("op", recDetailInfoDO.get("op"));
                journal.set("direction", recDetailInfoDO.get("direction"));
                journal.set("createtime", recDetailInfoDO.get("createtime"));
                journal.set("creator", recDetailInfoDO.get("creator"));
                journalArrays.add(journal);
            }
            return journalArrays.toArray(new DynamicObject[journalArrays.size()]);
        }
        return null;
    }

    public static String getDetailsSelector(CreditScheme scheme) {
        long dimensionId = scheme.getDimension().getId();
        DimensionEntryFieldMapper mapper = new DimensionEntryFieldMapper(dimensionId);
        List<String> fieldTypeKeys = mapper.getFieldTypeKeys();
        List<String> fieldKeys = mapper.getRoleFieldKeys();
        StringBuilder sb = new StringBuilder("id,dimension,scheme,org,dimensionvalue,archiveid,quotatype,originalunit,originalunit,originalamount,conversionRate,unit,amount,entitykey,entrykey,billid,entryid,billno,mainentitykey,mainbillid,action,op,direction,createtime,creator");
        for (String fieldTypeKey : fieldTypeKeys) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(fieldTypeKey);
        }
        for (String fieldKeyStr : fieldKeys) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(fieldKeyStr);
        }
        return sb.toString();
    }
}

