/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.business.scheme;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.utils.StringUtils;
import kd.scmc.ccm.business.core.CreditContext;
import kd.scmc.ccm.business.core.CreditElement;
import kd.scmc.ccm.business.core.Direction;
import kd.scmc.ccm.business.core.Expression;
import kd.scmc.ccm.business.plugin.DefaultCreditServicePlugin;
import kd.scmc.ccm.business.plugin.ICreditPlugin;
import kd.scmc.ccm.business.scheme.CreditScheme;
import kd.scmc.ccm.business.setting.EntityConfig;
import kd.scmc.ccm.business.valuegetter.ValueGetter;
import kd.scmc.ccm.business.valuegetter.ValueGetterManager;
import kd.scmc.ccm.common.ks.KsLoader;

public class BillStrategy
implements Serializable {
    private String number;
    private OrmLocaleValue name;
    private String entityKey;
    private EntityConfig config;
    private String pluginType;
    private String pluginName;
    private Direction direction;
    private String updateOp;
    private List<String> reverseOps = new ArrayList<String>(3);
    private List<Expression> expressions = new ArrayList<Expression>(3);
    private List<String> reduceOps = new ArrayList<String>(3);
    private List<String> increaseOps = new ArrayList<String>(3);
    private ICreditPlugin plugin;
    private ValueGetterManager valueGetterManager;
    private List<String> checkOps = new ArrayList<String>(3);
    private String forwardAction;
    private String calculateDate;
    private String calculateAmt;
    private Expression expression;
    private String assingEntityKey;
    private String mode;

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public OrmLocaleValue getName() {
        return this.name;
    }

    public void setName(OrmLocaleValue name) {
        this.name = name;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public String getAssingEntityKey() {
        return this.assingEntityKey;
    }

    public void setAssingEntityKey(String assingEntityKey) {
        this.assingEntityKey = assingEntityKey;
    }

    public String getCalculateDate() {
        return this.calculateDate;
    }

    public String getCalculateAmt() {
        return this.calculateAmt;
    }

    public void setCalculateAmt(String calculateAmt) {
        this.calculateAmt = calculateAmt;
    }

    public void setCalculateDate(String calculateDate) {
        this.calculateDate = calculateDate;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    public EntityConfig getConfig() {
        return this.config;
    }

    public void setConfig(EntityConfig entitySetting) {
        this.config = entitySetting;
    }

    public ICreditPlugin getPlugin(CreditScheme scheme, CreditContext context) {
        if (this.plugin == null) {
            this.plugin = this.createPlugin(this.pluginName, this.pluginType);
            this.plugin.init(scheme, context);
        }
        return this.plugin;
    }

    public void setPlugin(ICreditPlugin plugin) {
        this.plugin = plugin;
    }

    public List<String> getCheckOps() {
        return this.checkOps;
    }

    public void setCheckOps(List<String> checkOps) {
        this.checkOps = checkOps;
    }

    public String getForwardAction() {
        return this.forwardAction;
    }

    public void setForwardAction(String forwardAction) {
        this.forwardAction = forwardAction;
    }

    public String getEntityKey() {
        return this.entityKey;
    }

    public void setEntityKey(String entityKey) {
        this.entityKey = entityKey;
    }

    private ICreditPlugin createPlugin(String pluginName, String pluginType) {
        if (StringUtils.isEmpty((CharSequence)pluginName)) {
            return new DefaultCreditServicePlugin();
        }
        if ("ks".equals(pluginType)) {
            KsLoader ksLoader = new KsLoader();
            Map script = ksLoader.getScript(pluginName);
            return (ICreditPlugin)ksLoader.wapScript(pluginName, (String)script.get("scriptcontext"), ICreditPlugin.class, new Object[0]);
        }
        try {
            Class<?> pluginClass = Class.forName(pluginName);
            return (ICreditPlugin)pluginClass.newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    public ICreditPlugin getPlugin() {
        return this.plugin;
    }

    public ValueGetter getValueGetter(CreditElement element) {
        if (this.valueGetterManager == null) {
            this.valueGetterManager = new ValueGetterManager(this.config);
        }
        return this.valueGetterManager.getValueGetter(element);
    }

    public void setValueGetter(CreditElement element, ValueGetter valueGetter) {
        if (this.valueGetterManager == null) {
            this.valueGetterManager = new ValueGetterManager(this.config);
        }
        this.valueGetterManager.registerValueGetter(element, valueGetter);
    }

    public String getPluginType() {
        return this.pluginType;
    }

    public void setPluginType(String pluginType) {
        this.pluginType = pluginType;
    }

    public String getPluginName() {
        return this.pluginName;
    }

    public void setPluginName(String pluginName) {
        this.pluginName = pluginName;
    }

    public List<Expression> getExpressions() {
        return this.expressions;
    }

    public void setExpressions(List<Expression> expressions) {
        this.expressions = expressions;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public void setDirection(Direction direction) {
        this.direction = direction;
    }

    public String getUpdateOp() {
        return this.updateOp;
    }

    public void setUpdateOp(String updateOp) {
        this.updateOp = updateOp;
    }

    public List<String> getReverseOps() {
        return this.reverseOps;
    }

    public void setReverseOps(List<String> reverseOps) {
        this.reverseOps = reverseOps;
    }

    public void setReduceOps(List<String> reduceOps) {
        this.reduceOps = reduceOps;
    }

    public List<String> getReduceOps() {
        return this.reduceOps;
    }

    public void setIncreaseOps(List<String> increaseOps) {
        this.increaseOps = increaseOps;
    }

    public List<String> getIncreaseOps() {
        return this.increaseOps;
    }

    public String toString() {
        return "{entityKey='" + this.entityKey + '\'' + ", config=" + this.config + ", direction=" + (Object)((Object)this.direction) + ", updateOp='" + this.updateOp + '\'' + ", reverseOps=" + this.reverseOps + ", expressions=" + this.expressions + ", reduceOps=" + this.reduceOps + ", increaseOps=" + this.increaseOps + ", checkOps=" + this.checkOps + ", forwardAction='" + this.forwardAction + '\'' + ", calculateDate='" + this.calculateDate + '\'' + ", calculateAmt='" + this.calculateAmt + '\'' + ", expression=" + this.expression + ", assingEntityKey='" + this.assingEntityKey + '\'' + ", mode='" + this.mode + '\'' + '}';
    }
}

