/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.business.scheme;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.scmc.ccm.business.core.CreditContext;
import kd.scmc.ccm.business.core.CreditElement;
import kd.scmc.ccm.business.core.Dimension;
import kd.scmc.ccm.business.core.Expression;
import kd.scmc.ccm.business.core.QuotaType;
import kd.scmc.ccm.business.plugin.ICreditPlugin;
import kd.scmc.ccm.business.recalculate.RecalculateStrategy;
import kd.scmc.ccm.business.scheme.BillStrategy;
import kd.scmc.ccm.business.setting.EntityConfig;
import kd.scmc.ccm.business.valuegetter.ValueGetter;

public class CreditScheme
implements Serializable {
    private long id;
    private String number;
    private String name;
    private Dimension dimension;
    private long currency;
    private int currencyPrecision = 10;
    private boolean singleCurrencyControl;
    private long exchangeRateTable;
    private QuotaType quotaType;
    private List<BillStrategy> billStrategies = new ArrayList<BillStrategy>();
    private List<RecalculateStrategy> recalculateStrategies = new ArrayList<RecalculateStrategy>();
    private boolean globalScheme;
    private List<Long> orgScopes = new LinkedList<Long>();
    private String validity;
    private boolean isReverseForAllBS = false;
    private DynamicObject rawScheme;

    public Dimension getDimension() {
        return this.dimension;
    }

    public void setDimension(Dimension dimension) {
        this.dimension = dimension;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DynamicObject getRawScheme() {
        return this.rawScheme;
    }

    public void setRawScheme(DynamicObject rawScheme) {
        this.rawScheme = rawScheme;
    }

    public long getCurrency() {
        return this.currency;
    }

    public void setCurrency(long currency) {
        this.currency = currency;
    }

    public int getCurrencyPrecision() {
        return this.currencyPrecision;
    }

    public void setCurrencyPrecision(int currencyPrecision) {
        this.currencyPrecision = currencyPrecision;
    }

    public boolean isSingleCurrencyControl() {
        return this.singleCurrencyControl;
    }

    public void setSingleCurrencyControl(boolean singleCurrencyControl) {
        this.singleCurrencyControl = singleCurrencyControl;
    }

    public long getExchangeRateTable() {
        return this.exchangeRateTable;
    }

    public void setExchangeRateTable(long exchangeRateTable) {
        this.exchangeRateTable = exchangeRateTable;
    }

    public ICreditPlugin getPlugin(CreditContext context) {
        if ("INIT".equals(context.getCreditAction())) {
            RecalculateStrategy recalculateStrategy = this.getRecalculateStrategy(context.getEntityKey());
            return recalculateStrategy.getPlugin(this, context);
        }
        BillStrategy billSetting = this.getBillStrategy(context.getEntityKey());
        ICreditPlugin plugin = billSetting.getPlugin(this, context);
        return plugin;
    }

    public BillStrategy getBillStrategy(String entityKey) {
        for (BillStrategy billSetting : this.billStrategies) {
            if (!Objects.equals(billSetting.getEntityKey(), entityKey)) continue;
            return billSetting;
        }
        throw new IllegalArgumentException("Unsupported entityKey=" + entityKey);
    }

    public List<Expression> getExpressions(CreditContext context) {
        if ("INIT".equals(context.getCreditAction())) {
            return this.getRecalculateStrategy(context.getEntityKey()).getExpressions();
        }
        return this.getBillStrategy(context.getEntityKey()).getExpressions();
    }

    public ValueGetter getValueGetter(CreditContext context, CreditElement element) {
        if ("INIT".equals(context.getCreditAction())) {
            RecalculateStrategy recalculateStrategy = this.getRecalculateStrategy(context.getEntityKey());
            return recalculateStrategy.getValueGetter(element);
        }
        BillStrategy billStrategy = this.getBillStrategy(context.getEntityKey());
        return billStrategy.getValueGetter(element);
    }

    public RecalculateStrategy getRecalculateStrategy(String entityKey) {
        for (RecalculateStrategy billSetting : this.recalculateStrategies) {
            if (!Objects.equals(billSetting.getEntityKey(), entityKey)) continue;
            return billSetting;
        }
        throw new IllegalArgumentException("Unsupported entityKey=" + entityKey);
    }

    public EntityConfig getEntityConfig(CreditContext context) {
        if ("INIT".equals(context.getCreditAction())) {
            return this.getRecalculateStrategy(context.getEntityKey()).getConfig();
        }
        return this.getBillStrategy(context.getEntityKey()).getConfig();
    }

    public List<BillStrategy> getBillStrategies() {
        return this.billStrategies;
    }

    public void setBillStrategies(List<BillStrategy> billStrategies) {
        this.billStrategies = billStrategies;
    }

    public List<RecalculateStrategy> getRecalculateStrategies() {
        return this.recalculateStrategies;
    }

    public void setRecalculateStrategies(List<RecalculateStrategy> recalculateStrategies) {
        this.recalculateStrategies = recalculateStrategies;
    }

    public QuotaType getQuotaType() {
        return this.quotaType;
    }

    public void setQuotaType(QuotaType quotaType) {
        this.quotaType = quotaType;
    }

    public boolean isGlobalScheme() {
        return this.globalScheme;
    }

    public void setGlobalScheme(boolean globalScheme) {
        this.globalScheme = globalScheme;
    }

    public List<Long> getOrgScopes() {
        return this.orgScopes;
    }

    public void setOrgScopes(List<Long> orgScopes) {
        this.orgScopes = orgScopes;
    }

    public String getValidity() {
        return this.validity;
    }

    public void setValidity(String validity) {
        this.validity = validity;
    }

    public boolean isReverseForAllBS() {
        return this.isReverseForAllBS;
    }

    public void setReverseForAllBS(boolean isReverseForAllBS) {
        this.isReverseForAllBS = isReverseForAllBS;
    }

    public String toString() {
        return "{id=" + this.id + ", number='" + this.number + '\'' + ", name='" + this.name + '\'' + ", dimension=" + this.dimension + ", currency=" + this.currency + ", singleCurrencyControl=" + this.singleCurrencyControl + ", exchangeRateTable=" + this.exchangeRateTable + ", quotaType=" + this.quotaType + ", globalScheme=" + this.globalScheme + ", orgScopes=" + this.orgScopes + '}';
    }
}

