/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.business.scheme;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.scmc.ccm.business.core.CreditContext;
import kd.scmc.ccm.business.core.Expression;
import kd.scmc.ccm.business.core.Field;
import kd.scmc.ccm.business.filter.BillFilter;
import kd.scmc.ccm.business.filter.BillMultiConditionFilter;
import kd.scmc.ccm.business.filter.CreditCurrencyBillFilter;
import kd.scmc.ccm.business.filter.CreditOrgBillFilter;
import kd.scmc.ccm.business.scheme.CreditScheme;
import kd.scmc.ccm.business.setting.EntityConfig;

public class SchemeFilter
implements BillFilter {
    private CreditScheme scheme;
    private CreditContext context;
    private List<BillFilter> filterChain = new ArrayList<BillFilter>();

    public SchemeFilter(CreditScheme scheme, CreditContext context) {
        this.context = context;
        this.scheme = scheme;
        this.initFilterChain();
    }

    @Override
    public boolean isBillMatch(DynamicObject bill) {
        for (BillFilter filter : this.filterChain) {
            if (filter.isBillMatch(bill)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isRowMatch(DynamicObject row) {
        for (BillFilter filter : this.filterChain) {
            if (filter.isRowMatch(row)) continue;
            return false;
        }
        return true;
    }

    private void initFilterChain() {
        EntityConfig config = this.scheme.getEntityConfig(this.context);
        Field orgField = config.getOrgField();
        CreditOrgBillFilter orgFilter = new CreditOrgBillFilter(this.scheme, orgField);
        this.filterChain.add(orgFilter);
        Field currencyField = config.getCurrencyField();
        CreditCurrencyBillFilter creditCurrencyFilter = new CreditCurrencyBillFilter(this.scheme, currencyField);
        this.filterChain.add(creditCurrencyFilter);
        List<Expression> expressions = this.scheme.getExpressions(this.context);
        BillMultiConditionFilter billMultiConditionFilter = new BillMultiConditionFilter(expressions);
        this.filterChain.add(billMultiConditionFilter);
    }
}

