/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.business.scheme;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.botp.CRFormula;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.scmc.ccm.business.core.CreditCondition;
import kd.scmc.ccm.business.core.CreditFormula;
import kd.scmc.ccm.business.core.Dimension;
import kd.scmc.ccm.business.core.Direction;
import kd.scmc.ccm.business.core.Expression;
import kd.scmc.ccm.business.core.QuotaType;
import kd.scmc.ccm.business.core.Role;
import kd.scmc.ccm.business.filter.BillConditionFilter;
import kd.scmc.ccm.business.recalculate.RecalculateStrategy;
import kd.scmc.ccm.business.scheme.BillStrategy;
import kd.scmc.ccm.business.scheme.CreditScheme;
import kd.scmc.ccm.business.setting.EntityConfig;
import kd.scmc.ccm.business.setting.EntityConfigReader;
import kd.scmc.ccm.business.valuegetter.AmountFormulaValueGetter;
import kd.scmc.ccm.business.valuegetter.ConstValueGettter;
import kd.scmc.ccm.common.enums.EnableStatusEnum;
import kd.scmc.ccm.common.enums.StatusEnum;
import kd.scmc.ccm.common.util.OrmFacade;

public class SchemeReader {
    private OrmFacade ormFacade = new OrmFacade();
    private EntityConfigReader entityConfigReader = new EntityConfigReader();

    public List<CreditScheme> getSchemes(long orgId) {
        return this.loadScheme(orgId);
    }

    private List<CreditScheme> loadScheme(long orgId) {
        LinkedList<CreditScheme> useableSchemes = new LinkedList<CreditScheme>();
        QFilter orgFilter = new QFilter("orgentry.org", "=", (Object)orgId).or("orgscope", "=", (Object)"GLOBAL");
        QFilter enableFilter = new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
        QFilter statusFilter = new QFilter("status", "=", (Object)StatusEnum.AUDIT.getValue());
        QFilter[] filters = new QFilter[]{enableFilter, orgFilter, statusFilter};
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"ccm_scheme");
        Map cachedSchemes = this.ormFacade.loadFromCache(dataEntityType, filters);
        for (DynamicObject rawScheme : cachedSchemes.values()) {
            CreditScheme scheme = this.dynamicToScheme(this.entityConfigReader, rawScheme);
            useableSchemes.add(scheme);
        }
        return useableSchemes;
    }

    public CreditScheme getScheme(long schemeId) {
        DynamicObject rawScheme = this.ormFacade.loadSingleFromCache((Object)schemeId, "ccm_scheme");
        return this.dynamicToScheme(this.entityConfigReader, rawScheme);
    }

    public List<CreditScheme> getSchemes(Set<Long> schemeIds) {
        LinkedList<CreditScheme> creditSchemes = new LinkedList<CreditScheme>();
        Map cachedSchemes = this.ormFacade.loadFromCache(schemeIds.toArray(), "ccm_scheme");
        for (DynamicObject rawScheme : cachedSchemes.values()) {
            CreditScheme scheme = this.dynamicToScheme(this.entityConfigReader, rawScheme);
            creditSchemes.add(scheme);
        }
        return creditSchemes;
    }

    private CreditScheme dynamicToScheme(EntityConfigReader entityConfigReader, DynamicObject rawScheme) {
        CreditScheme scheme = new CreditScheme();
        scheme.setRawScheme(rawScheme);
        scheme.setId(rawScheme.getLong("id"));
        scheme.setNumber(rawScheme.getString("number"));
        String name = rawScheme.getLocaleString("name").getLocaleValue();
        scheme.setName(name);
        long currencyID = rawScheme.getLong("currency.id");
        if (currencyID > 0L) {
            DynamicObject currencyDO = BusinessDataServiceHelper.loadSingleFromCache((Object)currencyID, (String)"bd_currency", (String)"id,name,number,amtprecision");
            scheme.setCurrencyPrecision(currencyDO.getInt("amtprecision"));
        }
        scheme.setCurrency(rawScheme.getLong("currency.id"));
        scheme.setSingleCurrencyControl(rawScheme.getBoolean("singlecurcontrol"));
        scheme.setExchangeRateTable(rawScheme.getLong("exratetable.id"));
        scheme.setValidity(rawScheme.getString("validity"));
        scheme.setReverseForAllBS(rawScheme.getBoolean("isreverseforallbs"));
        Dimension dimension = new Dimension();
        scheme.setDimension(dimension);
        DynamicObject dimensionObj = rawScheme.getDynamicObject("dimension");
        dimension.setId(dimensionObj.getLong("id"));
        DynamicObjectCollection rolesEntry = dimensionObj.getDynamicObjectCollection("entry");
        LinkedList<Long> roleIds = new LinkedList<Long>();
        for (Object role : rolesEntry) {
            roleIds.add(role.getLong("role.id"));
        }
        Map roles = BusinessDataServiceHelper.loadFromCache((Object[])roleIds.toArray(new Object[0]), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"ccm_role"));
        for (DynamicObject roleObj : rolesEntry) {
            Role role = new Role(roleObj.getString("role.number"));
            role.setRoleName(roleObj.getString("role.name"));
            role.setBasedataEntityKey(((DynamicObject)roles.get(roleObj.getLong("role.id"))).getString("basedata.id"));
            role.setIsControled(((DynamicObject)roles.get(roleObj.getLong("role.id"))).getBoolean("iscontroled"));
            dimension.getRoles().add(role);
        }
        LinkedList<String> entityKeys = new LinkedList<String>();
        QuotaType quotaType = new QuotaType(this.getQuotaType(rawScheme.getString("checktype.number")));
        scheme.setQuotaType(quotaType);
        DynamicObjectCollection entry = rawScheme.getDynamicObjectCollection("entry");
        HashSet<Long> billstrategyIds = new HashSet<Long>(entry.size());
        for (Object row : entry) {
            billstrategyIds.add(row.getLong("billstrategy.id"));
        }
        Map billSettings = this.ormFacade.loadFromCache(billstrategyIds.toArray(new Object[0]), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"ccm_billstrategy"));
        for (Object row : entry) {
            DynamicObject billSetting = (DynamicObject)billSettings.get(row.getLong("billstrategy.id"));
            Iterator<EntityConfig> billStrategy = this.createBillStrategy(billSetting);
            ((BillStrategy)((Object)billStrategy)).setMode(row.getString("controlmode"));
            boolean merge = false;
            for (BillStrategy strategy : scheme.getBillStrategies()) {
                if (!Objects.equals(strategy.getEntityKey(), ((BillStrategy)((Object)billStrategy)).getEntityKey()) || !Objects.equals(strategy.getUpdateOp(), ((BillStrategy)((Object)billStrategy)).getUpdateOp()) || !strategy.getReverseOps().containsAll(((BillStrategy)((Object)billStrategy)).getReverseOps())) continue;
                merge = true;
                strategy.getExpressions().addAll(((BillStrategy)((Object)billStrategy)).getExpressions());
            }
            if (!merge) {
                scheme.getBillStrategies().add((BillStrategy)((Object)billStrategy));
            }
            entityKeys.add(((BillStrategy)((Object)billStrategy)).getEntityKey());
            RecalculateStrategy recalculateStrategy = this.createRecalculateStrategy(billSetting);
            scheme.getRecalculateStrategies().add(recalculateStrategy);
        }
        List<EntityConfig> configs = entityConfigReader.readConfigs(entityKeys);
        for (BillStrategy billStrategy : scheme.getBillStrategies()) {
            for (EntityConfig config : configs) {
                if (!Objects.equals(billStrategy.getEntityKey(), config.getEntityKey())) continue;
                billStrategy.setConfig(config);
            }
        }
        for (RecalculateStrategy recalculateStrategy : scheme.getRecalculateStrategies()) {
            for (EntityConfig config : configs) {
                if (!Objects.equals(recalculateStrategy.getEntityKey(), config.getEntityKey())) continue;
                recalculateStrategy.setConfig(config);
            }
        }
        String orgScope = rawScheme.getString("orgscope");
        scheme.setGlobalScheme("GLOBAL".equals(orgScope));
        if ("SINGLE".equals(orgScope)) {
            DynamicObjectCollection orgEntry = rawScheme.getDynamicObjectCollection("orgentry");
            ArrayList<Long> orgIds = new ArrayList<Long>(orgEntry.size());
            for (DynamicObject orgRow : orgEntry) {
                DynamicObject orgObj = orgRow.getDynamicObject("org");
                if (orgObj == null) continue;
                orgIds.add(orgObj.getLong("id"));
            }
            scheme.setOrgScopes(orgIds);
        }
        return scheme;
    }

    private RecalculateStrategy createRecalculateStrategy(DynamicObject billSetting) {
        String entityKey = billSetting.getString("entity.id");
        RecalculateStrategy recalculateStrategy = new RecalculateStrategy();
        recalculateStrategy.setEntityKey(entityKey);
        DynamicObjectCollection recalEntry = billSetting.getDynamicObjectCollection("recalentry");
        for (DynamicObject row : recalEntry) {
            String recalFilterTag = row.getString("newrecalfilter_tag");
            String recalFormulaTag = row.getString("newrecalformula_tag");
            if (StringUtils.isBlank((CharSequence)recalFilterTag) || StringUtils.isBlank((CharSequence)recalFormulaTag)) {
                ILocaleString name = billSetting.getLocaleString("name");
                String message = String.format(ResManager.loadKDString((String)"\u4fe1\u7528\u7ba1\u7406\uff1a\u5355\u636e\u7b56\u7565\u201c%s\u201d\u7684\u91cd\u7b97\u914d\u7f6e\u4e2d\u53ea\u914d\u7f6e\u4e86\u8fc7\u6ee4\u6761\u4ef6\u6216\u53d6\u503c\u516c\u5f0f\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"SchemeReader_1", (String)"scmc-ccm-business", (Object[])new Object[0]), name);
                throw new KDBizException(message);
            }
            Expression expression = new Expression();
            Direction direction = Direction.REDUCE;
            String forwardAction = billSetting.getString("forwardaction").toUpperCase();
            if (StringUtils.isNotBlank((CharSequence)forwardAction)) {
                direction = Direction.valueOf(forwardAction);
            }
            expression.setDirection(direction);
            this.setExpressionByFilterCondition(expression, row, "newrecalfilter_tag", entityKey);
            this.setExpressionByValueFormual(expression, row, "newrecalformula_tag", entityKey);
            recalculateStrategy.getExpressions().add(expression);
        }
        recalculateStrategy.setPluginType(billSetting.getString("recalculateplugintype"));
        recalculateStrategy.setPluginName(billSetting.getString("recalculateplugin"));
        return recalculateStrategy;
    }

    private BillStrategy createBillStrategy(DynamicObject billSetting) {
        Object expression;
        BillStrategy billStrategy = new BillStrategy();
        billStrategy.setNumber(billSetting.getString("number"));
        billStrategy.setName((OrmLocaleValue)billSetting.get("name"));
        String entityKey = billSetting.getString("entity.id");
        billStrategy.setEntityKey(entityKey);
        List<String> reduceOps = this.getCreditOpList(billSetting, "reduceops");
        List<String> increaseOps = this.getCreditOpList(billSetting, "increaseops");
        List<String> checkOps = this.getCreditOpList(billSetting, "checkops");
        billStrategy.setReduceOps(reduceOps);
        billStrategy.setIncreaseOps(increaseOps);
        billStrategy.setCheckOps(checkOps);
        if (checkOps.isEmpty() && billSetting.getBoolean("ischeck")) {
            billStrategy.setCheckOps(reduceOps);
        }
        String forwardAction = billSetting.getString("forwardaction");
        billStrategy.setForwardAction(forwardAction.toUpperCase());
        Direction direction = Direction.REDUCE;
        if (StringUtils.isNotBlank((CharSequence)forwardAction)) {
            direction = Direction.valueOf(forwardAction.toUpperCase());
        }
        billStrategy.setDirection(direction);
        LinkedList<String> reverseOps = new LinkedList<String>();
        String updateOp = null;
        for (String op : reduceOps) {
            if (this.isReverseOp(op, direction, increaseOps, reduceOps)) {
                reverseOps.add(op);
                continue;
            }
            updateOp = op;
        }
        for (String op : increaseOps) {
            if (this.isReverseOp(op, direction, increaseOps, reduceOps)) {
                reverseOps.add(op);
                continue;
            }
            updateOp = op;
        }
        billStrategy.setUpdateOp(updateOp);
        billStrategy.setReverseOps(reverseOps);
        DynamicObjectCollection checkEntry = billSetting.getDynamicObjectCollection("checkentry");
        if (checkEntry.size() == 0 && ("KZFW002".equals(billSetting.getString("checktype.number")) || "KZFW006".equals(billSetting.getString("checktype.number")))) {
            expression = new Expression();
            ((Expression)expression).setDirection(direction);
            CreditCondition condition = new CreditCondition(entityKey, null);
            ((Expression)expression).setCondition(condition);
            ((Expression)expression).setFilter(new BillConditionFilter(null));
            billStrategy.getExpressions().add((Expression)expression);
        }
        for (DynamicObject row : checkEntry) {
            Expression expression2 = new Expression();
            expression2.setDirection(direction);
            this.setExpressionByFilterCondition(expression2, row, "newcheckfilter_tag", entityKey);
            this.setExpressionByValueFormual(expression2, row, "newcheckformula_tag", entityKey);
            billStrategy.getExpressions().add(expression2);
        }
        expression = new Expression();
        DynamicObject assingEntity = billSetting.getDynamicObject("assingentity");
        if (!ObjectUtils.isEmpty((Object)assingEntity)) {
            this.setExpressionByFilterCondition((Expression)expression, billSetting, "newdatafilter_tag", assingEntity.getString("id"));
        }
        billStrategy.setExpression((Expression)expression);
        String checkType = billSetting.getString("checktype.number");
        if ("KZFW002".equals(checkType)) {
            billStrategy.setCalculateDate(billSetting.getString("calculatedate"));
        } else if ("KZFW006".equals(checkType)) {
            billStrategy.setCalculateDate(billSetting.getString("calculatedate"));
            billStrategy.setCalculateAmt(billSetting.getString("calculateamt"));
        }
        if (!ObjectUtils.isEmpty((Object)assingEntity)) {
            billStrategy.setAssingEntityKey(assingEntity.getString("number"));
        }
        billStrategy.setPluginType(billSetting.getString("plugintype"));
        billStrategy.setPluginName(billSetting.getString("plugin"));
        return billStrategy;
    }

    private boolean isReverseOp(String op, Direction direction, List<String> increaseOps, List<String> reduceOps) {
        if ("unsubmit".equals(op) || "unaudit".equals(op) || "bizunclose".equals(op) || "bizuncancel".equals(op)) {
            return true;
        }
        if (direction == Direction.REDUCE) {
            return increaseOps.contains(op);
        }
        return reduceOps.contains(op);
    }

    private String getQuotaType(String checkType) {
        switch (checkType) {
            case "KZFW001": {
                return "amount";
            }
            case "KZFW002": {
                return "days";
            }
            case "KZFW003": {
                return "qty";
            }
            case "KZFW006": {
                return "overdueamt";
            }
            case "KZFW010": {
                return "privilegeamt";
            }
            case "KZFW011": {
                return "privilegeday";
            }
        }
        throw new IllegalArgumentException("Unknow checktype:" + checkType);
    }

    private List<String> getCreditOpList(DynamicObject billSetting, String creditOpType) {
        String[] creditOps = billSetting.getString(creditOpType).split(",");
        LinkedList<String> creditOpList = new LinkedList<String>();
        for (String op : creditOps) {
            if (!StringUtils.isNotBlank((CharSequence)op)) continue;
            creditOpList.add(op);
        }
        return creditOpList;
    }

    private void setExpressionByFilterCondition(Expression expression, DynamicObject data, String filterConditionName, String entityKey) {
        String filterCondition = data.getString(filterConditionName);
        if (StringUtils.isNotBlank((CharSequence)filterCondition)) {
            CRCondition crCondition = (CRCondition)SerializationUtils.fromJsonString((String)filterCondition, CRCondition.class);
            CreditCondition condition = new CreditCondition(entityKey, crCondition);
            expression.setCondition(condition);
            expression.setFilter(new BillConditionFilter(condition));
        } else {
            CreditCondition condition = new CreditCondition(entityKey, null);
            expression.setCondition(condition);
            expression.setFilter(new BillConditionFilter(null));
        }
    }

    private void setExpressionByValueFormual(Expression expression, DynamicObject data, String valueFormualName, String entityKey) {
        String rawFormulaStr = data.getString(valueFormualName);
        if (StringUtils.isNotBlank((CharSequence)rawFormulaStr)) {
            CRFormula crFormula = (CRFormula)SerializationUtils.fromJsonString((String)rawFormulaStr, CRFormula.class);
            CreditFormula formula = new CreditFormula(entityKey, crFormula.getExpression());
            expression.setFormula(formula);
            expression.setValueGetter(new AmountFormulaValueGetter(formula));
        } else {
            CreditFormula formula = new CreditFormula(entityKey, null);
            expression.setFormula(formula);
            expression.setValueGetter(new ConstValueGettter(BigDecimal.ZERO));
        }
    }
}

