/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.business.scheme;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.scmc.ccm.business.check.CheckResult;
import kd.scmc.ccm.business.core.Dimension;
import kd.scmc.ccm.business.core.Field;
import kd.scmc.ccm.business.core.Role;
import kd.scmc.ccm.business.scheme.BillStrategy;
import kd.scmc.ccm.business.scheme.CreditScheme;
import kd.scmc.ccm.business.setting.EntityConfig;

public class SchemeValidator {
    public CheckResult validate(CreditScheme scheme) {
        CheckResult checkResult = this.checkSchemeBizState(scheme);
        if (!checkResult.isSuccess()) {
            return checkResult;
        }
        Dimension dimension = scheme.getDimension();
        List<Role> roles = dimension.getRoles();
        List<BillStrategy> billStrategies = scheme.getBillStrategies();
        for (BillStrategy billStrategy : billStrategies) {
            EntityConfig config = billStrategy.getConfig();
            for (Role role : roles) {
                Field roleField = config.getRoleField(role.getRoleType());
                if (roleField != null) continue;
                String entityKey = config.getEntityKey();
                MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)entityKey);
                String entityDisplayName = dataEntityType.getDisplayName().getLocaleValue();
                String messageTemplate = ResManager.loadKDString((String)"\u4fe1\u7528\u63a7\u5236\u7ba1\u7406\uff1a\u8bf7\u5148\u901a\u8fc7\u3010\u5355\u636e\u6ce8\u518c\u3011\u914d\u7f6e\u201c%1$s\u201d\u7684\u201c%2$s\u201d\u5b57\u6bb5\u6620\u5c04\uff0c\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"SchemeValidator_2", (String)"scmc-ccm-business", (Object[])new Object[0]);
                checkResult = new CheckResult(scheme, entityKey);
                checkResult.setSuccess(false);
                checkResult.setMessage(String.format(messageTemplate, entityDisplayName, role.getRoleName()));
            }
        }
        return checkResult;
    }

    public CheckResult checkSetting(CreditScheme scheme) {
        CheckResult checkResult = new CheckResult();
        checkResult.setSuccess(true);
        Dimension dimension = scheme.getDimension();
        List<Role> roles = dimension.getRoles();
        List<BillStrategy> billStrategies = scheme.getBillStrategies();
        for (BillStrategy billStrategy : billStrategies) {
            EntityConfig config = billStrategy.getConfig();
            for (Role role : roles) {
                Field roleField = config.getRoleField(role.getRoleType());
                if (roleField != null) continue;
                String entityKey = config.getEntityKey();
                MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)entityKey);
                String entityDisplayName = dataEntityType.getDisplayName().getLocaleValue();
                String messageTemplate = ResManager.loadKDString((String)"\u4fe1\u7528\u63a7\u5236\u7ba1\u7406\uff1a\u8bf7\u5148\u901a\u8fc7\u3010\u5355\u636e\u6ce8\u518c\u3011\u914d\u7f6e\u201c%1$s\u201d\u7684\u201c%2$s\u201d\u5b57\u6bb5\u6620\u5c04\uff0c\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"SchemeValidator_2", (String)"scmc-ccm-business", (Object[])new Object[0]);
                checkResult = new CheckResult(scheme, entityKey);
                checkResult.setSuccess(false);
                checkResult.setMessage(String.format(messageTemplate, entityDisplayName, role.getRoleName()));
            }
        }
        return checkResult;
    }

    private CheckResult checkSchemeBizState(CreditScheme scheme) {
        DynamicObject rawScheme = scheme.getRawScheme();
        String bizState = rawScheme.getString("bizstate");
        CheckResult checkResult = new CheckResult();
        checkResult.setSuccess(true);
        if ("initing".equals(bizState)) {
            String message = String.format(ResManager.loadKDString((String)"\u4fe1\u7528\u65b9\u6848%s\u6b63\u5728\u91cd\u7b97\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"SchemeValidator_1", (String)"scmc-ccm-business", (Object[])new Object[0]), rawScheme.getString("name"));
            checkResult.setBillno("");
            checkResult.setSuccess(false);
            checkResult.setMessage(message);
            checkResult.setSchemeId(rawScheme.getLong("id"));
        }
        return checkResult;
    }
}

