/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.business.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.CommitListener;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BigIntProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scmc.ccm.business.analysesum.AnalyseSumOverdueBillQueryHelper;
import kd.scmc.ccm.business.analysesum.QueryAmountSumResult;
import kd.scmc.ccm.business.analysesum.QueryDaySumResult;
import kd.scmc.ccm.business.analysesum.QueryOverdueAmtResult;
import kd.scmc.ccm.business.archives.ArchiveCollection;
import kd.scmc.ccm.business.archives.ArchiveValidator;
import kd.scmc.ccm.business.archives.CreditArchive;
import kd.scmc.ccm.business.balance.CreditBalanceQuerier;
import kd.scmc.ccm.business.balance.QueryBalanceResult;
import kd.scmc.ccm.business.check.CheckResult;
import kd.scmc.ccm.business.core.CreditContext;
import kd.scmc.ccm.business.core.Dimension;
import kd.scmc.ccm.business.core.DimensionValue;
import kd.scmc.ccm.business.core.Field;
import kd.scmc.ccm.business.core.Role;
import kd.scmc.ccm.business.journal.Journal;
import kd.scmc.ccm.business.journal.JournalGroup;
import kd.scmc.ccm.business.log.CcmLogHelper;
import kd.scmc.ccm.business.monitor.Monitor;
import kd.scmc.ccm.business.plugin.CreditPluginProxy;
import kd.scmc.ccm.business.scheme.BillStrategy;
import kd.scmc.ccm.business.scheme.CreditScheme;
import kd.scmc.ccm.business.scheme.SchemeReader;
import kd.scmc.ccm.business.scheme.SchemeValidator;
import kd.scmc.ccm.business.service.CreditServiceFacade;
import kd.scmc.ccm.business.setting.DimensionEntryFieldMapper;
import kd.scmc.ccm.business.setting.DimensionReader;
import kd.scmc.ccm.business.setting.EntityConfig;
import kd.scmc.ccm.common.helper.SysParamHelper;
import kd.scmc.ccm.common.util.DateUtils;
import kd.scmc.ccm.common.util.Lock;

public class CreditService {
    private static final Log logger = LogFactory.getLog(CreditService.class);
    private static final Integer Code_MAXOVERDUEDAY = 0;
    private static final Integer Code_SUMOVERDUEAMT = 1;
    private static final String lineSeparator = System.lineSeparator();
    private CreditServiceFacade facade;

    public CreditService() {
        this.facade = new CreditServiceFacade();
    }

    public CreditService(CreditServiceFacade facade) {
        this.facade = facade;
    }

    public List<QueryBalanceResult> queryBalance(DynamicObject bill) {
        String entityKey = bill.getDataEntityType().getName();
        CreditContext context = new CreditContext();
        context.setEntityKey(entityKey);
        context.setCreditAction("QUERYBALANCE");
        CreditContext.set(context);
        logger.info("\u4fe1\u7528\u67e5\u8be2\u53ef\u7528\u989d\u5ea6 queryBalance billid : " + bill.getPkValue());
        List<CreditScheme> creditSchemes = this.getSchemes(new DynamicObject[]{bill}, context, this.facade);
        LinkedList<QueryBalanceResult> resultList = new LinkedList<QueryBalanceResult>();
        if (ObjectUtils.isEmpty(creditSchemes)) {
            QueryBalanceResult uncontrolledResult = new QueryBalanceResult();
            uncontrolledResult.setMessage(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u4e0d\u53c2\u4e0e\u4fe1\u7528\u7ba1\u63a7\u3002", (String)"CreditService_0", (String)"scmc-ccm-business", (Object[])new Object[0]));
            resultList.add(uncontrolledResult);
            logger.info("\u4fe1\u7528\u67e5\u8be2\u53ef\u7528\u989d\u5ea6 queryBalance creditSchemes is null : " + uncontrolledResult.getMessage());
            return resultList;
        }
        for (CreditScheme scheme : creditSchemes) {
            CreditBalanceQuerier querier = new CreditBalanceQuerier(this.facade);
            List<QueryBalanceResult> queryResults = querier.queryBalance(scheme, bill);
            resultList.addAll(queryResults);
        }
        return resultList;
    }

    public List<QueryBalanceResult> queryBalancebyScheme(Long schemeId, Set<String> dimensionvalueStrs) {
        HashSet<DimensionValue> dimensionValues = new HashSet<DimensionValue>(dimensionvalueStrs.size());
        CreditScheme scheme = this.facade.getScheme(schemeId);
        for (String dimensionvalueStr : dimensionvalueStrs) {
            DimensionValue dimensionValue = new DimensionValue(scheme.getDimension());
            dimensionValue.setValue(dimensionvalueStr);
            dimensionValues.add(dimensionValue);
        }
        CreditBalanceQuerier querier = new CreditBalanceQuerier(this.facade);
        return querier.queryBalance(scheme, dimensionValues);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CheckResult> check(DynamicObject[] bills, String operateKey) {
        if (bills == null || bills.length == 0) {
            return new ArrayList<CheckResult>(0);
        }
        CreditContext context = this.createContext(bills, operateKey, "CHECK");
        List<CreditScheme> schemes = this.getSchemes(bills, context, this.facade);
        this.checkScheme(schemes);
        LinkedList<CheckResult> results = new LinkedList<CheckResult>();
        List<DynamicObject> billList = Arrays.asList(bills);
        String entityKey = context.getEntityKey();
        HashMap<String, Set<String>> needInverseColumnsColumnsMap = new HashMap<String, Set<String>>(16);
        for (DynamicObject bill : billList) {
            Set<String> ccmEntityConfigColumns;
            if (!bill.getDataEntityType().getName().contains("im_") || !bill.containsProperty("invscheme") || !bill.containsProperty("ischargeoff")) continue;
            String billEntity = bill.getDataEntityType().getName();
            boolean isChargeOff = bill.getBoolean("ischargeoff");
            DynamicObject invScheme = bill.getDynamicObject("invscheme");
            if (invScheme == null || !invScheme.containsProperty("bizdirection") || invScheme.getString("bizdirection") == null) continue;
            String bizDirection = invScheme.getString("bizdirection");
            boolean isNeedInverse = false;
            if (!isChargeOff && "1".equals(bizDirection) || isChargeOff && "0".equals(bizDirection)) {
                isNeedInverse = true;
            }
            if ((ccmEntityConfigColumns = (Set<String>)needInverseColumnsColumnsMap.get(billEntity)) == null) {
                ccmEntityConfigColumns = this.getEntityConfigColumns(billEntity);
                Set<String> imNeedInverseColumns = this.getImNeedInverseColumns(billEntity);
                ccmEntityConfigColumns.retainAll(imNeedInverseColumns);
                needInverseColumnsColumnsMap.put(billEntity, ccmEntityConfigColumns);
            }
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
            for (DynamicObject entry : entrys) {
                for (String column : ccmEntityConfigColumns) {
                    BigDecimal value = entry.getBigDecimal(column);
                    if (value == null) {
                        value = BigDecimal.ZERO;
                    }
                    value = isNeedInverse ? value.abs().negate() : value.abs();
                    entry.set(column, (Object)value);
                }
            }
        }
        try (Lock lock = new Lock();){
            ArchiveValidator validator = new ArchiveValidator();
            for (CreditScheme scheme : schemes) {
                CreditPluginProxy pluginProxy = new CreditPluginProxy(scheme, context, this.facade);
                List<JournalGroup> journalGroups = pluginProxy.buildJournals(billList);
                List<DimensionValue> dimensionValues = this.getDimensionValues(journalGroups);
                ArchiveCollection preloadArchives = pluginProxy.loadArchives(dimensionValues);
                List<CheckResult> preloadValidateResult = validator.validate(journalGroups, preloadArchives);
                results.addAll(preloadValidateResult);
                if (ObjectUtils.isEmpty((Object)preloadArchives)) continue;
                Boolean checkservicenolock = (Boolean)SysParamHelper.getCCMSysParam((String)"checkservicenolock");
                if (!Boolean.TRUE.equals(checkservicenolock) || scheme.getBillStrategy(entityKey) == null || !"warning".equals(scheme.getBillStrategy(entityKey).getMode())) {
                    this.tryLock(journalGroups, lock, results, "CHECK");
                }
                ArchiveCollection archives = pluginProxy.loadArchives(dimensionValues);
                List<CheckResult> validateResult = validator.validate(journalGroups, archives);
                results.addAll(validateResult);
                List<CheckResult> checkResults = pluginProxy.check(journalGroups, archives);
                results.addAll(checkResults);
            }
            LinkedList<CheckResult> linkedList = results;
            return linkedList;
        }
    }

    private List<String> tryLock(List<JournalGroup> journalGroups, Lock lock, List<CheckResult> results, String timepoint) {
        ArrayList<String> lockKeys = new ArrayList<String>();
        ArrayList<String> failLockKeys = new ArrayList<String>();
        if (journalGroups == null || journalGroups.size() < 1) {
            logger.info("CreditService.tryLock \u5165\u53c2\u6d41\u6c34\u7ec4 journalGroups is null");
            return lockKeys;
        }
        ArrayList<CheckResult> unlockArchiveList = new ArrayList<CheckResult>(journalGroups.size());
        Iterator<JournalGroup> journalGroupIterator = journalGroups.iterator();
        block9: while (journalGroupIterator.hasNext()) {
            JournalGroup journalGroup = journalGroupIterator.next();
            for (Journal journal : journalGroup.getJournals()) {
                String lockKey = journal.getScheme().getId() + ":" + journal.getDimensionValue().getValue();
                if (!lock.tryLock(lockKey)) {
                    failLockKeys.add(lockKey);
                    CheckResult checkResult = new CheckResult(journalGroup.getScheme(), journalGroup.getMainEntityKey());
                    checkResult.setSuccess(false);
                    checkResult.setBillno(journalGroup.getBillNo());
                    String messageTemplate = ResManager.loadKDString((String)"\u5355\u636e\u5bf9\u5e94\u7684\u4fe1\u7528\u6863\u6848\u5b58\u5728\u5e76\u53d1\u9501\u201c%s\u201d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"CreditService_3", (String)"scmc-ccm-business", (Object[])new Object[0]);
                    checkResult.setMessage(String.format(messageTemplate, lockKey));
                    results.add(checkResult);
                    unlockArchiveList.add(checkResult);
                    journalGroupIterator.remove();
                    DynamicObject journalFailRecord = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"ccm_journal_failrecord"));
                    journalFailRecord.set("billid", (Object)journal.getMainBillId());
                    journalFailRecord.set("mainentitykey", (Object)journal.getMainEntityKey());
                    journalFailRecord.set("optype", (Object)journal.getOp());
                    journalFailRecord.set("timepoint", (Object)timepoint);
                    journalFailRecord.set("scheme", (Object)journal.getScheme().getId());
                    journalFailRecord.set("status", (Object)"0");
                    journalFailRecord.set("createtime", (Object)new Date());
                    TXHandle tx = TX.requiresNew();
                    Throwable throwable = null;
                    try {
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{journalFailRecord});
                        continue block9;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (tx == null) continue block9;
                        if (throwable != null) {
                            try {
                                tx.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue block9;
                        }
                        tx.close();
                        continue block9;
                    }
                }
                lockKeys.add(lockKey);
            }
        }
        CcmLogHelper.writeUnLockArchiveLog(unlockArchiveList);
        logger.info("trylock success key : {},fail key : {}", lockKeys, failLockKeys);
        return lockKeys;
    }

    private void unlockAllOnEnded(final Lock lock) {
        if (lock != null) {
            TX.addCommitListener((CommitListener)new CommitListener(){

                public void onEnded(boolean rollbacked) {
                    lock.unlockAll();
                }
            });
        }
    }

    private void checkScheme(List<CreditScheme> schemes) {
        SchemeValidator schemeValidator = new SchemeValidator();
        for (CreditScheme scheme : schemes) {
            CheckResult validateResult = schemeValidator.validate(scheme);
            if (validateResult.isSuccess()) continue;
            throw new KDBizException(validateResult.getMessage());
        }
    }

    private void checkScheme(List<CreditScheme> schemes, List<CheckResult> results) {
        SchemeValidator schemeValidator = new SchemeValidator();
        for (CreditScheme scheme : schemes) {
            CheckResult validateResult = schemeValidator.validate(scheme);
            if (validateResult.isSuccess()) continue;
            results.add(validateResult);
            throw new KDBizException(validateResult.getMessage());
        }
    }

    public List<CheckResult> reduceBalance(DynamicObject[] bills, String operateKey) {
        logger.info("\u6263\u51cf\u4fe1\u7528\u4f59\u989d reduceBalance begin : " + System.currentTimeMillis());
        return this.update(bills, operateKey);
    }

    public List<CheckResult> increaseBalance(DynamicObject[] bills, String operateKey) {
        logger.info("\u589e\u52a0\u4fe1\u7528\u4f59\u989d increaseBalance begin : " + System.currentTimeMillis());
        return this.update(bills, operateKey);
    }

    public Map<String, List> updateAndReturnLock(DynamicObject[] bills, String operateKey) {
        Throwable throwable = null;
        try (TXHandle txHandle = TX.requiresNew();){
            StringBuilder logStrBuilder = new StringBuilder("UPDATECREDIT:").append(lineSeparator);
            logStrBuilder.append("begin:").append(new Date(System.currentTimeMillis())).append(lineSeparator);
            if (bills == null || bills.length == 0) {
                HashMap<String, List> hashMap = new HashMap<String, List>();
                return hashMap;
            }
            CreditContext context = this.createContext(bills, operateKey, "UPDATE");
            CcmLogHelper.startCreditLogForService(bills, operateKey, "UPDATE");
            logStrBuilder.append("1.createContext:").append(SerializationUtils.toJsonString((Object)context)).append(lineSeparator);
            List<CreditScheme> schemes = this.getSchemes(bills, context, this.facade);
            logStrBuilder.append("2.getSchemes: scheme.size :").append(schemes != null ? schemes.size() : 0).append(lineSeparator);
            LinkedList<CheckResult> results = new LinkedList<CheckResult>();
            Lock lock = new Lock();
            long updatetryLockTime = 0L;
            try {
                this.checkScheme(schemes, results);
                logStrBuilder.append("3.checkScheme: scheme.size :").append(schemes != null ? schemes.size() : 0).append(lineSeparator);
                CcmLogHelper.writeCreateSchemeLog(schemes);
                LinkedList<JournalGroup> saveableJournalGroups = new LinkedList<JournalGroup>();
                LinkedList<JournalGroup> deleteableJournalGroups = new LinkedList<JournalGroup>();
                LinkedList<CreditArchive> updateableArchives = new LinkedList<CreditArchive>();
                Set<Long> billIds = Arrays.stream(bills).map(bill -> bill.getLong("id")).collect(Collectors.toSet());
                List<DynamicObject> billList = Arrays.asList(bills);
                ArchiveValidator validator = new ArchiveValidator();
                logStrBuilder.append("4.begin loopSchemes :").append(lineSeparator);
                for (CreditScheme scheme : schemes) {
                    if (scheme == null) continue;
                    String updateOp = scheme.getBillStrategy(context.getEntityKey()).getUpdateOp();
                    boolean isReverse = !Objects.equals(updateOp, context.getOperateKey());
                    logStrBuilder.append("4.loopSchemeid :");
                    logStrBuilder.append(scheme.getId()).append("---updateop: ").append(updateOp).append("---isReverse = ").append(isReverse).append(lineSeparator);
                    CreditPluginProxy pluginProxy = new CreditPluginProxy(scheme, context, this.facade);
                    List<JournalGroup> journalGroups = null;
                    if (isReverse) {
                        boolean isReverseForMultiBs = false;
                        HashSet<String> updateOpSet = new HashSet<String>(16);
                        if (scheme.isReverseForAllBS()) {
                            int count = 0;
                            for (BillStrategy bs : scheme.getBillStrategies()) {
                                if (!context.getEntityKey().equals(bs.getEntityKey()) || !bs.getReverseOps().contains(operateKey)) continue;
                                ++count;
                                updateOpSet.add(bs.getUpdateOp());
                            }
                            if (count > 1) {
                                isReverseForMultiBs = true;
                            }
                        }
                        if (isReverseForMultiBs) {
                            logStrBuilder.append("5.journal: isReverse = ").append(isReverse).append(" ---isReverseForMultiBs = true --- updateOpSet = ").append(updateOpSet).append(lineSeparator);
                            journalGroups = this.facade.loadJournals(scheme, context.getEntityKey(), updateOpSet, billIds);
                        } else {
                            journalGroups = this.facade.loadJournals(scheme, context.getEntityKey(), updateOp, billIds);
                        }
                        if (journalGroups != null) {
                            deleteableJournalGroups.addAll(journalGroups);
                        }
                        logStrBuilder.append("5.journal: isReverse = true").append("---loadJournals.size : ").append(journalGroups != null ? journalGroups.size() : 0).append(lineSeparator);
                    } else {
                        journalGroups = pluginProxy.buildJournals(billList);
                        if (journalGroups != null) {
                            saveableJournalGroups.addAll(journalGroups);
                        }
                        logStrBuilder.append("5.journal: isReverse = false").append("---buildJournalGroups.size : ").append(journalGroups != null ? journalGroups.size() : 0).append(lineSeparator);
                    }
                    CcmLogHelper.writeCreateJournalLog(scheme, journalGroups);
                    List<DimensionValue> dimensionValues = this.getDimensionValues(journalGroups);
                    logStrBuilder.append("5.journal: dimensionValues").append(dimensionValues != null ? SerializationUtils.toJsonString(dimensionValues) : Integer.valueOf(0)).append(lineSeparator);
                    ArchiveCollection preloadArchives = pluginProxy.loadArchives(dimensionValues);
                    List<CheckResult> preloadValidateResult = validator.validate(journalGroups, preloadArchives, true);
                    results.addAll(preloadValidateResult);
                    logStrBuilder.append("6.archive_validate_preloadArchives: ").append(SerializationUtils.toJsonString(preloadValidateResult)).append(lineSeparator);
                    if (ObjectUtils.isEmpty((Object)preloadArchives)) {
                        logStrBuilder.append("6.archive_validate_preloadArchives: noarchives,continue nextScheme.").append(lineSeparator);
                        continue;
                    }
                    logStrBuilder.append("7.trylock first time begin: ").append(new Date(System.currentTimeMillis())).append(lineSeparator);
                    this.tryLock(journalGroups, lock, results, "UPDATE");
                    logStrBuilder.append("7.trylock first time end: ").append(new Date(System.currentTimeMillis())).append(lineSeparator);
                    ArchiveCollection archives = pluginProxy.loadArchives(dimensionValues);
                    CcmLogHelper.writeArchiveBeforeLog(scheme, archives);
                    List<CheckResult> validateResult = validator.validate(journalGroups, archives, true);
                    results.addAll(validateResult);
                    if (isReverse && results.size() > 0) {
                        this.deleteInvalidJournalGroup(deleteableJournalGroups, results);
                    }
                    List<CheckResult> updateResults = pluginProxy.update(journalGroups, archives, isReverse);
                    results.addAll(updateResults);
                    updateableArchives.addAll(archives.values());
                    CcmLogHelper.writeArchiveAfterLog(scheme, archives);
                }
                Boolean ischeckdupjournal = (Boolean)SysParamHelper.getCCMSysParam((String)"ischeckdupjournal");
                if (!Boolean.FALSE.equals(ischeckdupjournal)) {
                    this.checkDuplicateJournal(operateKey, saveableJournalGroups);
                }
                logger.info(logStrBuilder.toString());
                this.facade.saveJournals(saveableJournalGroups);
                this.facade.deleteJournals(deleteableJournalGroups);
                this.facade.saveArchives(updateableArchives);
                HashMap<String, List> resultMap = new HashMap<String, List>();
                resultMap.put("checkResults", results);
                this.unlockAllOnEnded(lock);
                CcmLogHelper.writeCreditLog(results);
                HashMap<String, List> hashMap = resultMap;
                return hashMap;
            }
            catch (Exception e) {
                try {
                    CcmLogHelper.collectUpdateExpResult(bills, operateKey, results, e.toString());
                    CcmLogHelper.collectExpLog(e);
                    txHandle.markRollback();
                    logger.error(e.getMessage().concat(Arrays.toString(e.getStackTrace())));
                    lock.close();
                    long closeLockTime = System.currentTimeMillis();
                    logger.info("\u66f4\u65b0\u4fe1\u7528\u4f59\u989d update---\u672c\u6b21\u5206\u5e03\u5f0f\u9501\uff08\u521b\u5efa\u65f6\u95f4\uff09 \uff1a " + updatetryLockTime + "({})", (Object)new Date(updatetryLockTime));
                    logger.info("\u66f4\u65b0\u4fe1\u7528\u4f59\u989d update---\u672c\u6b21\u5206\u5e03\u5f0f\u9501\uff08\u91ca\u653e\u65f6\u95f4\uff09 \uff1a " + closeLockTime + "({})", (Object)new Date(closeLockTime));
                    logger.info("\u66f4\u65b0\u4fe1\u7528\u4f59\u989d update---\u672c\u6b21\u5206\u5e03\u5f0f\u9501\uff08\u521b\u5efa\u5230\uff09\u8017\u65f6 \uff1a { } ms\u3002", (Object)(closeLockTime - updatetryLockTime));
                    throw e;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CheckResult> update(DynamicObject[] bills, String operateKey) {
        ArrayList lockKeys = new ArrayList();
        try {
            Map<String, List> resMap = this.updateAndReturnLock(bills, operateKey);
            if (resMap.get("lockKeys") != null) {
                lockKeys.addAll(resMap.get("lockKeys"));
            }
            List list = resMap.get("checkResults");
            return list;
        }
        finally {
            if (lockKeys.size() > 0) {
                DLock.forceUnlock((String[])lockKeys.toArray(new String[0]));
                logger.info("\u66f4\u65b0\u4fe1\u7528\u4f59\u989d\uff0c\u91ca\u653e\u9501\uff1a" + lockKeys);
            }
        }
    }

    private void deleteInvalidJournalGroup(List<JournalGroup> deleteableJournalGroups, List<CheckResult> results) {
        block0: for (CheckResult info : results) {
            String expBillNo = info.getBillno();
            if (expBillNo == null || "".equals(expBillNo)) continue;
            long schemeId = info.getSchemeId();
            boolean success = info.isSuccess();
            if (success) continue;
            Iterator<JournalGroup> iterator = deleteableJournalGroups.iterator();
            while (iterator.hasNext()) {
                long id;
                JournalGroup bill = iterator.next();
                String billNo = bill.getBillNo();
                if (billNo == null || "".equals(billNo) || schemeId != (id = bill.getScheme().getId()) || !expBillNo.equals(billNo)) continue;
                iterator.remove();
                continue block0;
            }
        }
    }

    private List<DimensionValue> getDimensionValues(List<JournalGroup> journals) {
        LinkedList<DimensionValue> dimensionValues = new LinkedList<DimensionValue>();
        if (journals == null) {
            return dimensionValues;
        }
        for (JournalGroup journalGroup : journals) {
            for (Journal journal : journalGroup.getJournals()) {
                dimensionValues.add(journal.getDimensionValue());
            }
        }
        return dimensionValues;
    }

    private CreditContext createContext(DynamicObject[] bills, String operateKey, String creditAction) {
        String entityKey = bills[0].getDataEntityType().getName();
        CreditContext context = new CreditContext();
        context.setEntityKey(entityKey);
        context.setOperateKey(operateKey);
        context.setCreditAction(creditAction);
        CreditContext.set(context);
        return context;
    }

    private List<CreditScheme> getSchemes(DynamicObject[] bills, CreditContext context, CreditServiceFacade creditServiceFacade) {
        Set<Long> creditUnits = this.getBillOrgIds(bills, context, creditServiceFacade);
        Monitor.getDebugInfo().setOrgIds(creditUnits);
        LinkedList<CreditScheme> allSchemes = new LinkedList<CreditScheme>();
        for (Long orgId : creditUnits) {
            List<CreditScheme> schemes = creditServiceFacade.getSchemes(orgId);
            for (CreditScheme scheme : schemes) {
                if (this.isSchemeMatch(scheme, context)) {
                    this.addIfAbsent(scheme, allSchemes);
                    continue;
                }
                Monitor.getDebugDetail(scheme).info(this.getClass(), "scheme not match");
            }
        }
        return allSchemes;
    }

    private Set<Long> getBillOrgIds(DynamicObject[] bills, CreditContext context, CreditServiceFacade creditServiceFacade) {
        EntityConfig config = creditServiceFacade.getConfig(context.getEntityKey());
        HashSet<Long> creditUnits = new HashSet<Long>();
        Field orgField = config.getOrgField();
        if (orgField.getEntryKey() != null) {
            for (DynamicObject bill : bills) {
                DynamicObjectCollection entry = bill.getDynamicObjectCollection(orgField.getEntryKey());
                for (DynamicObject row : entry) {
                    DynamicObject creditUnit = row.getDynamicObject(orgField.getKey());
                    if (creditUnit == null) continue;
                    creditUnits.add(creditUnit.getLong("id"));
                }
            }
        } else {
            for (DynamicObject bill : bills) {
                DynamicObject creditUnit = bill.getDynamicObject(orgField.getKey());
                if (creditUnit == null) continue;
                creditUnits.add(creditUnit.getLong("id"));
            }
        }
        return creditUnits;
    }

    private boolean isSchemeMatch(CreditScheme scheme, CreditContext context) {
        List<BillStrategy> billStrategies = scheme.getBillStrategies();
        boolean isMatch = false;
        Iterator<BillStrategy> iterator = billStrategies.iterator();
        while (iterator.hasNext()) {
            BillStrategy billStrategy = iterator.next();
            if (!Objects.equals(billStrategy.getEntityKey(), context.getEntityKey())) continue;
            if (!this.isOpMatch(billStrategy, context)) {
                iterator.remove();
                continue;
            }
            isMatch = true;
        }
        return isMatch;
    }

    private boolean isOpMatch(BillStrategy billStrategy, CreditContext context) {
        if ("CHECK".equals(context.getCreditAction())) {
            return billStrategy.getCheckOps().contains(context.getOperateKey());
        }
        if ("UPDATE".equals(context.getCreditAction())) {
            return Objects.equals(context.getOperateKey(), billStrategy.getUpdateOp()) || billStrategy.getReverseOps().contains(context.getOperateKey());
        }
        return "QUERYBALANCE".equals(context.getCreditAction());
    }

    private void addIfAbsent(CreditScheme scheme, List<CreditScheme> schemes) {
        for (CreditScheme s : schemes) {
            if (!Objects.equals(scheme.getId(), s.getId())) continue;
            return;
        }
        schemes.add(scheme);
    }

    public List<CheckResult> rebuildJournal(DynamicObject[] bills, String operateKey) {
        if (bills == null || bills.length < 1) {
            return new ArrayList<CheckResult>(0);
        }
        CreditContext context = this.createContext(bills, operateKey, "UPDATE");
        List<CreditScheme> schemes = this.getSchemes(bills, context, this.facade);
        this.checkScheme(schemes);
        try (Lock lock = new Lock();){
            for (CreditScheme scheme : schemes) {
                this.rebuildJournal0(scheme, context, bills);
            }
            LinkedList linkedList = new LinkedList();
            return linkedList;
        }
    }

    public void rebuildJournal(CreditScheme scheme, DynamicObject[] bills, String operateKey) {
        if (bills == null || bills.length < 1) {
            return;
        }
        CreditContext context = this.createContext(bills, operateKey, "UPDATE");
        this.rebuildJournal0(scheme, context, bills);
    }

    public List<CheckResult> rebuildJournals(DynamicObject[] bills, String operateKey, Map<String, Object> parameters) {
        if (bills == null || bills.length < 1 || parameters == null || parameters.get("schemeId") == null) {
            return new ArrayList<CheckResult>(0);
        }
        CreditContext context = this.createContext(bills, operateKey, "UPDATE");
        HashSet<Long> schemeIdSet = new HashSet<Long>();
        schemeIdSet.add((Long)parameters.get("schemeId"));
        List<CreditScheme> schemesList = new SchemeReader().getSchemes(schemeIdSet);
        if (schemesList != null && !schemesList.isEmpty()) {
            CreditScheme scheme = schemesList.get(0);
            this.checkScheme(Collections.singletonList(scheme));
            this.rebuildJournal0(scheme, context, bills);
            return new LinkedList<CheckResult>();
        }
        return new ArrayList<CheckResult>(0);
    }

    private void rebuildJournal0(CreditScheme scheme, CreditContext context, DynamicObject[] bills) {
        Set<Long> billIds = Arrays.stream(bills).map(bill -> bill.getLong("id")).collect(Collectors.toSet());
        List<DynamicObject> billList = Arrays.asList(bills);
        try (Lock lock = new Lock();){
            CreditPluginProxy pluginProxy = new CreditPluginProxy(scheme, context, this.facade);
            LinkedList<CheckResult> results = new LinkedList<CheckResult>();
            List<JournalGroup> pastSavedJournals = this.facade.loadJournals(scheme, context.getEntityKey(), context.getOperateKey(), billIds);
            this.tryLock(pastSavedJournals, lock, results, "REBUILD_H");
            List<JournalGroup> journalGroups = pluginProxy.buildJournals(billList);
            this.tryLock(journalGroups, lock, results, "REBUILD_N");
            List<DimensionValue> dimensionValues = this.getDimensionValues(journalGroups);
            List<DimensionValue> pastDimensionValues = this.getDimensionValues(pastSavedJournals);
            LinkedList<DimensionValue> allDimensionValues = new LinkedList<DimensionValue>();
            allDimensionValues.addAll(dimensionValues);
            allDimensionValues.addAll(pastDimensionValues);
            ArchiveCollection archives = pluginProxy.loadArchives(allDimensionValues);
            ArchiveValidator validator = new ArchiveValidator();
            List<CheckResult> validateResult = validator.validate(journalGroups, archives);
            results.addAll(validateResult);
            pluginProxy.update(pastSavedJournals, archives, true);
            pluginProxy.update(journalGroups, archives, false);
            this.facade.deleteJournals(pastSavedJournals);
            this.facade.saveJournals(journalGroups);
            this.facade.saveArchives(archives.values());
        }
    }

    public List<QueryAmountSumResult> queryAmountSum(String dimension, List<String> dimensionValues) {
        ArrayList<QueryAmountSumResult> results = new ArrayList<QueryAmountSumResult>();
        if (StringUtils.isEmpty((CharSequence)dimension) || dimensionValues == null || dimensionValues.isEmpty()) {
            return results;
        }
        QFilter dimensionFilter = new QFilter("number", "=", (Object)dimension);
        DynamicObject dimensionObject = BusinessDataServiceHelper.loadSingleFromCache((String)"ccm_dimension", (QFilter[])new QFilter[]{dimensionFilter});
        if (dimensionObject == null || dimensionObject.getPkValue() == null || (Long)dimensionObject.getPkValue() <= 0L) {
            return results;
        }
        DynamicObject[] archives = this.queryArchives(dimension, dimensionValues, "KZFW001");
        if (archives != null) {
            List<DynamicObject> normalArchives = this.getNormalArchives(archives);
            Map<Long, BigDecimal> tmpArchivesData = this.getTmpArchivesData(archives);
            for (DynamicObject archive : normalArchives) {
                QueryAmountSumResult result = new QueryAmountSumResult();
                Long archiveId = archive.getLong("id");
                DynamicObject scheme = archive.getDynamicObject("scheme");
                DynamicObject currency = scheme.getDynamicObject("currency");
                String dimensionValue = archive.getString("dimensionvalue");
                BigDecimal quotaAmt = archive.getBigDecimal("quota");
                BigDecimal quotaTmpAmt = BigDecimal.ZERO;
                if (tmpArchivesData.get(archiveId) != null) {
                    quotaTmpAmt = tmpArchivesData.get(archiveId);
                }
                BigDecimal reduceAmt = archive.getBigDecimal("reducesum");
                BigDecimal increaseAmt = archive.getBigDecimal("increasesum");
                BigDecimal availableQuotaAmt = quotaAmt.add(quotaTmpAmt).subtract(reduceAmt).add(increaseAmt);
                result.setDimension(dimension);
                result.setDimensionValue(dimensionValue);
                result.setScheme(scheme.getString("name"));
                result.setSchemeId((Long)scheme.getPkValue());
                result.setCurrency(currency.getString("name"));
                result.setCurrencyId((Long)currency.getPkValue());
                result.setQuotaAmt(quotaAmt);
                result.setQuotaTmpAmt(quotaTmpAmt);
                result.setReduceAmt(reduceAmt);
                result.setIncreaseAmt(increaseAmt);
                result.setAvailableQuotaAmt(availableQuotaAmt);
                results.add(result);
            }
        }
        return results;
    }

    public List<QueryDaySumResult> queryDaySum(String dimension, List<String> dimensionValues) {
        ArrayList<QueryDaySumResult> results = new ArrayList<QueryDaySumResult>();
        if (StringUtils.isEmpty((CharSequence)dimension) || dimensionValues == null || dimensionValues.isEmpty()) {
            return results;
        }
        QFilter dimensionFilter = new QFilter("number", "=", (Object)dimension);
        DynamicObject dimensionObject = BusinessDataServiceHelper.loadSingleFromCache((String)"ccm_dimension", (QFilter[])new QFilter[]{dimensionFilter});
        if (dimensionObject == null || dimensionObject.getPkValue() == null || (Long)dimensionObject.getPkValue() <= 0L) {
            return results;
        }
        DynamicObject[] archives = this.queryArchives(dimension, dimensionValues, "KZFW002");
        if (archives != null) {
            List<DynamicObject> normalArchives = this.getNormalArchives(archives);
            Map<Long, BigDecimal> tmpArchivesData = this.getTmpArchivesData(archives);
            Map<Long, Map<String, Object[]>> overdueBillsMap = this.getOverdueBillsMap(normalArchives, (Long)dimensionObject.getPkValue());
            for (DynamicObject archive : normalArchives) {
                Date now;
                Date overdueBillsDate;
                int billOverdueDays;
                Object[] overdueBillsData;
                QueryDaySumResult result = new QueryDaySumResult();
                Long archiveId = archive.getLong("id");
                DynamicObject scheme = archive.getDynamicObject("scheme");
                Long schemeId = (Long)scheme.getPkValue();
                String dimensionValue = archive.getString("dimensionvalue");
                BigDecimal quotaDay = archive.getBigDecimal("quota");
                BigDecimal quotaTmpDay = BigDecimal.ZERO;
                if (tmpArchivesData.get(archiveId) != null) {
                    quotaTmpDay = tmpArchivesData.get(archiveId);
                }
                BigDecimal maxOverdueDay = BigDecimal.ZERO;
                Map<String, Object[]> overdueBillsDataMap = overdueBillsMap.get(schemeId);
                if (overdueBillsDataMap != null && (overdueBillsData = overdueBillsDataMap.get(dimensionValue)) != null && overdueBillsData[Code_MAXOVERDUEDAY] != null && (billOverdueDays = DateUtils.getDiffDays((Date)(overdueBillsDate = (Date)overdueBillsData[Code_MAXOVERDUEDAY]), (Date)(now = new Date()))) > 0) {
                    maxOverdueDay = new BigDecimal(billOverdueDays);
                }
                result.setDimension(dimension);
                result.setDimensionValue(dimensionValue);
                result.setScheme(scheme.getString("name"));
                result.setSchemeId((Long)scheme.getPkValue());
                result.setQuotaDay(quotaDay);
                result.setQuotaTmpDay(quotaTmpDay);
                result.setMaxOverdueDay(maxOverdueDay);
                results.add(result);
            }
        }
        return results;
    }

    public List<QueryOverdueAmtResult> queryOverdueAmt(String dimension, List<String> dimensionValues) {
        ArrayList<QueryOverdueAmtResult> results = new ArrayList<QueryOverdueAmtResult>();
        if (StringUtils.isEmpty((CharSequence)dimension) || dimensionValues == null || dimensionValues.isEmpty()) {
            return results;
        }
        QFilter dimensionFilter = new QFilter("number", "=", (Object)dimension);
        DynamicObject dimensionObject = BusinessDataServiceHelper.loadSingleFromCache((String)"ccm_dimension", (QFilter[])new QFilter[]{dimensionFilter});
        if (dimensionObject == null || dimensionObject.getPkValue() == null || (Long)dimensionObject.getPkValue() <= 0L) {
            return results;
        }
        DynamicObject[] archives = this.queryArchives(dimension, dimensionValues, "KZFW006");
        if (archives != null) {
            List<DynamicObject> normalArchives = this.getNormalArchives(archives);
            Map<Long, BigDecimal> tmpArchivesData = this.getTmpArchivesData(archives);
            Map<Long, Map<String, Object[]>> overdueBillsMap = this.getOverdueBillsMap(normalArchives, (Long)dimensionObject.getPkValue());
            for (DynamicObject archive : normalArchives) {
                Object[] overdueBillsData;
                QueryOverdueAmtResult result = new QueryOverdueAmtResult();
                Long archiveId = archive.getLong("id");
                DynamicObject scheme = archive.getDynamicObject("scheme");
                DynamicObject currency = scheme.getDynamicObject("currency");
                Long schemeId = (Long)scheme.getPkValue();
                String dimensionValue = archive.getString("dimensionvalue");
                BigDecimal quotaOverdueAmt = archive.getBigDecimal("quota");
                BigDecimal tmpOverdueAmt = BigDecimal.ZERO;
                if (tmpArchivesData.get(archiveId) != null) {
                    tmpOverdueAmt = tmpArchivesData.get(archiveId);
                }
                BigDecimal actualOverdueAmt = BigDecimal.ZERO;
                Map<String, Object[]> overdueBillsDataMap = overdueBillsMap.get(schemeId);
                if (overdueBillsDataMap != null && (overdueBillsData = overdueBillsDataMap.get(dimensionValue)) != null && overdueBillsData[Code_SUMOVERDUEAMT] != null) {
                    BigDecimal overdueBillsAmt;
                    actualOverdueAmt = overdueBillsAmt = (BigDecimal)overdueBillsData[Code_SUMOVERDUEAMT];
                }
                result.setDimension(dimension);
                result.setDimensionValue(dimensionValue);
                result.setScheme(scheme.getString("name"));
                result.setSchemeId((Long)scheme.getPkValue());
                result.setCurrency(currency.getString("name"));
                result.setCurrencyId((Long)currency.getPkValue());
                result.setQuotaOverdueAmt(quotaOverdueAmt);
                result.setTmpOverdueAmt(tmpOverdueAmt);
                result.setActualOverdueAmt(actualOverdueAmt);
                results.add(result);
            }
        }
        return results;
    }

    private Map<Long, Map<String, Object[]>> getOverdueBillsMap(List<DynamicObject> normalArchives, Long dimensionId) {
        HashMap<Long, Map<String, Object[]>> overdueBillsMap = new HashMap<Long, Map<String, Object[]>>(16);
        DimensionReader dimensionReader = new DimensionReader();
        Dimension dimension = dimensionReader.getDimension(dimensionId);
        DimensionEntryFieldMapper dimensionEntryFieldMapper = new DimensionEntryFieldMapper(dimension.getId());
        LinkedList<DimensionValue> dimensionValues = new LinkedList<DimensionValue>();
        for (DynamicObject numberArchive : normalArchives) {
            DimensionValue dimensionValue = new DimensionValue(dimension);
            dimensionValue.setValue(numberArchive.getString("dimensionvalue"));
            dimensionValues.add(dimensionValue);
        }
        for (DynamicObject archive : normalArchives) {
            DynamicObject schemeObject = archive.getDynamicObject("scheme");
            Long schemeId = (Long)schemeObject.getPkValue();
            SchemeReader schemeReader = new SchemeReader();
            CreditScheme scheme = schemeReader.getScheme(schemeId);
            HashMap<String, Object[]> overdueBillsDataMap = new HashMap<String, Object[]>();
            if (overdueBillsMap.get(schemeId) != null || scheme.getBillStrategies() == null || scheme.getBillStrategies().isEmpty()) continue;
            BillStrategy billStrategy = scheme.getBillStrategies().get(0);
            String entityKey = billStrategy.getAssingEntityKey();
            String calculateDate = billStrategy.getCalculateDate();
            String calculateAmt = billStrategy.getCalculateAmt();
            String assingEntityKey = billStrategy.getAssingEntityKey();
            EntityConfig entityConfig = this.facade.getConfig(entityKey);
            DataSet billDataSet = this.queryOverdueBills(scheme, dimension, dimensionValues, billStrategy).distinct();
            for (Row billDataRow : billDataSet) {
                Object[] overdueBillsData;
                List<Role> roles = scheme.getDimension().getRoles();
                DimensionValue dimensionValue = new DimensionValue(scheme.getDimension());
                for (Role role : roles) {
                    DynamicObjectCollection cusunicodes;
                    String roleType;
                    QFilter q;
                    DynamicObject roleId;
                    MainEntityType assEntityType;
                    MainEntityType assEntityType2;
                    Field field = entityConfig.getField(role.getElement());
                    String entryKey = field.getEntryKey();
                    String fullName = field.getFullName();
                    String baseDataKey = dimensionEntryFieldMapper.getBaseDataKey(role.getRoleType());
                    MainEntityType roleBDEntityType = MetadataServiceHelper.getDataEntityType((String)baseDataKey);
                    if (roleBDEntityType != null && roleBDEntityType.findProperty("masterid") != null && !((assEntityType2 = MetadataServiceHelper.getDataEntityType((String)assingEntityKey)).getProperty(fullName) instanceof BigIntProp)) {
                        fullName = fullName + ".masterid";
                    }
                    StringBuilder fullNameStrBuf = new StringBuilder();
                    if (!StringUtils.isBlank((CharSequence)entryKey)) {
                        fullNameStrBuf.append(entryKey).append('.');
                    }
                    fullNameStrBuf.append(fullName);
                    Object roleValue = billDataRow.get(fullNameStrBuf.toString());
                    if (roleBDEntityType != null && roleBDEntityType.findProperty("masterid") != null && (assEntityType = MetadataServiceHelper.getDataEntityType((String)assingEntityKey)).getProperty(fullName) instanceof BigIntProp && (roleId = QueryServiceHelper.queryOne((String)baseDataKey, (String)"masterid", (QFilter[])new QFilter[]{q = new QFilter("id", "=", roleValue)})) != null) {
                        roleValue = roleId.getLong("masterid");
                    }
                    if ("CUSUNICODE".equals(roleType = role.getRoleType()) && (cusunicodes = QueryServiceHelper.query((String)"ccm_cusunicode", (String)"id,entry.e_customer", (QFilter[])new QFilter[]{new QFilter("entry.e_customer", "=", roleValue)})) != null && !cusunicodes.isEmpty()) {
                        roleValue = ((DynamicObject)cusunicodes.get(0)).getLong("id");
                    }
                    dimensionValue.putValue(role, roleValue);
                }
                String dimensionString = dimensionValue.getValue();
                Date billCalculateDate = new Date();
                BigDecimal billCalculateAmt = BigDecimal.ZERO;
                if (!StringUtils.isEmpty((CharSequence)calculateAmt)) {
                    billCalculateAmt = billDataRow.getBigDecimal(calculateAmt);
                    Long billcurrency = billDataRow.getLong("billcurrency");
                    Long schemeCurrency = scheme.getCurrency();
                    Long schemeExratetable = scheme.getExchangeRateTable();
                    if (schemeCurrency.longValue() != billcurrency.longValue()) {
                        BigDecimal rate = this.getRate(billcurrency, schemeCurrency, schemeExratetable, new Date());
                        billCalculateAmt = rate == null ? BigDecimal.ZERO : billCalculateAmt.multiply(rate);
                    }
                } else {
                    billCalculateDate = billDataRow.getDate(calculateDate);
                }
                if (overdueBillsDataMap.get(dimensionString) != null) {
                    overdueBillsData = (Object[])overdueBillsDataMap.get(dimensionString);
                    Date maxOverdueBillsData = (Date)overdueBillsData[Code_MAXOVERDUEDAY];
                    if (maxOverdueBillsData.after(billCalculateDate)) {
                        maxOverdueBillsData = billCalculateDate;
                    }
                    BigDecimal billCalculateAmtSum = (BigDecimal)overdueBillsData[Code_SUMOVERDUEAMT];
                    billCalculateAmtSum = billCalculateAmtSum.add(billCalculateAmt);
                    overdueBillsData[CreditService.Code_MAXOVERDUEDAY.intValue()] = maxOverdueBillsData;
                    overdueBillsData[CreditService.Code_SUMOVERDUEAMT.intValue()] = billCalculateAmtSum;
                } else {
                    overdueBillsData = new Object[]{billCalculateDate, billCalculateAmt};
                }
                overdueBillsDataMap.put(dimensionString, overdueBillsData);
            }
            overdueBillsMap.put(schemeId, overdueBillsDataMap);
        }
        return overdueBillsMap;
    }

    private DataSet queryOverdueBills(CreditScheme scheme, Dimension dimension, List<DimensionValue> dimensionValues, BillStrategy billStrategy) {
        LinkedList<String> selectors = new LinkedList<String>();
        selectors.add("id");
        AnalyseSumOverdueBillQueryHelper querier = new AnalyseSumOverdueBillQueryHelper();
        return querier.queryOverdueDayBills(scheme, dimension, dimensionValues, billStrategy, selectors);
    }

    private BigDecimal getRate(long srcCurrency, long targetCurrency, long rateTable, Date date) {
        if (srcCurrency == targetCurrency || srcCurrency == 0L || targetCurrency == 0L || rateTable == 0L || date == null) {
            return BigDecimal.ONE;
        }
        BigDecimal rate = BaseDataServiceHelper.getExchangeRate((Long)rateTable, (Long)srcCurrency, (Long)targetCurrency, (Date)date);
        return rate;
    }

    private DynamicObject[] queryArchives(String dimension, List<String> dimensionValues, String checkType) {
        QFilter dimensionFilter = new QFilter("dimension.number", "=", (Object)dimension);
        QFilter dimensionValueFilter = new QFilter("dimensionvalue", "in", dimensionValues);
        Date today = new Date();
        QFilter beginDateFilter = new QFilter("begindate", "<=", (Object)DateUtils.getEndOfDay((Date)today));
        QFilter endDateFilter = new QFilter("enddate", ">=", (Object)DateUtils.getStartOfDay((Date)today));
        QFilter schemeFilter = new QFilter("scheme.checktype.number", "=", (Object)checkType);
        DynamicObject[] archives = BusinessDataServiceHelper.load((String)"ccm_archive", (String)"id,scheme,dimension,dimensionvalue,quota,reducesum,increasesum,archivetype,relatedid", (QFilter[])new QFilter[]{dimensionFilter, dimensionValueFilter, beginDateFilter, endDateFilter, schemeFilter});
        return archives;
    }

    private List<DynamicObject> getNormalArchives(DynamicObject[] archives) {
        ArrayList<DynamicObject> normalArchives = new ArrayList<DynamicObject>();
        if (archives != null) {
            for (DynamicObject archive : archives) {
                String archiveType = archive.getString("archivetype");
                if (!"normal".equals(archiveType)) continue;
                normalArchives.add(archive);
            }
        }
        return normalArchives;
    }

    private Map<Long, BigDecimal> getTmpArchivesData(DynamicObject[] archives) {
        HashMap<Long, BigDecimal> tmpArchivesData = new HashMap<Long, BigDecimal>(16);
        if (archives != null) {
            for (DynamicObject archive : archives) {
                String archiveType = archive.getString("archivetype");
                if (!"temp".equals(archiveType)) continue;
                Long relatedId = archive.getLong("relatedid");
                BigDecimal quota = archive.getBigDecimal("quota");
                if (tmpArchivesData.get(relatedId) != null) {
                    tmpArchivesData.put(relatedId, ((BigDecimal)tmpArchivesData.get(relatedId)).add(quota));
                    continue;
                }
                tmpArchivesData.put(relatedId, quota);
            }
        }
        return tmpArchivesData;
    }

    private Set<String> getEntityConfigColumns(String entityKey) {
        HashSet<String> selectors = new HashSet<String>();
        DynamicObject entityConfig = BusinessDataServiceHelper.loadSingleFromCache((Object)entityKey, (String)"ccm_entityconfig");
        if (entityConfig == null) {
            return selectors;
        }
        DynamicObjectCollection selectorEntry = entityConfig.getDynamicObjectCollection("selectors");
        for (DynamicObject selectorRow : selectorEntry) {
            selectors.add(selectorRow.getString("field"));
        }
        selectors.add("billno");
        return selectors;
    }

    private Set<String> getImNeedInverseColumns(String billEntity) {
        Map<String, Map<String, Object>> settingMap = this.getColumnsSetting(billEntity, "id,bill,entry.field,entry.isinverse");
        HashSet<String> needInverseColumnSet = new HashSet<String>();
        for (Map.Entry<String, Map<String, Object>> fieldSetting : settingMap.entrySet()) {
            Map<String, Object> setting = fieldSetting.getValue();
            Boolean isinverse = (Boolean)setting.get("isinverse");
            if (isinverse == null || !isinverse.booleanValue()) continue;
            needInverseColumnSet.add(fieldSetting.getKey());
        }
        return needInverseColumnSet;
    }

    private Map<String, Map<String, Object>> getColumnsSetting(String billEntity, String selectFields) {
        HashMap<String, Map<String, Object>> result = new HashMap<String, Map<String, Object>>(256);
        QFilter f = new QFilter("bill", "=", (Object)billEntity);
        f = f.and("enable", "=", (Object)"1");
        DynamicObject setting = BusinessDataServiceHelper.loadSingleFromCache((String)"im_billfieldsetting", (String)("id,bill,entry.field" + selectFields), (QFilter[])f.toArray());
        if (setting != null) {
            String[] fields = selectFields.split(",");
            HashSet<String> entryFields = new HashSet<String>();
            for (int i = 0; i < fields.length; ++i) {
                String field = fields[i];
                if (field.indexOf(46) <= 0) continue;
                entryFields.add(field.substring(field.indexOf(46) + 1));
            }
            DynamicObjectCollection entrys = setting.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entrys) {
                HashMap<String, Object> fieldProps = new HashMap<String, Object>(entryFields.size());
                String filedKey = entry.getString("field");
                for (String entryField : entryFields) {
                    fieldProps.put(entryField, entry.get(entryField));
                }
                result.put(filedKey, fieldProps);
            }
        }
        return result;
    }

    private void checkDuplicateJournal(String operateKey, List<JournalGroup> saveableJournalGroups) {
        QFilter mainbillidFilter;
        QFilter opFilter;
        if (saveableJournalGroups == null || saveableJournalGroups.size() <= 0) {
            return;
        }
        ArrayList<Long> mainBillIds = new ArrayList<Long>(saveableJournalGroups.size());
        for (JournalGroup saveJouGrp : saveableJournalGroups) {
            mainBillIds.add(saveJouGrp.getMainBillId());
        }
        QFilter traceFilter = new QFilter("traceid", "!=", (Object)RequestContext.get().getTraceId());
        Object[] journals = BusinessDataServiceHelper.load((String)"ccm_journal", (String)"id,mainbillid,op,billid,billno,entryid", (QFilter[])new QFilter[]{traceFilter, opFilter = new QFilter("op", "=", (Object)operateKey), mainbillidFilter = new QFilter("mainbillid", "in", mainBillIds)});
        if (!ObjectUtils.isEmpty((Object[])journals)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8be5\u5355\u636e\u5f53\u524d\u64cd\u4f5c\u5bf9\u5e94\u7684\u4fe1\u7528\u6d41\u6c34\u5df2\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u4fe1\u7528\u6d41\u6c34\u3002", (String)"CreditService_4", (String)"scmc-ccm-business", (Object[])new Object[0]), new Object[0]));
        }
    }
}

