/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.business.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.audit.Auditable;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scmc.ccm.business.archives.ArchiveCollection;
import kd.scmc.ccm.business.archives.ArchiveLoader;
import kd.scmc.ccm.business.archives.ArchiveService;
import kd.scmc.ccm.business.archives.CreditArchive;
import kd.scmc.ccm.business.check.CheckResult;
import kd.scmc.ccm.business.check.CreditChecker;
import kd.scmc.ccm.business.core.CreditContext;
import kd.scmc.ccm.business.core.DimensionValue;
import kd.scmc.ccm.business.factory.ArchiveLoaderFactory;
import kd.scmc.ccm.business.factory.CreditCheckerFactory;
import kd.scmc.ccm.business.journal.Journal;
import kd.scmc.ccm.business.journal.JournalGroup;
import kd.scmc.ccm.business.journal.JournalReader;
import kd.scmc.ccm.business.journal.OverdueDayJournalBuilder;
import kd.scmc.ccm.business.journal.RuleBasedJournalBuilder;
import kd.scmc.ccm.business.monitor.Monitor;
import kd.scmc.ccm.business.recalculate.RecalculateService;
import kd.scmc.ccm.business.recalculatenew.RecalculateNewService;
import kd.scmc.ccm.business.scheme.CreditScheme;
import kd.scmc.ccm.business.scheme.SchemeReader;
import kd.scmc.ccm.business.setting.EntityConfig;
import kd.scmc.ccm.business.setting.EntityConfigReader;
import kd.scmc.ccm.common.apm.Audit;

public class CreditServiceFacade {
    private static final Log logger = LogFactory.getLog(CreditServiceFacade.class);

    public List<CreditScheme> getSchemes(long orgId) {
        try (Auditable audit = Audit.audit((String)"ccm.getSchemes");){
            Monitor.getDebugInfo().addOrgId(orgId);
            List<CreditScheme> list = new SchemeReader().getSchemes(orgId);
            return list;
        }
    }

    public CreditScheme getScheme(long schemeId) {
        try (Auditable audit = Audit.audit((String)"ccm.getSchemebyId");){
            CreditScheme creditScheme = new SchemeReader().getScheme(schemeId);
            return creditScheme;
        }
    }

    public List<CreditScheme> getSchemes(Set<Long> schemeIds) {
        try (Auditable audit = Audit.audit((String)"ccm.getSchemesbyIds");){
            List<CreditScheme> list = new SchemeReader().getSchemes(schemeIds);
            return list;
        }
    }

    public EntityConfig getConfig(String entityKey) {
        try (Auditable audit = Audit.audit((String)"ccm.getConfig");){
            EntityConfig entityConfig = new EntityConfigReader().readConfig(entityKey);
            return entityConfig;
        }
    }

    public List<JournalGroup> buildJournals(CreditScheme scheme, CreditContext context, List<DynamicObject> bills) {
        try (Auditable audit = Audit.audit((String)"ccm.buildJournals");){
            long beginbuildjournaltime = System.currentTimeMillis();
            logger.info("\u4fe1\u7528 buildJournals begin\uff1a " + new Date(beginbuildjournaltime));
            boolean isOverduDay = scheme.getQuotaType().getQuotaType().equals("days") || scheme.getQuotaType().getQuotaType().equals("overdueamt");
            RuleBasedJournalBuilder journalBuilder = isOverduDay ? new OverdueDayJournalBuilder(scheme, context) : new RuleBasedJournalBuilder(scheme, context);
            List<JournalGroup> journals = journalBuilder.buildJournals(bills);
            Monitor.getDebugDetail(scheme).setJournalGroups(journals);
            List<JournalGroup> list = journals;
            return list;
        }
    }

    public List<CheckResult> check(CreditScheme scheme, Collection<JournalGroup> journalGroups, ArchiveCollection archives) {
        try (Auditable audit = Audit.audit((String)"ccm.check");){
            ArrayList<CheckResult> results = new ArrayList<CheckResult>(journalGroups.size());
            String quotaType = scheme.getQuotaType().getQuotaType();
            CreditChecker creditChecker = CreditCheckerFactory.getCreditChecker(quotaType);
            for (JournalGroup journalGroup : journalGroups) {
                CheckResult checkResult = creditChecker.check(journalGroup, archives);
                Monitor.getDebugDetail(journalGroup.getScheme()).addCheckResult(checkResult);
                results.add(checkResult);
            }
            ArrayList<CheckResult> arrayList = results;
            return arrayList;
        }
    }

    public CheckResult updateBalance(JournalGroup journalGroup, ArchiveCollection archives, boolean isReverse) {
        try (Auditable audit = Audit.audit((String)"ccm.update");){
            CheckResult checkResult = new ArchiveService().updateBalance(journalGroup, archives, isReverse);
            return checkResult;
        }
    }

    public void deleteJournal(CreditScheme scheme) {
        try (Auditable audit = Audit.audit((String)"ccm.deleteJournal");){
            if (Monitor.isDebugMode()) {
                return;
            }
            QFilter schemeFilter = new QFilter("scheme", "=", (Object)scheme.getId());
            QFilter actionFilter = new QFilter("action", "<>", (Object)"ADJUST");
            DeleteServiceHelper.delete((String)"ccm_journal", (QFilter[])new QFilter[]{schemeFilter, actionFilter});
        }
    }

    public void deleteJournal(CreditScheme scheme, List<DimensionValue> dimensionValues) {
        try (Auditable audit = Audit.audit((String)"ccm.deleteJournal");){
            if (Monitor.isDebugMode()) {
                return;
            }
            QFilter schemeFilter = new QFilter("scheme", "=", (Object)scheme.getId());
            HashSet<String> plainValues = new HashSet<String>(dimensionValues.size());
            for (DimensionValue value : dimensionValues) {
                plainValues.add(value.getValue());
            }
            QFilter dimensionValueFilter = new QFilter("dimensionvalue", "in", plainValues);
            QFilter actionFilter = new QFilter("action", "<>", (Object)"ADJUST");
            DeleteServiceHelper.delete((String)"ccm_journal", (QFilter[])new QFilter[]{schemeFilter, dimensionValueFilter, actionFilter});
        }
    }

    public void deleteJournals(List<JournalGroup> journalGroups) {
        long deleteJourBeginTime = System.currentTimeMillis();
        logger.info("\u4fe1\u7528\u5220\u9664\u6d41\u6c34 begin \uff1a " + new Date(deleteJourBeginTime));
        try (Auditable audit = Audit.audit((String)"ccm.deleteJournals");){
            if (Monitor.isDebugMode()) {
                return;
            }
            HashSet<Long> journalPks = new HashSet<Long>(journalGroups.size());
            logger.info("\u4fe1\u7528\u5220\u9664\u6d41\u6c34 \u672c\u6b21\u8981\u5220\u9664\u7684\u6d41\u6c34\u7ec4\u6570\u91cf  \uff1a {}", (Object)journalGroups.size());
            logger.info("\u4fe1\u7528\u5220\u9664\u6d41\u6c34 \u5faa\u73af journalGroups begin \uff01");
            for (JournalGroup journalGroup : journalGroups) {
                if (journalGroup == null) {
                    logger.info("\u4fe1\u7528\u5220\u9664\u6d41\u6c34 \u5faa\u73af journalGroups---journalGroup.BillNo \uff1a{}", (Object)"journalGroup is null");
                    continue;
                }
                logger.info("\u4fe1\u7528\u5220\u9664\u6d41\u6c34 \u5faa\u73af journalGroups---journalGroup.BillNo \uff1a{}", (Object)journalGroup.getBillNo());
                for (Journal journal : journalGroup.getJournals()) {
                    if (journal == null) {
                        logger.info("\u4fe1\u7528\u5220\u9664\u6d41\u6c34 \u5faa\u73af journalGroup.getJournals()---journal is null!");
                        continue;
                    }
                    logger.info("\u4fe1\u7528\u5220\u9664\u6d41\u6c34 \u5faa\u73af journalGroup.getJournals()---journalid \uff1a{}", (Object)journal.getJournalId());
                    journalPks.add(journal.getJournalId());
                    logger.info("\u4fe1\u7528\u5220\u9664\u6d41\u6c34 \u5faa\u73af journalGroup.getJournals()---journalBillno \uff1a{}", (Object)journal.getBillNo());
                    logger.info("\u4fe1\u7528\u5220\u9664\u6d41\u6c34 \u5faa\u73af joujournalGroup.getJournals()rnals---journalAmount \uff1a{}", (Object)journal.getAmount());
                }
            }
            logger.info("\u4fe1\u7528 CreditServiceFacade.deleteJournals \u5faa\u73af journalGroups end \uff01");
            if (!journalPks.isEmpty()) {
                logger.info("\u4fe1\u7528\u5220\u9664\u6d41\u6c34 delResult \u5f85\u5220\u9664\u6d41\u6c34\u6570\u91cf\uff1a" + journalPks.hashCode());
                OperationResult delResult = OperationServiceHelper.executeOperate((String)"delete", (String)"ccm_journal", (Object[])journalPks.toArray(new Long[0]), (OperateOption)OperateOption.create());
                logger.info("\u4fe1\u7528\u5220\u9664\u6d41\u6c34 delResult success\uff1a" + delResult.isSuccess());
                logger.info("\u4fe1\u7528\u5220\u9664\u6d41\u6c34 delResult billCount\uff1a" + delResult.getBillCount());
                logger.info("\u4fe1\u7528\u5220\u9664\u6d41\u6c34delResult errorinfo\uff1a" + delResult.getAllErrorInfo());
                logger.info("\u4fe1\u7528\u5220\u9664\u6d41\u6c34 delResult SuccessPkIds\uff1a" + delResult.getSuccessPkIds());
                logger.info("\u4fe1\u7528\u5220\u9664\u6d41\u6c34  endtime\uff1a" + delResult.getFinishedTime());
            }
        }
    }

    public void saveJournals(List<JournalGroup> journalGroups) {
        long saveJourBeginTime = System.currentTimeMillis();
        logger.info("\u4fe1\u7528\u4fdd\u5b58\u6d41\u6c34 begin \uff1a " + new Date(saveJourBeginTime));
        try (Auditable audit = Audit.audit((String)"ccm.saveJournals");){
            if (Monitor.isDebugMode()) {
                return;
            }
            LinkedList<DynamicObject> dynJournals = new LinkedList<DynamicObject>();
            logger.info("\u4fe1\u7528\u4fdd\u5b58\u6d41\u6c34 \u5165\u53c2\u5f85\u4fdd\u5b58\u7684\u6d41\u6c34\u7ec4\u6570\u91cf  \uff1a {}", (Object)journalGroups.size());
            logger.info("\u4fe1\u7528\u4fdd\u5b58\u6d41\u6c34 \u5faa\u73af journalGroups begin \uff1a");
            for (JournalGroup journalGroup : journalGroups) {
                if (journalGroup != null) {
                    logger.info("\u4fe1\u7528\u4fdd\u5b58\u6d41\u6c34 \u5faa\u73af journalGroups---journalGroup.getBillNo \uff1a{} ", (Object)(journalGroup != null ? journalGroup.getBillNo() : "journalGroup is null"));
                    logger.info("\u4fe1\u7528\u4fdd\u5b58\u6d41\u6c34 \u5faa\u73af journalGroups---journalGroup.schemeid \uff1a{}", journalGroup != null && journalGroup.getScheme() != null ? Long.valueOf(journalGroup.getScheme().getId()) : "");
                    logger.info("\u4fe1\u7528\u4fdd\u5b58\u6d41\u6c34 \u5faa\u73af journalGroups---journalGroup.getJournals size \uff1a{}", journalGroup != null && journalGroup.getJournals() != null ? Integer.valueOf(journalGroup.getJournals().size()) : "\u5f53\u524djournalGroup\u4e2djournal\u4e3a\u7a7a");
                    for (Journal journal : journalGroup.getJournals()) {
                        if (journal == null) {
                            logger.info("\u4fe1\u7528\u4fdd\u5b58\u6d41\u6c34 \u5faa\u73af journals---journal is null!");
                            continue;
                        }
                        logger.info("\u4fe1\u7528\u4fdd\u5b58\u6d41\u6c34 \u5faa\u73af journals---journal.getArchiveId() \uff1a{}", (Object)journal.getArchiveId());
                        if (journal.getArchiveId() == 0L) continue;
                        dynJournals.add(journal.toDynamicObject());
                        logger.info("\u4fe1\u7528\u4fdd\u5b58\u6d41\u6c34 \u5faa\u73af journals---journal.getMainEntityKey() \uff1a" + journal.getMainEntityKey());
                        logger.info("\u4fe1\u7528\u4fdd\u5b58\u6d41\u6c34 \u5faa\u73af journals---journal.getBillNo() \uff1a" + journal.getBillNo());
                        logger.info("\u4fe1\u7528\u4fdd\u5b58\u6d41\u6c34 \u5faa\u73af journals---journal.getAction() \uff1a" + journal.getAction());
                        logger.info("\u4fe1\u7528\u4fdd\u5b58\u6d41\u6c34 \u5faa\u73af journals---journal.getOp() \uff1a" + journal.getOp());
                        logger.info("\u4fe1\u7528\u4fdd\u5b58\u6d41\u6c34 \u5faa\u73af journals---journal.getAmount() \uff1a" + journal.getAmount());
                    }
                    continue;
                }
                logger.info("\u4fe1\u7528\u4fdd\u5b58\u6d41\u6c34 \u5faa\u73af journalGroups---journalGroup.BillNo \uff1a{}", (Object)"journalGroup is null");
            }
            logger.info("\u4fe1\u7528 CreditServiceFacade.saveJournals \u5faa\u73af journalGroups end \uff01");
            if (!dynJournals.isEmpty()) {
                logger.info("\u4fe1\u7528\u4fdd\u5b58\u6d41\u6c34 \u5faa\u73af journals---journal.size : " + dynJournals.size());
                Object[] saveJournalResult = SaveServiceHelper.save((DynamicObject[])dynJournals.toArray(new DynamicObject[0]));
                logger.info("\u4fe1\u7528\u4fdd\u5b58\u6d41\u6c34 \u7ed3\u679c \uff1a " + SerializationUtils.toJsonString((Object)saveJournalResult));
            }
        }
    }

    public List<JournalGroup> loadJournals(CreditScheme scheme, String entityKey, Set<Long> billIds) {
        try (Auditable audit = Audit.audit((String)"ccm.loadJournals");){
            List<JournalGroup> journals = new JournalReader().loadJournals(scheme, entityKey, billIds);
            Monitor.getDebugDetail(scheme).setJournalGroups(journals);
            List<JournalGroup> list = journals;
            return list;
        }
    }

    public List<JournalGroup> loadJournals(CreditScheme scheme, String entityKey, String op, Set<Long> billIds) {
        try (Auditable audit = Audit.audit((String)"ccm.loadJournals");){
            long loadjourbegintime = System.currentTimeMillis();
            logger.info("\u4fe1\u7528facade.loadJournals(scheme,entityKey,op,billIds) begin : " + new Date(loadjourbegintime));
            List<JournalGroup> journals = new JournalReader().loadJournals(scheme, entityKey, op, billIds);
            Monitor.getDebugDetail(scheme).setJournalGroups(journals);
            List<JournalGroup> list = journals;
            return list;
        }
    }

    public List<JournalGroup> loadJournals(CreditScheme scheme, String entityKey, Set<String> upOpSet, Set<Long> billIds) {
        try (Auditable audit = Audit.audit((String)"ccm.loadJournals");){
            long loadjourbegintime = System.currentTimeMillis();
            logger.info("\u4fe1\u7528facade.loadJournals(scheme,entityKey,upOpSet,billIds) begin : " + new Date(loadjourbegintime));
            List<JournalGroup> journals = new JournalReader().loadJournals(scheme, entityKey, upOpSet, billIds);
            Monitor.getDebugDetail(scheme).setJournalGroups(journals);
            List<JournalGroup> list = journals;
            return list;
        }
    }

    public List<JournalGroup> loadJournals(CreditScheme scheme, Set<Long> archiveIds, String action) {
        try (Auditable audit = Audit.audit((String)"ccm.loadJournals");){
            List<JournalGroup> journals = new JournalReader().loadJournals(scheme, archiveIds, action);
            Monitor.getDebugDetail(scheme).setJournalGroups(journals);
            List<JournalGroup> list = journals;
            return list;
        }
    }

    public ArchiveCollection loadArchives(CreditScheme scheme) {
        try (Auditable audit = Audit.audit((String)"ccm.loadArchives");){
            String quotaType = scheme.getQuotaType().getQuotaType();
            ArchiveLoader archiveLoader = ArchiveLoaderFactory.getArchiveLoader(quotaType);
            ArchiveCollection archives = archiveLoader.loadArchives(scheme);
            Monitor.getDebugDetail(scheme).setArchiveCollection(archives);
            ArchiveCollection archiveCollection = archives;
            return archiveCollection;
        }
    }

    public ArchiveCollection loadArchives(CreditScheme scheme, List<DimensionValue> dimensionValues) {
        try (Auditable audit = Audit.audit((String)"ccm.loadArchives");){
            String quotaType = scheme.getQuotaType().getQuotaType();
            ArchiveLoader archiveLoader = ArchiveLoaderFactory.getArchiveLoader(quotaType);
            ArchiveCollection archives = archiveLoader.loadArchives(scheme, dimensionValues);
            Monitor.getDebugDetail(scheme).setArchiveCollection(archives);
            ArchiveCollection archiveCollection = archives;
            return archiveCollection;
        }
    }

    public ArchiveCollection loadArchives(CreditScheme scheme, boolean isRecalFlag) {
        try (Auditable audit = Audit.audit((String)"ccm.loadArchives");){
            String quotaType = scheme.getQuotaType().getQuotaType();
            ArchiveLoader archiveLoader = ArchiveLoaderFactory.getArchiveLoader(quotaType, isRecalFlag);
            ArchiveCollection archives = archiveLoader.loadArchives(scheme);
            Monitor.getDebugDetail(scheme).setArchiveCollection(archives);
            ArchiveCollection archiveCollection = archives;
            return archiveCollection;
        }
    }

    public ArchiveCollection loadArchives(CreditScheme scheme, List<DimensionValue> dimensionValues, boolean isRecalFlag) {
        try (Auditable audit = Audit.audit((String)"ccm.loadArchives");){
            String quotaType = scheme.getQuotaType().getQuotaType();
            ArchiveLoader archiveLoader = ArchiveLoaderFactory.getArchiveLoader(quotaType, isRecalFlag);
            ArchiveCollection archives = archiveLoader.loadArchives(scheme, dimensionValues);
            Monitor.getDebugDetail(scheme).setArchiveCollection(archives);
            ArchiveCollection archiveCollection = archives;
            return archiveCollection;
        }
    }

    public void saveArchives(Collection<CreditArchive> archives) {
        try (Auditable audit = Audit.audit((String)"ccm.saveArchives");){
            if (Monitor.isDebugMode()) {
                return;
            }
            ArrayList<DynamicObject> rawArchives = new ArrayList<DynamicObject>(archives.size());
            for (CreditArchive archive : archives) {
                rawArchives.addAll(archive.getRawArchives());
            }
            if (!rawArchives.isEmpty()) {
                logger.info("\u4fdd\u5b58\u4fe1\u7528\u6863\u6848-\u6301\u4e45\u5316\u524d\u8bb0\u5f55rawArchives size\uff1a " + rawArchives.size());
                for (DynamicObject rawArchive : rawArchives) {
                    logger.info("\u4fdd\u5b58\u4fe1\u7528\u6863\u6848-\u672c\u6b21\u5f85\u6301\u4e45\u5316\u6863\u6848 rawArchive.getPkValue()\uff1a " + rawArchive.getPkValue());
                    logger.info("\u4fdd\u5b58\u4fe1\u7528\u6863\u6848-\u672c\u6b21\u5f85\u6301\u4e45\u5316\u6863\u6848 rawArchive.dimensionvalue\uff1a " + rawArchive.getString("dimensionvalue"));
                    logger.info("\u4fdd\u5b58\u4fe1\u7528\u6863\u6848-\u672c\u6b21\u5f85\u6301\u4e45\u5316\u6863\u6848 rawArchive.reducesum\uff1a " + rawArchive.getBigDecimal("reducesum"));
                    logger.info("\u4fdd\u5b58\u4fe1\u7528\u6863\u6848-\u672c\u6b21\u5f85\u6301\u4e45\u5316\u6863\u6848 rawArchive.increasesum\uff1a " + rawArchive.getBigDecimal("increasesum"));
                    logger.info("\u4fdd\u5b58\u4fe1\u7528\u6863\u6848-\u672c\u6b21\u5f85\u6301\u4e45\u5316\u6863\u6848 rawArchive.balance\uff1a " + rawArchive.getBigDecimal("balance"));
                }
                SaveServiceHelper.save((DynamicObject[])rawArchives.toArray(new DynamicObject[0]));
            }
        }
    }

    public List<CreditArchive> recalculatePreview(CreditScheme scheme, String dimensionRangeMode, List<DimensionValue> dimensionValues) {
        try (Auditable audit = Audit.audit((String)"ccm.recalculatePreview");){
            List<CreditArchive> list = new RecalculateService().recalculatePreview(scheme, dimensionRangeMode, dimensionValues);
            return list;
        }
    }

    public List<Journal> recalculateDetailPreview(CreditScheme scheme, DimensionValue dimensionValue) {
        try (Auditable audit = Audit.audit((String)"ccm.recalculateDetailPreview");){
            List<Journal> list = new RecalculateService().recalculateDetailPreview(scheme, dimensionValue);
            return list;
        }
    }

    public List<CreditArchive> recalculate(CreditScheme scheme, String dimensionRangeMode, List<DimensionValue> dimensionValues) {
        try (Auditable audit = Audit.audit((String)"ccm.recalculate");){
            List<CreditArchive> list = new RecalculateService().recalculate(scheme, dimensionRangeMode, dimensionValues);
            return list;
        }
    }

    public Map<Long, List<CreditArchive>> recalculateNew(CreditScheme scheme, String dimensionRangeMode, List<DimensionValue> dimensionValues, Date beginDate) {
        try (Auditable audit = Audit.audit((String)"ccm.recalculateNew");){
            Map<Long, List<CreditArchive>> map = new RecalculateNewService().recalculatePreview(scheme, dimensionRangeMode, dimensionValues, beginDate);
            return map;
        }
    }

    public boolean recalculateConfirm(Long currentRecalRecordID, CreditScheme scheme, String dimensionRangeMode, List<DimensionValue> dimensionValues) {
        try (Auditable audit = Audit.audit((String)"ccm.recalculateConfirm");){
            boolean bl = new RecalculateNewService().recalculateConfirm(currentRecalRecordID, scheme, dimensionRangeMode, dimensionValues);
            return bl;
        }
    }
}

