/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.business.setting;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.exception.KDBizException;
import kd.scmc.ccm.business.setting.FieldMapper;
import org.apache.commons.lang3.tuple.Pair;

public abstract class AbstractFieldMapper
implements FieldMapper {
    protected Map<String, Pair<String, String>> mapper = new HashMap<String, Pair<String, String>>(10);

    @Override
    public String getFieldKey(String number) {
        this.refresh();
        Pair<String, String> setting = this.mapper.get(number);
        if (setting != null) {
            return (String)setting.getRight();
        }
        throw new KDBizException("Unknown number:" + number);
    }

    @Override
    public List<String> getFieldKeys() {
        this.refresh();
        return this.mapper.values().stream().map(v -> (String)v.getRight()).collect(Collectors.toList());
    }

    @Override
    public String getRelatedFieldMark(String number) {
        this.refresh();
        Pair<String, String> setting = this.mapper.get(number);
        if (setting != null) {
            return (String)setting.getLeft();
        }
        throw new KDBizException("Unknown number:" + number);
    }

    @Override
    public List<String> getNoRelatedFieldMarkList(String number) {
        this.refresh();
        LinkedList<String> notRelationMarkList = new LinkedList<String>();
        for (Map.Entry<String, Pair<String, String>> relatedMap : this.mapper.entrySet()) {
            if (relatedMap.getKey().equals(number)) continue;
            notRelationMarkList.add((String)relatedMap.getValue().getLeft());
        }
        return notRelationMarkList;
    }

    protected abstract void refresh();
}

