/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.business.setting;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class DimensionEntryFieldMapper {
    private Map<String, String> roleFieldKeyMap;
    private Map<String, String> roleFieldTypeKeyMap;
    private List<String> roleNumbers;
    private Map<String, LocaleString> roleDisplayNameMap;
    private Map<String, String> baseDataKeyMap;
    private Map<String, String> roleTypeBaseDataKeyMap;
    private Map<String, String> roleFilterKeyMap;
    private Map<String, String> roleFieldBaeDateKeyMap;

    public DimensionEntryFieldMapper(Object dimensionId) {
        DynamicObject dimension = BusinessDataServiceHelper.loadSingleFromCache((Object)dimensionId, (String)"ccm_dimension");
        this.init(dimension);
    }

    public DimensionEntryFieldMapper(DynamicObject dimension) {
        this.init(dimension);
    }

    private void init(DynamicObject dimension) {
        DynamicObjectCollection rolesEntry = dimension.getDynamicObjectCollection("entry");
        this.roleFieldKeyMap = new LinkedHashMap<String, String>(rolesEntry.size());
        this.roleDisplayNameMap = new LinkedHashMap<String, LocaleString>(rolesEntry.size());
        this.roleFieldTypeKeyMap = new LinkedHashMap<String, String>(rolesEntry.size());
        this.baseDataKeyMap = new LinkedHashMap<String, String>(rolesEntry.size());
        this.roleTypeBaseDataKeyMap = new LinkedHashMap<String, String>(rolesEntry.size());
        this.roleNumbers = new ArrayList<String>(rolesEntry.size());
        this.roleFilterKeyMap = new LinkedHashMap<String, String>(rolesEntry.size());
        this.roleFieldBaeDateKeyMap = new LinkedHashMap<String, String>(rolesEntry.size());
        for (int i = 0; i < rolesEntry.size(); ++i) {
            DynamicObject roleRow = (DynamicObject)rolesEntry.get(i);
            DynamicObject roleObj = roleRow.getDynamicObject("role");
            String roleNumber = roleObj.getString("number");
            this.roleNumbers.add(roleNumber);
            this.roleFieldTypeKeyMap.put(roleNumber, "roletype" + i);
            this.roleDisplayNameMap.put("role" + i, new LocaleString(roleObj.getString("name")));
            this.baseDataKeyMap.put("roletype" + i, roleObj.getString("basedata.id"));
            this.roleFieldBaeDateKeyMap.put("role" + i, roleObj.getString("basedata.id"));
            this.roleFieldKeyMap.put(roleNumber, "role" + i);
            this.roleFilterKeyMap.put(roleNumber, "role" + i + "_s");
            this.roleTypeBaseDataKeyMap.put(roleNumber, roleObj.getString("basedata.id"));
        }
    }

    public List<String> getRoleFieldKeys() {
        return new ArrayList<String>(this.roleFieldKeyMap.values());
    }

    public List<String> getFieldTypeKeys() {
        return new ArrayList<String>(this.roleFieldTypeKeyMap.values());
    }

    public List<String> getRoleNumbers() {
        return this.roleNumbers;
    }

    public LocaleString getRoleDisplayName(String roleFieldKey) {
        return this.roleDisplayNameMap.get(roleFieldKey);
    }

    public String getBaseDataKey(String roleFieldTypeKey) {
        String baseDataKey = this.roleTypeBaseDataKeyMap.get(roleFieldTypeKey);
        if (baseDataKey == null) {
            baseDataKey = this.baseDataKeyMap.get(roleFieldTypeKey);
        }
        return baseDataKey;
    }

    public String getFieldBaseDataKey(String roleFieldKey) {
        return this.roleFieldBaeDateKeyMap.get(roleFieldKey);
    }

    public String getFieldTypeKey(String roleType) {
        return this.roleFieldTypeKeyMap.get(roleType);
    }

    public String getRoleFieldKey(String roleType) {
        return this.roleFieldKeyMap.get(roleType);
    }

    public String getRoleFilterKey(String roleType) {
        return this.roleFilterKeyMap.get(roleType);
    }
}

