/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.business.setting;

import java.util.LinkedList;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.scmc.ccm.business.core.Dimension;
import kd.scmc.ccm.business.core.Role;
import kd.scmc.ccm.common.util.OrmFacade;

public class DimensionReader {
    private OrmFacade ormFacade = new OrmFacade();

    public Dimension getDimension(long dimensionId) {
        DynamicObject dimension = this.ormFacade.loadSingleFromCache((Object)dimensionId, "ccm_dimension");
        return this.dynamicToDimension(dimension);
    }

    private Dimension dynamicToDimension(DynamicObject dimensionObj) {
        Dimension dimension = new Dimension();
        dimension.setId(dimensionObj.getLong("id"));
        DynamicObjectCollection rolesEntry = dimensionObj.getDynamicObjectCollection("entry");
        LinkedList<Long> roleIds = new LinkedList<Long>();
        for (DynamicObject role : rolesEntry) {
            roleIds.add(role.getLong("role.id"));
        }
        Map roles = BusinessDataServiceHelper.loadFromCache((Object[])roleIds.toArray(new Object[0]), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"ccm_role"));
        for (DynamicObject roleObj : rolesEntry) {
            Role role = new Role(roleObj.getString("role.number"));
            role.setRoleName(roleObj.getString("role.name"));
            role.setBasedataEntityKey(((DynamicObject)roles.get(roleObj.getLong("role.id"))).getString("basedata.id"));
            role.setIsControled(((DynamicObject)roles.get(roleObj.getLong("role.id"))).getBoolean("iscontroled"));
            dimension.getRoles().add(role);
        }
        return dimension;
    }
}

