/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.business.setting;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.ccm.business.core.DimensionValue;
import kd.scmc.ccm.business.core.Role;
import kd.scmc.ccm.business.scheme.CreditScheme;

public class DimensionValueControlledHelper {
    public List<DimensionValue> getControlledDimensionValues(CreditScheme scheme, List<DimensionValue> dimensionValues) {
        List<Role> roles = scheme.getDimension().getRoles();
        LinkedList<Long> roleValueIdList = new LinkedList<Long>();
        for (DimensionValue dimensionValue : dimensionValues) {
            for (Role role : roles) {
                Object roleValue;
                String roleType = role.getRoleType();
                if ("CUSUNICODE".equals(roleType) || !StringUtils.isNotBlank((Object)(roleValue = dimensionValue.getValue(role))) || role.getIsControled()) continue;
                roleValueIdList.add(Long.valueOf(String.valueOf(roleValue)));
            }
        }
        DynamicObjectCollection controledStatusList = QueryServiceHelper.query((String)"ccm_controlstatus", (String)"role.basedata,rolevalueid", (QFilter[])new QFilter[]{new QFilter("rolevalueid", "in", roleValueIdList), new QFilter("controlstatus", "=", (Object)"1")});
        HashMap controlRoleIdMap = new HashMap(16);
        for (DynamicObject cs : controledStatusList) {
            if (cs == null) continue;
            String roleBaseType = cs.getString("role.basedata");
            Long roleValueID = cs.getLong("rolevalueid");
            if (StringUtils.isNotBlank((CharSequence)roleBaseType) && controlRoleIdMap.get(roleBaseType) != null) {
                ((Set)controlRoleIdMap.get(roleBaseType)).add(roleValueID);
                continue;
            }
            if (!StringUtils.isNotBlank((CharSequence)roleBaseType) || controlRoleIdMap.get(roleBaseType) != null) continue;
            HashSet<Long> controledRoleIds = new HashSet<Long>(16);
            controledRoleIds.add(roleValueID);
            controlRoleIdMap.put(roleBaseType, controledRoleIds);
        }
        ArrayList<DimensionValue> controlledDimensionValues = new ArrayList<DimensionValue>(dimensionValues.size());
        for (DimensionValue dimensionValue : dimensionValues) {
            boolean isControled = true;
            for (Role role : roles) {
                String roleType = role.getRoleType();
                String bdKey = role.getBasedataEntityKey();
                Object roleValue = dimensionValue.getValue(role);
                if ("CUSUNICODE".equals(roleType)) {
                    if (!StringUtils.isBlank((Object)roleValue)) continue;
                    isControled = false;
                    break;
                }
                if (StringUtils.isBlank((Object)roleValue)) {
                    isControled = false;
                    break;
                }
                if (role.getIsControled()) {
                    isControled = true;
                    continue;
                }
                if (controlRoleIdMap.get(bdKey) != null) {
                    Set roleControledRoleIds = (Set)controlRoleIdMap.get(bdKey);
                    isControled = roleValue instanceof Long ? roleControledRoleIds.contains((Long)roleValue) : roleControledRoleIds.contains(Long.valueOf(roleValue.toString()));
                } else {
                    isControled = false;
                }
                if (isControled) continue;
                break;
            }
            if (!isControled) continue;
            controlledDimensionValues.add(dimensionValue);
        }
        return controlledDimensionValues;
    }
}

