/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.business.setting;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.scmc.ccm.business.core.CreditElement;
import kd.scmc.ccm.business.core.Field;

public class EntityConfig {
    private String entityKey;
    private Field orgField;
    private Field currencyField;
    private Map<String, Field> creditRolesKeyMap = new HashMap<String, Field>();
    private Map<CreditElement, Field> elementFieldRelation = new HashMap<CreditElement, Field>();
    private String pluginType;
    private String pluginName;
    private Set<String> selectors = new HashSet<String>();

    public Field getRoleField(String roleType) {
        return this.creditRolesKeyMap.get(roleType);
    }

    public Map<String, Field> getCreditRolesKeyMap() {
        return this.creditRolesKeyMap;
    }

    public String getPluginType() {
        return this.pluginType;
    }

    public void setPluginType(String pluginType) {
        this.pluginType = pluginType;
    }

    public String getPluginName() {
        return this.pluginName;
    }

    public void setPluginName(String pluginName) {
        this.pluginName = pluginName;
    }

    public String getEntityKey() {
        return this.entityKey;
    }

    public void setEntityKey(String entityKey) {
        this.entityKey = entityKey;
    }

    public Field getOrgField() {
        return this.orgField;
    }

    public Field getCurrencyField() {
        return this.currencyField;
    }

    public Set<String> getSelectors() {
        return this.selectors;
    }

    public void setSelectors(Set<String> selectors) {
        this.selectors = selectors;
    }

    public void setField(CreditElement element, Field field) {
        this.elementFieldRelation.put(element, field);
        if (element.getType() == CreditElement.ElementType.ROLE) {
            this.creditRolesKeyMap.put(element.getNumber(), field);
        } else if (element.getType() == CreditElement.ElementType.ORG) {
            this.orgField = field;
        } else if (element.getType() == CreditElement.ElementType.CURRENCY) {
            this.currencyField = field;
        }
    }

    public Field getField(CreditElement element) {
        return this.elementFieldRelation.get(element);
    }
}

