/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.business.setting;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.scmc.ccm.business.core.CreditElement;
import kd.scmc.ccm.business.core.Field;
import kd.scmc.ccm.business.setting.EntityConfig;
import kd.scmc.ccm.common.util.OrmFacade;

public class EntityConfigReader {
    private OrmFacade ormFacade = new OrmFacade();
    private Map<String, EntityConfig> entityConfigCache = new HashMap<String, EntityConfig>();

    public EntityConfig readConfig(String entityKey) {
        EntityConfig entityConfig = this.entityConfigCache.get(entityKey);
        if (entityConfig == null) {
            entityConfig = this.readConfigs(Collections.singletonList(entityKey)).get(0);
            this.entityConfigCache.put(entityKey, entityConfig);
        }
        return entityConfig;
    }

    public List<EntityConfig> readConfigs(List<String> entityKeys) {
        Map entityConfigs = this.ormFacade.loadFromCache((Object[])entityKeys.toArray(new String[0]), "ccm_entityconfig");
        ArrayList<EntityConfig> configs = new ArrayList<EntityConfig>(entityKeys.size());
        for (DynamicObject billSetting : entityConfigs.values()) {
            configs.add(this.toConfigObj(billSetting));
        }
        for (String entityKey : entityKeys) {
            boolean isMatch = false;
            for (EntityConfig config : configs) {
                if (!Objects.equals(config.getEntityKey(), entityKey)) continue;
                isMatch = true;
                break;
            }
            if (isMatch) continue;
            throw new KDBizException("None credit setting was found,entityKey=" + entityKey);
        }
        return configs;
    }

    public EntityConfig toConfigObj(DynamicObject billSetting) {
        String entityKey = billSetting.getString("number");
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)entityKey);
        EntityConfig config = new EntityConfig();
        config.setEntityKey(entityKey);
        String orgKey = billSetting.getString("orgkey");
        Field orgField = this.createField(orgKey, dataEntityType);
        config.setField(CreditElement.ELEMENT_ORG, orgField);
        String currencyKey = billSetting.getString("currencykey");
        Field currencyField = this.createField(currencyKey, dataEntityType);
        config.setField(CreditElement.ELEMENT_CURRENCY, currencyField);
        DynamicObjectCollection dimensionEntry = billSetting.getDynamicObjectCollection("dimensions");
        if (!dimensionEntry.isEmpty()) {
            for (DynamicObject dimSettingRow : dimensionEntry) {
                DynamicObject role = dimSettingRow.getDynamicObject("role");
                if (role == null) continue;
                String roleKey = dimSettingRow.getString("rolekey");
                Field roleField = this.createField(roleKey, dataEntityType);
                CreditElement element = new CreditElement(CreditElement.ElementType.ROLE, role.getString("number").toUpperCase());
                config.setField(element, roleField);
            }
        }
        config.setPluginType(billSetting.getString("plugintype"));
        config.setPluginName(billSetting.getString("plugin"));
        DynamicObjectCollection selectorsEntry = billSetting.getDynamicObjectCollection("selectors");
        HashSet<String> selectors = new HashSet<String>(selectorsEntry.size());
        for (DynamicObject selectorRow : selectorsEntry) {
            selectors.add(selectorRow.getString("field"));
        }
        config.setSelectors(selectors);
        return config;
    }

    private Field createField(String key, MainEntityType dataEntityType) {
        return new Field(key, dataEntityType);
    }
}

