/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.business.setting;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.OpBizRuleSetServiceHelper;

public class ServerServiceRegister {
    public void registerService(DynamicObject[] auditStrategies) {
        HashSet<String> updateableCheckEntities = new HashSet<String>(10);
        HashSet<String> updateableUpdateEntities = new HashSet<String>(10);
        for (DynamicObject strategy : auditStrategies) {
            String entityKey = strategy.getString("entity.id");
            List<String> checkCreditOps = this.getComboItemValues(strategy.getString("checkops"));
            if (!checkCreditOps.isEmpty()) {
                updateableCheckEntities.add(entityKey);
            }
            List<String> list = this.getComboItemValues(strategy.getString("reduceops"));
            List<String> increaseCreditOps = this.getComboItemValues(strategy.getString("increaseops"));
            if (increaseCreditOps.isEmpty() && list.isEmpty()) continue;
            updateableUpdateEntities.add(entityKey);
        }
        HashMap<String, Set<String>> updateOps = new HashMap<String, Set<String>>(10);
        HashMap<String, Set<String>> checkOps = new HashMap<String, Set<String>>(10);
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        QFilter[] filters = new QFilter[]{statusFilter};
        DynamicObject[] strategies = BusinessDataServiceHelper.load((String)"ccm_billstrategy", (String)"entity,checkops,reduceops,increaseops", (QFilter[])filters);
        for (DynamicObject strategy : strategies) {
            String entityKey = strategy.getString("entity.id");
            if (updateableUpdateEntities.contains(entityKey)) {
                List<String> reduceCreditOps = this.getComboItemValues(strategy.getString("reduceops"));
                this.addToMap(updateOps, entityKey, reduceCreditOps);
                List<String> increaseCreditOps = this.getComboItemValues(strategy.getString("increaseops"));
                this.addToMap(updateOps, entityKey, increaseCreditOps);
            }
            if (!updateableCheckEntities.contains(entityKey)) continue;
            List<String> ops = this.getComboItemValues(strategy.getString("checkops"));
            this.addToMap(checkOps, entityKey, ops);
        }
        for (Map.Entry entry : checkOps.entrySet()) {
            OpBizRuleSetServiceHelper.saveOpBizRuleSet((String)((String)entry.getKey()), (String)"CheckCredit", new ArrayList((Collection)entry.getValue()));
        }
        for (Map.Entry entry : updateOps.entrySet()) {
            OpBizRuleSetServiceHelper.saveOpBizRuleSet((String)((String)entry.getKey()), (String)"UpdateCredit", new ArrayList((Collection)entry.getValue()));
        }
    }

    public void updateRegisterService(DynamicObject[] unauditStrategies) {
        Set<String> ops;
        DynamicObject[] allStrategies;
        HashMap<String, Set<String>> allActiveCheckOps = new HashMap<String, Set<String>>(10);
        HashMap<String, Set<String>> allActiveUpdateOps = new HashMap<String, Set<String>>(10);
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        for (DynamicObject strategy : allStrategies = BusinessDataServiceHelper.load((String)"ccm_billstrategy", (String)"entity,checkops,reduceops,increaseops", (QFilter[])new QFilter[]{statusFilter})) {
            String entityKey = strategy.getString("entity.id");
            List<String> checkOps = this.getComboItemValues(strategy.getString("checkops"));
            this.addToMap(allActiveCheckOps, entityKey, checkOps);
            List<String> reduceOps = this.getComboItemValues(strategy.getString("reduceops"));
            this.addToMap(allActiveUpdateOps, entityKey, reduceOps);
            List<String> increaseOps = this.getComboItemValues(strategy.getString("increaseops"));
            this.addToMap(allActiveUpdateOps, entityKey, increaseOps);
        }
        HashMap<String, Set<String>> removableCheckOps = new HashMap<String, Set<String>>(10);
        HashMap<String, Set<String>> removableUpdateOps = new HashMap<String, Set<String>>(10);
        for (DynamicObject strategy : unauditStrategies) {
            String entityKey = strategy.getString("entity.id");
            List<String> checkOps = this.getComboItemValues(strategy.getString("checkops"));
            this.addToMap(removableCheckOps, entityKey, checkOps);
            List<String> reduceOps = this.getComboItemValues(strategy.getString("reduceops"));
            this.addToMap(removableUpdateOps, entityKey, reduceOps);
            List<String> increaseOps = this.getComboItemValues(strategy.getString("increaseops"));
            this.addToMap(removableUpdateOps, entityKey, increaseOps);
        }
        Map<String, Set<String>> retainableCheckOps = this.mergeMap(allActiveCheckOps, removableCheckOps);
        for (Map.Entry<String, Set<String>> entry : retainableCheckOps.entrySet()) {
            String entityKey = entry.getKey();
            ops = entry.getValue();
            if (ops.isEmpty()) {
                OpBizRuleSetServiceHelper.deleteOpBizRuleSet((String)entityKey, (String)"CheckCredit");
                continue;
            }
            if (ops.containsAll((Collection)removableCheckOps.get(entityKey))) continue;
            OpBizRuleSetServiceHelper.saveOpBizRuleSet((String)entityKey, (String)"CheckCredit", new ArrayList<String>(ops));
        }
        Map<String, Set<String>> retainableUpdateOps = this.mergeMap(allActiveUpdateOps, removableUpdateOps);
        for (Map.Entry<String, Set<String>> entry : retainableUpdateOps.entrySet()) {
            ops = entry.getValue();
            String entityKey = entry.getKey();
            if (ops.isEmpty()) {
                OpBizRuleSetServiceHelper.deleteOpBizRuleSet((String)entityKey, (String)"UpdateCredit");
                continue;
            }
            if (ops.containsAll((Collection)removableUpdateOps.get(entityKey))) continue;
            OpBizRuleSetServiceHelper.saveOpBizRuleSet((String)entityKey, (String)"UpdateCredit", new ArrayList<String>(ops));
        }
    }

    private void addToMap(Map<String, Set<String>> map, String key, Collection<String> items) {
        Set<String> set = map.get(key);
        if (set == null) {
            set = new HashSet<String>();
            map.put(key, set);
        }
        set.addAll(items);
    }

    private Map<String, Set<String>> mergeMap(Map<String, Set<String>> allActiveOps, Map<String, Set<String>> removableOps) {
        HashMap<String, Set<String>> retainableOps = new HashMap<String, Set<String>>(allActiveOps.size());
        for (Map.Entry<String, Set<String>> entry : removableOps.entrySet()) {
            String entityKey = entry.getKey();
            Set<String> activeOps = allActiveOps.get(entityKey);
            if (activeOps == null) {
                activeOps = new HashSet<String>(10);
            }
            retainableOps.put(entityKey, activeOps);
        }
        return retainableOps;
    }

    private List<String> getComboItemValues(String value) {
        if (value == null) {
            return new LinkedList<String>();
        }
        String[] reduceCreditOps = value.split(",");
        return Arrays.stream(reduceCreditOps).filter(op -> !ObjectUtils.isEmpty((Object)op)).collect(Collectors.toList());
    }
}

