/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.business.valuegetter;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.scmc.ccm.business.core.Field;
import kd.scmc.ccm.business.valuegetter.ValueGetter;
import kd.scmc.ccm.common.util.OrmFacade;

public class CustomerUnicodeValueGetter
implements ValueGetter {
    private OrmFacade ormFacade = new OrmFacade();
    protected Field field;
    private Map<Long, DynamicObject> customerUnicodeCache = new HashMap<Long, DynamicObject>(10);

    public CustomerUnicodeValueGetter(Field field) {
        this.field = field;
    }

    @Override
    public Object get(DynamicObject source) {
        DynamicObject customerUnicode;
        Object customer = this.field.getValue(source);
        Long customerId = null;
        if (customer != null) {
            if (customer instanceof DynamicObject) {
                customerId = ((DynamicObject)customer).getLong("masterid");
            } else if (customer instanceof Long) {
                customerId = (Long)customer;
                QFilter filter = new QFilter("id", "=", (Object)customerId);
                DynamicObject customerF7 = this.ormFacade.loadSingle("bd_customer", "id,masterid", new QFilter[]{filter});
                if (customerF7 == null) {
                    return null;
                }
                customerId = customerF7.getLong("masterid");
            } else {
                throw new IllegalArgumentException("Unsupported field type:" + customer.getClass().getName());
            }
        }
        if ((customerUnicode = this.customerUnicodeCache.get(customerId)) != null) {
            return customerUnicode;
        }
        if (this.customerUnicodeCache.containsKey(customerId)) {
            return null;
        }
        QFilter filter = new QFilter("entry.e_customer", "=", (Object)customerId);
        customerUnicode = this.ormFacade.loadSingle("ccm_cusunicode", "id,masterid", new QFilter[]{filter});
        this.customerUnicodeCache.put(customerId, customerUnicode);
        return customerUnicode;
    }
}

