/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.business.valuegetter;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.property.MasterBasedataProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.ccm.business.core.CreditContext;
import kd.scmc.ccm.business.core.DimensionValue;
import kd.scmc.ccm.business.core.Role;
import kd.scmc.ccm.business.scheme.BillStrategy;
import kd.scmc.ccm.business.scheme.CreditScheme;
import kd.scmc.ccm.business.setting.DimensionEntryFieldMapper;
import kd.scmc.ccm.business.valuegetter.RoleValueGetter;
import kd.scmc.ccm.business.valuegetter.ValueGetter;
import kd.scmc.ccm.common.util.MetadataUtils;

public class DimensionValueGetter
implements RoleValueGetter {
    private CreditScheme scheme;
    private BillStrategy billStrategy;
    private List<Role> roles;

    public DimensionValueGetter(CreditScheme scheme, CreditContext context) {
        this.scheme = scheme;
        this.billStrategy = scheme.getBillStrategy(context.getEntityKey());
        this.roles = scheme.getDimension().getRoles();
    }

    @Override
    public Object get(DynamicObject source) {
        DimensionValue dimensionValue = new DimensionValue(this.scheme.getDimension());
        for (Role role : this.roles) {
            ValueGetter valueGetter = this.billStrategy.getValueGetter(role.getElement());
            Object value = valueGetter.get(source);
            DynamicProperty property = null;
            DynamicObject roleTypeF7 = null;
            if (value instanceof DynamicObject) {
                property = ((DynamicObject)value).getDynamicObjectType().getProperty("masterid");
                if (property instanceof MasterBasedataProp) {
                    value = ((DynamicObject)value).getDynamicObject("masterid");
                    property = ((DynamicObject)value).getDynamicObjectType().getProperty("masterid");
                }
                roleTypeF7 = (DynamicObject)value;
            } else {
                String roleType = role.getRoleType();
                DimensionEntryFieldMapper mapper = new DimensionEntryFieldMapper(this.scheme.getDimension().getId());
                String baseDataKey = mapper.getBaseDataKey(roleType);
                property = MetadataUtils.getProperty((String)baseDataKey, (String)"masterid");
                if (property != null) {
                    QFilter filter = new QFilter("id", "=", value);
                    roleTypeF7 = QueryServiceHelper.queryOne((String)baseDataKey, (String)"id,masterid", (QFilter[])new QFilter[]{filter});
                }
            }
            dimensionValue.putValue(role, roleTypeF7 == null ? value : Long.valueOf(roleTypeF7.getLong(property == null ? "id" : "masterid")));
        }
        return dimensionValue;
    }
}

