/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.business.valuegetter;

import java.util.HashMap;
import java.util.Map;
import kd.bos.exception.KDBizException;
import kd.scmc.ccm.business.core.CreditElement;
import kd.scmc.ccm.business.core.Field;
import kd.scmc.ccm.business.setting.EntityConfig;
import kd.scmc.ccm.business.valuegetter.BasedataValueGetter;
import kd.scmc.ccm.business.valuegetter.CustomerUnicodeValueGetter;
import kd.scmc.ccm.business.valuegetter.MaterialGroupValueGetter;
import kd.scmc.ccm.business.valuegetter.ValueGetter;

public class ValueGetterManager {
    private Map<CreditElement, ValueGetter> valueGetters = new HashMap<CreditElement, ValueGetter>();
    private EntityConfig config;

    public ValueGetterManager(EntityConfig config) {
        this.config = config;
    }

    public ValueGetter getValueGetter(CreditElement element) {
        ValueGetter valueGetter = this.valueGetters.get(element);
        if (valueGetter == null) {
            Field field = this.config.getField(element);
            if (field == null) {
                throw new KDBizException("No related field was found.CreditElement=" + element);
            }
            if (CreditElement.ElementType.ROLE == element.getType()) {
                if ("CUSUNICODE".equals(element.getNumber())) {
                    valueGetter = new CustomerUnicodeValueGetter(field);
                } else if ("MATERIALGROUP".equals(element.getNumber())) {
                    valueGetter = new MaterialGroupValueGetter(field);
                }
            }
            if (valueGetter == null) {
                valueGetter = new BasedataValueGetter(field);
            }
            this.valueGetters.put(element, valueGetter);
        }
        return valueGetter;
    }

    public void registerValueGetter(CreditElement element, ValueGetter valueGetter) {
        this.valueGetters.put(element, valueGetter);
    }
}

