/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.report;

import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.report.ReportList;
import kd.bos.report.events.CreateColumnEvent;
import kd.scmc.ccm.business.setting.DimensionEntryFieldMapper;
import kd.scmc.ccm.common.helper.BasedataBatchReader;
import kd.scmc.ccm.common.helper.PermissionHelper;
import kd.scmc.ccm.common.util.MetadataUtils;
import kd.scmc.ccm.report.ReportField;
import kd.scmc.ccm.report.RptFormBasePlugin;
import kd.scmc.ccm.report.RptFormRelatedChecktypeHelper;

public class AnalyseDetailFormRpt
extends RptFormBasePlugin
implements HyperLinkClickListener {
    private static final Log logger = LogFactory.getLog(AnalyseDetailFormRpt.class);
    private static final long checkTypeByDayOverduesId = 854843125875611648L;
    private static final String KEY_ANALYSE_DETAIL = "ccm_analyse_detail_rpt";

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{"quota_s"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"tempquota_s"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"caltype_s"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"qty_s"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"tempqty_s"});
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        super.addClickListeners(new String[]{KEY_ANALYSE_DETAIL});
        ReportList list = (ReportList)this.getControl("reportlistap");
        list.addHyperClickListener((HyperLinkClickListener)this);
        this.registerSchemeFilter();
    }

    private void registerSchemeFilter() {
        BasedataEdit schemesF7 = (BasedataEdit)this.getView().getControl("scheme_s");
        String appId = this.getView().getFormShowParameter().getAppId();
        schemesF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            QFilter filter = new QFilter("checktype", "!=", (Object)854843125875611648L);
            HasPermOrgResult permOrgResult = PermissionHelper.getAllPermOrgs((String)KEY_ANALYSE_DETAIL, (String)appId, (String)"47150e89000000ac");
            if (!permOrgResult.hasAllOrgPerm()) {
                filter.and("mainorg", "in", (Object)permOrgResult.getHasPermOrgs());
            }
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ListFilterParameter listFilterParameter = showParameter.getListFilterParameter();
            listFilterParameter.setFilter(filter);
        });
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        String baseDataKey;
        String fieldTypeKey;
        Long roleId;
        int min;
        String[] dimensionValues;
        String dimensionValue;
        super.processRowData(gridPK, rowData, queryParam);
        DynamicObject dimension = (DynamicObject)this.getModel().getValue("dimension_s");
        if (dimension == null) {
            return;
        }
        BasedataBatchReader basedataBatchReader = new BasedataBatchReader();
        DimensionEntryFieldMapper fieldMapper = new DimensionEntryFieldMapper(dimension.getPkValue());
        List roleNumbers = fieldMapper.getRoleNumbers();
        for (DynamicObject row : rowData) {
            dimensionValue = row.getString("dimensionvalue");
            if (StringUtils.isBlank((CharSequence)dimensionValue)) continue;
            dimensionValues = dimensionValue.split("[-]");
            min = Math.min(dimensionValues.length, roleNumbers.size());
            for (int i = 0; i < min; ++i) {
                roleId = Long.valueOf(dimensionValues[i]);
                fieldTypeKey = fieldMapper.getFieldTypeKey((String)roleNumbers.get(i));
                baseDataKey = fieldMapper.getBaseDataKey(fieldTypeKey);
                basedataBatchReader.addParam(baseDataKey, (Object)roleId);
            }
        }
        for (DynamicObject row : rowData) {
            dimensionValue = row.getString("dimensionvalue");
            if (StringUtils.isBlank((CharSequence)dimensionValue)) continue;
            dimensionValues = dimensionValue.split("[-]");
            min = Math.min(dimensionValues.length, roleNumbers.size());
            for (int i = 0; i < min; ++i) {
                roleId = Long.valueOf(dimensionValues[i]);
                fieldTypeKey = fieldMapper.getFieldTypeKey((String)roleNumbers.get(i));
                baseDataKey = fieldMapper.getBaseDataKey(fieldTypeKey);
                DynamicObject roleObj = basedataBatchReader.read(baseDataKey, (Object)roleId);
                row.set(fieldMapper.getRoleFieldKey((String)roleNumbers.get(i)), (Object)roleObj);
            }
            DynamicObject entity = row.getDynamicObject("billkey");
            if (entity == null) continue;
            String op = row.getString("op");
            String opDisplayName = MetadataUtils.getOpDisplayName((String)entity.getString("number"), (String)op);
            row.set("op", (Object)opDisplayName);
        }
    }

    public void packageData(PackageDataEvent packageDataEvent) {
        long formPackageDataBeginDate = System.currentTimeMillis();
        logger.info("formPackageDataBeginDate :" + new Date(formPackageDataBeginDate));
        super.packageData(packageDataEvent);
        DynamicObject scheme = (DynamicObject)this.getModel().getValue("scheme_s");
        String checkType = scheme.getDynamicObject("checktype").getString("number");
        ReportField reportField = new ReportField();
        String relationZWMark = reportField.getRelationZWMark(checkType);
        DynamicObject rowData = packageDataEvent.getRowData();
        ReportColumn col = (ReportColumn)packageDataEvent.getSource();
        String fieldKey = col.getFieldKey();
        if (1 == rowData.getInt("sumlevel")) {
            if ("scheme".equals(fieldKey)) {
                packageDataEvent.setFormatValue((Object)ResManager.loadKDString((String)"\u5408\u8ba1", (String)"AnalyseDetailFormRpt_0", (String)"scmc-ccm-report", (Object[])new Object[0]));
            }
            if ("createtime".equals(fieldKey)) {
                packageDataEvent.setFormatValue(null);
            }
        } else if (2 == rowData.getInt("sumlevel")) {
            if ("scheme".equals(fieldKey)) {
                packageDataEvent.setFormatValue((Object)String.format(ResManager.loadKDString((String)"\u4fe1\u7528%s", (String)"AnalyseDetailFormRpt_1", (String)"scmc-ccm-report", (Object[])new Object[0]), relationZWMark));
            }
            if ("createtime".equals(fieldKey)) {
                packageDataEvent.setFormatValue(null);
            }
        } else if (3 == rowData.getInt("sumlevel")) {
            if ("scheme".equals(fieldKey)) {
                packageDataEvent.setFormatValue((Object)String.format(ResManager.loadKDString((String)"\u4e34\u65f6%s", (String)"AnalyseDetailFormRpt_2", (String)"scmc-ccm-report", (Object[])new Object[0]), relationZWMark));
            }
            if ("createtime".equals(fieldKey)) {
                packageDataEvent.setFormatValue(null);
            }
        } else if (4 == rowData.getInt("sumlevel")) {
            if ("scheme".equals(fieldKey)) {
                packageDataEvent.setFormatValue((Object)String.format(ResManager.loadKDString((String)"\u53ef\u7528%s", (String)"AnalyseDetailFormRpt_3", (String)"scmc-ccm-report", (Object[])new Object[0]), relationZWMark));
            }
            if ("createtime".equals(fieldKey)) {
                packageDataEvent.setFormatValue(null);
            }
        }
        long formPackageDataEndDate = System.currentTimeMillis();
        logger.info("formPackageDataEndDate :" + new Date(formPackageDataEndDate));
        logger.info("formPackageData\u8017\u65f6 :" + (formPackageDataEndDate - formPackageDataBeginDate) + "ms");
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
        ReportList reportList = (ReportList)event.getSource();
        IReportListModel reportModel = reportList.getReportModel();
        DynamicObject rowData = reportModel.getRowData(event.getRowIndex());
        BillShowParameter param = new BillShowParameter();
        param.setFormId(rowData.getDynamicObject("billkey").getString("number"));
        param.setPkId((Object)rowData.getString("billid"));
        param.setStatus(OperationStatus.VIEW);
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        param.setHasRight(true);
        this.getView().showForm((FormShowParameter)param);
    }

    @Override
    public void afterCreateColumn(CreateColumnEvent event) {
        super.afterCreateColumn(event);
        DynamicObject scheme = (DynamicObject)this.getModel().getValue("scheme_s");
        if (event.getQueryParam() != null && event.getQueryParam().getFilter() != null && event.getQueryParam().getFilter().getDynamicObject("scheme_s") != null) {
            scheme = event.getQueryParam().getFilter().getDynamicObject("scheme_s");
        }
        if (scheme == null || scheme.getDynamicObject("checktype") == null) {
            return;
        }
        String checkType = scheme.getDynamicObject("checktype").getString("number");
        RptFormRelatedChecktypeHelper rptHelper = new RptFormRelatedChecktypeHelper(KEY_ANALYSE_DETAIL, checkType);
        List columns = event.getColumns();
        rptHelper.setColumnVisableByCheckType(columns);
    }

    @Override
    protected List<String> getAllFilterControlKeys() {
        List<String> filterControlKeys = super.getAllFilterControlKeys();
        filterControlKeys.remove("billkey_s");
        return filterControlKeys;
    }
}

