/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.report;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.Field;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.ccm.business.setting.DimensionEntryFieldMapper;
import kd.scmc.ccm.report.AnalyseSumListDataRpt;
import kd.scmc.ccm.report.ReportField;
import kd.scmc.ccm.report.ReportRelatedChecktypeMapper;

public class AnalyseDetailListDataRpt
extends AbstractReportListDataPlugin {
    private static final Log logger = LogFactory.getLog(AnalyseSumListDataRpt.class);

    public DataSet query(ReportQueryParam queryParam, Object arg1) throws Throwable {
        try {
            QFilter filter = this.prepareQueryFilter(queryParam);
            DataSet dataSet = this.queryJournals(filter);
            DataSet resultDataSet = null;
            if ("CALAVAILABLE".equals(queryParam.getFilter().getString("caltype_s"))) {
                DataSet unionQuotaData = this.unionQuotaData(dataSet, queryParam);
                resultDataSet = this.packageCompleteData(queryParam, unionQuotaData);
            } else {
                resultDataSet = this.packageSumData(queryParam, dataSet);
            }
            return resultDataSet;
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw e;
        }
    }

    private QFilter prepareQueryFilter(ReportQueryParam queryParam) {
        String dimensionValue;
        String direction;
        FilterInfo filterInfo = queryParam.getFilter();
        Long scheme = filterInfo.getLong("scheme_s");
        QFilter qFilter = new QFilter("scheme", "=", (Object)scheme);
        qFilter.and(new QFilter("quotatype", "in", (Object)new String[]{"amount", "qty", "privilegeamt"}));
        LinkedList<String> billKeys = new LinkedList<String>();
        DynamicObjectCollection bills = filterInfo.getDynamicObjectCollection("billkey_s");
        if (bills != null) {
            for (DynamicObject bill : bills) {
                billKeys.add(bill.getString("number"));
            }
        }
        if (billKeys.size() > 0) {
            qFilter.and(new QFilter("entitykey", "in", billKeys));
        }
        if ((direction = filterInfo.getString("direction_s")) != null && !"".equals(direction)) {
            qFilter.and(new QFilter("direction", "=", (Object)direction));
        }
        if ((dimensionValue = filterInfo.getString("dimensionvalue_s")) != null && !"".equals(dimensionValue)) {
            String[] dimensionValues = dimensionValue.split(",");
            qFilter.and(new QFilter("dimensionvalue", "in", (Object)dimensionValues));
        } else {
            DynamicObject dimension = queryParam.getFilter().getDynamicObject("dimension_s");
            if (dimension == null) {
                return qFilter;
            }
            DimensionEntryFieldMapper roleFieldMapper = new DimensionEntryFieldMapper((Object)((Long)dimension.getPkValue()));
            List roleNumbers = roleFieldMapper.getRoleNumbers();
            for (String roleNumber : roleNumbers) {
                String roleFilterKey = roleFieldMapper.getRoleFilterKey(roleNumber);
                DynamicObjectCollection filterF7Coll = filterInfo.getDynamicObjectCollection(roleFilterKey);
                if (filterF7Coll == null) continue;
                ArrayList<Long> f7Ids = new ArrayList<Long>(filterF7Coll.size());
                DynamicProperty property = ((DynamicObject)filterF7Coll.get(0)).getDynamicObjectType().getProperty("masterid");
                String filterField = property == null ? "id" : "masterid";
                for (int j = 0; j < filterF7Coll.size(); ++j) {
                    f7Ids.add(((DynamicObject)filterF7Coll.get(j)).getLong(filterField));
                }
                DynamicObjectCollection roleVaues = QueryServiceHelper.query((String)roleFieldMapper.getBaseDataKey(roleNumber), (String)"id", (QFilter[])new QFilter[]{new QFilter(filterField, "in", f7Ids)});
                HashSet roleIds = new HashSet(roleVaues.size());
                roleVaues.stream().forEach(roleVaue -> roleIds.add(roleVaue.getLong("id")));
                qFilter.and(new QFilter(roleFieldMapper.getRoleFieldKey(roleNumber), "in", roleIds));
            }
        }
        return qFilter;
    }

    private DataSet unionQuotaData(DataSet dataSet, ReportQueryParam queryParam) {
        FilterInfo filter = queryParam.getFilter();
        RowMeta rowMeta = dataSet.getRowMeta();
        DataSetBuilder createDataSetBuilder = Algo.create((String)"ccm.AnalyseDetailListDataRpt.quota").createDataSetBuilder(rowMeta);
        BigDecimal quota = filter.getBigDecimal("quota_s");
        BigDecimal tempQuota = filter.getBigDecimal("tempquota_s");
        createDataSetBuilder.append(this.createExtraData(quota, 2));
        createDataSetBuilder.append(this.createExtraData(tempQuota, 3));
        DataSet build = createDataSetBuilder.build();
        return build.union(dataSet);
    }

    private DataSet packageSumData(ReportQueryParam queryParam, DataSet dataSet) {
        Field[] fields;
        DynamicObject scheme = queryParam.getFilter().getDynamicObject("scheme_s");
        String checkType = scheme.getDynamicObject("checktype").getString("number");
        ReportRelatedChecktypeMapper rptMapper = new ReportRelatedChecktypeMapper("ccm_analyse_detail_rpt", checkType);
        List<String> sumFields = rptMapper.getRptSumFieldList();
        LinkedList<String> selectFields = new LinkedList<String>();
        for (Field field : fields = dataSet.getRowMeta().getFields()) {
            if ("sumlevel".equals(field.getName())) {
                selectFields.add("1 as sumlevel");
                continue;
            }
            if (sumFields.contains(field.getName())) {
                selectFields.add(field.getName());
                continue;
            }
            selectFields.add("NULL as " + field.getName());
        }
        GroupbyDataSet groupbyDataSet = dataSet.groupBy(new String[]{"sumlevel"});
        for (String sumField : sumFields) {
            groupbyDataSet = groupbyDataSet.sum(sumField);
        }
        DataSet sumDataSet = groupbyDataSet.finish();
        sumDataSet = sumDataSet.select(String.join((CharSequence)",", selectFields));
        return dataSet.union(sumDataSet);
    }

    private DataSet packageCompleteData(ReportQueryParam queryParam, DataSet dataSet) {
        DynamicObject scheme = queryParam.getFilter().getDynamicObject("scheme_s");
        String checkType = scheme.getDynamicObject("checktype").getString("number");
        ReportField reportField = new ReportField();
        String relationMark = reportField.getRelationMark(checkType);
        BigDecimal minuend = BigDecimal.ZERO;
        BigDecimal subtrahend = BigDecimal.ZERO;
        for (Row row : dataSet.copy()) {
            if ("INCREASE".equals(row.getString("direction")) || ObjectUtils.isEmpty((Object)row.getString("direction"))) {
                minuend = minuend.add(row.getBigDecimal("converted_" + relationMark));
                continue;
            }
            if (!"REDUCE".equals(row.getString("direction"))) continue;
            subtrahend = subtrahend.add(row.getBigDecimal("converted_" + relationMark));
        }
        BigDecimal availableQuota = minuend.subtract(subtrahend);
        RowMeta rowMeta = dataSet.getRowMeta();
        DataSetBuilder createDataSetBuilder = Algo.create((String)"ccm.AnalyseDetailListDataRpt.availableQuota").createDataSetBuilder(rowMeta);
        createDataSetBuilder.append(this.createExtraData(availableQuota, 4));
        DataSet build = createDataSetBuilder.build();
        return dataSet.union(build);
    }

    public DataSet queryJournals(QFilter filter) {
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"ccm.analyseDetailListDataRpt.query", (String)"ccm_journal", (String)"scheme,dimensionvalue,quotatype,originalunit originalcurrency_amt,originalamount original_amt,unit convertedcurrency_amt,amount converted_amt,billno,entitykey billkey,billid,op,action,direction,createtime,createtime as createtimerpt,creator,0 sumlevel,amount converted_qty,unit measureunit_qty,amount converted_tpze,originalamount original_tpze,originalunit originalcurrency_tpze,unit convertedcurrency_tpze", (QFilter[])filter.toArray(), null);
        return dataSet.orderBy(new String[]{"createtime desc"});
    }

    public Object[] createExtraData(BigDecimal quota, int level) {
        Object[] headData = new Object[23];
        headData[6] = quota;
        headData[16] = level;
        headData[17] = quota;
        headData[19] = quota;
        return headData;
    }
}

