/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.report;

import java.util.Date;
import java.util.EventObject;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.events.CreateColumnEvent;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.ccm.business.setting.DimensionEntryFieldMapper;
import kd.scmc.ccm.common.helper.PermissionHelper;
import kd.scmc.ccm.report.ReportField;
import kd.scmc.ccm.report.RptFormBasePlugin;
import kd.scmc.ccm.report.RptFormRelatedChecktypeHelper;

public class AnalyseSumFormRpt
extends RptFormBasePlugin
implements HyperLinkClickListener {
    private static final Log logger = LogFactory.getLog(AnalyseSumFormRpt.class);
    private static final String KEY_ANALYSE_SUM = "ccm_analyse_sum_rpt";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        super.addClickListeners(new String[]{KEY_ANALYSE_SUM});
        ReportList list = (ReportList)this.getControl("reportlistap");
        list.addHyperClickListener((HyperLinkClickListener)this);
        this.registerSchemeFilter();
    }

    @Override
    public void afterSetModelValue(DynamicObject scheme) {
        super.afterSetModelValue(scheme);
        DynamicObject creditSchemeDO = (DynamicObject)this.getModel().getValue("scheme_s");
        this.setIsShowedRelated(creditSchemeDO);
    }

    private void registerSchemeFilter() {
        BasedataEdit schemesF7 = (BasedataEdit)this.getView().getControl("scheme_s");
        String appId = this.getView().getFormShowParameter().getAppId();
        schemesF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            QFilter filter = new QFilter("checktype.number", "in", (Object)new String[]{"KZFW001", "KZFW003", "KZFW010"});
            HasPermOrgResult permOrgResult = PermissionHelper.getAllPermOrgs((String)KEY_ANALYSE_SUM, (String)appId, (String)"47150e89000000ac");
            if (!permOrgResult.hasAllOrgPerm()) {
                filter.and("mainorg", "in", (Object)permOrgResult.getHasPermOrgs());
            }
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ListFilterParameter listFilterParameter = showParameter.getListFilterParameter();
            listFilterParameter.setFilter(filter);
        });
    }

    public void packageData(PackageDataEvent packageDataEvent) {
        long formPackageDataBeginDate = System.currentTimeMillis();
        logger.info("formPackageDataBeginDate :" + new Date(formPackageDataBeginDate));
        super.packageData(packageDataEvent);
        DynamicObject rowData = packageDataEvent.getRowData();
        ReportColumn col = (ReportColumn)packageDataEvent.getSource();
        String fieldKey = col.getFieldKey();
        if (1 == rowData.getInt("sumlevel") && "scheme".equals(fieldKey)) {
            packageDataEvent.setFormatValue((Object)ResManager.loadKDString((String)"\u5408\u8ba1", (String)"AnalyseDetailFormRpt_0", (String)"scmc-ccm-report", (Object[])new Object[0]));
        }
        long formPackageDataEndDate = System.currentTimeMillis();
        logger.info("formPackageDataEndDate :" + new Date(formPackageDataEndDate));
        logger.info("formPackageData\u8017\u65f6 :" + (formPackageDataEndDate - formPackageDataBeginDate) + "ms");
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        boolean isShowed;
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if ("scheme_s".equals(key)) {
            this.schemeChange();
        } else if ("isshowed".equals(key) && (isShowed = ((Boolean)this.getModel().getValue("isshowed")).booleanValue())) {
            DynamicObject dimension = (DynamicObject)this.getModel().getValue("dimension_s");
            DynamicObjectCollection entry = dimension.getDynamicObjectCollection("entry");
            LinkedList<Long> roleId = new LinkedList<Long>();
            for (DynamicObject row : entry) {
                DynamicObject role = row.getDynamicObject("role");
                roleId.add(role.getLong("id"));
            }
            for (Long id : roleId) {
                if (id != 849975482177826816L) continue;
                this.getModel().setValue("showdimensions", (Object)new Object[]{id});
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
        ReportList reportList = (ReportList)event.getSource();
        String fieldName = event.getFieldName();
        IReportListModel reportModel = reportList.getReportModel();
        DynamicObject rowData = reportModel.getRowData(event.getRowIndex());
        int sumLevel = rowData.getInt("sumlevel");
        if (1 == sumLevel) {
            return;
        }
        ReportShowParameter param = new ReportShowParameter();
        param.setFormId("ccm_analyse_detail_rpt");
        param.getOpenStyle().setTargetKey(this.getView().getFormShowParameter().getOpenStyle().getTargetKey());
        param.getOpenStyle().setShowType(this.getView().getFormShowParameter().getFormConfig().getShowType());
        param.setQueryParam(this.getQueryParam(rowData, fieldName));
        param.setCustomParam("isopenbyhyperlink", (Object)Boolean.TRUE);
        this.getView().showForm((FormShowParameter)param);
    }

    @Override
    public void afterCreateColumn(CreateColumnEvent event) {
        super.afterCreateColumn(event);
        DynamicObject scheme = (DynamicObject)this.getModel().getValue("scheme_s");
        if (event.getQueryParam() != null && event.getQueryParam().getFilter() != null && event.getQueryParam().getFilter().getDynamicObject("scheme_s") != null) {
            scheme = event.getQueryParam().getFilter().getDynamicObject("scheme_s");
        }
        if (scheme == null || scheme.getDynamicObject("checktype") == null) {
            return;
        }
        String checkType = scheme.getDynamicObject("checktype").getString("number");
        RptFormRelatedChecktypeHelper rptHelper = new RptFormRelatedChecktypeHelper(KEY_ANALYSE_SUM, checkType);
        List columns = event.getColumns();
        rptHelper.setColumnVisableByCheckType(columns);
    }

    private ReportQueryParam getQueryParam(DynamicObject row, String fieldName) {
        ReportQueryParam queryParam = new ReportQueryParam();
        DynamicObject scheme = (DynamicObject)this.getModel().getValue("scheme_s");
        if (row.getDynamicObject("scheme") != null) {
            scheme = row.getDynamicObject("scheme");
        }
        String checkType = scheme.getDynamicObject("checktype").getString("number");
        ReportField reportField = new ReportField();
        String relationMark = reportField.getRelationMark(checkType);
        FilterInfo filter = this.getCustomFilter(row);
        if (("reducesum_" + relationMark).equals(fieldName)) {
            filter.addFilterItem("direction_s", (Object)"REDUCE");
            filter.addFilterItem("caltype_s", (Object)"CALREDUCE");
        } else if (("increasesum_" + relationMark).equals(fieldName)) {
            filter.addFilterItem("direction_s", (Object)"INCREASE");
            filter.addFilterItem("caltype_s", (Object)"CALINCREASE");
        } else {
            filter.addFilterItem("quota_s", (Object)row.getBigDecimal("quota_" + relationMark));
            filter.addFilterItem("tempquota_s", (Object)row.getBigDecimal("tempquota_" + relationMark));
            filter.addFilterItem("caltype_s", (Object)"CALAVAILABLE");
        }
        queryParam.setFilter(filter);
        return queryParam;
    }

    private FilterInfo getCustomFilter(DynamicObject row) {
        FilterInfo filter = new FilterInfo();
        DynamicObject dimension = (DynamicObject)this.getModel().getValue("dimension_s");
        DynamicObject scheme = (DynamicObject)this.getModel().getValue("scheme_s");
        String orgFunc = (String)this.getModel().getValue("orgfunc_s");
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency_s");
        if (row.getDynamicObject("scheme") != null) {
            scheme = row.getDynamicObject("scheme");
            dimension = scheme.getDynamicObject("dimension");
            orgFunc = scheme.getString("orgfunc");
            currency = scheme.getDynamicObject("currency");
        }
        DimensionEntryFieldMapper fieldMapper = new DimensionEntryFieldMapper(dimension.getPkValue());
        MainEntityType dataEntityType = this.getModel().getDataEntityType();
        Set keySet = dataEntityType.getFields().keySet();
        List fieldTypeKeys = fieldMapper.getFieldTypeKeys();
        for (String fieldTypeKey : fieldTypeKeys) {
            String baseDataKey = fieldMapper.getBaseDataKey(fieldTypeKey);
            if (!keySet.contains(baseDataKey)) continue;
            filter.addFilterItem(baseDataKey, this.getModel().getValue(baseDataKey));
        }
        filter.addFilterItem("scheme_s", (Object)scheme);
        filter.addFilterItem("dimension_s", (Object)dimension);
        filter.addFilterItem("orgfunc_s", (Object)orgFunc);
        filter.addFilterItem("currency_s", (Object)currency);
        String dimensionValue = (String)row.get("dimensionvalue");
        if (dimensionValue.isEmpty()) {
            this.queryDimensionValue(row, filter, dimension, fieldMapper);
        } else {
            filter.addFilterItem("dimensionvalue_s", row.get("dimensionvalue"));
        }
        return filter;
    }

    private void queryDimensionValue(DynamicObject row, FilterInfo filter, DynamicObject dimension, DimensionEntryFieldMapper fieldMapper) {
        QFilter schemeFilter = new QFilter("scheme.id", "=", row.getDynamicObject("scheme").getPkValue());
        QFilter dimensionFilter = new QFilter("dimension.id", "=", dimension.getPkValue());
        DynamicObjectCollection showDimensions = (DynamicObjectCollection)this.getModel().getValue("showdimensions");
        LinkedList<QFilter> roleTypeFilters = new LinkedList<QFilter>();
        LinkedList<QFilter> roleFilters = new LinkedList<QFilter>();
        for (Object showDimension : showDimensions) {
            DynamicObject dynamicObject = showDimension.getDynamicObject("fbasedataid");
            String roleNumber = dynamicObject.getString("number");
            String fieldTypeKey = fieldMapper.getFieldTypeKey(roleNumber);
            String baseDataKey = fieldMapper.getBaseDataKey(roleNumber);
            roleTypeFilters.add(new QFilter(fieldTypeKey, "=", (Object)baseDataKey));
            String roleFieldKey = fieldMapper.getRoleFieldKey(roleNumber);
            Object roleFieldId = row.getDynamicObject(roleFieldKey).getPkValue();
            if (roleFieldId instanceof Long) {
                roleFilters.add(new QFilter(roleFieldKey, "=", (Object)((Long)roleFieldId)));
                continue;
            }
            if (!(roleFieldId instanceof String)) continue;
            roleFilters.add(new QFilter(roleFieldKey, "=", (Object)Long.parseLong((String)roleFieldId)));
        }
        QFilter roleTypeFilter = null;
        for (QFilter qFilter : roleTypeFilters) {
            if (roleTypeFilter == null) {
                roleTypeFilter = qFilter;
                continue;
            }
            roleTypeFilter = roleTypeFilter.and(qFilter);
        }
        QFilter roleFilter = null;
        for (QFilter qFilter : roleFilters) {
            if (roleFilter == null) {
                roleFilter = qFilter;
                continue;
            }
            roleFilter = roleFilter.and(qFilter);
        }
        DynamicObject[] dynamicObjectArray = BusinessDataServiceHelper.load((String)"ccm_archive", (String)"id,dimensionvalue", (QFilter[])new QFilter[]{schemeFilter, dimensionFilter, roleTypeFilter, roleFilter});
        LinkedList<String> dimensionValues = new LinkedList<String>();
        for (DynamicObject archive : dynamicObjectArray) {
            dimensionValues.add(archive.getString("dimensionvalue"));
        }
        filter.addFilterItem("dimensionvalue_s", (Object)String.join((CharSequence)",", dimensionValues));
    }

    @Override
    protected void schemeChange() {
        super.schemeChange();
        IDataModel model = this.getModel();
        DynamicObject scheme = (DynamicObject)model.getValue("scheme_s");
        this.setIsShowedRelated(scheme);
    }

    private void setIsShowedRelated(DynamicObject scheme) {
        IDataModel model = this.getModel();
        IReportView view = this.getView();
        if (ObjectUtils.isEmpty((Object)scheme)) {
            model.setValue("isshowed", (Object)Boolean.FALSE);
            view.setEnable(Boolean.FALSE, new String[]{"isshowed"});
        }
        if (scheme != null) {
            DimensionEntryFieldMapper mapper = this.getMapper();
            List roleNumbers = mapper.getRoleNumbers();
            if (!roleNumbers.contains("CUSTOMER")) {
                model.setValue("isshowed", (Object)Boolean.FALSE);
                view.setEnable(Boolean.FALSE, new String[]{"isshowed"});
            } else {
                view.setEnable(Boolean.TRUE, new String[]{"isshowed"});
                boolean isShowed = (Boolean)this.getModel().getValue("isshowed");
                if (isShowed) {
                    DynamicObject dimension = (DynamicObject)this.getModel().getValue("dimension_s");
                    DynamicObjectCollection entry = dimension.getDynamicObjectCollection("entry");
                    LinkedList<Long> roleId = new LinkedList<Long>();
                    for (DynamicObject row : entry) {
                        DynamicObject role = row.getDynamicObject("role");
                        roleId.add(role.getLong("id"));
                    }
                    for (Long id : roleId) {
                        if (id != 849975482177826816L) continue;
                        this.getModel().setValue("showdimensions", (Object)new Object[]{id});
                    }
                }
            }
        }
    }
}

