/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.report;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.ccm.business.archives.ArchiveEffectService;
import kd.scmc.ccm.business.setting.DimensionEntryFieldMapper;
import kd.scmc.ccm.common.util.DateUtils;
import kd.scmc.ccm.report.ReportField;
import kd.scmc.ccm.report.ReportRelatedChecktypeMapper;

public class AnalyseSumListDataRpt
extends AbstractReportListDataPlugin {
    private static final Log logger = LogFactory.getLog(AnalyseSumListDataRpt.class);
    private DimensionEntryFieldMapper roleFieldMapper;
    private List<String> fieldKeys;
    private List<String> fieldTypeKeys;
    private ReportField reportField = new ReportField();
    private List<String> showDimensions;

    public DataSet query(ReportQueryParam queryParam, Object arg1) throws Throwable {
        try {
            DynamicObject scheme = queryParam.getFilter().getDynamicObject("scheme_s");
            String checkType = scheme.getDynamicObject("checktype").getString("number");
            String relationMark = this.reportField.getRelationMark(checkType);
            QFilter filter = this.prepareParams(queryParam);
            ArchiveEffectService archiveEffect = new ArchiveEffectService();
            archiveEffect.effect(this.queryData(filter, this.fieldKeys, relationMark));
            DataSet dataSet = this.queryData(filter, this.fieldKeys, relationMark);
            DataSet resultDataSet = this.packageData(queryParam, dataSet);
            return resultDataSet;
        }
        catch (Exception exception) {
            logger.error((Throwable)exception);
            throw exception;
        }
    }

    private DataSet packageData(ReportQueryParam queryParam, DataSet dataSet) {
        Field[] fields;
        LinkedList<String> groupbySelectors = new LinkedList<String>();
        groupbySelectors.add("scheme");
        if (ObjectUtils.isEmpty(this.showDimensions)) {
            groupbySelectors.add("dimensionvalue");
            for (String fieldKey : this.fieldKeys) {
                groupbySelectors.add(fieldKey);
            }
            for (String fieldTypeKey : this.fieldTypeKeys) {
                groupbySelectors.add(fieldTypeKey);
            }
        } else {
            for (String showDimension : this.showDimensions) {
                groupbySelectors.add(this.roleFieldMapper.getFieldTypeKey(showDimension));
                groupbySelectors.add(this.roleFieldMapper.getRoleFieldKey(showDimension));
            }
        }
        DynamicObject scheme = queryParam.getFilter().getDynamicObject("scheme_s");
        String checkType = scheme.getDynamicObject("checktype").getString("number");
        String relationMark = this.reportField.getRelationMark(checkType);
        groupbySelectors.add("unit_" + relationMark);
        dataSet = dataSet.groupBy(groupbySelectors.toArray(new String[0])).sum("quota", "quota_" + relationMark).sum("tempquota", "tempquota_" + relationMark).sum("balance", "availablequota_" + relationMark).sum("reducesum", "reducesum_" + relationMark).sum("increasesum", "increasesum_" + relationMark).finish();
        dataSet = dataSet.addField("0", "sumlevel");
        ReportRelatedChecktypeMapper rptMapper = new ReportRelatedChecktypeMapper("ccm_analyse_sum_rpt", checkType);
        List<String> sumFields = rptMapper.getRptSumFieldList();
        LinkedList<String> selectFields = new LinkedList<String>();
        for (Field field : fields = dataSet.getRowMeta().getFields()) {
            if ("sumlevel".equals(field.getName())) {
                selectFields.add("1 as sumlevel");
                continue;
            }
            if (sumFields.contains(field.getName())) {
                selectFields.add(field.getName());
                continue;
            }
            selectFields.add("NULL as " + field.getName());
        }
        GroupbyDataSet groupbyDataSet = dataSet.groupBy(new String[]{"sumlevel"});
        for (String sumField : sumFields) {
            groupbyDataSet = groupbyDataSet.sum(sumField);
        }
        DataSet sumDataSet = groupbyDataSet.finish();
        sumDataSet = sumDataSet.select(String.join((CharSequence)",", selectFields));
        return dataSet.union(sumDataSet);
    }

    private QFilter prepareParams(ReportQueryParam queryParam) {
        FilterInfo filterInfo = queryParam.getFilter();
        Long schemeId = filterInfo.getLong("scheme_s");
        boolean isshowed = filterInfo.getBoolean("isshowed");
        DynamicObjectCollection showDimensionCollection = filterInfo.getDynamicObjectCollection("showdimensions");
        if (isshowed && !ObjectUtils.isEmpty((Object)showDimensionCollection)) {
            this.showDimensions = new LinkedList<String>();
            for (DynamicObject showDimension : showDimensionCollection) {
                this.showDimensions.add(showDimension.getString("number"));
            }
        }
        QFilter qFilter = new QFilter("scheme", "=", (Object)schemeId);
        qFilter.and(new QFilter("quotatype", "in", (Object)new String[]{"amount", "qty", "privilegeamt"}));
        Date today = new Date();
        qFilter.and(new QFilter("begindate", "<=", (Object)DateUtils.getEndOfDay((Date)today)));
        qFilter.and(new QFilter("enddate", ">=", (Object)DateUtils.getStartOfDay((Date)today)));
        DynamicObject dimension = queryParam.getFilter().getDynamicObject("dimension_s");
        this.roleFieldMapper = new DimensionEntryFieldMapper(dimension.getPkValue());
        this.fieldKeys = this.roleFieldMapper.getRoleFieldKeys();
        this.fieldTypeKeys = this.roleFieldMapper.getFieldTypeKeys();
        List roleNumbers = this.roleFieldMapper.getRoleNumbers();
        for (String roleNumber : roleNumbers) {
            this.addQfilterByRole(filterInfo, qFilter, roleNumber);
        }
        return qFilter;
    }

    private void addQfilterByRole(FilterInfo filterInfo, QFilter qFilter, String roleNumber) {
        String roleFilterKey = this.roleFieldMapper.getRoleFilterKey(roleNumber);
        DynamicObjectCollection filterF7Coll = filterInfo.getDynamicObjectCollection(roleFilterKey);
        if (filterF7Coll != null) {
            ArrayList<Long> f7Ids = new ArrayList<Long>(filterF7Coll.size());
            DynamicProperty property = ((DynamicObject)filterF7Coll.get(0)).getDynamicObjectType().getProperty("masterid");
            String filterField = property == null ? "id" : "masterid";
            for (int j = 0; j < filterF7Coll.size(); ++j) {
                f7Ids.add(((DynamicObject)filterF7Coll.get(j)).getLong(filterField));
            }
            DynamicObjectCollection roleVaues = QueryServiceHelper.query((String)this.roleFieldMapper.getBaseDataKey(roleNumber), (String)"id", (QFilter[])new QFilter[]{new QFilter(filterField, "in", f7Ids)});
            HashSet roleIds = new HashSet(roleVaues.size());
            roleVaues.stream().forEach(roleVaue -> roleIds.add(roleVaue.getLong("id")));
            qFilter.and(new QFilter(this.roleFieldMapper.getRoleFieldKey(roleNumber), "in", roleIds));
        }
    }

    private DataSet queryData(QFilter filter, List<String> fieldKeys, String relationMark) {
        LinkedList<String> queryFields = new LinkedList<String>();
        queryFields.add("id");
        queryFields.add("scheme");
        queryFields.add("dimensionvalue");
        queryFields.add("balance");
        queryFields.addAll(this.fieldTypeKeys);
        queryFields.addAll(fieldKeys);
        queryFields.add("(CASE WHEN archivetype = 'normal' THEN quota ELSE 0 END) quota");
        queryFields.add("(CASE WHEN archivetype = 'temp' THEN quota ELSE 0 END) tempquota");
        queryFields.add("reducesum");
        queryFields.add("increasesum");
        queryFields.add("begindate");
        queryFields.add("enddate");
        queryFields.add("effectstate");
        queryFields.add("unit as unit_" + relationMark);
        String selectors = String.join((CharSequence)",", queryFields);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"ccm.analyseSumListDataRpt.query", (String)"ccm_archive", (String)selectors, (QFilter[])filter.toArray(), null);
        return dataSet;
    }
}

