/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.report;

import java.util.EventObject;
import java.util.List;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.report.ReportList;
import kd.bos.report.events.CreateColumnEvent;
import kd.scmc.ccm.common.helper.PermissionHelper;
import kd.scmc.ccm.report.RptFormBasePlugin;
import kd.scmc.ccm.report.RptFormRelatedChecktypeHelper;

public class ArchiveChangedFormRpt
extends RptFormBasePlugin
implements HyperLinkClickListener {
    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        ReportList list = (ReportList)this.getControl("reportlistap");
        list.addHyperClickListener((HyperLinkClickListener)this);
        this.registerSchemeFilter();
    }

    private void registerSchemeFilter() {
        BasedataEdit schemesF7 = (BasedataEdit)this.getView().getControl("scheme_s");
        String appId = this.getView().getFormShowParameter().getAppId();
        schemesF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            QFilter filter = null;
            HasPermOrgResult permOrgResult = PermissionHelper.getAllPermOrgs((String)"ccm_archivechanged_rpt", (String)appId, (String)"47150e89000000ac");
            if (!permOrgResult.hasAllOrgPerm()) {
                filter = new QFilter("mainorg", "in", (Object)permOrgResult.getHasPermOrgs());
            }
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ListFilterParameter listFilterParameter = showParameter.getListFilterParameter();
            listFilterParameter.setFilter(filter);
        });
    }

    @Override
    public void afterCreateColumn(CreateColumnEvent event) {
        super.afterCreateColumn(event);
        DynamicObject scheme = (DynamicObject)this.getModel().getValue("scheme_s");
        if (scheme == null || scheme.getDynamicObject("checktype") == null) {
            return;
        }
        String checkType = scheme.getDynamicObject("checktype").getString("number");
        List columns = event.getColumns();
        RptFormRelatedChecktypeHelper rptHelper = new RptFormRelatedChecktypeHelper("ccm_archivechanged_rpt", checkType);
        rptHelper.setColumnVisableByCheckType(columns);
        for (AbstractReportColumn column : columns) {
            ReportColumn rc;
            if (!(column instanceof ReportColumn) || !"billid".equals((rc = (ReportColumn)column).getFieldKey())) continue;
            rc.setHide(true);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent arg0) {
        ReportList reportList = (ReportList)arg0.getSource();
        IReportListModel reportModel = reportList.getReportModel();
        DynamicObject rowData = reportModel.getRowData(arg0.getRowIndex());
        long billId = rowData.getLong("billid");
        BillShowParameter param = new BillShowParameter();
        param.setFormId("ccm_archive_change");
        param.setPkId((Object)billId);
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)param);
    }
}

