/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.report;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.ccm.business.setting.DimensionEntryFieldMapper;

public class ArchiveChangedListDataRpt
extends AbstractReportListDataPlugin {
    private static final Log logger = LogFactory.getLog(ArchiveChangedListDataRpt.class);
    private DimensionEntryFieldMapper roleFieldMapper;
    private List<String> fieldKeys;
    private List<String> fieldTypeKeys;

    public DataSet query(ReportQueryParam queryParam, Object arg1) throws Throwable {
        try {
            QFilter filter = this.prepareQFilter(queryParam);
            this.getRoleFields(queryParam);
            DataSet queryData = this.queryData(filter);
            return queryData;
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw e;
        }
    }

    private QFilter prepareQFilter(ReportQueryParam queryParam) {
        FilterInfo filterInfo = queryParam.getFilter();
        long schemeId = filterInfo.getLong("scheme_s");
        QFilter filter = new QFilter("scheme", "=", (Object)schemeId);
        filter.and(new QFilter("billstatus", "=", (Object)"C"));
        DynamicObject dimension = queryParam.getFilter().getDynamicObject("dimension_s");
        this.roleFieldMapper = new DimensionEntryFieldMapper(dimension.getPkValue());
        this.fieldKeys = this.roleFieldMapper.getRoleFieldKeys();
        this.fieldTypeKeys = this.roleFieldMapper.getFieldTypeKeys();
        List roleNumbers = this.roleFieldMapper.getRoleNumbers();
        for (String roleNumber : roleNumbers) {
            this.addQfilterByRole(filterInfo, filter, roleNumber);
        }
        return filter;
    }

    private void addQfilterByRole(FilterInfo filterInfo, QFilter filter, String roleNumber) {
        String roleFilterKey = this.roleFieldMapper.getRoleFilterKey(roleNumber);
        DynamicObjectCollection filterF7Coll = filterInfo.getDynamicObjectCollection(roleFilterKey);
        if (filterF7Coll != null) {
            ArrayList<Long> f7Ids = new ArrayList<Long>(filterF7Coll.size());
            DynamicProperty property = ((DynamicObject)filterF7Coll.get(0)).getDynamicObjectType().getProperty("masterid");
            String filterField = property == null ? "id" : "masterid";
            for (int j = 0; j < filterF7Coll.size(); ++j) {
                f7Ids.add(((DynamicObject)filterF7Coll.get(j)).getLong(filterField));
            }
            DynamicObjectCollection roleVaues = QueryServiceHelper.query((String)this.roleFieldMapper.getBaseDataKey(roleNumber), (String)"id", (QFilter[])new QFilter[]{new QFilter(filterField, "in", f7Ids)});
            HashSet roleIds = new HashSet(roleVaues.size());
            roleVaues.stream().forEach(roleVaue -> roleIds.add(roleVaue.getLong("id")));
            String roleFieldKey = this.roleFieldMapper.getRoleFieldKey(roleNumber);
            filter.and(new QFilter("schemeentry." + roleFieldKey, "in", roleIds));
        }
    }

    private void getRoleFields(ReportQueryParam queryParam) {
        DynamicObject dimension = queryParam.getFilter().getDynamicObject("dimension_s");
        this.roleFieldMapper = new DimensionEntryFieldMapper(dimension);
        this.fieldKeys = this.roleFieldMapper.getRoleFieldKeys();
        this.fieldTypeKeys = this.roleFieldMapper.getFieldTypeKeys();
    }

    private DataSet queryData(QFilter filter) {
        LinkedList<String> queryFields = new LinkedList<String>();
        queryFields.add("scheme");
        for (String fieldKey : this.fieldKeys) {
            queryFields.add("schemeentry." + fieldKey + " as " + fieldKey);
        }
        queryFields.addAll(this.fieldTypeKeys);
        queryFields.add("billno");
        queryFields.add("id as billid");
        queryFields.add("currency");
        queryFields.add("changedate");
        queryFields.add("remark");
        queryFields.add("changeperson");
        queryFields.add("schemeentry.gradebefore as gradebefore");
        queryFields.add("schemeentry.grade as grade");
        queryFields.add("schemeentry.before_amount as quotabefore_amt");
        queryFields.add("schemeentry.quota_amount as quota_amt");
        queryFields.add("schemeentry.before_days as daybefore_day");
        queryFields.add("schemeentry.quota_days as day_day");
        queryFields.add("schemeentry.before_overdueamt as quotabefore_overdueamt");
        queryFields.add("schemeentry.quota_overdueamt as quota_overdueamt");
        queryFields.add("schemeentry.before_qty as qtybefore_qty");
        queryFields.add("schemeentry.quota_qty as quantity_qty");
        queryFields.add("schemeentry.measureunit_qty as measureunit_qty");
        queryFields.add("schemeentry.begindatebefore as begindatebefore");
        queryFields.add("schemeentry.enddatebefore as enddatebefore");
        queryFields.add("schemeentry.begindate as begindate");
        queryFields.add("schemeentry.enddate as enddate");
        String selectors = String.join((CharSequence)",", queryFields);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"ccm.ArchiveChangedListDataRpt.query", (String)"ccm_archive_change", (String)selectors, (QFilter[])filter.toArray(), (String)"changedate desc");
        return dataSet;
    }
}

