/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.report;

import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.report.ReportList;
import kd.bos.report.events.CreateColumnEvent;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.scmc.ccm.business.scheme.BillStrategy;
import kd.scmc.ccm.business.scheme.CreditScheme;
import kd.scmc.ccm.business.scheme.SchemeReader;
import kd.scmc.ccm.business.setting.DimensionEntryFieldMapper;
import kd.scmc.ccm.common.helper.PermissionHelper;
import kd.scmc.ccm.common.util.MetadataUtils;
import kd.scmc.ccm.report.RptFormBasePlugin;

public class OverdueDayFormRpt
extends RptFormBasePlugin
implements HyperLinkClickListener {
    private static final long checkTypeByDayOverduesId = 854843125875611648L;

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        ReportList list = (ReportList)this.getControl("reportlistap");
        list.addHyperClickListener((HyperLinkClickListener)this);
        this.registerSchemeFilter();
    }

    private void registerSchemeFilter() {
        BasedataEdit schemesF7 = (BasedataEdit)this.getView().getControl("scheme_s");
        String appId = this.getView().getFormShowParameter().getAppId();
        schemesF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            QFilter filter = new QFilter("checktype", "=", (Object)854843125875611648L);
            HasPermOrgResult permOrgResult = PermissionHelper.getAllPermOrgs((String)"ccm_overdue_rpt", (String)appId, (String)"47150e89000000ac");
            if (!permOrgResult.hasAllOrgPerm()) {
                filter.and("mainorg", "in", (Object)permOrgResult.getHasPermOrgs());
            }
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ListFilterParameter listFilterParameter = showParameter.getListFilterParameter();
            listFilterParameter.setFilter(filter);
        });
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if ("scheme_s".equals(key)) {
            Object scheme = this.getModel().getValue("scheme_s");
            if (ObjectUtils.isEmpty((Object)scheme)) {
                return;
            }
            DimensionEntryFieldMapper mapper = this.getMapper();
            List roleFieldKeys = mapper.getRoleFieldKeys();
            for (String roleFieldKey : roleFieldKeys) {
                FieldEdit control = (FieldEdit)this.getControl(roleFieldKey + "_s");
                control.setMustInput(true);
            }
        }
    }

    @Override
    public boolean verifyQuery(ReportQueryParam queryParam) {
        if (!super.verifyQuery(queryParam)) {
            return false;
        }
        DimensionEntryFieldMapper mapper = this.getMapper();
        if (mapper != null) {
            List roleFieldKeys = mapper.getRoleFieldKeys();
            for (String roleFieldKey : roleFieldKeys) {
                DynamicObjectCollection roleFilterValue = (DynamicObjectCollection)this.getModel().getValue(roleFieldKey + "_s");
                if (roleFilterValue != null && !roleFilterValue.isEmpty()) continue;
                LocaleString roleDisplayName = mapper.getRoleDisplayName(roleFieldKey);
                String messageTemplate = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c%s\u201d\u3002", (String)"OverdueDayFormRpt_0", (String)"scmc-ccm-report", (Object[])new Object[0]);
                this.getView().showTipNotification(String.format(messageTemplate, roleDisplayName.getLocaleValue()));
                return false;
            }
        }
        DynamicObject rawScheme = (DynamicObject)this.getModel().getValue("scheme_s");
        DynamicObjectCollection entry = (rawScheme = BusinessDataServiceHelper.loadSingleFromCache((Object)rawScheme.getPkValue(), (String)"ccm_scheme")).getDynamicObjectCollection("entry");
        if (entry.isEmpty()) {
            String message = ResManager.loadKDString((String)"\u6240\u9009\u4fe1\u63a7\u65b9\u6848\u7684\u5355\u636e\u7b56\u7565\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"OverdueDayFormRpt_1", (String)"scmc-ccm-report", (Object[])new Object[0]);
            this.getView().showTipNotification(message);
            return false;
        }
        return true;
    }

    @Override
    public void afterCreateColumn(CreateColumnEvent event) {
        super.afterCreateColumn(event);
        DynamicObject rawScheme = (DynamicObject)this.getModel().getValue("scheme_s");
        if (rawScheme != null) {
            CreditScheme scheme = new SchemeReader().getScheme(((Long)rawScheme.getPkValue()).longValue());
            BillStrategy billStrategy = (BillStrategy)scheme.getBillStrategies().get(0);
            String calculateDate = billStrategy.getCalculateDate();
            String overdueEntityKey = billStrategy.getAssingEntityKey();
            String prefix = calculateDate.split("[.]")[0];
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)overdueEntityKey);
            List entryProps = MetadataUtils.getEntryProps((IDataEntityType)dataEntityType);
            boolean isBasedEntry = false;
            for (EntryProp entryProp : entryProps) {
                if (!Objects.equals(entryProp.getName(), prefix)) continue;
                isBasedEntry = true;
                break;
            }
            if (!isBasedEntry) {
                List columns = event.getColumns();
                Iterator iterator = columns.iterator();
                while (iterator.hasNext()) {
                    AbstractReportColumn column = (AbstractReportColumn)iterator.next();
                    if (!(column instanceof ReportColumn) || !"entryseq".equals(((ReportColumn)column).getFieldKey())) continue;
                    iterator.remove();
                }
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
        ReportList reportList = (ReportList)event.getSource();
        IReportListModel reportModel = reportList.getReportModel();
        DynamicObject rowData = reportModel.getRowData(event.getRowIndex());
        BillShowParameter param = new BillShowParameter();
        param.setFormId(rowData.getDynamicObject("billkey").getString("number"));
        param.setPkId((Object)rowData.getString("billid"));
        param.setStatus(OperationStatus.VIEW);
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        param.setHasRight(true);
        this.getView().showForm((FormShowParameter)param);
    }
}

