/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.report;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.ccm.business.core.DimensionValue;
import kd.scmc.ccm.business.core.Role;
import kd.scmc.ccm.business.overdue.OverdueDayBillQuerier;
import kd.scmc.ccm.business.scheme.BillStrategy;
import kd.scmc.ccm.business.scheme.CreditScheme;
import kd.scmc.ccm.business.scheme.SchemeReader;
import kd.scmc.ccm.business.service.CreditServiceFacade;
import kd.scmc.ccm.business.setting.DimensionEntryFieldMapper;
import kd.scmc.ccm.business.setting.EntityConfig;
import kd.scmc.ccm.common.util.DateUtils;
import kd.scmc.ccm.common.util.MetadataUtils;

public class OverdueDayListDataRpt
extends AbstractReportListDataPlugin {
    private CreditServiceFacade facade = new CreditServiceFacade();
    private OverdueDayBillQuerier querier = new OverdueDayBillQuerier();
    private CreditScheme scheme;
    private DimensionEntryFieldMapper dimensionEntryFieldMapper;
    private List<Role> roles;
    private String overdueEntry;

    public DataSet query(ReportQueryParam paramReportQueryParam, Object paramObject) throws Throwable {
        Date now = new Date();
        this.prepareParms(paramReportQueryParam);
        DataSet archivesDataSet = this.queryArchives(paramReportQueryParam);
        HashMap<String, Integer> overdueDayQuotaMap = new HashMap<String, Integer>();
        LinkedList<DimensionValue> dimensionValues = new LinkedList<DimensionValue>();
        for (Row row : archivesDataSet) {
            String dValue = row.getString("dimensionvalue");
            DimensionValue dimensionValue = new DimensionValue(this.scheme.getDimension());
            dimensionValue.setValue(dValue);
            dimensionValues.add(dimensionValue);
            if (!overdueDayQuotaMap.containsKey(dValue)) {
                overdueDayQuotaMap.put(dValue, row.getInteger("quota"));
                continue;
            }
            Integer quota = (Integer)overdueDayQuotaMap.get(dValue);
            overdueDayQuotaMap.put(dValue, quota + row.getInteger("quota"));
        }
        BillStrategy billStrategy = (BillStrategy)this.scheme.getBillStrategies().get(0);
        String entityKey = billStrategy.getAssingEntityKey();
        MainEntityType assEntityType = MetadataServiceHelper.getDataEntityType((String)entityKey);
        String calculateDate = billStrategy.getCalculateDate();
        DataSet billDataSet = this.queryOverdueBills(this.scheme, dimensionValues, billStrategy);
        Field[] fields = this.createDataSetFields();
        DataSetBuilder dataSetBuilder = Algo.create((String)"scmc.ccm.OverdueDayListDataRpt").createDataSetBuilder(new RowMeta(fields));
        EntityConfig entityConfig = this.facade.getConfig(entityKey);
        for (Row row : billDataSet) {
            int billOverdueDays;
            Date date;
            Object[] rowData = new Object[fields.length];
            rowData[0] = this.scheme.getId();
            rowData[1] = entityKey;
            rowData[2] = row.getString("billno");
            rowData[3] = row.get("id");
            rowData[4] = this.overdueEntry != null ? row.getInteger(this.overdueEntry + ".seq") : Integer.valueOf(-1);
            rowData[6] = BigDecimal.ZERO;
            rowData[7] = row.get("auditor");
            rowData[8] = row.get("auditdate");
            rowData[9] = 1;
            DimensionValue dimensionValue = new DimensionValue(this.scheme.getDimension());
            int index = 10;
            for (Role role : this.roles) {
                DynamicObjectCollection cusunicodes;
                DynamicObject roleValueDO;
                Object billRoleValue;
                String roleType = role.getRoleType();
                kd.scmc.ccm.business.core.Field field = entityConfig.getField(role.getElement());
                String entryKey = field.getEntryKey();
                String fullName = field.getFullName();
                String baseDataKey = this.dimensionEntryFieldMapper.getBaseDataKey(roleType);
                MainEntityType roleBDEntityType = MetadataServiceHelper.getDataEntityType((String)baseDataKey);
                if (roleBDEntityType != null && roleBDEntityType.findProperty("masterid") != null) {
                    DynamicProperty dp = assEntityType.getProperty(fullName);
                    if (assEntityType.getProperty(fullName) instanceof BasedataProp) {
                        fullName = fullName + ".masterid";
                    }
                }
                StringBuilder fullNameStrBuf = new StringBuilder();
                if (!StringUtils.isBlank((CharSequence)entryKey)) {
                    fullNameStrBuf.append(entryKey).append('.');
                }
                fullNameStrBuf.append(fullName);
                Object roleValue = billRoleValue = row.get(fullNameStrBuf.toString());
                QFilter q = new QFilter("id", "=", billRoleValue);
                if ("CUSUNICODE".equals(roleType)) {
                    baseDataKey = "bd_customer";
                }
                if ((roleValueDO = QueryServiceHelper.queryOne((String)baseDataKey, (String)"masterid", (QFilter[])new QFilter[]{q})) != null) {
                    roleValue = roleValueDO.getLong("masterid");
                }
                if ("CUSUNICODE".equals(roleType) && (cusunicodes = QueryServiceHelper.query((String)"ccm_cusunicode", (String)"id,entry.e_customer", (QFilter[])new QFilter[]{new QFilter("entry.e_customer", "=", roleValue)})) != null && !cusunicodes.isEmpty()) {
                    roleValue = ((DynamicObject)cusunicodes.get(0)).getLong("id");
                }
                rowData[++index] = baseDataKey;
                rowData[++index] = roleValue;
                dimensionValue.putValue(role, roleValue);
            }
            rowData[10] = dimensionValue.getValue();
            Integer overdueDayQuota = (Integer)overdueDayQuotaMap.get(dimensionValue.getValue());
            if (overdueDayQuota == null || (date = row.getDate(calculateDate)) == null || (billOverdueDays = DateUtils.getDiffDays((Date)date, (Date)now)) <= overdueDayQuota) continue;
            rowData[5] = billOverdueDays;
            dataSetBuilder.append(rowData);
        }
        return dataSetBuilder.build();
    }

    private void prepareParms(ReportQueryParam paramReportQueryParam) {
        DynamicObject schemeObj = paramReportQueryParam.getFilter().getDynamicObject("scheme_s");
        SchemeReader schemeReader = new SchemeReader();
        long schemeId = schemeObj.getLong("id");
        this.scheme = schemeReader.getScheme(schemeId);
        this.roles = this.scheme.getDimension().getRoles();
        this.dimensionEntryFieldMapper = new DimensionEntryFieldMapper((Object)this.scheme.getDimension().getId());
    }

    private Field[] createDataSetFields() {
        LinkedList<Field> fields = new LinkedList<Field>();
        fields.add(new Field("scheme", (DataType)DataType.LongType));
        fields.add(new Field("billkey", (DataType)DataType.StringType));
        fields.add(new Field("billno", (DataType)DataType.StringType));
        fields.add(new Field("billid", (DataType)DataType.LongType));
        fields.add(new Field("entryseq", (DataType)DataType.IntegerType));
        fields.add(new Field("overdueday", (DataType)DataType.IntegerType));
        fields.add(new Field("overdueamount", (DataType)DataType.BigDecimalType));
        fields.add(new Field("auditor", (DataType)DataType.LongType));
        fields.add(new Field("auditdate", (DataType)DataType.DateType));
        fields.add(new Field("sumlevel", (DataType)DataType.IntegerType));
        fields.add(new Field("dimensionvalue", (DataType)DataType.StringType));
        for (Role role : this.scheme.getDimension().getRoles()) {
            String fieldTypeKey = this.dimensionEntryFieldMapper.getFieldTypeKey(role.getRoleType());
            fields.add(new Field(fieldTypeKey, (DataType)DataType.StringType));
            String roleFieldKey = this.dimensionEntryFieldMapper.getRoleFieldKey(role.getRoleType());
            fields.add(new Field(roleFieldKey, (DataType)DataType.LongType));
        }
        return fields.toArray(new Field[0]);
    }

    private DataSet queryArchives(ReportQueryParam paramReportQueryParam) {
        Date now = new Date();
        LinkedList<QFilter> archiveFilters = new LinkedList<QFilter>();
        archiveFilters.add(new QFilter("scheme", "=", (Object)this.scheme.getId()));
        archiveFilters.add(new QFilter("begindate", "<=", (Object)now));
        archiveFilters.add(new QFilter("enddate", ">=", (Object)now));
        for (int i = 0; i < this.roles.size(); ++i) {
            DynamicObjectCollection filterF7Coll = paramReportQueryParam.getFilter().getDynamicObjectCollection("role" + i + "_s");
            ArrayList<Long> f7Ids = new ArrayList<Long>(filterF7Coll.size());
            for (int j = 0; j < filterF7Coll.size(); ++j) {
                f7Ids.add(((DynamicObject)filterF7Coll.get(j)).getLong("masterid"));
            }
            String roleFieldKey = this.dimensionEntryFieldMapper.getRoleFieldKey(this.roles.get(i).getRoleType());
            archiveFilters.add(new QFilter(roleFieldKey, "in", f7Ids));
        }
        DataSet archivesDataSet = QueryServiceHelper.queryDataSet((String)"scmc.ccm.OverdueDayListDataRpt", (String)"ccm_archive", (String)"dimensionvalue,quota", (QFilter[])archiveFilters.toArray(new QFilter[0]), null);
        return archivesDataSet;
    }

    private DataSet queryOverdueBills(CreditScheme scheme, List<DimensionValue> dimensionValues, BillStrategy billStrategy) {
        String overdueEntityKey = billStrategy.getAssingEntityKey();
        String calculateDate = billStrategy.getCalculateDate();
        LinkedList<String> selectors = new LinkedList<String>();
        selectors.add("billno");
        selectors.add("id");
        selectors.add("auditor");
        selectors.add("auditdate");
        String prefix = calculateDate.split("[.]")[0];
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)overdueEntityKey);
        List entryProps = MetadataUtils.getEntryProps((IDataEntityType)dataEntityType);
        for (EntryProp entryProp : entryProps) {
            if (!Objects.equals(entryProp.getName(), prefix)) continue;
            this.overdueEntry = prefix;
            break;
        }
        if (this.overdueEntry != null) {
            selectors.add(this.overdueEntry + ".seq");
        }
        return this.querier.queryOverdueDayBills(scheme, dimensionValues, billStrategy, selectors);
    }
}

