/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.report;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.events.CreateColumnEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.scmc.ccm.business.setting.DimensionEntryFieldMapper;

public class RptFormBasePlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    protected static final String KEY_SCHEME_S = "scheme_s";
    protected static final String KEY_DIMENSION_S = "dimension_s";
    protected static final String KEY_ORGFUNC_S = "orgfunc_s";
    protected static final String KEY_CURRENCY_S = "currency_s";
    private static final String KEY_QUERY_SCHEME = "now_query_scheme";

    public void afterSetModelValue(DynamicObject scheme) {
        if (scheme != null) {
            List<String> allFilterControlKeys = this.getAllFilterControlKeys();
            LinkedList<String> visiableKeys = new LinkedList<String>();
            List<String> unvisiableKeys = allFilterControlKeys;
            DynamicObject creditScheme = scheme.getDynamicObject(KEY_SCHEME_S);
            this.getModel().setValue(KEY_SCHEME_S, (Object)creditScheme);
            if (creditScheme != null) {
                DynamicObject dimension = creditScheme.getDynamicObject("dimension");
                this.getPageCache().put("dimensionid", dimension.getString("id"));
                DimensionEntryFieldMapper mapper = this.getMapper();
                List roleNumbers = mapper.getRoleNumbers();
                for (String roleNumer : roleNumbers) {
                    String roleFilterKey = mapper.getRoleFilterKey(roleNumer);
                    String roleFilterTypeKey = mapper.getBaseDataKey(roleNumer);
                    visiableKeys.add(roleFilterKey);
                    unvisiableKeys.remove(roleFilterKey);
                    LocaleString roleDisplayName = mapper.getRoleDisplayName(mapper.getRoleFieldKey(roleNumer));
                    FieldEdit control = (FieldEdit)this.getControl(roleFilterKey);
                    control.setCaption(roleDisplayName);
                    ((DynamicProperty)control.getProperty()).setDisplayName(roleDisplayName);
                    if (scheme.get(roleFilterKey) != null && scheme.get(roleFilterKey) instanceof MulBasedataDynamicObjectCollection) {
                        MulBasedataDynamicObjectCollection roleValueCol = (MulBasedataDynamicObjectCollection)scheme.get(roleFilterKey);
                        if (roleValueCol != null && roleValueCol.size() > 0) {
                            HashSet<Object> roleValueIDs = new HashSet<Object>(roleValueCol.size());
                            for (DynamicObject roDo : roleValueCol) {
                                if (roDo == null || roDo.get("fbasedataid") == null) continue;
                                roleValueIDs.add(((DynamicObject)roDo.get("fbasedataid")).getPkValue());
                            }
                            Map loadRoleDoMap = BusinessDataServiceHelper.loadFromCache((Object[])roleValueIDs.toArray(), (String)roleFilterTypeKey);
                            MulBasedataDynamicObjectCollection newRoleMulBDDoCol = new MulBasedataDynamicObjectCollection();
                            for (DynamicObject loadRoleDo : loadRoleDoMap.values()) {
                                newRoleMulBDDoCol.add(loadRoleDo);
                            }
                            if (newRoleMulBDDoCol.size() < 1) {
                                this.getModel().setValue(roleFilterKey, null);
                                continue;
                            }
                            this.getModel().setValue(roleFilterKey, (Object)newRoleMulBDDoCol);
                            continue;
                        }
                        this.getModel().setValue(roleFilterKey, null);
                        continue;
                    }
                    this.getModel().setValue(roleFilterKey, null);
                }
            }
            if (!visiableKeys.isEmpty()) {
                this.getView().setVisible(Boolean.TRUE, visiableKeys.toArray(new String[0]));
            }
            if (!unvisiableKeys.isEmpty()) {
                this.getView().setVisible(Boolean.FALSE, unvisiableKeys.toArray(new String[0]));
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.roleFieldListener();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.schemeChange();
        this.getView().setVisible(Boolean.FALSE, new String[]{"dimensionvalue_s"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if (KEY_SCHEME_S.equals(key)) {
            this.schemeChange();
        }
    }

    protected void schemeChange() {
        IDataModel model = this.getModel();
        IReportView view = this.getView();
        DynamicObject scheme = (DynamicObject)model.getValue(KEY_SCHEME_S);
        List<String> allFilterControlKeys = this.getAllFilterControlKeys();
        for (String key : allFilterControlKeys) {
            this.getModel().setValue(key, null);
        }
        LinkedList<String> visiableKeys = new LinkedList<String>();
        List<String> unvisiableKeys = allFilterControlKeys;
        if (scheme != null) {
            DynamicObject dimension = scheme.getDynamicObject("dimension");
            this.getPageCache().put("dimensionid", dimension.getString("id"));
            DimensionEntryFieldMapper mapper = this.getMapper();
            model.setValue(KEY_DIMENSION_S, scheme.get("dimension"));
            model.setValue(KEY_ORGFUNC_S, scheme.get("orgfunc"));
            model.setValue(KEY_CURRENCY_S, scheme.get("currency"));
            List roleNumbers = mapper.getRoleNumbers();
            for (String roleNumer : roleNumbers) {
                String roleFilterKey = mapper.getRoleFilterKey(roleNumer);
                visiableKeys.add(roleFilterKey);
                unvisiableKeys.remove(roleFilterKey);
                LocaleString roleDisplayName = mapper.getRoleDisplayName(mapper.getRoleFieldKey(roleNumer));
                FieldEdit control = (FieldEdit)this.getControl(roleFilterKey);
                control.setCaption(roleDisplayName);
                ((DynamicProperty)control.getProperty()).setDisplayName(roleDisplayName);
                this.getModel().setValue(roleFilterKey, null);
            }
        } else {
            this.getPageCache().remove("dimensionid");
            model.setValue(KEY_DIMENSION_S, null);
            model.setValue(KEY_ORGFUNC_S, null);
            model.setValue(KEY_CURRENCY_S, null);
        }
        if (!visiableKeys.isEmpty()) {
            view.setVisible(Boolean.TRUE, visiableKeys.toArray(new String[0]));
        }
        if (!unvisiableKeys.isEmpty()) {
            view.setVisible(Boolean.FALSE, unvisiableKeys.toArray(new String[0]));
        }
    }

    protected DimensionEntryFieldMapper getMapper() {
        DynamicObject scheme = (DynamicObject)this.getModel().getValue(KEY_SCHEME_S);
        DynamicObject dimension = scheme.getDynamicObject("dimension");
        DimensionEntryFieldMapper mapper = new DimensionEntryFieldMapper(dimension.getPkValue());
        return mapper;
    }

    protected List<String> getAllFilterControlKeys() {
        LinkedList<String> filterControlKeys = new LinkedList<String>();
        MainEntityType dataEntityType = this.getModel().getDataEntityType();
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        for (IDataEntityProperty prop : properties) {
            if (!(prop instanceof MulBasedataProp)) continue;
            filterControlKeys.add(prop.getName());
        }
        return filterControlKeys;
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        FilterInfo filterInfo = queryParam.getFilter();
        if (filterInfo.getString(KEY_SCHEME_S) == null || this.getModel().getValue(KEY_SCHEME_S) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6307\u5b9a\u4fe1\u63a7\u65b9\u6848\u3002", (String)"RptFormBasePlugin_0", (String)"scmc-ccm-report", (Object[])new Object[0]));
            return false;
        }
        return super.verifyQuery(queryParam);
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        DynamicObject scheme = (DynamicObject)this.getModel().getValue(KEY_SCHEME_S);
        if (scheme != null && !ObjectUtils.isEmpty((Object)scheme.getPkValue())) {
            this.getPageCache().put(KEY_QUERY_SCHEME, scheme.getPkValue().toString());
        }
        ReportList rptList = (ReportList)this.getControl("reportlistap");
        List columns = rptList.getColumns();
        int schemeColumnIndex = 0;
        HashSet<String> columnKeys = new HashSet<String>(columns.size());
        for (int i = 0; i < columns.size(); ++i) {
            AbstractReportColumn column = (AbstractReportColumn)columns.get(i);
            if (!(column instanceof ReportColumn)) continue;
            String fieldKey = ((ReportColumn)column).getFieldKey();
            if ("scheme".equals(fieldKey)) {
                schemeColumnIndex = i;
            }
            columnKeys.add(fieldKey);
        }
        DimensionEntryFieldMapper fieldMapper = this.getMapper();
        if (queryParam.getFilter() != null && queryParam.getFilter().getDynamicObject(KEY_DIMENSION_S) != null) {
            fieldMapper = new DimensionEntryFieldMapper(queryParam.getFilter().getDynamicObject(KEY_DIMENSION_S).getPkValue());
        }
        List roleNumbers = fieldMapper.getRoleNumbers();
        ArrayList<ReportColumn> dimensionColumns = new ArrayList<ReportColumn>(roleNumbers.size());
        for (String roleNumber : roleNumbers) {
            String roleFieldKey = fieldMapper.getRoleFieldKey(roleNumber);
            if (columnKeys.contains(roleFieldKey)) continue;
            String baseDataKey = fieldMapper.getBaseDataKey(roleNumber);
            ReportColumn baseDataColumn = ReportColumn.createBaseDataColumn((String)roleFieldKey, (String)baseDataKey);
            baseDataColumn.setCaption(fieldMapper.getRoleDisplayName(roleFieldKey));
            dimensionColumns.add(baseDataColumn);
        }
        columns.addAll(schemeColumnIndex + 1, dimensionColumns);
    }

    public void afterCreateColumn(CreateColumnEvent event) {
        super.afterCreateColumn(event);
        List columns = event.getColumns();
        for (AbstractReportColumn column : columns) {
            if (!(column instanceof ReportColumn)) continue;
            ReportColumn rc = (ReportColumn)column;
            if ("unit_amt".equals(rc.getFieldKey())) {
                rc.setHide(true);
                continue;
            }
            if ("sumlevel".equals(rc.getFieldKey())) {
                rc.setHide(true);
                continue;
            }
            if (!"dimensionvalue".equals(rc.getFieldKey())) continue;
            rc.setHide(true);
        }
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        super.getEntityType(e);
        MainEntityType originalEntityType = e.getOriginalEntityType();
        String dimensionIdStr = this.getPageCache().get("dimensionid");
        if (StringUtils.isBlank((CharSequence)dimensionIdStr)) {
            return;
        }
        MainEntityType newEntityType = null;
        try {
            newEntityType = (MainEntityType)originalEntityType.clone();
        }
        catch (CloneNotSupportedException e1) {
            throw new RuntimeException(e1);
        }
        DimensionEntryFieldMapper dimensionEntryFieldMapper = new DimensionEntryFieldMapper((Object)Long.valueOf(dimensionIdStr));
        List roleNumbers = dimensionEntryFieldMapper.getRoleNumbers();
        for (String roleNumber : roleNumbers) {
            String fieldTypeKey = dimensionEntryFieldMapper.getFieldTypeKey(roleNumber);
            String baseDataKey = dimensionEntryFieldMapper.getBaseDataKey(fieldTypeKey);
            String roleFilterKey = dimensionEntryFieldMapper.getRoleFilterKey(roleNumber);
            if ("bd_customer".equals(baseDataKey)) continue;
            MulBasedataProp prop = (MulBasedataProp)newEntityType.getProperty(roleFilterKey);
            prop.setBaseEntityId(baseDataKey);
            BasedataProp bPropMul = (BasedataProp)prop.getItemType().getProperties().get((Object)"fbasedataid");
            bPropMul.setBaseEntityId(baseDataKey);
            MainEntityType newDT = EntityMetadataCache.getDataEntityType((String)baseDataKey);
            EntityType newSimpleDT = newDT.getSubEntityType(new ArrayList(0));
            bPropMul.setComplexType((IDataEntityType)newSimpleDT);
            DynamicProperty refProp = prop.getDynamicCollectionItemPropertyType().getProperty("fbasedataid_id");
            bPropMul.setRefIdProp((IDataEntityProperty)refProp);
            bPropMul.setRefIdPropName(refProp.getName());
        }
        e.setNewEntityType(newEntityType);
    }

    private void roleFieldListener() {
        Object scheme = this.getModel().getValue(KEY_SCHEME_S);
        if (!ObjectUtils.isEmpty((Object)scheme)) {
            DimensionEntryFieldMapper mapper = this.getMapper();
            List roleNumbers = mapper.getRoleNumbers();
            for (String roleNumber : roleNumbers) {
                String roleFieldKey = mapper.getRoleFilterKey(roleNumber);
                BasedataEdit roleValueF7 = (BasedataEdit)this.getControl(roleFieldKey);
                roleValueF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        IDataModel model = this.getModel();
        Object scheme = model.getValue(KEY_SCHEME_S);
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        if (!ObjectUtils.isEmpty((Object)scheme)) {
            DimensionEntryFieldMapper mapper = this.getMapper();
            List roleNumbers = mapper.getRoleNumbers();
            long orgId = ((DynamicObject)scheme).getDynamicObject("mainorg").getLong("id");
            for (String roleNumber : roleNumbers) {
                if (!key.equalsIgnoreCase(mapper.getRoleFilterKey(roleNumber))) continue;
                QFilter filter = null;
                filter = BaseDataServiceHelper.getBaseDataFilter((String)mapper.getBaseDataKey(roleNumber), (Long)orgId);
                if (!ObjectUtils.isEmpty((Object)filter)) {
                    filter.and(new QFilter("status", "=", (Object)"C"));
                } else {
                    filter = new QFilter("status", "=", (Object)"C");
                }
                ListFilterParameter listFilterParameter = showParameter.getListFilterParameter();
                listFilterParameter.getQFilters().add(filter);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        DynamicObject scheme;
        super.beforeDoOperation(e);
        FormOperate op = (FormOperate)e.getSource();
        if ("refresh".equals(op.getOperateKey()) && ((scheme = (DynamicObject)this.getModel().getValue(KEY_SCHEME_S)) == null || scheme.getPkValue() == null || this.getPageCache().get(KEY_QUERY_SCHEME) == null || !this.getPageCache().get(KEY_QUERY_SCHEME).equals(scheme.getPkValue().toString()))) {
            e.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4fe1\u63a7\u65b9\u6848\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u91cd\u65b0\u67e5\u8be2\u3002", (String)"RptFormBasePlugin_1", (String)"scmc-ccm-report", (Object[])new Object[0]));
        }
    }
}

