/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.report.analysedetail;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bplat.scmc.report.conf.BigTableColConf;
import kd.bplat.scmc.report.conf.ReportConf;
import kd.bplat.scmc.report.core.ReportDataHandle;
import kd.bplat.scmc.report.util.ReportUtil;
import kd.scmc.ccm.business.setting.DimensionEntryFieldMapper;
import kd.scmc.ccm.common.enums.StatusEnum;
import kd.scmc.ccm.common.helper.PermissionHelper;

public class AnalyseDetailReportPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener,
HyperLinkClickListener {
    private static final String KEY_ANALYSE_DETAIL = "ccm_analyse_detail_new";
    private static final String KEY_SCHEMA_S = "schema_s";
    private static final String KEY_DIMENSION_S = "dimension_s";
    private static final String KEY_ORGFUNC_S = "orgfunc_s";
    private static final String KEY_CURRENCY_S = "currency_s";
    private static final String KEY_QUERY_DIMENSION = "now_query_dimension";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit schema = (BasedataEdit)this.getView().getControl(KEY_SCHEMA_S);
        if (schema != null) {
            schema.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        ReportList list = (ReportList)this.getControl("reportlistap");
        list.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void initialize() {
        super.initialize();
        MulBasedataEdit role0 = (MulBasedataEdit)this.getView().getControl("role0_s");
        role0.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit role1 = (MulBasedataEdit)this.getView().getControl("role1_s");
        role1.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit role2 = (MulBasedataEdit)this.getView().getControl("role2_s");
        role2.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit role3 = (MulBasedataEdit)this.getView().getControl("role3_s");
        role3.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.schemeChange();
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String name = e.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        String appId = this.getView().getFormShowParameter().getAppId();
        if (KEY_SCHEMA_S.equals(name)) {
            QFilter filter1 = new QFilter("checktype.number", "in", (Object)new String[]{"KZFW001", "KZFW003", "KZFW010"});
            HasPermOrgResult permOrgResult = PermissionHelper.getAllPermOrgs((String)KEY_ANALYSE_DETAIL, (String)appId, (String)"47150e89000000ac");
            if (!permOrgResult.hasAllOrgPerm()) {
                filter1.and("mainorg", "in", (Object)permOrgResult.getHasPermOrgs());
            }
            QFilter filter2 = new QFilter("status", "=", (Object)StatusEnum.AUDIT.getValue());
            showParameter.getListFilterParameter().getQFilters().add(filter1.and(filter2));
        } else {
            Object scheme = this.getModel().getValue(KEY_SCHEMA_S);
            if (!ObjectUtils.isEmpty((Object)scheme)) {
                DimensionEntryFieldMapper mapper = this.getMapper();
                List roleNumbers = mapper.getRoleNumbers();
                long orgId = ((DynamicObject)scheme).getDynamicObject("mainorg").getLong("id");
                for (String roleNumber : roleNumbers) {
                    if (!name.equalsIgnoreCase(mapper.getRoleFilterKey(roleNumber))) continue;
                    QFilter filter = null;
                    filter = BaseDataServiceHelper.getBaseDataFilter((String)mapper.getBaseDataKey(roleNumber), (Long)orgId);
                    if (!ObjectUtils.isEmpty((Object)filter)) {
                        filter.and(new QFilter("status", "=", (Object)"C"));
                    } else {
                        filter = new QFilter("status", "=", (Object)"C");
                    }
                    showParameter.getListFilterParameter().getQFilters().add(filter);
                }
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "showkeycols": {
                IDataModel model = this.getModel();
                Set sumKeyCols = ReportUtil.parseCombColVal((IDataModel)model, (String)"sumkeycols");
                Set showKeyCols = ReportUtil.parseCombColVal((IDataModel)model, (String)"showkeycols");
                this.fillComboItem("sumkeycols", colConf -> showKeyCols.contains(colConf.getCol()));
                boolean result = sumKeyCols.retainAll(showKeyCols);
                if (!result) break;
                model.setValue("sumkeycols", sumKeyCols.isEmpty() ? null : "," + org.apache.commons.lang3.StringUtils.join((Iterable)sumKeyCols, (String)",") + ",");
                break;
            }
            case "schema_s": {
                this.schemeChange();
                break;
            }
        }
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        super.getEntityType(e);
        MainEntityType originalEntityType = e.getOriginalEntityType();
        String dimensionIdStr = this.getPageCache().get("dimensionid");
        if (StringUtils.isBlank((CharSequence)dimensionIdStr)) {
            return;
        }
        MainEntityType newEntityType = null;
        try {
            newEntityType = (MainEntityType)originalEntityType.clone();
        }
        catch (CloneNotSupportedException e1) {
            throw new RuntimeException(e1);
        }
        DimensionEntryFieldMapper dimensionEntryFieldMapper = new DimensionEntryFieldMapper((Object)Long.valueOf(dimensionIdStr));
        List roleNumbers = dimensionEntryFieldMapper.getRoleNumbers();
        for (String roleNumber : roleNumbers) {
            String fieldTypeKey = dimensionEntryFieldMapper.getFieldTypeKey(roleNumber);
            String baseDataKey = dimensionEntryFieldMapper.getBaseDataKey(fieldTypeKey);
            String roleFilterKey = dimensionEntryFieldMapper.getRoleFilterKey(roleNumber);
            MulBasedataProp prop = (MulBasedataProp)newEntityType.getProperty(roleFilterKey);
            prop.setBaseEntityId(baseDataKey);
            BasedataProp bPropMul = (BasedataProp)prop.getItemType().getProperties().get((Object)"fbasedataid");
            bPropMul.setBaseEntityId(baseDataKey);
            MainEntityType newDT = EntityMetadataCache.getDataEntityType((String)baseDataKey);
            bPropMul.setComplexType((IDataEntityType)newDT);
            DynamicProperty refProp = prop.getDynamicCollectionItemPropertyType().getProperty("fbasedataid_id");
            bPropMul.setRefIdProp((IDataEntityProperty)refProp);
            bPropMul.setRefIdPropName(refProp.getName());
            LocaleString roleDisplayName = dimensionEntryFieldMapper.getRoleDisplayName(dimensionEntryFieldMapper.getRoleFieldKey(roleNumber));
            FieldEdit control = (FieldEdit)this.getControl(roleFilterKey);
            ((DynamicProperty)control.getProperty()).setDisplayName(roleDisplayName);
        }
        e.setNewEntityType(newEntityType);
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
        ReportList reportList = (ReportList)event.getSource();
        IReportListModel reportModel = reportList.getReportModel();
        DynamicObject rowData = reportModel.getRowData(event.getRowIndex());
        BillShowParameter param = new BillShowParameter();
        param.setFormId(rowData.getDynamicObject("billkey").getString("number"));
        param.setPkId((Object)rowData.getString("billid"));
        param.setStatus(OperationStatus.VIEW);
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        param.setHasRight(true);
        this.getView().showForm((FormShowParameter)param);
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        FilterInfo filterInfo = queryParam.getFilter();
        if (filterInfo.getString(KEY_SCHEMA_S) == null || this.getModel().getValue(KEY_SCHEMA_S) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6307\u5b9a\u4fe1\u63a7\u65b9\u6848\u3002", (String)"AnalyseDetailReportPlugin_0", (String)"scmc-ccm-report", (Object[])new Object[0]));
            return false;
        }
        return super.verifyQuery(queryParam);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        DynamicObject dimension;
        super.beforeDoOperation(e);
        FormOperate op = (FormOperate)e.getSource();
        if ("refresh".equals(op.getOperateKey()) && ((dimension = (DynamicObject)this.getModel().getValue(KEY_DIMENSION_S)) == null || dimension.getPkValue() == null || this.getPageCache().get(KEY_QUERY_DIMENSION) == null || !this.getPageCache().get(KEY_QUERY_DIMENSION).equals(dimension.getPkValue().toString()))) {
            e.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4fe1\u63a7\u7ef4\u5ea6\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u91cd\u65b0\u67e5\u8be2\u3002", (String)"AnalyseDetailReportPlugin_16", (String)"scmc-ccm-report", (Object[])new Object[0]));
        }
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        DynamicObject schema = (DynamicObject)this.getModel().getValue(KEY_SCHEMA_S);
        DynamicObject dimension = schema.getDynamicObject("dimension");
        DynamicObject currency = (DynamicObject)this.getModel().getValue(KEY_CURRENCY_S);
        DynamicObjectCollection bills = (DynamicObjectCollection)this.getModel().getValue("billkey_s");
        String direction = (String)this.getModel().getValue("direction_s");
        queryParam.getCustomParam().put("scheme", schema);
        queryParam.getCustomParam().put("dimension", dimension);
        queryParam.getCustomParam().put("currency", currency);
        queryParam.getCustomParam().put("bills", bills);
        queryParam.getCustomParam().put("direction", direction);
        if (dimension.getPkValue() != null) {
            this.getPageCache().put(KEY_QUERY_DIMENSION, dimension.getPkValue().toString());
        }
        ArrayList<QFilter> pageFs = new ArrayList<QFilter>();
        QFilter schemaFilter = new QFilter("scheme", "=", schema.getPkValue());
        pageFs.add(schemaFilter);
        ReportList rptList = (ReportList)this.getControl("reportlistap");
        List columns = rptList.getColumns();
        HashSet<String> columnKeys = new HashSet<String>(columns.size());
        for (int i = 0; i < columns.size(); ++i) {
            AbstractReportColumn column = (AbstractReportColumn)columns.get(i);
            if (!(column instanceof ReportColumn)) continue;
            String fieldKey = ((ReportColumn)column).getFieldKey();
            columnKeys.add(fieldKey);
        }
        DimensionEntryFieldMapper fieldMapper = new DimensionEntryFieldMapper(dimension.getPkValue());
        List roleNumbers = fieldMapper.getRoleNumbers();
        ArrayList<ReportColumn> dimensionColumns = new ArrayList<ReportColumn>(roleNumbers.size());
        for (String roleNumber : roleNumbers) {
            String roleFieldKey = fieldMapper.getRoleFieldKey(roleNumber);
            DynamicObjectCollection roleCol = (DynamicObjectCollection)this.getModel().getValue(fieldMapper.getRoleFilterKey(roleNumber));
            queryParam.getCustomParam().put(roleFieldKey, roleCol.stream().map(d -> d.getLong("fbasedataid.id")).collect(Collectors.toList()));
            if (columnKeys.contains(roleFieldKey)) continue;
            String baseDataKey = fieldMapper.getBaseDataKey(roleNumber);
            ReportColumn baseDataColumn = ReportColumn.createBaseDataColumn((String)roleFieldKey, (String)baseDataKey);
            baseDataColumn.setCaption(fieldMapper.getRoleDisplayName(roleFieldKey));
            dimensionColumns.add(baseDataColumn);
            DynamicObjectCollection roleCollection = (DynamicObjectCollection)this.getModel().getValue(fieldMapper.getRoleFilterKey(roleNumber));
            if (roleCollection.size() <= 0) continue;
            List pkIds = roleCollection.stream().map(d -> d.getLong("fbasedataid.id")).collect(Collectors.toList());
            QFilter roleFilter = new QFilter(fieldMapper.getRoleFieldKey(roleNumber), "in", pkIds);
            queryParam.getCustomParam().put(fieldMapper.getRoleFieldKey(roleNumber), pkIds);
            pageFs.add(roleFilter);
        }
        queryParam.getFilter().setQFilters(pageFs);
        columns.addAll(1, dimensionColumns);
    }

    public void afterSetModelValue(DynamicObject scheme) {
        if (scheme != null) {
            List<String> allFilterControlKeys = this.getAllFilterControlKeys();
            LinkedList<String> visiableKeys = new LinkedList<String>();
            List<String> unvisiableKeys = allFilterControlKeys;
            DynamicObject schema = (DynamicObject)this.getModel().getValue(KEY_SCHEMA_S);
            DynamicObject dimension = schema.getDynamicObject("dimension");
            this.getModel().setValue(KEY_SCHEMA_S, (Object)schema);
            this.getPageCache().put("dimensionid", dimension.getString("id"));
            DimensionEntryFieldMapper mapper = new DimensionEntryFieldMapper(dimension.getPkValue());
            List roleNumbers = mapper.getRoleNumbers();
            for (String roleNumer : roleNumbers) {
                String roleFilterKey = mapper.getRoleFilterKey(roleNumer);
                String roleFilterTypeKey = mapper.getBaseDataKey(roleNumer);
                visiableKeys.add(roleFilterKey);
                unvisiableKeys.remove(roleFilterKey);
                LocaleString roleDisplayName = mapper.getRoleDisplayName(mapper.getRoleFieldKey(roleNumer));
                FieldEdit control = (FieldEdit)this.getControl(roleFilterKey);
                control.setCaption(roleDisplayName);
                ((DynamicProperty)control.getProperty()).setDisplayName(roleDisplayName);
                if (scheme.get(roleFilterKey) != null && scheme.get(roleFilterKey) instanceof MulBasedataDynamicObjectCollection) {
                    MulBasedataDynamicObjectCollection roleValueCol = (MulBasedataDynamicObjectCollection)scheme.get(roleFilterKey);
                    if (roleValueCol != null && roleValueCol.size() > 0) {
                        HashSet<Object> roleValueIDs = new HashSet<Object>(roleValueCol.size());
                        for (DynamicObject roDo : roleValueCol) {
                            if (roDo == null || roDo.get("fbasedataid") == null) continue;
                            roleValueIDs.add(((DynamicObject)roDo.get("fbasedataid")).getPkValue());
                        }
                        Map loadRoleDoMap = BusinessDataServiceHelper.loadFromCache((Object[])roleValueIDs.toArray(), (String)roleFilterTypeKey);
                        MulBasedataDynamicObjectCollection newRoleMulBDDoCol = new MulBasedataDynamicObjectCollection();
                        for (DynamicObject loadRoleDo : loadRoleDoMap.values()) {
                            newRoleMulBDDoCol.add(loadRoleDo);
                        }
                        if (newRoleMulBDDoCol == null || newRoleMulBDDoCol.size() < 1) {
                            this.getModel().setValue(roleFilterKey, null);
                            continue;
                        }
                        this.getModel().setValue(roleFilterKey, (Object)newRoleMulBDDoCol);
                        continue;
                    }
                    this.getModel().setValue(roleFilterKey, null);
                    continue;
                }
                this.getModel().setValue(roleFilterKey, null);
            }
            if (!visiableKeys.isEmpty()) {
                this.getView().setVisible(Boolean.TRUE, visiableKeys.toArray(new String[0]));
            }
            if (!unvisiableKeys.isEmpty()) {
                this.getView().setVisible(Boolean.FALSE, unvisiableKeys.toArray(new String[0]));
            }
        }
    }

    private DimensionEntryFieldMapper getMapper() {
        DynamicObject scheme = (DynamicObject)this.getModel().getValue(KEY_SCHEMA_S);
        DynamicObject dimension = scheme.getDynamicObject("dimension");
        DimensionEntryFieldMapper mapper = new DimensionEntryFieldMapper(dimension.getPkValue());
        return mapper;
    }

    private List<String> getAllFilterControlKeys() {
        LinkedList<String> filterControlKeys = new LinkedList<String>();
        MainEntityType dataEntityType = this.getModel().getDataEntityType();
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        for (IDataEntityProperty prop : properties) {
            if (!(prop instanceof MulBasedataProp) || !prop.getName().startsWith("role")) continue;
            filterControlKeys.add(prop.getName());
        }
        return filterControlKeys;
    }

    private void fillComboItem(String comboCol, ColFilter filter) {
        ReportConf conf = ReportDataHandle.loadReportConf((String)this.getModel().getDataEntityType().getName());
        DynamicObject schema = (DynamicObject)this.getModel().getValue(KEY_SCHEMA_S);
        if (schema == null) {
            return;
        }
        DynamicObject dimension = schema.getDynamicObject("dimension");
        if (dimension == null) {
            return;
        }
        DimensionEntryFieldMapper fieldMapper = new DimensionEntryFieldMapper(dimension.getPkValue());
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>(16);
        List bigTableColConfs = conf.getBigTableColConf();
        for (BigTableColConf colConf : bigTableColConfs) {
            if (fieldMapper.getRoleFieldKeys().contains(colConf.getCol())) {
                colConf.setColName(fieldMapper.getRoleDisplayName(colConf.getCol()).getLocaleValue());
            }
            if (!filter.filter(colConf)) continue;
            combos.add(new ComboItem(new LocaleString(colConf.getColName()), colConf.getCol()));
        }
        ComboEdit item = (ComboEdit)this.getView().getControl(comboCol);
        item.setComboItems(combos);
    }

    private void schemeChange() {
        IDataModel model = this.getModel();
        IReportView view = this.getView();
        model.setValue(KEY_DIMENSION_S, null);
        model.setValue(KEY_ORGFUNC_S, null);
        model.setValue(KEY_CURRENCY_S, null);
        DynamicObject schema = (DynamicObject)model.getValue(KEY_SCHEMA_S);
        DynamicObject dimension = null;
        DynamicObject checkType = null;
        if (schema != null) {
            dimension = schema.getDynamicObject("dimension");
            checkType = schema.getDynamicObject("checktype");
        }
        List<String> allFilterControlKeys = this.getAllFilterControlKeys();
        for (String key : allFilterControlKeys) {
            this.getModel().setValue(key, null);
        }
        LinkedList<String> visiableKeys = new LinkedList<String>();
        List<String> unvisiableKeys = allFilterControlKeys;
        List roleNumbers = new ArrayList();
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>(16);
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("commonfs");
        List baseFilterColumns = filterGrid.getFilterColumns().stream().filter(d -> !((String)d.get("fieldName")).startsWith("role") && !((String)d.get("fieldName")).equals("isover")).collect(Collectors.toList());
        filterGrid.setFilterColumns(baseFilterColumns);
        this.getView().updateView("commonfs");
        if (dimension != null) {
            this.getPageCache().put("dimensionid", dimension.getString("id"));
            model.setValue(KEY_DIMENSION_S, schema.get("dimension"));
            model.setValue(KEY_ORGFUNC_S, schema.get("orgfunc"));
            model.setValue(KEY_CURRENCY_S, schema.get("currency"));
            DimensionEntryFieldMapper mapper = new DimensionEntryFieldMapper(dimension.getPkValue());
            roleNumbers = mapper.getRoleNumbers();
            for (String roleNumer : roleNumbers) {
                String roleFilterKey = mapper.getRoleFilterKey(roleNumer);
                visiableKeys.add(roleFilterKey);
                unvisiableKeys.remove(roleFilterKey);
                LocaleString roleDisplayName = mapper.getRoleDisplayName(mapper.getRoleFieldKey(roleNumer));
                FieldEdit control = (FieldEdit)this.getControl(roleFilterKey);
                control.setCaption(roleDisplayName);
                ((DynamicProperty)control.getProperty()).setDisplayName(roleDisplayName);
                combos.add(new ComboItem(roleDisplayName, mapper.getRoleFieldKey(roleNumer)));
                this.getModel().setValue(roleFilterKey, null);
            }
        } else {
            this.getPageCache().remove("dimensionid");
        }
        combos.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u4fe1\u63a7\u65b9\u6848", (String)"AnalyseDetailReportPlugin_1", (String)"scmc-ccm-report", (Object[])new Object[0])), "scheme"));
        combos.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5e01\u79cd", (String)"AnalyseDetailReportPlugin_2", (String)"scmc-ccm-report", (Object[])new Object[0])), "currency"));
        combos.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7", (String)"AnalyseDetailReportPlugin_3", (String)"scmc-ccm-report", (Object[])new Object[0])), "billno"));
        combos.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e", (String)"AnalyseDetailReportPlugin_4", (String)"scmc-ccm-report", (Object[])new Object[0])), "billkey"));
        combos.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5355\u636e\u64cd\u4f5c", (String)"AnalyseDetailReportPlugin_5", (String)"scmc-ccm-report", (Object[])new Object[0])), "billop"));
        combos.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u4fe1\u7528\u65b9\u5411", (String)"AnalyseDetailReportPlugin_6", (String)"scmc-ccm-report", (Object[])new Object[0])), "direction"));
        combos.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u989d\u5ea6\u7c7b\u578b", (String)"AnalyseDetailReportPlugin_7", (String)"scmc-ccm-report", (Object[])new Object[0])), "quotatype"));
        combos.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5355\u636e\u64cd\u4f5c\u65f6\u95f4", (String)"AnalyseDetailReportPlugin_8", (String)"scmc-ccm-report", (Object[])new Object[0])), "createtime"));
        combos.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u64cd\u4f5c\u4eba", (String)"AnalyseDetailReportPlugin_9", (String)"scmc-ccm-report", (Object[])new Object[0])), "creator"));
        if (checkType != null) {
            String checkTypeNumber = checkType.getString("number");
            ComboEdit showqtyItem = (ComboEdit)this.getView().getControl("showqtycols");
            ArrayList<ComboItem> showqtyCombos = new ArrayList<ComboItem>(8);
            if ("KZFW001".equals(checkTypeNumber) || "KZFW010".equals(checkTypeNumber)) {
                combos.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u539f\u5e01", (String)"AnalyseDetailReportPlugin_10", (String)"scmc-ccm-report", (Object[])new Object[0])), "originalcurrency_amt"));
                combos.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6298\u7b97\u5e01", (String)"AnalyseDetailReportPlugin_11", (String)"scmc-ccm-report", (Object[])new Object[0])), "convertedcurrency_amt"));
                showqtyCombos.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u539f\u5e01\u91d1\u989d", (String)"AnalyseDetailReportPlugin_12", (String)"scmc-ccm-report", (Object[])new Object[0])), "original_amt"));
                showqtyCombos.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6298\u7b97\u5e01\u91d1\u989d", (String)"AnalyseDetailReportPlugin_13", (String)"scmc-ccm-report", (Object[])new Object[0])), "converted_amt"));
            } else if ("KZFW003".equals(checkTypeNumber)) {
                combos.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u8ba1\u91cf\u5355\u4f4d", (String)"AnalyseDetailReportPlugin_14", (String)"scmc-ccm-report", (Object[])new Object[0])), "measureunit_qty"));
                showqtyCombos.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6570\u91cf", (String)"AnalyseDetailReportPlugin_15", (String)"scmc-ccm-report", (Object[])new Object[0])), "converted_qty"));
            }
            showqtyItem.setComboItems(showqtyCombos);
            StringBuilder selectedCols = new StringBuilder();
            showqtyCombos.stream().forEach(d -> selectedCols.append(d.getValue()).append(','));
            this.getModel().setValue("showqtycols", (Object)selectedCols);
        }
        if (!visiableKeys.isEmpty()) {
            view.setVisible(Boolean.TRUE, visiableKeys.toArray(new String[0]));
        }
        if (!unvisiableKeys.isEmpty()) {
            view.setVisible(Boolean.FALSE, unvisiableKeys.toArray(new String[0]));
        }
        ComboEdit item = (ComboEdit)this.getView().getControl("showkeycols");
        item.setComboItems(combos);
        StringBuilder selectedCols = new StringBuilder();
        combos.stream().forEach(d -> selectedCols.append(d.getValue()).append(','));
        this.getModel().setValue("showkeycols", (Object)selectedCols);
        ComboEdit sumkeycols = (ComboEdit)this.getView().getControl("sumkeycols");
        sumkeycols.setComboItems(combos);
    }

    private static interface ColFilter {
        public boolean filter(BigTableColConf var1);
    }
}

