/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.report.analysedetail.function;

import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.dataentity.utils.StringUtils;
import kd.scmc.ccm.common.util.MetadataUtils;

public class AnalyseDetailDataFunction
extends GroupReduceFunction {
    private RowMeta rowMeta;
    private Map<String, Integer> indexMap;

    public AnalyseDetailDataFunction(RowMeta rowMeta) {
        this.rowMeta = rowMeta;
        Field[] fields = rowMeta.getFields();
        if (this.indexMap == null) {
            this.indexMap = new HashMap<String, Integer>(fields.length);
        }
        for (int i = 0; i < fields.length; ++i) {
            this.indexMap.put(fields[i].getName(), i);
        }
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        for (RowX row : iterable) {
            String entity;
            Integer billOpIndex = this.indexMap.get("billop");
            Integer billKeyIndex = this.indexMap.get("billkey");
            if (billOpIndex != null && billKeyIndex != null && StringUtils.isNotBlank((CharSequence)(entity = row.getString(billKeyIndex.intValue())))) {
                String op = row.getString(billOpIndex.intValue());
                String opDisplayName = MetadataUtils.getOpDisplayName((String)entity, (String)op);
                row.set(billOpIndex.intValue(), (Object)opDisplayName);
            }
            collector.collect(row);
        }
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }
}

