/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.report.analysesum;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.DataSetX;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.orm.query.QFilter;
import kd.bplat.scmc.report.conf.BigTableColConf;
import kd.bplat.scmc.report.conf.SrcBlockConf;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataTransform;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.bplat.scmc.report.core.tpl.IReportDataHandle;
import kd.scmc.ccm.business.setting.DimensionEntryFieldMapper;
import kd.scmc.ccm.common.enums.StatusEnum;
import kd.scmc.ccm.common.util.DateUtils;
import kd.scmc.ccm.report.analysesum.function.CalculateDataFunction;

public class AnalyseSumReportHandle
implements IReportDataHandle {
    private DimensionEntryFieldMapper fieldMapper;

    public void handleBlockDataSelectCols(Set<String> repoColFilter, SrcBlockConf blockConf, ReportDataCtx ctx) {
        Map repoColFullSrcColMap = blockConf.getRepoColFullSrcColMap();
        repoColFullSrcColMap.putIfAbsent("id", "id");
        Map repoColSrcColMap = blockConf.getRepoColSrcColMap();
        repoColSrcColMap.putIfAbsent("id", "id");
    }

    public void modifyBlocks(List<SrcBlockConf> blockCollector, ReportDataCtx ctx) {
        Map params = ctx.getParams();
        List<QFilter> filters = this.getFilters(params);
        for (SrcBlockConf srcBlockConf : blockCollector) {
            String srcEntity = srcBlockConf.getSrcEntity();
            if (!"ccm_archive".equalsIgnoreCase(srcEntity)) continue;
            QFilter dataFs = srcBlockConf.getDataFs();
            if (dataFs == null) {
                dataFs = QFilter.of((String)"1=1", (Object[])new Object[0]);
            }
            for (QFilter filter : filters) {
                dataFs.and(filter);
            }
            srcBlockConf.setDataFs(dataFs);
        }
    }

    private List<QFilter> getFilters(Map<String, Object> filterInfo) {
        QFilter schemeFilter;
        DynamicObjectCollection scheme;
        Date today;
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        if (filterInfo == null) {
            return filters;
        }
        DynamicObject dimension = (DynamicObject)filterInfo.get("dimension");
        if (dimension != null) {
            filters.add(new QFilter("dimension", "=", dimension.getPkValue()));
        }
        if ((today = (Date)filterInfo.get("today")) != null) {
            QFilter beginDateFilter = new QFilter("begindate", "<=", (Object)DateUtils.getEndOfDay((Date)today));
            QFilter endDateFilter = new QFilter("enddate", ">=", (Object)DateUtils.getStartOfDay((Date)today));
            filters.add(beginDateFilter);
            filters.add(endDateFilter);
        }
        if ((scheme = (DynamicObjectCollection)filterInfo.get("scheme")) != null && scheme.size() > 0) {
            schemeFilter = new QFilter("scheme", "in", scheme.stream().map(d -> d.getLong("fbasedataid.id")).collect(Collectors.toList()));
            filters.add(schemeFilter);
        } else {
            schemeFilter = new QFilter("scheme.checktype.number", "in", (Object)new String[]{"KZFW001", "KZFW002", "KZFW006"}).and(new QFilter("scheme.status", "=", (Object)StatusEnum.AUDIT.getValue()));
            filters.add(schemeFilter);
        }
        DynamicObjectCollection currency = (DynamicObjectCollection)filterInfo.get("currency");
        if (currency != null && currency.size() > 0) {
            QFilter currencyFilter = new QFilter("scheme.currency", "in", currency.stream().map(d -> d.getLong("fbasedataid.id")).collect(Collectors.toList()));
            filters.add(currencyFilter);
        }
        return filters;
    }

    public void setupCtx(ReportDataCtx ctx) {
        ctx.getShowKeyCols().add("mainorg");
        ctx.getShowKeyCols().add("id");
        ctx.getShowKeyCols().add("dimensionvalue");
        DynamicObject dimension = (DynamicObject)ctx.getParam("dimension");
        DimensionEntryFieldMapper fieldMapper = new DimensionEntryFieldMapper(dimension.getPkValue());
        List roleFieldKeys = fieldMapper.getRoleFieldKeys();
        List colConfs = ctx.getReportConf().getBigTableColConf();
        for (BigTableColConf colConf : colConfs) {
            if (!roleFieldKeys.contains(colConf.getCol())) continue;
            colConf.setColName(fieldMapper.getRoleDisplayName(colConf.getCol()).getLocaleValue());
        }
    }

    public List<AbstractReportColumn> buildShowColumn(List<AbstractReportColumn> cols, ReportDataCtx ctx) {
        DynamicObject dimension = (DynamicObject)ctx.getParam("dimension");
        this.fieldMapper = new DimensionEntryFieldMapper(dimension.getPkValue());
        cols.stream().forEach(d -> {
            if (((ReportColumn)d).getFieldKey().endsWith("_s")) {
                ((ReportColumn)d).setFieldType("basedata");
                d.setCaption(this.fieldMapper.getRoleDisplayName(((ReportColumn)d).getFieldKey().substring(0, ((ReportColumn)d).getFieldKey().indexOf(95))));
                ((ReportColumn)d).setRefBasedataProp(this.fieldMapper.getFieldBaseDataKey(((ReportColumn)d).getFieldKey().substring(0, ((ReportColumn)d).getFieldKey().indexOf(95))));
            }
            if (d.getCaption().getLocaleValue() != null && d.getCaption().getLocaleValue().contains(".")) {
                d.setCaption(new LocaleString(d.getCaption().getLocaleValue().replace(".", "")));
            }
        });
        this.buildDimensionColumnGroup(cols);
        ReportColumnGroup amt_group = this.buildReportColumnGroup(cols, "_amt");
        ReportColumnGroup overdueday_group = this.buildReportColumnGroup(cols, "_overdueday");
        ReportColumnGroup overdueamt_group = this.buildReportColumnGroup(cols, "_overdueamt");
        cols.add(cols.size() - 2, (AbstractReportColumn)amt_group);
        cols.add(cols.size() - 2, (AbstractReportColumn)overdueday_group);
        cols.add(cols.size() - 2, (AbstractReportColumn)overdueamt_group);
        return cols;
    }

    private void buildDimensionColumnGroup(List<AbstractReportColumn> cols) {
        ReportColumnGroup group = new ReportColumnGroup();
        group.setFieldKey("dimension_group");
        group.setCaption(new LocaleString(ResManager.loadKDString((String)"\u4fe1\u63a7\u7ef4\u5ea6", (String)"AnalyseSumReportHandle_4", (String)"scmc-ccm-report", (Object[])new Object[0])));
        List roleCols = cols.stream().filter(d -> ((ReportColumn)d).getFieldKey().startsWith("role")).collect(Collectors.toList());
        roleCols.stream().forEach(d -> d.setHideSingleColumnRow(false));
        cols.removeAll(roleCols);
        List numberCols = roleCols.stream().filter(d -> d.getCaption().getLocaleValue().endsWith(ResManager.loadKDString((String)"\u7f16\u7801", (String)"AnalyseSumReportHandle_3", (String)"scmc-ccm-report", (Object[])new Object[0]))).collect(Collectors.toList());
        roleCols.removeAll(numberCols);
        int index = 0;
        for (AbstractReportColumn c : numberCols) {
            roleCols.add(index, c);
            index += 2;
        }
        group.getChildren().addAll(roleCols);
        int linetype_index = cols.indexOf(cols.stream().filter(d -> ((ReportColumn)d).getFieldKey().equals("linetype")).findFirst().get());
        cols.add(linetype_index + 1, (AbstractReportColumn)group);
    }

    private ReportColumnGroup buildReportColumnGroup(List<AbstractReportColumn> cols, String prefix) {
        ReportColumnGroup group = new ReportColumnGroup();
        group.setFieldKey(String.format("%s_group", prefix));
        String columnName = "";
        if ("_amt".equals(prefix)) {
            columnName = ResManager.loadKDString((String)"\u4fe1\u7528\u989d\u5ea6", (String)"AnalyseSumReportHandle_0", (String)"scmc-ccm-report", (Object[])new Object[0]);
        } else if ("_overdueday".equals(prefix)) {
            columnName = ResManager.loadKDString((String)"\u4fe1\u7528\u5929\u6570", (String)"AnalyseSumReportHandle_1", (String)"scmc-ccm-report", (Object[])new Object[0]);
        } else if ("_overdueamt".equals(prefix)) {
            columnName = ResManager.loadKDString((String)"\u903e\u671f\u989d\u5ea6", (String)"AnalyseSumReportHandle_2", (String)"scmc-ccm-report", (Object[])new Object[0]);
        }
        group.setCaption(new LocaleString(columnName));
        List prefixCols = cols.stream().filter(d -> !(d instanceof ReportColumnGroup)).filter(d -> ((ReportColumn)d).getFieldKey().contains(prefix)).collect(Collectors.toList());
        cols.removeAll(prefixCols);
        prefixCols.stream().map(d -> {
            ReportColumn reportColumn = (ReportColumn)d;
            reportColumn.setHideSingleColumnRow(false);
            reportColumn.setScale(2);
            reportColumn.setZeroShow(true);
            return reportColumn;
        }).collect(Collectors.toList());
        group.getChildren().addAll(prefixCols);
        return group;
    }

    public void transFormAfterGroup(List<IDataXTransform> transCollector, final ReportDataCtx ctx) {
        transCollector.add(new IDataXTransform(){

            public DataSetX doTransform(DataSetX srcData) {
                Map filterInfo = ctx.getParams();
                DynamicObject dimension = (DynamicObject)filterInfo.get("dimension");
                Long dimensionId = 0L;
                if (dimension != null) {
                    dimensionId = (Long)dimension.getPkValue();
                }
                List filterList = AnalyseSumReportHandle.this.getFilters(filterInfo);
                QFilter[] filters = filterList.toArray(new QFilter[0]);
                return srcData.reduceGroup((GroupReduceFunction)new CalculateDataFunction(srcData.getRowMeta(), filters, dimensionId));
            }
        });
    }

    public void transformResult(List<IDataTransform> transCollector, final ReportDataCtx ctx) {
        transCollector.add(new IDataTransform(){

            public DataSet doTransform(DataSet srcData) {
                RowMeta rowMeta = srcData.getRowMeta();
                Field actual_overdueday = rowMeta.getField("actual_overdueday", false);
                Field quota_overdueday = rowMeta.getField("quota_overdueday", false);
                Field tmp_overdueday = rowMeta.getField("tmp_overdueday", false);
                Field actual_overdueamt = rowMeta.getField("actual_overdueamt", false);
                Field quota_overdueamt = rowMeta.getField("quota_overdueamt", false);
                Field tmp_overdueamt = rowMeta.getField("tmp_overdueamt", false);
                Field availablequota_amt = rowMeta.getField("availablequota_amt", false);
                if (availablequota_amt != null || actual_overdueday != null && quota_overdueday != null && tmp_overdueday != null || actual_overdueamt != null && quota_overdueamt != null && tmp_overdueamt != null) {
                    StringBuilder str = new StringBuilder();
                    str.append("case");
                    if (availablequota_amt != null) {
                        str.append(" when availablequota_amt < 0 then 1 ");
                    }
                    if (actual_overdueday != null && quota_overdueday != null && tmp_overdueday != null) {
                        str.append(" when actual_overdueday > quota_overdueday + tmp_overdueday then 1 ");
                    }
                    if (actual_overdueamt != null && quota_overdueamt != null && tmp_overdueamt != null) {
                        str.append(" when actual_overdueamt > quota_overdueamt + tmp_overdueamt then 1 ");
                    }
                    str.append(" else 0 end ");
                    srcData = srcData.addField(str.toString(), "isover");
                    String quatoover = (String)ctx.getParam("quatoover");
                    if (quatoover != null && quatoover.split(",").length == 2) {
                        srcData = srcData.filter(String.format("isover = %s", quatoover.split(",")[1]));
                    }
                }
                return srcData;
            }
        });
    }
}

