/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.report.analysesum.function;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BigIntProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.ccm.business.analysesum.AnalyseSumOverdueBillQueryHelper;
import kd.scmc.ccm.business.core.Dimension;
import kd.scmc.ccm.business.core.DimensionValue;
import kd.scmc.ccm.business.core.Role;
import kd.scmc.ccm.business.scheme.BillStrategy;
import kd.scmc.ccm.business.scheme.CreditScheme;
import kd.scmc.ccm.business.scheme.SchemeReader;
import kd.scmc.ccm.business.service.CreditServiceFacade;
import kd.scmc.ccm.business.setting.DimensionEntryFieldMapper;
import kd.scmc.ccm.business.setting.DimensionReader;
import kd.scmc.ccm.business.setting.EntityConfig;
import kd.scmc.ccm.common.helper.CurrencyHelper;
import kd.scmc.ccm.common.util.DateUtils;

public class CalculateDataFunction
extends GroupReduceFunction {
    private RowMeta rowMeta;
    private Map<String, Integer> indexMap;
    private QFilter[] queryQFilters;
    private Long dimensionId;

    public CalculateDataFunction(RowMeta rowMeta, QFilter[] queryQFilters, Long dimensionId) {
        this.rowMeta = rowMeta;
        this.queryQFilters = queryQFilters;
        this.dimensionId = dimensionId;
        Field[] fields = rowMeta.getFields();
        if (this.indexMap == null) {
            this.indexMap = new HashMap<String, Integer>(fields.length);
        }
        for (int i = 0; i < fields.length; ++i) {
            this.indexMap.put(fields[i].getName(), i);
        }
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        Iterator<RowX> iterator = iterable.iterator();
        boolean flag = this.hasField(new String[]{"id", "checktype", "scheme", "dimensionvalue", "quota_amt", "quotatmp_amt", "reducesum_amt", "increasesum_amt", "availablequota_amt", "quota_overdueday", "tmp_overdueday", "actual_overdueday", "quota_overdueamt", "tmp_overdueamt", "actual_overdueamt"});
        if (flag) {
            HashMap<String, BigDecimal> tmpQuotaMap = new HashMap<String, BigDecimal>(16);
            HashMap<Long, DynamicObject> checkTypeMap = new HashMap<Long, DynamicObject>(16);
            HashMap<Long, CreditScheme> schemeMap = new HashMap<Long, CreditScheme>(16);
            HashMap<Long, Map<String, Object[]>> overdueBillsMap = new HashMap<Long, Map<String, Object[]>>(16);
            LinkedList<DimensionValue> dimensionValues = new LinkedList<DimensionValue>();
            QFilter tmpArchiveFilter = new QFilter("archivetype", "=", (Object)"temp");
            ArrayList<QFilter> tmpArchiveQueryFilter = new ArrayList<QFilter>(Arrays.asList(this.queryQFilters));
            tmpArchiveQueryFilter.add(tmpArchiveFilter);
            DynamicObjectCollection tmpArchiveCollection = QueryServiceHelper.query((String)"ccm_archive", (String)"id,scheme,dimensionvalue,relatedid,quota", (QFilter[])tmpArchiveQueryFilter.toArray(new QFilter[0]));
            for (DynamicObject tmpArchive : tmpArchiveCollection) {
                Long schemeId = tmpArchive.getLong("scheme");
                String dimensionValue = tmpArchive.getString("dimensionvalue");
                String tmpArchiveKey = schemeId + ":" + dimensionValue;
                if (tmpQuotaMap.get(tmpArchiveKey) != null) {
                    BigDecimal quotaSum = (BigDecimal)tmpQuotaMap.get(tmpArchiveKey);
                    BigDecimal quota = tmpArchive.getBigDecimal("quota");
                    tmpQuotaMap.put(tmpArchiveKey, quotaSum.add(quota));
                    continue;
                }
                BigDecimal quota = tmpArchive.getBigDecimal("quota");
                tmpQuotaMap.put(tmpArchiveKey, quota);
            }
            QFilter normalArchiveFilter = new QFilter("archivetype", "=", (Object)"normal");
            ArrayList<QFilter> normalArchiveQueryFilter = new ArrayList<QFilter>(Arrays.asList(this.queryQFilters));
            normalArchiveQueryFilter.add(normalArchiveFilter);
            DynamicObjectCollection normalArchiveCollection = QueryServiceHelper.query((String)"ccm_archive", (String)"id,dimensionvalue,quota", (QFilter[])normalArchiveQueryFilter.toArray(new QFilter[0]));
            DimensionReader dimensionReader = new DimensionReader();
            Dimension dimension = dimensionReader.getDimension(this.dimensionId.longValue());
            DimensionEntryFieldMapper dimensionEntryFieldMapper = new DimensionEntryFieldMapper((Object)dimension.getId());
            for (DynamicObject numberArchive : normalArchiveCollection) {
                DimensionValue dimensionValue = new DimensionValue(dimension);
                dimensionValue.setValue(numberArchive.getString("dimensionvalue"));
                dimensionValues.add(dimensionValue);
            }
            while (iterator.hasNext()) {
                String checkTypeNumber;
                CreditScheme scheme;
                DynamicObject checkType;
                RowX row = iterator.next();
                Integer archiveIdIndex = this.indexMap.get("id");
                Integer checkTypeIndex = this.indexMap.get("checktype");
                Integer schemeIndex = this.indexMap.get("scheme");
                Integer dimensionValueIndex = this.indexMap.get("dimensionvalue");
                Integer quotaAmtIndex = this.indexMap.get("quota_amt");
                Integer quotaTmpAmtIndex = this.indexMap.get("quotatmp_amt");
                Integer reduceSumAmtIndex = this.indexMap.get("reducesum_amt");
                Integer increaseSumAmtIndex = this.indexMap.get("increasesum_amt");
                Integer availableQuotaAmtIndex = this.indexMap.get("availablequota_amt");
                Integer quotaOverdueDayIndex = this.indexMap.get("quota_overdueday");
                Integer tmpOverdueDayIndex = this.indexMap.get("tmp_overdueday");
                Integer actualOverdueDayIndex = this.indexMap.get("actual_overdueday");
                Integer quotaOverdueAmtIndex = this.indexMap.get("quota_overdueamt");
                Integer tmpOverdueAmtIndex = this.indexMap.get("tmp_overdueamt");
                Integer actualOverdueAmtIndex = this.indexMap.get("actual_overdueamt");
                Long checkTypeId = (Long)row.get(checkTypeIndex.intValue());
                if (checkTypeMap.get(checkTypeId) != null) {
                    checkType = (DynamicObject)checkTypeMap.get(checkTypeId);
                } else {
                    checkType = BusinessDataServiceHelper.loadSingleFromCache((Object)checkTypeId, (String)"ccm_checktype");
                    checkTypeMap.put(checkTypeId, checkType);
                }
                Long schemeId = (Long)row.get(schemeIndex.intValue());
                if (schemeMap.get(schemeId) != null) {
                    scheme = (CreditScheme)schemeMap.get(schemeId);
                } else {
                    SchemeReader schemeReader = new SchemeReader();
                    scheme = schemeReader.getScheme(schemeId.longValue());
                    schemeMap.put(schemeId, scheme);
                }
                Long archiveId = (Long)row.get(archiveIdIndex.intValue());
                String archiveDimensionValue = (String)row.get(dimensionValueIndex.intValue());
                String tempArchiveKey = schemeId + ":" + archiveDimensionValue;
                BigDecimal quotaAmt = (BigDecimal)row.get(quotaAmtIndex.intValue());
                BigDecimal reduceSumAmt = (BigDecimal)row.get(reduceSumAmtIndex.intValue());
                BigDecimal increaseSumAmt = (BigDecimal)row.get(increaseSumAmtIndex.intValue());
                Map<String, Object[]> overdueBillsDataMap = new HashMap();
                if (checkType != null && ("KZFW002".equals(checkTypeNumber = checkType.getString("number")) || "KZFW006".equals(checkTypeNumber))) {
                    if (overdueBillsMap.get(schemeId) != null) {
                        overdueBillsDataMap = (Map)overdueBillsMap.get(schemeId);
                    } else if (scheme.getBillStrategies() != null && !scheme.getBillStrategies().isEmpty()) {
                        BillStrategy billStrategy = (BillStrategy)scheme.getBillStrategies().get(0);
                        String entityKey = billStrategy.getAssingEntityKey();
                        String calculateDate = billStrategy.getCalculateDate();
                        String calculateAmt = billStrategy.getCalculateAmt();
                        String assingEntityKey = billStrategy.getAssingEntityKey();
                        CreditServiceFacade facade = new CreditServiceFacade();
                        EntityConfig entityConfig = facade.getConfig(entityKey);
                        DataSet billDataSet = this.queryOverdueBills(scheme, dimension, dimensionValues, billStrategy).distinct();
                        for (Row billDataRow : billDataSet) {
                            Object[] overdueBillsData;
                            List roles = scheme.getDimension().getRoles();
                            DimensionValue dimensionValue = new DimensionValue(scheme.getDimension());
                            for (Role role : roles) {
                                DynamicObjectCollection cusunicodes;
                                String roleType;
                                QFilter q;
                                DynamicObject roleId;
                                MainEntityType assEntityType;
                                MainEntityType assEntityType2;
                                kd.scmc.ccm.business.core.Field field = entityConfig.getField(role.getElement());
                                String entryKey = field.getEntryKey();
                                String fullName = field.getFullName();
                                String baseDataKey = dimensionEntryFieldMapper.getBaseDataKey(role.getRoleType());
                                MainEntityType roleBDEntityType = MetadataServiceHelper.getDataEntityType((String)baseDataKey);
                                if (roleBDEntityType != null && roleBDEntityType.findProperty("masterid") != null && !((assEntityType2 = MetadataServiceHelper.getDataEntityType((String)assingEntityKey)).getProperty(fullName) instanceof BigIntProp)) {
                                    fullName = fullName + ".masterid";
                                }
                                StringBuilder fullNameStrBuf = new StringBuilder();
                                if (!StringUtils.isBlank((CharSequence)entryKey)) {
                                    fullNameStrBuf.append(entryKey).append('.');
                                }
                                fullNameStrBuf.append(fullName);
                                Object roleValue = billDataRow.get(fullNameStrBuf.toString());
                                if (roleBDEntityType != null && roleBDEntityType.findProperty("masterid") != null && (assEntityType = MetadataServiceHelper.getDataEntityType((String)assingEntityKey)).getProperty(fullName) instanceof BigIntProp && (roleId = QueryServiceHelper.queryOne((String)baseDataKey, (String)"masterid", (QFilter[])new QFilter[]{q = new QFilter("id", "=", roleValue)})) != null) {
                                    roleValue = roleId.getLong("masterid");
                                }
                                if ("CUSUNICODE".equals(roleType = role.getRoleType()) && (cusunicodes = QueryServiceHelper.query((String)"ccm_cusunicode", (String)"id,entry.e_customer", (QFilter[])new QFilter[]{new QFilter("entry.e_customer", "=", roleValue)})) != null && !cusunicodes.isEmpty()) {
                                    roleValue = ((DynamicObject)cusunicodes.get(0)).getLong("id");
                                }
                                dimensionValue.putValue(role, roleValue);
                            }
                            String dimensionString = dimensionValue.getValue();
                            Date billCalculateDate = new Date();
                            BigDecimal billCalculateAmt = BigDecimal.ZERO;
                            if (!StringUtils.isEmpty((CharSequence)calculateAmt)) {
                                billCalculateAmt = billDataRow.getBigDecimal(calculateAmt);
                                Long billcurrency = billDataRow.getLong("billcurrency");
                                Long schemeCurrency = scheme.getCurrency();
                                Long schemeExratetable = scheme.getExchangeRateTable();
                                if (schemeCurrency.longValue() != billcurrency.longValue()) {
                                    BigDecimal rate = CurrencyHelper.getExChangeRate((Long)billcurrency, (Long)schemeCurrency, (Long)schemeExratetable, (Date)new Date());
                                    billCalculateAmt = rate == null ? BigDecimal.ZERO : billCalculateAmt.multiply(rate);
                                }
                            } else {
                                billCalculateDate = billDataRow.getDate(calculateDate);
                            }
                            if (overdueBillsDataMap.get(dimensionString) != null) {
                                overdueBillsData = (Object[])overdueBillsDataMap.get(dimensionString);
                                Date maxOverdueBillsData = (Date)overdueBillsData[0];
                                if (maxOverdueBillsData.after(billCalculateDate)) {
                                    maxOverdueBillsData = billCalculateDate;
                                }
                                BigDecimal billCalculateAmtSum = (BigDecimal)overdueBillsData[1];
                                billCalculateAmtSum = billCalculateAmtSum.add(billCalculateAmt);
                                overdueBillsData[0] = maxOverdueBillsData;
                                overdueBillsData[1] = billCalculateAmtSum;
                            } else {
                                overdueBillsData = new Object[]{billCalculateDate, billCalculateAmt};
                            }
                            overdueBillsDataMap.put(dimensionString, overdueBillsData);
                        }
                        overdueBillsMap.put(schemeId, overdueBillsDataMap);
                    }
                }
                if (checkType != null) {
                    Object[] overdueBillsData;
                    checkTypeNumber = checkType.getString("number");
                    if ("KZFW001".equals(checkTypeNumber)) {
                        BigDecimal quotaTmpAmt = (BigDecimal)tmpQuotaMap.get(tempArchiveKey);
                        if (quotaTmpAmt == null) {
                            quotaTmpAmt = BigDecimal.ZERO;
                        }
                        BigDecimal availableQuotaAmt = quotaAmt.add(quotaTmpAmt).subtract(reduceSumAmt).add(increaseSumAmt);
                        row.set(quotaTmpAmtIndex.intValue(), (Object)quotaTmpAmt);
                        row.set(availableQuotaAmtIndex.intValue(), (Object)availableQuotaAmt);
                        row.set(quotaOverdueDayIndex.intValue(), (Object)BigDecimal.ZERO);
                        row.set(tmpOverdueDayIndex.intValue(), (Object)BigDecimal.ZERO);
                        row.set(actualOverdueDayIndex.intValue(), (Object)BigDecimal.ZERO);
                        row.set(quotaOverdueAmtIndex.intValue(), (Object)BigDecimal.ZERO);
                        row.set(tmpOverdueAmtIndex.intValue(), (Object)BigDecimal.ZERO);
                        row.set(actualOverdueAmtIndex.intValue(), (Object)BigDecimal.ZERO);
                    } else if ("KZFW002".equals(checkTypeNumber)) {
                        Date now;
                        Date overdueBillsDate;
                        int billOverdueDays;
                        BigDecimal tmpOverdueDay = (BigDecimal)tmpQuotaMap.get(tempArchiveKey);
                        if (tmpOverdueDay == null) {
                            tmpOverdueDay = BigDecimal.ZERO;
                        }
                        row.set(tmpOverdueDayIndex.intValue(), (Object)tmpOverdueDay);
                        overdueBillsData = (Object[])overdueBillsDataMap.get(archiveDimensionValue);
                        if (overdueBillsData != null && overdueBillsData[0] != null && (billOverdueDays = DateUtils.getDiffDays((Date)(overdueBillsDate = (Date)overdueBillsData[0]), (Date)(now = new Date()))) > 0) {
                            row.set(actualOverdueDayIndex.intValue(), (Object)new BigDecimal(billOverdueDays));
                        }
                        row.set(quotaAmtIndex.intValue(), (Object)BigDecimal.ZERO);
                        row.set(quotaTmpAmtIndex.intValue(), (Object)BigDecimal.ZERO);
                        row.set(reduceSumAmtIndex.intValue(), (Object)BigDecimal.ZERO);
                        row.set(increaseSumAmtIndex.intValue(), (Object)BigDecimal.ZERO);
                        row.set(availableQuotaAmtIndex.intValue(), (Object)BigDecimal.ZERO);
                        row.set(quotaOverdueAmtIndex.intValue(), (Object)BigDecimal.ZERO);
                        row.set(tmpOverdueAmtIndex.intValue(), (Object)BigDecimal.ZERO);
                        row.set(actualOverdueAmtIndex.intValue(), (Object)BigDecimal.ZERO);
                    } else if ("KZFW006".equals(checkTypeNumber)) {
                        BigDecimal tmpOverdueAmt = (BigDecimal)tmpQuotaMap.get(tempArchiveKey);
                        if (tmpOverdueAmt == null) {
                            tmpOverdueAmt = BigDecimal.ZERO;
                        }
                        row.set(tmpOverdueAmtIndex.intValue(), (Object)tmpOverdueAmt);
                        overdueBillsData = (Object[])overdueBillsDataMap.get(archiveDimensionValue);
                        if (overdueBillsData != null && overdueBillsData[1] != null) {
                            BigDecimal overdueBillsAmt = (BigDecimal)overdueBillsData[1];
                            row.set(actualOverdueAmtIndex.intValue(), (Object)overdueBillsAmt);
                        }
                        row.set(quotaAmtIndex.intValue(), (Object)BigDecimal.ZERO);
                        row.set(quotaTmpAmtIndex.intValue(), (Object)BigDecimal.ZERO);
                        row.set(reduceSumAmtIndex.intValue(), (Object)BigDecimal.ZERO);
                        row.set(increaseSumAmtIndex.intValue(), (Object)BigDecimal.ZERO);
                        row.set(availableQuotaAmtIndex.intValue(), (Object)BigDecimal.ZERO);
                        row.set(quotaOverdueDayIndex.intValue(), (Object)BigDecimal.ZERO);
                        row.set(tmpOverdueDayIndex.intValue(), (Object)BigDecimal.ZERO);
                        row.set(actualOverdueDayIndex.intValue(), (Object)BigDecimal.ZERO);
                    } else {
                        row.set(quotaAmtIndex.intValue(), (Object)BigDecimal.ZERO);
                        row.set(quotaTmpAmtIndex.intValue(), (Object)BigDecimal.ZERO);
                        row.set(reduceSumAmtIndex.intValue(), (Object)BigDecimal.ZERO);
                        row.set(increaseSumAmtIndex.intValue(), (Object)BigDecimal.ZERO);
                        row.set(availableQuotaAmtIndex.intValue(), (Object)BigDecimal.ZERO);
                        row.set(quotaOverdueDayIndex.intValue(), (Object)BigDecimal.ZERO);
                        row.set(tmpOverdueDayIndex.intValue(), (Object)BigDecimal.ZERO);
                        row.set(actualOverdueDayIndex.intValue(), (Object)BigDecimal.ZERO);
                        row.set(quotaOverdueAmtIndex.intValue(), (Object)BigDecimal.ZERO);
                        row.set(tmpOverdueAmtIndex.intValue(), (Object)BigDecimal.ZERO);
                        row.set(actualOverdueAmtIndex.intValue(), (Object)BigDecimal.ZERO);
                    }
                }
                collector.collect(row);
            }
        } else {
            while (iterator.hasNext()) {
                RowX next = iterator.next();
                collector.collect(next);
            }
        }
    }

    private DataSet queryOverdueBills(CreditScheme scheme, Dimension dimension, List<DimensionValue> dimensionValues, BillStrategy billStrategy) {
        LinkedList<String> selectors = new LinkedList<String>();
        selectors.add("id");
        AnalyseSumOverdueBillQueryHelper querier = new AnalyseSumOverdueBillQueryHelper();
        return querier.queryOverdueDayBills(scheme, dimension, dimensionValues, billStrategy, selectors);
    }

    private boolean hasField(String[] fields) {
        boolean flag = true;
        for (String field : fields) {
            if (this.indexMap.containsKey(field)) continue;
            flag = false;
            break;
        }
        return flag;
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }
}

