/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.report.archivechange;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.DataSetX;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.orm.query.QFilter;
import kd.bplat.scmc.report.conf.BigTableColConf;
import kd.bplat.scmc.report.conf.SrcBlockConf;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.bplat.scmc.report.core.tpl.IReportDataHandle;
import kd.scmc.ccm.business.setting.DimensionEntryFieldMapper;

public class ArchiveChangeReportHandle
implements IReportDataHandle {
    private DimensionEntryFieldMapper fieldMapper;
    private static String[] orderByFields = new String[]{"changedate", "role0", "role1", "role2", "role3", "billno", "scheme"};

    public void handleBlockDataSelectCols(Set<String> repoColFilter, SrcBlockConf blockConf, ReportDataCtx ctx) {
        Map repoColFullSrcColMap2 = blockConf.getRepoColFullSrcColMap();
        repoColFullSrcColMap2.putIfAbsent("billid", "id");
        Map repoColSrcColMap2 = blockConf.getRepoColSrcColMap();
        repoColSrcColMap2.putIfAbsent("billid", "id");
    }

    public void modifyBlocks(List<SrcBlockConf> blockCollector, ReportDataCtx ctx) {
        Map params = ctx.getParams();
        List<QFilter> filters = this.getFilters(params);
        for (SrcBlockConf srcBlockConf : blockCollector) {
            String srcEntity = srcBlockConf.getSrcEntity();
            if (!"ccm_archive_change".equalsIgnoreCase(srcEntity)) continue;
            QFilter dataFs = srcBlockConf.getDataFs();
            if (dataFs == null) {
                dataFs = QFilter.of((String)"1=1", (Object[])new Object[0]);
            }
            for (QFilter filter : filters) {
                dataFs.and(filter);
            }
            srcBlockConf.setDataFs(dataFs);
        }
    }

    public void setupCtx(ReportDataCtx ctx) {
        ctx.getShowKeyCols().add("billid");
        if (ctx.getSumKeyCols() != null && !ctx.getSumKeyCols().isEmpty() && ctx.getSumKeyCols().contains("billno")) {
            ctx.getSumKeyCols().add("billid");
            ctx.getSumKeyCols4Count().add("billid");
        }
        DynamicObject dimension = (DynamicObject)ctx.getParam("dimension");
        DimensionEntryFieldMapper fieldMapper = new DimensionEntryFieldMapper(dimension.getPkValue());
        List roleFieldKeys = fieldMapper.getRoleFieldKeys();
        List colConfs = ctx.getReportConf().getBigTableColConf();
        for (BigTableColConf colConf : colConfs) {
            if (!roleFieldKeys.contains(colConf.getCol())) continue;
            colConf.setColName(fieldMapper.getRoleDisplayName(colConf.getCol()).getLocaleValue());
        }
    }

    public List<AbstractReportColumn> buildShowColumn(List<AbstractReportColumn> cols, ReportDataCtx ctx) {
        DynamicObject dimension = (DynamicObject)ctx.getParam("dimension");
        this.fieldMapper = new DimensionEntryFieldMapper(dimension.getPkValue());
        cols.stream().forEach(d -> {
            if (((ReportColumn)d).getFieldKey().endsWith("_s")) {
                ((ReportColumn)d).setFieldType("basedata");
                d.setCaption(this.fieldMapper.getRoleDisplayName(((ReportColumn)d).getFieldKey().substring(0, ((ReportColumn)d).getFieldKey().indexOf(95))));
                ((ReportColumn)d).setRefBasedataProp(this.fieldMapper.getFieldBaseDataKey(((ReportColumn)d).getFieldKey().substring(0, ((ReportColumn)d).getFieldKey().indexOf(95))));
            }
            if (d.getCaption().getLocaleValue() != null && d.getCaption().getLocaleValue().contains(".")) {
                d.setCaption(new LocaleString(d.getCaption().getLocaleValue().replace(".", "")));
            }
        });
        ReportColumnGroup beforeDateGroup = this.buildReportColumnGroup(cols, "before_date", "begindatebefore", "enddatebefore");
        ReportColumnGroup nowDateGroup = this.buildReportColumnGroup(cols, "now_date", "begindate", "enddate");
        if (beforeDateGroup != null) {
            if (cols.size() - 3 >= 0) {
                cols.add(cols.size() - 3, (AbstractReportColumn)beforeDateGroup);
            } else {
                cols.add(cols.size(), (AbstractReportColumn)beforeDateGroup);
            }
        }
        if (nowDateGroup != null) {
            if (cols.size() - 3 >= 0) {
                cols.add(cols.size() - 3, (AbstractReportColumn)nowDateGroup);
            } else {
                cols.add(cols.size(), (AbstractReportColumn)nowDateGroup);
            }
        }
        return cols;
    }

    public void transFormAfterGroup(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        transCollector.add(new IDataXTransform(){

            public DataSetX doTransform(DataSetX srcData) {
                RowMeta rptRowMeta = srcData.getRowMeta();
                Field[] rptFields = rptRowMeta.getFields();
                HashMap<String, Integer> rptIndexMap = new HashMap<String, Integer>(rptFields.length);
                for (int i = 0; i < rptFields.length; ++i) {
                    rptIndexMap.put(rptFields[i].getName(), i);
                }
                for (String orderByField : orderByFields) {
                    if (rptIndexMap.get(orderByField) == null) continue;
                    srcData = "changedate".equals(orderByField) ? srcData.orderBy(new String[]{"changedate desc"}) : srcData.orderBy(new String[]{orderByField});
                }
                return srcData;
            }
        });
    }

    private List<QFilter> getFilters(Map<String, Object> filterInfo) {
        DynamicObject dimension;
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        if (filterInfo == null) {
            return filters;
        }
        DynamicObject scheme = (DynamicObject)filterInfo.get("scheme");
        if (scheme != null) {
            QFilter schemeFilter = new QFilter("scheme", "=", scheme.getPkValue());
            filters.add(schemeFilter);
        }
        if ((dimension = (DynamicObject)filterInfo.get("dimension")) != null) {
            DimensionEntryFieldMapper roleFieldMapper = new DimensionEntryFieldMapper((Object)((Long)dimension.getPkValue()));
            List roleNumbers = roleFieldMapper.getRoleNumbers();
            for (String roleNumber : roleNumbers) {
                List roleIds = (List)filterInfo.get(roleFieldMapper.getRoleFieldKey(roleNumber));
                if (roleIds == null || roleIds.isEmpty()) continue;
                filters.add(new QFilter("schemeentry." + roleFieldMapper.getRoleFieldKey(roleNumber), "in", (Object)roleIds));
            }
        }
        return filters;
    }

    private void buildDimensionColumnGroup(List<AbstractReportColumn> cols) {
        ReportColumnGroup group = new ReportColumnGroup();
        group.setFieldKey("dimension_group");
        group.setCaption(new LocaleString(ResManager.loadKDString((String)"\u4fe1\u63a7\u7ef4\u5ea6", (String)"ArchiveChangeReportHandle_2", (String)"scmc-ccm-report", (Object[])new Object[0])));
        List roleCols = cols.stream().filter(d -> ((ReportColumn)d).getFieldKey().startsWith("role")).collect(Collectors.toList());
        roleCols.stream().forEach(d -> d.setHideSingleColumnRow(false));
        cols.removeAll(roleCols);
        List numberCols = roleCols.stream().filter(d -> d.getCaption().getLocaleValue().endsWith(ResManager.loadKDString((String)"\u7f16\u7801", (String)"ArchiveChangeReportHandle_3", (String)"scmc-ccm-report", (Object[])new Object[0]))).collect(Collectors.toList());
        roleCols.removeAll(numberCols);
        int index = 0;
        for (AbstractReportColumn c : numberCols) {
            roleCols.add(index, c);
            index += 2;
        }
        group.getChildren().addAll(roleCols);
        int linetype_index = cols.indexOf(cols.stream().filter(d -> ((ReportColumn)d).getFieldKey().equals("linetype")).findFirst().get());
        cols.add(linetype_index + 1, (AbstractReportColumn)group);
    }

    private ReportColumnGroup buildReportColumnGroup(List<AbstractReportColumn> cols, String prefix, String beginDate, String endDate) {
        ReportColumnGroup group = new ReportColumnGroup();
        group.setFieldKey(String.format("%s_group", prefix));
        String columnName = "";
        if ("before_date".equals(prefix)) {
            columnName = ResManager.loadKDString((String)"\u539f\u751f\u6548\u65e5\u671f\u8303\u56f4", (String)"ArchiveChangeReportHandle_0", (String)"scmc-ccm-report", (Object[])new Object[0]);
        } else if ("now_date".equals(prefix)) {
            columnName = ResManager.loadKDString((String)"\u65b0\u751f\u6548\u65e5\u671f\u8303\u56f4", (String)"ArchiveChangeReportHandle_1", (String)"scmc-ccm-report", (Object[])new Object[0]);
        }
        group.setCaption(new LocaleString(columnName));
        List prefixCols = cols.stream().filter(d -> !(d instanceof ReportColumnGroup)).filter(d -> ((ReportColumn)d).getFieldKey().equals(beginDate) || ((ReportColumn)d).getFieldKey().equals(endDate)).collect(Collectors.toList());
        if (prefixCols == null || prefixCols.isEmpty()) {
            return null;
        }
        cols.removeAll(prefixCols);
        group.getChildren().addAll(prefixCols);
        return group;
    }
}

