/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.report.overdue;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.DataSetInput;
import kd.bos.algox.AlgoX;
import kd.bos.algox.DataSetX;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.JobSession;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bplat.scmc.report.conf.BigTableColConf;
import kd.bplat.scmc.report.conf.SrcBlockConf;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataTransform;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.bplat.scmc.report.core.tpl.IReportDataHandle;
import kd.scmc.ccm.business.analysesum.OverdueQueryHelper;
import kd.scmc.ccm.business.core.Dimension;
import kd.scmc.ccm.business.core.DimensionValue;
import kd.scmc.ccm.business.scheme.BillStrategy;
import kd.scmc.ccm.business.scheme.CreditScheme;
import kd.scmc.ccm.business.scheme.SchemeReader;
import kd.scmc.ccm.business.setting.DimensionEntryFieldMapper;
import kd.scmc.ccm.business.setting.DimensionReader;
import kd.scmc.ccm.common.enums.StatusEnum;
import kd.scmc.ccm.common.util.DateUtils;
import kd.scmc.ccm.report.overdue.function.ModifyUnionDataFunction;

public class OverdueReportHandle
implements IReportDataHandle {
    private DimensionEntryFieldMapper fieldMapper;

    public void modifyBlocks(List<SrcBlockConf> blockCollector, ReportDataCtx ctx) {
        Map params = ctx.getParams();
        for (SrcBlockConf srcBlockConf : blockCollector) {
            String srcEntity = srcBlockConf.getSrcEntity();
            if (!"ccm_archive".equalsIgnoreCase(srcEntity)) continue;
            List<QFilter> filters = this.getFilters(params);
            QFilter dataFs = srcBlockConf.getDataFs();
            if (dataFs == null) {
                dataFs = QFilter.of((String)"1=1", (Object[])new Object[0]);
            }
            for (QFilter filter : filters) {
                dataFs.and(filter);
            }
            srcBlockConf.setDataFs(dataFs);
        }
    }

    private List<QFilter> getFilters(Map<String, Object> filterInfo) {
        QFilter schemeFilter;
        DynamicObjectCollection scheme;
        Date today;
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        if (filterInfo == null) {
            return filters;
        }
        DynamicObject dimension = (DynamicObject)filterInfo.get("dimension");
        if (dimension != null) {
            filters.add(new QFilter("dimension", "=", dimension.getPkValue()));
        }
        if ((today = (Date)filterInfo.get("today")) != null) {
            QFilter beginDateFilter = new QFilter("begindate", "<=", (Object)DateUtils.getEndOfDay((Date)today));
            QFilter endDateFilter = new QFilter("enddate", ">=", (Object)DateUtils.getStartOfDay((Date)today));
            filters.add(beginDateFilter);
            filters.add(endDateFilter);
        }
        if ((scheme = (DynamicObjectCollection)filterInfo.get("scheme")).size() > 0) {
            schemeFilter = new QFilter("scheme", "in", scheme.stream().map(d -> d.getLong("fbasedataid.id")).collect(Collectors.toList()));
            filters.add(schemeFilter);
        } else {
            schemeFilter = new QFilter("scheme.checktype.number", "in", (Object)new String[]{"KZFW002", "KZFW006"}).and(new QFilter("scheme.status", "=", (Object)StatusEnum.AUDIT.getValue()));
            filters.add(schemeFilter);
        }
        DynamicObjectCollection currency = (DynamicObjectCollection)filterInfo.get("currency");
        if (currency != null && currency.size() > 0) {
            QFilter currencyFilter = new QFilter("scheme.currency", "in", currency.stream().map(d -> d.getLong("fbasedataid.id")).collect(Collectors.toList()));
            filters.add(currencyFilter);
        }
        return filters;
    }

    public void setupCtx(ReportDataCtx ctx) {
        ctx.getShowKeyCols().add("billno");
        ctx.getShowKeyCols().add("billkey");
        ctx.getShowKeyCols().add("dimensionvalue");
        ctx.getShowKeyCols().add("billcurrency");
        DynamicObject dimension = (DynamicObject)ctx.getParam("dimension");
        DimensionEntryFieldMapper fieldMapper = new DimensionEntryFieldMapper(dimension.getPkValue());
        List roleFieldKeys = fieldMapper.getRoleFieldKeys();
        List colConfs = ctx.getReportConf().getBigTableColConf();
        for (BigTableColConf colConf : colConfs) {
            if (!roleFieldKeys.contains(colConf.getCol())) continue;
            colConf.setColName(fieldMapper.getRoleDisplayName(colConf.getCol()).getLocaleValue());
        }
    }

    public List<AbstractReportColumn> buildShowColumn(List<AbstractReportColumn> cols, ReportDataCtx ctx) {
        DynamicObject dimension = (DynamicObject)ctx.getParam("dimension");
        this.fieldMapper = new DimensionEntryFieldMapper(dimension.getPkValue());
        cols.stream().forEach(d -> {
            if (((ReportColumn)d).getFieldKey().endsWith("_s")) {
                ((ReportColumn)d).setFieldType("basedata");
                d.setCaption(this.fieldMapper.getRoleDisplayName(((ReportColumn)d).getFieldKey().substring(0, ((ReportColumn)d).getFieldKey().indexOf(95))));
                ((ReportColumn)d).setRefBasedataProp(this.fieldMapper.getFieldBaseDataKey(((ReportColumn)d).getFieldKey().substring(0, ((ReportColumn)d).getFieldKey().indexOf(95))));
            }
            if (d.getCaption().getLocaleValue() != null && d.getCaption().getLocaleValue().contains(".")) {
                d.setCaption(new LocaleString(d.getCaption().getLocaleValue().replace(".", "")));
            }
        });
        this.buildDimensionColumnGroup(cols);
        return cols;
    }

    private void buildDimensionColumnGroup(List<AbstractReportColumn> cols) {
        ReportColumnGroup group = new ReportColumnGroup();
        group.setFieldKey("dimension_group");
        group.setCaption(new LocaleString(ResManager.loadKDString((String)"\u4fe1\u63a7\u7ef4\u5ea6", (String)"OverdueReportHandle_2", (String)"scmc-ccm-report", (Object[])new Object[0])));
        List roleCols = cols.stream().filter(d -> ((ReportColumn)d).getFieldKey().startsWith("role")).collect(Collectors.toList());
        roleCols.stream().forEach(d -> d.setHideSingleColumnRow(false));
        cols.removeAll(roleCols);
        List numberCols = roleCols.stream().filter(d -> d.getCaption().getLocaleValue().endsWith(ResManager.loadKDString((String)"\u7f16\u7801", (String)"OverdueReportHandle_0", (String)"scmc-ccm-report", (Object[])new Object[0]))).collect(Collectors.toList());
        roleCols.removeAll(numberCols);
        int index = 0;
        for (AbstractReportColumn c : numberCols) {
            roleCols.add(index, c);
            index += 2;
        }
        group.getChildren().addAll(roleCols);
        int linetype_index = cols.indexOf(cols.stream().filter(d -> ((ReportColumn)d).getFieldKey().equals("linetype")).findFirst().get());
        cols.add(linetype_index + 1, (AbstractReportColumn)group);
    }

    public void transFormAfterUnion(List<IDataXTransform> transCollector, final ReportDataCtx ctx) {
        transCollector.add(new IDataXTransform(){

            public DataSetX doTransform(DataSetX srcData) {
                Map filterInfo = ctx.getParams();
                DynamicObject dimensionDynamicObject = (DynamicObject)filterInfo.get("dimension");
                Long dimensionId = 0L;
                if (dimensionDynamicObject != null) {
                    dimensionId = (Long)dimensionDynamicObject.getPkValue();
                }
                List filterList = OverdueReportHandle.this.getFilters(filterInfo);
                List roleFilterList = (List)ctx.getParam("roleFilterList");
                if (roleFilterList != null && roleFilterList.size() > 0) {
                    filterList.addAll(roleFilterList);
                }
                QFilter[] filters = filterList.toArray(new QFilter[0]);
                HashMap<Long, BigDecimal> tmpQuotaMap = new HashMap<Long, BigDecimal>(16);
                HashMap<Long, ArrayList<DimensionValue>> dimensionValuesMap = new HashMap<Long, ArrayList<DimensionValue>>(16);
                HashMap normalQuotaMap = new HashMap(16);
                HashMap<Long, CreditScheme> schemeMap = new HashMap<Long, CreditScheme>(16);
                HashMap<Long, DynamicObject> schemeDynamicObjectMap = new HashMap<Long, DynamicObject>(16);
                QFilter tmpArchiveFilter = new QFilter("archivetype", "=", (Object)"temp");
                ArrayList<QFilter> tmpArchiveQueryFilter = new ArrayList<QFilter>(Arrays.asList(filters));
                tmpArchiveQueryFilter.add(tmpArchiveFilter);
                DynamicObjectCollection tmpArchiveCollection = QueryServiceHelper.query((String)"ccm_archive", (String)"id,relatedid,quota", (QFilter[])tmpArchiveQueryFilter.toArray(new QFilter[0]));
                for (DynamicObject tmpArchive : tmpArchiveCollection) {
                    Long relatedId = tmpArchive.getLong("relatedid");
                    if (tmpQuotaMap.get(relatedId) != null) {
                        BigDecimal quotaSum = (BigDecimal)tmpQuotaMap.get(relatedId);
                        BigDecimal quota = tmpArchive.getBigDecimal("quota");
                        tmpQuotaMap.put(relatedId, quotaSum.add(quota));
                        continue;
                    }
                    BigDecimal quota = tmpArchive.getBigDecimal("quota");
                    tmpQuotaMap.put(relatedId, quota);
                }
                QFilter normalArchiveFilter = new QFilter("archivetype", "=", (Object)"normal");
                ArrayList<QFilter> normalArchiveQueryFilter = new ArrayList<QFilter>(Arrays.asList(filters));
                normalArchiveQueryFilter.add(normalArchiveFilter);
                DynamicObjectCollection normalArchiveCollection = QueryServiceHelper.query((String)"ccm_archive", (String)"id,scheme.id,dimensionvalue,quota", (QFilter[])normalArchiveQueryFilter.toArray(new QFilter[0]));
                DimensionReader dimensionReader = new DimensionReader();
                Dimension dimension = dimensionReader.getDimension(dimensionId.longValue());
                DimensionEntryFieldMapper dimensionEntryFieldMapper = new DimensionEntryFieldMapper((Object)dimension.getId());
                for (DynamicObject normalArchive : normalArchiveCollection) {
                    Long schemeId = normalArchive.getLong("scheme.id");
                    if (schemeMap.get(schemeId) == null) {
                        SchemeReader schemeReader = new SchemeReader();
                        CreditScheme scheme = schemeReader.getScheme(schemeId.longValue());
                        schemeMap.put(schemeId, scheme);
                        DynamicObject schemeDynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)schemeId, (String)"ccm_scheme");
                        schemeDynamicObjectMap.put(schemeId, schemeDynamicObject);
                    }
                    String dimensionValueString = normalArchive.getString("dimensionvalue");
                    DimensionValue dimensionValue = new DimensionValue(dimension);
                    dimensionValue.setValue(dimensionValueString);
                    ArrayList<DimensionValue> dimensionValues = (ArrayList<DimensionValue>)dimensionValuesMap.get(schemeId);
                    if (dimensionValues == null) {
                        dimensionValues = new ArrayList<DimensionValue>();
                    }
                    dimensionValues.add(dimensionValue);
                    dimensionValuesMap.put(schemeId, dimensionValues);
                    Long id = normalArchive.getLong("id");
                    HashMap<String, Object[]> normalArchiveData = (HashMap<String, Object[]>)normalQuotaMap.get(schemeId);
                    if (normalArchiveData == null) {
                        normalArchiveData = new HashMap<String, Object[]>();
                    }
                    Object[] normalArchiveDataValue = new Object[]{id, normalArchive.getBigDecimal("quota")};
                    normalArchiveData.put(dimensionValueString, normalArchiveDataValue);
                    normalQuotaMap.put(schemeId, normalArchiveData);
                }
                Set billMainEntity = (Set)filterInfo.get("billMainEntity");
                if (!schemeMap.isEmpty()) {
                    for (Map.Entry entryScheme : schemeMap.entrySet()) {
                        List dimensionValues;
                        CreditScheme scheme = (CreditScheme)entryScheme.getValue();
                        Long schemeId = (Long)entryScheme.getKey();
                        if (scheme.getBillStrategies() == null || scheme.getBillStrategies().isEmpty()) continue;
                        BillStrategy billStrategy = (BillStrategy)scheme.getBillStrategies().get(0);
                        String entityKey = billStrategy.getAssingEntityKey();
                        if (!billMainEntity.isEmpty() && !billMainEntity.contains(entityKey) || (dimensionValues = (List)dimensionValuesMap.get(schemeId)) == null) continue;
                        DataSet billDataSet = OverdueReportHandle.this.queryOverdueBills(scheme, dimension, dimensionValues, billStrategy).distinct();
                        Long checkTypeId = ((DynamicObject)schemeDynamicObjectMap.get(schemeId)).getLong("checktype.id");
                        DataSetInput dataSetInput = new DataSetInput(billDataSet);
                        JobSession buildSession = AlgoX.createSession((String)("OverdueReportHandle" + schemeId));
                        DataSetX resultX = buildSession.fromInput((Input)dataSetInput);
                        DataSetX result = resultX.reduceGroup((GroupReduceFunction)new ModifyUnionDataFunction(srcData.getRowMeta(), resultX.getRowMeta(), schemeId, checkTypeId, (Map)normalQuotaMap.get(schemeId), tmpQuotaMap));
                        srcData = srcData.union(result);
                    }
                }
                return srcData;
            }
        });
    }

    public void transFormAfterGroup(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        transCollector.add(new IDataXTransform(){

            public DataSetX doTransform(DataSetX srcData) {
                RowMeta rptRowMeta = srcData.getRowMeta();
                Field[] rptFields = rptRowMeta.getFields();
                HashMap<String, Integer> rptIndexMap = new HashMap<String, Integer>(rptFields.length);
                for (int i = 0; i < rptFields.length; ++i) {
                    rptIndexMap.put(rptFields[i].getName(), i);
                }
                if (rptIndexMap.get("role0") != null) {
                    srcData = srcData.orderBy(new String[]{"role0"});
                }
                if (rptIndexMap.get("role1") != null) {
                    srcData = srcData.orderBy(new String[]{"role1"});
                }
                if (rptIndexMap.get("role2") != null) {
                    srcData = srcData.orderBy(new String[]{"role2"});
                }
                if (rptIndexMap.get("role3") != null) {
                    srcData = srcData.orderBy(new String[]{"role3"});
                }
                if (rptIndexMap.get("billkey") != null) {
                    srcData = srcData.orderBy(new String[]{"billkey"});
                }
                if (rptIndexMap.get("billno") != null) {
                    srcData = srcData.orderBy(new String[]{"billno"});
                }
                if (rptIndexMap.get("entryseq") != null) {
                    srcData = srcData.orderBy(new String[]{"entryseq"});
                }
                if (rptIndexMap.get("scheme") != null) {
                    srcData = srcData.orderBy(new String[]{"scheme"});
                }
                return srcData;
            }
        });
    }

    private DataSet queryOverdueBills(CreditScheme scheme, Dimension dimension, List<DimensionValue> dimensionValues, BillStrategy billStrategy) {
        LinkedList<String> selectors = new LinkedList<String>();
        selectors.add("id");
        OverdueQueryHelper querier = new OverdueQueryHelper();
        return querier.queryOverdueBills(scheme, dimension, dimensionValues, billStrategy, selectors);
    }

    public void transformResult(List<IDataTransform> transCollector, final ReportDataCtx ctx) {
        transCollector.add(new IDataTransform(){

            public DataSet doTransform(DataSet srcData) {
                String quatoover = (String)ctx.getParam("quatoover");
                if (quatoover != null && quatoover.split(",").length == 2) {
                    srcData = srcData.filter(String.format("isover = '%s'", quatoover.split(",")[1]));
                }
                return srcData;
            }
        });
    }
}

