/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.report.overdue;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.events.CellStyleRule;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bplat.scmc.report.conf.BigTableColConf;
import kd.bplat.scmc.report.conf.ReportConf;
import kd.bplat.scmc.report.core.ReportDataHandle;
import kd.bplat.scmc.report.util.ReportUtil;
import kd.scmc.ccm.business.core.Dimension;
import kd.scmc.ccm.business.core.Field;
import kd.scmc.ccm.business.core.Role;
import kd.scmc.ccm.business.scheme.BillStrategy;
import kd.scmc.ccm.business.scheme.CreditScheme;
import kd.scmc.ccm.business.service.CreditServiceFacade;
import kd.scmc.ccm.business.setting.DimensionEntryFieldMapper;
import kd.scmc.ccm.business.setting.DimensionReader;
import kd.scmc.ccm.business.setting.EntityConfig;
import kd.scmc.ccm.common.enums.StatusEnum;

public class OverdueReportPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    private static final String KEY_ANALYSE_SUM = "ccm_overdue_new_rpt";
    private static final String KEY_DIMENSION_S = "dimension_s";
    private static final String KEY_QUERY_DIMENSION = "now_query_dimension";
    private CreditServiceFacade facade = new CreditServiceFacade();

    public void registerListener(EventObject e) {
        BasedataEdit billMainEntity;
        super.registerListener(e);
        BasedataEdit schema = (BasedataEdit)this.getView().getControl("schema_s");
        if (schema != null) {
            schema.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((billMainEntity = (BasedataEdit)this.getView().getControl("billmainentity_s")) != null) {
            billMainEntity.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void initialize() {
        super.initialize();
        MulBasedataEdit role0 = (MulBasedataEdit)this.getView().getControl("role0_s");
        role0.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit role1 = (MulBasedataEdit)this.getView().getControl("role1_s");
        role1.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit role2 = (MulBasedataEdit)this.getView().getControl("role2_s");
        role2.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit role3 = (MulBasedataEdit)this.getView().getControl("role3_s");
        role3.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String name = e.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        DynamicObject dimension = (DynamicObject)this.getModel().getValue(KEY_DIMENSION_S);
        if (dimension == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6307\u5b9a\u4fe1\u63a7\u7ef4\u5ea6\u3002", (String)"OverdueReportPlugin_0", (String)"scmc-ccm-report", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        if ("schema_s".equals(name)) {
            QFilter filter1 = new QFilter("dimension.id", "=", dimension.getPkValue());
            QFilter filter2 = new QFilter("checktype.number", "in", (Object)new String[]{"KZFW002", "KZFW006"});
            QFilter filter3 = new QFilter("status", "=", (Object)StatusEnum.AUDIT.getValue());
            showParameter.getListFilterParameter().getQFilters().add(filter1.and(filter2).and(filter3));
        } else if ("billmainentity_s".equals(name)) {
            ArrayList<Long> billStrategyIds = new ArrayList<Long>();
            DynamicObject[] schemas = this.getSchemas();
            if (schemas != null && schemas.length > 0) {
                for (DynamicObject dynamicObject : schemas) {
                    if (dynamicObject.getDynamicObjectCollection("entry") == null || dynamicObject.getDynamicObjectCollection("entry").isEmpty()) continue;
                    billStrategyIds.add((Long)((DynamicObject)dynamicObject.getDynamicObjectCollection("entry").get(0)).getDynamicObject("billstrategy").getPkValue());
                }
            }
            if (!billStrategyIds.isEmpty()) {
                QFilter billStrategyFilter = new QFilter("id", "in", billStrategyIds);
                DynamicObject[] billEntrys = BusinessDataServiceHelper.load((String)"ccm_billstrategy", (String)"assingentity", (QFilter[])new QFilter[]{billStrategyFilter});
                if (billEntrys != null && billEntrys.length > 0) {
                    ArrayList<String> billEntryIds = new ArrayList<String>();
                    for (DynamicObject billEntry : billEntrys) {
                        DynamicObject assingEntity = billEntry.getDynamicObject("assingentity");
                        if (assingEntity == null) continue;
                        billEntryIds.add((String)assingEntity.getPkValue());
                    }
                    QFilter qFilter = new QFilter("id", "in", billEntryIds);
                    showParameter.getListFilterParameter().getQFilters().add(qFilter);
                } else {
                    QFilter filter = new QFilter("1", "!=", (Object)1);
                    showParameter.getListFilterParameter().getQFilters().add(filter);
                }
            } else {
                QFilter filter = new QFilter("1", "!=", (Object)1);
                showParameter.getListFilterParameter().getQFilters().add(filter);
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.dimensionChange();
    }

    private void dimensionChange() {
        IDataModel model = this.getModel();
        IReportView view = this.getView();
        model.setValue("schema_s", null);
        model.setValue("currency_s", null);
        model.setValue("billmainentity_s", null);
        model.setValue("quatoover_s", null);
        DynamicObject dimension = (DynamicObject)model.getValue(KEY_DIMENSION_S);
        List<String> allFilterControlKeys = this.getAllFilterControlKeys();
        for (String key : allFilterControlKeys) {
            this.getModel().setValue(key, null);
        }
        LinkedList<String> visiableKeys = new LinkedList<String>();
        List<String> unvisiableKeys = allFilterControlKeys;
        List roleNumbers = new ArrayList();
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>(16);
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("commonfs");
        List baseFilterColumns = filterGrid.getFilterColumns().stream().filter(d -> !((String)d.get("fieldName")).startsWith("role") && !((String)d.get("fieldName")).equals("isover")).collect(Collectors.toList());
        filterGrid.setFilterColumns(baseFilterColumns);
        this.getView().updateView("commonfs");
        if (dimension != null) {
            this.getPageCache().put("dimensionid", dimension.getString("id"));
            DimensionEntryFieldMapper mapper = new DimensionEntryFieldMapper(dimension.getPkValue());
            roleNumbers = mapper.getRoleNumbers();
            for (String roleNumer : roleNumbers) {
                String roleFilterKey = mapper.getRoleFilterKey(roleNumer);
                visiableKeys.add(roleFilterKey);
                unvisiableKeys.remove(roleFilterKey);
                LocaleString roleDisplayName = mapper.getRoleDisplayName(mapper.getRoleFieldKey(roleNumer));
                FieldEdit control = (FieldEdit)this.getControl(roleFilterKey);
                control.setCaption(roleDisplayName);
                ((DynamicProperty)control.getProperty()).setDisplayName(roleDisplayName);
                combos.add(new ComboItem(roleDisplayName, mapper.getRoleFieldKey(roleNumer)));
                this.getModel().setValue(roleFilterKey, null);
            }
        } else {
            this.getPageCache().remove("dimensionid");
        }
        combos.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u63a7\u5236\u7ec4\u7ec7\u8303\u56f4", (String)"OverdueReportPlugin_1", (String)"scmc-ccm-report", (Object[])new Object[0])), "orgscope"));
        combos.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u4fe1\u63a7\u65b9\u6848", (String)"OverdueReportPlugin_2", (String)"scmc-ccm-report", (Object[])new Object[0])), "scheme"));
        combos.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5e01\u79cd", (String)"OverdueReportPlugin_3", (String)"scmc-ccm-report", (Object[])new Object[0])), "currency"));
        combos.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5206\u5f55\u5e8f\u53f7", (String)"OverdueReportPlugin_4", (String)"scmc-ccm-report", (Object[])new Object[0])), "entryseq"));
        combos.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u4fe1\u63a7\u5f62\u5f0f", (String)"OverdueReportPlugin_5", (String)"scmc-ccm-report", (Object[])new Object[0])), "checktype"));
        if (!visiableKeys.isEmpty()) {
            view.setVisible(Boolean.TRUE, visiableKeys.toArray(new String[0]));
        }
        if (!unvisiableKeys.isEmpty()) {
            view.setVisible(Boolean.FALSE, unvisiableKeys.toArray(new String[0]));
        }
        ComboEdit item = (ComboEdit)this.getView().getControl("showkeycols");
        ComboEdit sumkeycols = (ComboEdit)this.getView().getControl("sumkeycols");
        item.setComboItems(combos);
        StringBuilder selectedCols = new StringBuilder();
        combos.stream().forEach(d -> selectedCols.append(d.getValue()).append(','));
        this.getModel().setValue("showkeycols", (Object)selectedCols);
        sumkeycols.setComboItems(combos);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "dimension_s": {
                this.dimensionChange();
                break;
            }
            case "showkeycols": {
                IDataModel model = this.getModel();
                Set sumKeyCols = ReportUtil.parseCombColVal((IDataModel)model, (String)"sumkeycols");
                Set showKeyCols = ReportUtil.parseCombColVal((IDataModel)model, (String)"showkeycols");
                this.fillComboItem("sumkeycols", colConf -> showKeyCols.contains(colConf.getCol()));
                boolean result = sumKeyCols.retainAll(showKeyCols);
                if (!result) break;
                model.setValue("sumkeycols", sumKeyCols.isEmpty() ? null : "," + org.apache.commons.lang3.StringUtils.join((Iterable)sumKeyCols, (String)",") + ",");
                break;
            }
            case "schema_s": {
                this.getModel().setValue("billmainentity_s", null);
                DynamicObjectCollection schemacol = (DynamicObjectCollection)this.getModel().getValue("schema_s");
                if (schemacol.size() > 0) {
                    List schemeIds = schemacol.stream().map(d -> d.getLong("fbasedataid.id")).collect(Collectors.toList());
                    QFilter idFilter = new QFilter("id", "in", schemeIds);
                    boolean checkformula = true;
                    boolean checkassingday = true;
                    boolean checkassingbalance = true;
                    this.fillComboItem("showqtycols", colConf -> this.showqtyFilter(colConf, checkformula, checkassingday, checkassingbalance));
                    this.fillDefVals("showqtycols", colConf -> this.showqtyFilter(colConf, checkformula, checkassingday, checkassingbalance));
                    break;
                }
                this.fillComboItem("showqtycols", colConf -> this.showqtyFilter(colConf, true, true, true));
                this.fillDefVals("showqtycols", colConf -> this.showqtyFilter(colConf, true, true, true));
                break;
            }
        }
    }

    private List<String> getAllFilterControlKeys() {
        LinkedList<String> filterControlKeys = new LinkedList<String>();
        MainEntityType dataEntityType = this.getModel().getDataEntityType();
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        for (IDataEntityProperty prop : properties) {
            if (!(prop instanceof MulBasedataProp) || !prop.getName().startsWith("role")) continue;
            filterControlKeys.add(prop.getName());
        }
        return filterControlKeys;
    }

    private void fillComboItem(String comboCol, ColFilter filter) {
        ReportConf conf = ReportDataHandle.loadReportConf((String)this.getModel().getDataEntityType().getName());
        DynamicObject dimension = (DynamicObject)this.getModel().getValue(KEY_DIMENSION_S);
        if (dimension == null) {
            return;
        }
        DimensionEntryFieldMapper fieldMapper = new DimensionEntryFieldMapper(dimension.getPkValue());
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>(16);
        List bigTableColConfs = conf.getBigTableColConf();
        for (BigTableColConf colConf : bigTableColConfs) {
            if (fieldMapper.getRoleFieldKeys().contains(colConf.getCol())) {
                colConf.setColName(fieldMapper.getRoleDisplayName(colConf.getCol()).getLocaleValue());
            }
            if (!filter.filter(colConf)) continue;
            combos.add(new ComboItem(new LocaleString(colConf.getColName()), colConf.getCol()));
        }
        ComboEdit item = (ComboEdit)this.getView().getControl(comboCol);
        item.setComboItems(combos);
    }

    private boolean showqtyFilter(BigTableColConf colConf, boolean checkformula, boolean checkassingday, boolean checkassingbalance) {
        boolean filter = "B".equals(colConf.getCalType());
        boolean andFilter = false;
        if (checkformula) {
            boolean bl = andFilter = andFilter || colConf.getCol().endsWith("_amt");
        }
        if (checkassingday) {
            boolean bl = andFilter = andFilter || colConf.getCol().endsWith("_overdueday");
        }
        if (checkassingbalance) {
            andFilter = andFilter || colConf.getCol().endsWith("_overdueamt");
        }
        return filter && andFilter;
    }

    private void fillDefVals(String comboCol, ColFilter filter) {
        ReportConf conf = ReportDataHandle.loadReportConf((String)this.getModel().getDataEntityType().getName());
        List bigTableColConfs = conf.getBigTableColConf();
        StringBuilder selectedCols = new StringBuilder();
        int i = 0;
        for (BigTableColConf colConf : bigTableColConfs) {
            if (!filter.filter(colConf) || !colConf.isDefShow()) continue;
            if (i > 0) {
                selectedCols.append(',');
            }
            selectedCols.append(colConf.getCol());
            ++i;
        }
        this.getModel().setValue(comboCol, (Object)selectedCols.toString());
    }

    private DynamicObject[] getSchemas() {
        QFilter schemaFilter;
        DynamicObjectCollection schemaCollection = (DynamicObjectCollection)this.getModel().getValue("schema_s");
        if (schemaCollection == null || schemaCollection.isEmpty()) {
            DynamicObject dimension = (DynamicObject)this.getModel().getValue(KEY_DIMENSION_S);
            QFilter filter1 = new QFilter("dimension", "=", dimension.getPkValue());
            QFilter filter2 = new QFilter("checktype.number", "in", (Object)new String[]{"KZFW002", "KZFW006"});
            schemaFilter = filter1.and(filter2);
        } else {
            List schemaIds = schemaCollection.stream().map(d -> d.getLong("fbasedataid.id")).collect(Collectors.toList());
            schemaFilter = new QFilter("id", "in", schemaIds);
        }
        QFilter statusFilter = new QFilter("status", "=", (Object)StatusEnum.AUDIT.getValue());
        DynamicObject[] schemas = BusinessDataServiceHelper.load((String)"ccm_scheme", (String)"id,currency,entry.billstrategy", (QFilter[])new QFilter[]{schemaFilter, statusFilter});
        return schemas;
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        super.getEntityType(e);
        MainEntityType originalEntityType = e.getOriginalEntityType();
        String dimensionIdStr = this.getPageCache().get("dimensionid");
        if (StringUtils.isBlank((CharSequence)dimensionIdStr)) {
            return;
        }
        MainEntityType newEntityType = null;
        try {
            newEntityType = (MainEntityType)originalEntityType.clone();
        }
        catch (CloneNotSupportedException e1) {
            throw new RuntimeException(e1);
        }
        DimensionEntryFieldMapper dimensionEntryFieldMapper = new DimensionEntryFieldMapper((Object)Long.valueOf(dimensionIdStr));
        List roleNumbers = dimensionEntryFieldMapper.getRoleNumbers();
        for (String roleNumber : roleNumbers) {
            String fieldTypeKey = dimensionEntryFieldMapper.getFieldTypeKey(roleNumber);
            String baseDataKey = dimensionEntryFieldMapper.getBaseDataKey(fieldTypeKey);
            String roleFilterKey = dimensionEntryFieldMapper.getRoleFilterKey(roleNumber);
            if (!"bd_customer".equals(baseDataKey)) {
                MulBasedataProp prop = (MulBasedataProp)newEntityType.getProperty(roleFilterKey);
                prop.setBaseEntityId(baseDataKey);
                BasedataProp bPropMul = (BasedataProp)prop.getItemType().getProperties().get((Object)"fbasedataid");
                bPropMul.setBaseEntityId(baseDataKey);
                MainEntityType newDT = EntityMetadataCache.getDataEntityType((String)baseDataKey);
                EntityType newSimpleDT = newDT.getSubEntityType(new ArrayList(0));
                bPropMul.setComplexType((IDataEntityType)newSimpleDT);
                DynamicProperty refProp = prop.getDynamicCollectionItemPropertyType().getProperty("fbasedataid_id");
                bPropMul.setRefIdProp((IDataEntityProperty)refProp);
                bPropMul.setRefIdPropName(refProp.getName());
            }
            LocaleString roleDisplayName = dimensionEntryFieldMapper.getRoleDisplayName(dimensionEntryFieldMapper.getRoleFieldKey(roleNumber));
            FieldEdit control = (FieldEdit)this.getControl(roleFilterKey);
            ((DynamicProperty)control.getProperty()).setDisplayName(roleDisplayName);
        }
        e.setNewEntityType(newEntityType);
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        FilterInfo filterInfo = queryParam.getFilter();
        if (filterInfo.getString(KEY_DIMENSION_S) == null || this.getModel().getValue(KEY_DIMENSION_S) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6307\u5b9a\u4fe1\u63a7\u7ef4\u5ea6\u3002", (String)"OverdueReportPlugin_0", (String)"scmc-ccm-report", (Object[])new Object[0]));
            return false;
        }
        DynamicObject dimensionObject = (DynamicObject)this.getModel().getValue(KEY_DIMENSION_S);
        DimensionReader dimensionReader = new DimensionReader();
        Dimension dimension = dimensionReader.getDimension(((Long)dimensionObject.getPkValue()).longValue());
        DynamicObject[] schemes = this.getSchemas();
        if (schemes != null && schemes.length > 0) {
            for (DynamicObject schemeObject : schemes) {
                CreditScheme scheme = this.facade.getScheme(((Long)schemeObject.getPkValue()).longValue());
                String quotaType = scheme.getQuotaType().getQuotaType();
                if (!"days".equals(quotaType) && !"overdueamt".equals(quotaType) || scheme.getBillStrategies() == null || scheme.getBillStrategies().isEmpty()) continue;
                BillStrategy billStrategy = (BillStrategy)scheme.getBillStrategies().get(0);
                String assingEntityKey = billStrategy.getAssingEntityKey();
                EntityConfig entityConfig = this.facade.getConfig(assingEntityKey);
                List roles = dimension.getRoles();
                for (Role role : roles) {
                    String roleType = role.getRoleType();
                    Field roleField = entityConfig.getRoleField(roleType);
                    if (roleField != null) continue;
                    String entityKey = entityConfig.getEntityKey();
                    MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)entityKey);
                    String entityDisplayName = dataEntityType.getDisplayName().getLocaleValue();
                    String messageTemplate = ResManager.loadKDString((String)"\u903e\u671f\u5355\u636e\u201c%1$s\u201d\u6ca1\u6709\u914d\u7f6e\u201c%2$s\u201d\u7ef4\u5ea6\u7684\u5b57\u6bb5\u6620\u5c04\uff0c\u8bf7\u524d\u5f80\u201c\u5355\u636e\u6ce8\u518c\u201d\u754c\u9762\u8fdb\u884c\u914d\u7f6e\u3002", (String)"AnalyseSumReportPlugin_5", (String)"scmc-ccm-report", (Object[])new Object[0]);
                    this.getView().showTipNotification(String.format(messageTemplate, entityDisplayName, role.getRoleName()));
                    return false;
                }
            }
        }
        return super.verifyQuery(queryParam);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        DynamicObject dimension;
        super.beforeDoOperation(e);
        FormOperate op = (FormOperate)e.getSource();
        if ("refresh".equals(op.getOperateKey()) && ((dimension = (DynamicObject)this.getModel().getValue(KEY_DIMENSION_S)) == null || dimension.getPkValue() == null || this.getPageCache().get(KEY_QUERY_DIMENSION) == null || !this.getPageCache().get(KEY_QUERY_DIMENSION).equals(dimension.getPkValue().toString()))) {
            e.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4fe1\u63a7\u7ef4\u5ea6\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u91cd\u65b0\u67e5\u8be2\u3002", (String)"OverdueReportPlugin_6", (String)"scmc-ccm-report", (Object[])new Object[0]));
        }
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        QFilter schemeFilter;
        super.beforeQuery(queryParam);
        DynamicObject dimension = (DynamicObject)this.getModel().getValue(KEY_DIMENSION_S);
        ReportList rptList = (ReportList)this.getControl("reportlistap");
        if (dimension.getPkValue() != null) {
            this.getPageCache().put(KEY_QUERY_DIMENSION, dimension.getPkValue().toString());
        }
        DynamicObjectCollection schemacol = (DynamicObjectCollection)this.getModel().getValue("schema_s");
        DynamicObjectCollection currency = (DynamicObjectCollection)this.getModel().getValue("currency_s");
        queryParam.getCustomParam().put("dimension", dimension);
        queryParam.getCustomParam().put("quatoover", this.getModel().getValue("quatoover_s"));
        queryParam.getCustomParam().put("scheme", schemacol);
        queryParam.getCustomParam().put("currency", currency);
        queryParam.getCustomParam().put("commonFilter", queryParam.getFilter().getCommFilter("ccm_analyse_sum_repo"));
        DynamicObjectCollection billMainEntitys = (DynamicObjectCollection)this.getModel().getValue("billmainentity_s");
        HashSet<String> billEntity = new HashSet<String>(8);
        for (DynamicObject billMainEntity : billMainEntitys) {
            billEntity.add(billMainEntity.getString("fbasedataid.id"));
        }
        queryParam.getCustomParam().put("billMainEntity", billEntity);
        Date today = new Date();
        queryParam.getCustomParam().put("today", today);
        ArrayList<QFilter> pageFs = new ArrayList<QFilter>();
        QFilter dimensionFilter = new QFilter(KEY_DIMENSION_S, "=", dimension.getPkValue());
        pageFs.add(dimensionFilter);
        if (schemacol.size() > 0) {
            schemeFilter = new QFilter("scheme", "in", schemacol.stream().map(d -> d.getLong("fbasedataid.id")).collect(Collectors.toList()));
            pageFs.add(schemeFilter);
        } else {
            schemeFilter = new QFilter("scheme.checktype.number", "in", (Object)new String[]{"KZFW002", "KZFW006"}).and(new QFilter("scheme.status", "=", (Object)StatusEnum.AUDIT.getValue()));
            pageFs.add(schemeFilter);
        }
        if (currency != null && currency.size() > 0) {
            QFilter currencyFilter = new QFilter("currency", "in", currency.stream().map(d -> d.getLong("fbasedataid.id")).collect(Collectors.toList()));
            pageFs.add(currencyFilter);
        }
        List columns = rptList.getColumns();
        HashSet<String> columnKeys = new HashSet<String>(columns.size());
        for (int i = 0; i < columns.size(); ++i) {
            AbstractReportColumn column = (AbstractReportColumn)columns.get(i);
            if (!(column instanceof ReportColumn)) continue;
            String fieldKey = ((ReportColumn)column).getFieldKey();
            columnKeys.add(fieldKey);
        }
        ArrayList<QFilter> roleFilterList = new ArrayList<QFilter>();
        DimensionEntryFieldMapper fieldMapper = new DimensionEntryFieldMapper(dimension.getPkValue());
        List roleNumbers = fieldMapper.getRoleNumbers();
        ArrayList<ReportColumn> dimensionColumns = new ArrayList<ReportColumn>(roleNumbers.size());
        for (String roleNumber : roleNumbers) {
            String roleFieldKey = fieldMapper.getRoleFieldKey(roleNumber);
            DynamicObjectCollection roleCol = (DynamicObjectCollection)this.getModel().getValue(fieldMapper.getRoleFilterKey(roleNumber));
            queryParam.getCustomParam().put(roleFieldKey, roleCol.stream().map(d -> d.getLong("fbasedataid.id")).collect(Collectors.toList()));
            if (columnKeys.contains(roleFieldKey)) continue;
            String baseDataKey = fieldMapper.getBaseDataKey(roleNumber);
            ReportColumn baseDataColumn = ReportColumn.createBaseDataColumn((String)roleFieldKey, (String)baseDataKey);
            baseDataColumn.setCaption(fieldMapper.getRoleDisplayName(roleFieldKey));
            dimensionColumns.add(baseDataColumn);
            DynamicObjectCollection roleCollection = (DynamicObjectCollection)this.getModel().getValue(fieldMapper.getRoleFilterKey(roleNumber));
            if (roleCollection.size() <= 0) continue;
            List pkIds = roleCollection.stream().map(d -> d.getLong("fbasedataid.id")).collect(Collectors.toList());
            QFilter roleFilter = new QFilter(fieldMapper.getRoleFieldKey(roleNumber), "in", pkIds);
            pageFs.add(roleFilter);
            roleFilterList.add(roleFilter);
        }
        queryParam.getCustomParam().put("roleFilterList", roleFilterList);
        queryParam.getFilter().setQFilters(pageFs);
        columns.addAll(1, dimensionColumns);
    }

    public void setCellStyleRules(List<CellStyleRule> cellStyleRules) {
        CellStyleRule cellStyleRule = new CellStyleRule();
        cellStyleRule.setFieldKey("isover");
        cellStyleRule.setForeColor("#FD6C6A");
        cellStyleRule.setCondition("isover = '1'");
        cellStyleRules.add(cellStyleRule);
    }

    public void afterSetModelValue(DynamicObject scheme) {
        if (scheme != null) {
            List<String> allFilterControlKeys = this.getAllFilterControlKeys();
            LinkedList<String> visiableKeys = new LinkedList<String>();
            List<String> unvisiableKeys = allFilterControlKeys;
            ArrayList<ComboItem> combos = new ArrayList<ComboItem>(16);
            DynamicObject dimension = scheme.getDynamicObject(KEY_DIMENSION_S);
            this.getModel().setValue(KEY_DIMENSION_S, (Object)dimension);
            this.getPageCache().put("dimensionid", dimension.getString("id"));
            DimensionEntryFieldMapper mapper = new DimensionEntryFieldMapper(dimension.getPkValue());
            List roleNumbers = mapper.getRoleNumbers();
            for (String roleNumer : roleNumbers) {
                String roleFilterKey = mapper.getRoleFilterKey(roleNumer);
                String roleFilterTypeKey = mapper.getBaseDataKey(roleNumer);
                visiableKeys.add(roleFilterKey);
                unvisiableKeys.remove(roleFilterKey);
                LocaleString roleDisplayName = mapper.getRoleDisplayName(mapper.getRoleFieldKey(roleNumer));
                FieldEdit control = (FieldEdit)this.getControl(roleFilterKey);
                control.setCaption(roleDisplayName);
                ((DynamicProperty)control.getProperty()).setDisplayName(roleDisplayName);
                combos.add(new ComboItem(roleDisplayName, mapper.getRoleFieldKey(roleNumer)));
                if (scheme.get(roleFilterKey) != null && scheme.get(roleFilterKey) instanceof MulBasedataDynamicObjectCollection) {
                    MulBasedataDynamicObjectCollection roleValueCol = (MulBasedataDynamicObjectCollection)scheme.get(roleFilterKey);
                    if (roleValueCol != null && roleValueCol.size() > 0) {
                        HashSet<Object> roleValueIDs = new HashSet<Object>(roleValueCol.size());
                        for (DynamicObject roDo : roleValueCol) {
                            if (roDo == null || roDo.get("fbasedataid") == null) continue;
                            roleValueIDs.add(((DynamicObject)roDo.get("fbasedataid")).getPkValue());
                        }
                        Map loadRoleDoMap = BusinessDataServiceHelper.loadFromCache((Object[])roleValueIDs.toArray(), (String)roleFilterTypeKey);
                        MulBasedataDynamicObjectCollection newRoleMulBDDoCol = new MulBasedataDynamicObjectCollection();
                        for (DynamicObject loadRoleDo : loadRoleDoMap.values()) {
                            newRoleMulBDDoCol.add(loadRoleDo);
                        }
                        if (newRoleMulBDDoCol == null || newRoleMulBDDoCol.size() < 1) {
                            this.getModel().setValue(roleFilterKey, null);
                            continue;
                        }
                        this.getModel().setValue(roleFilterKey, (Object)newRoleMulBDDoCol);
                        continue;
                    }
                    this.getModel().setValue(roleFilterKey, null);
                    continue;
                }
                this.getModel().setValue(roleFilterKey, null);
            }
            if (!visiableKeys.isEmpty()) {
                this.getView().setVisible(Boolean.TRUE, visiableKeys.toArray(new String[0]));
            }
            if (!unvisiableKeys.isEmpty()) {
                this.getView().setVisible(Boolean.FALSE, unvisiableKeys.toArray(new String[0]));
            }
            combos.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u63a7\u5236\u7ec4\u7ec7\u8303\u56f4", (String)"OverdueReportPlugin_1", (String)"scmc-ccm-report", (Object[])new Object[0])), "orgscope"));
            combos.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u4fe1\u63a7\u65b9\u6848", (String)"OverdueReportPlugin_2", (String)"scmc-ccm-report", (Object[])new Object[0])), "scheme"));
            combos.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5e01\u79cd", (String)"OverdueReportPlugin_3", (String)"scmc-ccm-report", (Object[])new Object[0])), "currency"));
            combos.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5206\u5f55\u5e8f\u53f7", (String)"OverdueReportPlugin_4", (String)"scmc-ccm-report", (Object[])new Object[0])), "entryseq"));
            combos.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u4fe1\u63a7\u5f62\u5f0f", (String)"OverdueReportPlugin_5", (String)"scmc-ccm-report", (Object[])new Object[0])), "checktype"));
            ComboEdit item = (ComboEdit)this.getView().getControl("showkeycols");
            item.setComboItems(combos);
            ComboEdit sumkeycols = (ComboEdit)this.getView().getControl("sumkeycols");
            sumkeycols.setComboItems(combos);
            Set showKeyCols = ReportUtil.parseCombColVal((IDataModel)this.getModel(), (String)"showkeycols");
            this.fillComboItem("sumkeycols", colConf -> showKeyCols.contains(colConf.getCol()));
        }
    }

    private static interface ColFilter {
        public boolean filter(BigTableColConf var1);
    }
}

